/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.AttributeCollection;
import com.icl.saxon.om.Name;
import com.icl.saxon.output.UnicodeCharacterSet;
import com.icl.saxon.output.XMLEmitter;
import java.io.IOException;
import org.xml.sax.SAXException;

public class TEXTEmitter
extends XMLEmitter {
    private int ignoreDepth = 0;
    private boolean ignoreElementContent = false;

    public void startDocument() throws SAXException {
        if (this.outputDetails.getMediaType() == null) {
            this.outputDetails.setMediaType("text/plain");
        }
        if ("saxon:no-element-content".equals(this.outputDetails.getUserData())) {
            this.ignoreElementContent = true;
        }
        if (this.characterSet == null) {
            this.characterSet = new UnicodeCharacterSet();
        }
        this.empty = true;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.ignoreDepth == 0) {
            int n3 = n;
            while (n3 < n + n2) {
                if (!this.characterSet.inCharset(cArray[n3])) {
                    throw new SAXException("Output character not available in this encoding (decimal " + cArray[n3] + ")");
                }
                ++n3;
            }
            try {
                this.writer.write(cArray, n, n2);
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
    }

    public void startElement(Name name, AttributeCollection attributeCollection) throws SAXException {
        if (this.ignoreElementContent) {
            ++this.ignoreDepth;
        }
    }

    public void endElement(Name name) throws SAXException {
        if (this.ignoreElementContent) {
            --this.ignoreDepth;
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
    }
}

