/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.ExtendedInputSource;
import com.icl.saxon.PreparedStyleSheet;
import com.icl.saxon.expr.AttributeValueTemplate;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.om.Name;
import com.icl.saxon.output.ContentHandlerProxy;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.FOPEmitter;
import com.icl.saxon.output.OutputDetails;
import com.icl.saxon.output.OutputManager;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import org.xml.sax.SAXException;

public class SAXONOutput
extends StyleElement {
    Expression file;
    Expression userData;
    Expression method = null;
    Expression version = null;
    Expression indent = null;
    Expression encoding = null;
    Expression mediaType = null;
    Expression doctypeSystem = null;
    Expression doctypePublic = null;
    Expression omitDeclaration = null;
    Expression standalone = null;
    Expression cdataElements = null;
    Expression nextInChain = null;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws SAXException {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        String string10;
        String string11;
        String string12;
        this.checkAllowedAttributes();
        String string13 = this.getAttributeValue("file");
        if (string13 != null) {
            this.file = AttributeValueTemplate.make(string13, this);
        }
        if ((string12 = this.getAttributeValue("user-data")) != null) {
            this.userData = AttributeValueTemplate.make(string12, this);
        }
        if ((string11 = this.getAttributeValue("method")) != null) {
            this.method = AttributeValueTemplate.make(string11, this);
        }
        if ((string10 = this.getAttributeValue("version")) != null) {
            this.version = AttributeValueTemplate.make(string10, this);
        }
        if ((string9 = this.getAttributeValue("indent")) != null) {
            this.indent = AttributeValueTemplate.make(string9, this);
        }
        if ((string8 = this.getAttributeValue("encoding")) != null) {
            this.encoding = AttributeValueTemplate.make(string8, this);
        }
        if ((string7 = this.getAttributeValue("media-type")) != null) {
            this.mediaType = AttributeValueTemplate.make(string7, this);
        }
        if ((string6 = this.getAttributeValue("doctype-system")) != null) {
            this.doctypeSystem = AttributeValueTemplate.make(string6, this);
        }
        if ((string5 = this.getAttributeValue("doctype-public")) != null) {
            this.doctypePublic = AttributeValueTemplate.make(string5, this);
        }
        if ((string4 = this.getAttributeValue("omit-xml-declaration")) != null) {
            this.omitDeclaration = AttributeValueTemplate.make(string4, this);
        }
        if ((string3 = this.getAttributeValue("standalone")) != null) {
            this.standalone = AttributeValueTemplate.make(string3, this);
        }
        if ((string2 = this.getAttributeValue("cdata-section-elements")) != null) {
            this.cdataElements = AttributeValueTemplate.make(string2, this);
        }
        if ((string = this.getAttributeValue("next-in-chain")) != null) {
            this.nextInChain = AttributeValueTemplate.make(string, this);
        }
        if (this.nextInChain != null && string13 != null) {
            throw this.styleError("The file attribute and the next-in-chain attribute must not both be present");
        }
    }

    protected void checkAllowedAttributes() throws SAXException {
        String[] stringArray = new String[]{"method", "version", "indent", "encoding", "media-type", "doctype-system", "doctype-public", "omit-xml-declaration", "standalone", "cdata-section-elements", "file", "next-in-chain", "user-data"};
        this.allowAttributes(stringArray);
    }

    public void validate() throws SAXException {
        this.checkWithinTemplate();
    }

    public void process(Context context) throws SAXException {
        Object object;
        Object object2;
        Object object3;
        String string;
        Controller controller = context.getController();
        OutputDetails outputDetails = controller.getCurrentOutputDetails();
        OutputDetails outputDetails2 = new OutputDetails(outputDetails);
        OutputManager outputManager = controller.getOutputManager();
        if (this.file != null) {
            string = this.file.evaluateAsString(context);
            try {
                object3 = new File(string);
                if (!((File)object3).exists() && (object2 = ((File)object3).getParent()) != null) {
                    object = new File((String)object2);
                    if (object != null && !((File)object).exists()) {
                        ((File)object).mkdirs();
                    }
                    ((File)object3).createNewFile();
                }
                outputDetails2.setOutputStream(new FileOutputStream((File)object3));
                outputDetails2.setWriter(null);
            }
            catch (IOException iOException) {
                throw new SAXException("Failed to create output file " + string, iOException);
            }
        }
        if (this.userData != null) {
            string = this.userData.evaluateAsString(context);
            outputDetails2.setUserData(string);
        }
        if (this.method != null) {
            string = this.method.evaluateAsString(context);
            if (!(string.equals("xml") || string.equals("html") || string.equals("text"))) {
                object3 = new Name(string, this, false);
                if (((Name)object3).getPrefix().equals("")) {
                    throw this.styleError("method must be xml, html, or text, or a prefixed name");
                }
                object2 = ((Name)object3).getLocalName();
                if (((String)object2).equals("fop")) {
                    outputDetails2.setEmitter(new FOPEmitter());
                    string = "saxon:user";
                } else if (((String)object2).equals("xhtml")) {
                    string = "xhtml";
                } else {
                    outputDetails2.setEmitter(XSLOutput.makeEmitter((String)object2));
                    string = "saxon:user";
                }
            }
            outputDetails2.setMethod(string);
        }
        if (this.version != null) {
            string = this.version.evaluateAsString(context);
            outputDetails2.setVersion(string);
        }
        if (this.indent != null) {
            string = this.indent.evaluateAsString(context);
            if (string == null || string.equals("yes") || string.equals("no")) {
                outputDetails2.setIndent(string);
            } else {
                try {
                    int n = Integer.parseInt(string);
                    outputDetails2.setIndent("yes");
                    outputDetails2.setIndentSpaces(n);
                }
                catch (NumberFormatException numberFormatException) {
                    throw this.styleError("indent must be yes or no or an integer");
                }
            }
        }
        if (this.encoding != null) {
            string = this.encoding.evaluateAsString(context);
            outputDetails2.setEncoding(string);
        }
        if (this.mediaType != null) {
            string = this.mediaType.evaluateAsString(context);
            outputDetails2.setEncoding(string);
        }
        if (this.doctypeSystem != null) {
            string = this.doctypeSystem.evaluateAsString(context);
            outputDetails2.setDoctypeSystem(string);
        }
        if (this.doctypePublic != null) {
            string = this.doctypePublic.evaluateAsString(context);
            outputDetails2.setDoctypePublic(string);
        }
        if (this.omitDeclaration != null) {
            string = this.omitDeclaration.evaluateAsString(context);
            if (string.equals("yes") || string.equals("no")) {
                outputDetails2.setOmitDeclaration(string);
            } else {
                throw this.styleError("omit-xml-declaration attribute must be yes or no");
            }
        }
        if (this.standalone != null) {
            string = this.standalone.evaluateAsString(context);
            if (string.equals("yes") || string.equals("no")) {
                outputDetails2.setStandalone(string);
            } else {
                throw this.styleError("omit-xml-declaration attribute must be yes or no");
            }
        }
        if (this.cdataElements != null) {
            string = this.cdataElements.evaluateAsString(context);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                object2 = stringTokenizer.nextToken();
                object = new Name((String)object2, this, true);
                outputDetails2.addCdataElement((Name)object);
            }
        }
        if (this.nextInChain != null) {
            string = this.nextInChain.evaluateAsString(context);
            Controller controller2 = this.prepareNextStylesheet(string);
            object2 = new ContentHandlerProxy();
            ((ContentHandlerProxy)object2).setUnderlyingContentHandler(controller2.getInputContentHandler());
            ((ContentHandlerProxy)object2).setRequireWellFormed(false);
            outputDetails2.setEmitter((Emitter)object2);
            outputDetails2.setMethod("saxon:user");
        }
        if (outputDetails2.getMethod() == null) {
            outputDetails2.setMethod("saxon:uncommitted");
        }
        outputManager.setOutputDetails(outputDetails2);
        this.processChildren(context);
        outputManager.resetOutputDetails();
    }

    private Controller prepareNextStylesheet(String string) throws SAXException {
        URL uRL;
        URL uRL2;
        try {
            uRL2 = new URL(this.getSystemId());
        }
        catch (MalformedURLException malformedURLException) {
            throw new SAXException("saxon:output - invalid base URL " + this.getSystemId());
        }
        try {
            uRL = new URL(uRL2, string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new SAXException("xsl:include - invalid target URL " + string);
        }
        ExtendedInputSource extendedInputSource = new ExtendedInputSource(uRL.toString());
        PreparedStyleSheet preparedStyleSheet = new PreparedStyleSheet();
        preparedStyleSheet.setXMLReader(this.getPreparedStyleSheet().getXMLReader());
        preparedStyleSheet.prepare(extendedInputSource);
        return (Controller)preparedStyleSheet.newTransformer();
    }
}

