/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tree;

import com.icl.saxon.expr.AnyNameTest;
import com.icl.saxon.expr.PrefixTest;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.tree.ElementImpl;
import com.icl.saxon.tree.NodeImpl;
import com.icl.saxon.tree.TextImpl;
import java.util.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class Stripper
implements ContentHandler,
LexicalHandler {
    private static final Name XML_SPACE = Name.reconstruct("xml", "http://www.w3.org/XML/1998/namespace", "space");
    private Hashtable preserveElements;
    private Hashtable preservePrefixes;
    private boolean preserveByDefault = true;
    private boolean preserveAll = true;
    private ContentHandler nextHandler;
    private byte[] stripStack = new byte[100];
    private int top = 0;
    private char[] buffer = new char[4096];
    private int used = 0;

    public Stripper() {
        this.preserveElements = new Hashtable();
        this.preservePrefixes = new Hashtable();
    }

    public void setPreserveSpace(Name name, boolean bl) {
        this.preserveElements.put(name.getURI() + "^" + name.getLocalName(), new Boolean(bl));
        if (!bl) {
            this.preserveAll = false;
        }
    }

    public void setPreserveSpace(PrefixTest prefixTest, boolean bl) {
        this.preservePrefixes.put(prefixTest.getURI(), new Boolean(bl));
        if (!bl) {
            this.preserveAll = false;
        }
    }

    public void setPreserveSpace(AnyNameTest anyNameTest, boolean bl) {
        this.preserveByDefault = bl;
        if (!bl) {
            this.preserveAll = false;
        }
    }

    public boolean isSpacePreserving(String string, String string2) {
        if (this.preserveAll) {
            return true;
        }
        Boolean bl = (Boolean)this.preserveElements.get(string + "^" + string2);
        if (bl == null) {
            bl = (Boolean)this.preservePrefixes.get(string);
        }
        if (bl != null) {
            return bl;
        }
        return this.preserveByDefault;
    }

    public boolean getPreserveAll() {
        return this.preserveAll;
    }

    public void setNextHandler(ContentHandler contentHandler) {
        this.nextHandler = contentHandler;
    }

    public void startDocument() throws SAXException {
        this.top = 0;
        this.stripStack[this.top] = 1;
        this.used = 0;
        this.nextHandler.startDocument();
    }

    public void endDocument() throws SAXException {
        this.flush();
        this.nextHandler.endDocument();
    }

    public void setDocumentLocator(Locator locator) {
        this.nextHandler.setDocumentLocator(locator);
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.nextHandler.startPrefixMapping(string, string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
        this.nextHandler.endPrefixMapping(string);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.flush();
        this.nextHandler.startElement(string, string2, string3, attributes);
        byte by = this.stripStack[this.top];
        String string4 = attributes.getValue("xml:space");
        int n = by & 2;
        if (string4 != null) {
            if (string4.equals("preserve")) {
                n = 2;
            }
            if (string4.equals("default")) {
                n = 0;
            }
        }
        if (this.isSpacePreserving(string, string2)) {
            n = (byte)(n | 1);
        }
        ++this.top;
        if (this.top >= this.stripStack.length) {
            byte[] byArray = new byte[this.top * 2];
            System.arraycopy(this.stripStack, 0, byArray, 0, this.top);
            this.stripStack = byArray;
        }
        this.stripStack[this.top] = n;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.flush();
        this.nextHandler.endElement(string, string2, string3);
        --this.top;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        while (this.used + n2 > this.buffer.length) {
            char[] cArray2 = new char[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, cArray2, 0, this.used);
            this.buffer = cArray2;
        }
        System.arraycopy(cArray, n, this.buffer, this.used, n2);
        this.used += n2;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.flush();
        this.nextHandler.processingInstruction(string, string2);
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.flush();
        if (this.nextHandler instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.nextHandler)).comment(cArray, n, n2);
        }
    }

    private boolean isWhite() {
        int n = 0;
        while (n < this.used) {
            if (this.buffer[n] > ' ') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void flush() throws SAXException {
        if (this.used > 0) {
            if (this.stripStack[this.top] != 0 || !this.isWhite()) {
                this.nextHandler.characters(this.buffer, 0, this.used);
            }
            this.used = 0;
        }
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        if (this.nextHandler instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.nextHandler)).startDTD(string, string2, string3);
        }
    }

    public void endDTD() throws SAXException {
        if (this.nextHandler instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.nextHandler)).endDTD();
        }
    }

    public void startEntity(String string) throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void strip(DocumentInfo documentInfo) throws SAXException {
        if (!this.getPreserveAll()) {
            this.strip((ElementImpl)documentInfo.getDocumentElement(), false);
        }
    }

    private void strip(ElementImpl elementImpl, boolean bl) throws SAXException {
        NodeInfo[] nodeInfoArray = elementImpl.getAllChildNodes();
        boolean bl2 = this.isSpacePreserving(elementImpl.getURI(), elementImpl.getLocalName());
        int n = 0;
        while (n < nodeInfoArray.length) {
            NodeImpl nodeImpl;
            NodeInfo nodeInfo = nodeInfoArray[n];
            if (nodeInfo instanceof TextImpl) {
                nodeImpl = (TextImpl)nodeInfo;
                if (!bl2 && !bl && ((TextImpl)nodeImpl).isWhite()) {
                    nodeImpl.removeNode();
                }
            } else if (nodeInfo instanceof ElementImpl) {
                nodeImpl = (ElementImpl)nodeInfo;
                String string = ((ElementImpl)nodeImpl).getAttributeValue(XML_SPACE);
                boolean bl3 = bl;
                if (string != null) {
                    if (string.equals("preserve")) {
                        bl3 = true;
                    }
                    if (string.equals("default")) {
                        bl3 = false;
                    }
                }
                this.strip((ElementImpl)nodeImpl, bl3);
            }
            ++n;
        }
        elementImpl.renumberChildren();
    }
}

