#pragma once
/*
 *      Copyright (C) 2005-2013 Team XBMC
 *      http://xbmc.org
 *
 *  This Program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This Program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with XBMC; see the file COPYING.  If not, see
 *  <http://www.gnu.org/licenses/>.
 *
 */

#include "DynamicDll.h"

class DllSidplay2Interface
{
public:
    virtual ~DllSidplay2Interface() {}
    virtual int Init()=0;
    virtual void* LoadSID(const char* szFileName)=0;
    virtual void FreeSID(void* sid)=0;
    virtual void StartPlayback(void* sid, int track)=0;
    virtual int FillBuffer(void* sid, void* buffer, int length)=0;
    virtual int GetNumberOfSongs(const char* szFileName)=0;
    virtual void SetSpeed(void* sid, int speed)=0;
};

class DllSidplay2 : public DllDynamic, DllSidplay2Interface
{
  DECLARE_DLL_WRAPPER(DllSidplay2, DLL_PATH_SID_CODEC)
  DEFINE_METHOD0(int, Init)
  DEFINE_METHOD1(void*, LoadSID, (const char* p1))
  DEFINE_METHOD1(void, FreeSID, (void* p1))
  DEFINE_METHOD2(void, StartPlayback,(void* p1, int p2))
  DEFINE_METHOD3(int, FillBuffer, (void* p1, void* p2, int p3))
  DEFINE_METHOD1(int, GetNumberOfSongs, (const char* p1))
  DEFINE_METHOD2(void, SetSpeed, (void* p1, int p2))
  BEGIN_METHOD_RESOLVE()
    RESOLVE_METHOD_RENAME(DLL_Init, Init)
    RESOLVE_METHOD_RENAME(DLL_LoadSID, LoadSID)
    RESOLVE_METHOD_RENAME(DLL_FreeSID, FreeSID)
    RESOLVE_METHOD_RENAME(DLL_StartPlayback,StartPlayback)
    RESOLVE_METHOD_RENAME(DLL_FillBuffer, FillBuffer)
    RESOLVE_METHOD_RENAME(DLL_GetNumberOfSongs, GetNumberOfSongs)
    RESOLVE_METHOD_RENAME(DLL_SetSpeed, SetSpeed)
  END_METHOD_RESOLVE()
};

