/* microcode.c:	Microcode update for PIII and later CPUS
 *
 *
 */


#include "boot.h"
#include "config.h"
#include "cpu.h"

struct microcode {
	unsigned int hdrver;
	unsigned int rev;
	unsigned int date;
	unsigned int sig;
	
	unsigned int cksum;
	unsigned int ldrver;
	unsigned int pf;

	unsigned int reserved[5];
	unsigned int bits[500];
};

const unsigned int microcode_updates [] = {
 /*
       Copyright  Intel Corporation, 1995, 96, 97, 98, 99, 2000, 2001. 
       
       These microcode updates are distributed for the sole purpose of 
       installation in the BIOS or Operating System of computer systems
       which include a Genuine Intel microprocessor sold or distributed
       to or by you. You are not authorized to use this material for
       any other purpose.  
*/

/*  MU168608.inc  */
0x00000001,	0x00000008,	0x05052000,	0x00000686,
0xea2b7b61,	0x00000001,	0x00000010,	0x00000000,
0x00000000,	0x00000000,	0x00000000,	0x00000000,
0x38709a5e,	0x7cbb9fcd,	0x46f2975c,	0xdf0a611a,
0x454f553d,	0x4dd783fc,	0x38b72f92,	0xe6cd7f96,
0xf57804bd,	0xf12c0d73,	0xafa105a2,	0x74073ece,
0xfa02d788,	0xd8a7bdd3,	0x2471c214,	0xcdcf7014,
0x0e6e693c,	0xbafbc7c1,	0xd765a8ca,	0x65b6cc40,
0x2ed8a24a,	0x2c1fcf0d,	0x7d73ba93,	0xcf0a98db,
0x3caea0c2,	0x49e601d9,	0x936c2fef,	0xc87dc94d,
0x1fef698e,	0xda05fa7b,	0x204f5b4e,	0x441cedfd,
0x09f63dcc,	0xf7cc7654,	0x2b69ecf9,	0x495d0ef9,
0x7679dac3,	0x7a4c0547,	0xb7adeed9,	0x29053d15,
0xcf0b21bd,	0x77204452,	0x99ba650b,	0x3d19d146,
0x150b0f41,	0xd7b5238f,	0xd02a8165,	0xd1270d1d,
0xf6d102bc,	0x198ab690,	0xed878dbf,	0x34c2ec98,
0x4c9bee07,	0x66ec11f1,	0xaa5202db,	0x4d2f2fc8,
0x4ba8194b,	0x569fbee6,	0x9016ef51,	0x8fe4062c,
0x90148cec,	0x5be3ddc4,	0xf04ff2c4,	0x5de8d897,
0x09b1d0b4,	0x9f83a4f7,	0x0cf74fdf,	0x3c02a388,
0xa2045a65,	0xbe469468,	0x03e4c532,	0x5f14280e,
0xb384e96b,	0xfdce24fc,	0x2458e3ea,	0x169dbd24,
0x71c8b3f3,	0x67e019af,	0xcda860c1,	0xe279acc0,
0x6bc10e92,	0xe51258ec,	0x4630c6d5,	0xfc260a15,
0xca8197db,	0x30aefd93,	0x789a7c9f,	0x1dbd5410,
0xd4e1c7a1,	0x309e8843,	0xd47f27ab,	0xf0c4a0d6,
0xe30a1e06,	0x3056c766,	0xb45c4d62,	0x3b8a2d43,
0x0b013cdc,	0x8b2163e8,	0x3027cc1b,	0xe4c4db4e,
0x89a26935,	0xaeab01f3,	0x46406071,	0xfe9ca870,
0x73c6b8e0,	0xd55517a0,	0x40672814,	0x28d9e205,
0xfd23b70b,	0x885e72ed,	0x41861524,	0xeb7f77b2,
0xea826a61,	0x06a47055,	0x83d71cfc,	0xb6b5cbb6,
0xeea709e3,	0x25b910bf,	0x64ef9e5a,	0xd048a5a3,
0x0ecae00e,	0x216700b2,	0xf51cc285,	0x107f4916,
0xb390e89e,	0x07efee47,	0x8eb3d423,	0x151e4c0c,
0xab7ebbdc,	0xe471757b,	0x717f586b,	0xaacd6c2a,
0xa0c63ad6,	0xde1feca6,	0x234e73d8,	0xfc302a04,
0x4119848a,	0xbc8c78d5,	0xf3bb6d22,	0x2adc091b,
0x3d6a50a6,	0x80d0806c,	0xe775d1b9,	0xa398ace3,
0x47a09e7d,	0x82e43ac0,	0xb3ae0953,	0x9e953074,
0x4964b471,	0x4a8bb0fd,	0x9e6a6e8e,	0xee971884,
0xc7f2e4cc,	0xdc1b7ff4,	0x0ba3d273,	0x7d37c53c,
0x27554173,	0x7865dc77,	0xb24f15c5,	0x90c00d9b,
0x0ddd4024,	0x65050eb7,	0xf833936d,	0xe93cd40a,
0xe31dd31f,	0xc990cca6,	0xaad5564a,	0xcb6c45b9,
0xb1a6ef0b,	0xbac07112,	0xddbe22b2,	0xa01f1135,
0x0562493a,	0xb3f2f526,	0xd414512f,	0x5d945ebe,
0x0a8c95f1,	0xc214aa4d,	0x5006a179,	0xdd57b9bf,
0x92cc0d68,	0x29556e76,	0xbe68e6a4,	0x5dd7cedc,
0x2606954f,	0xb1168ed2,	0xbc7f4b32,	0x1cd43eee,
0x7f7e1f59,	0xdacd550e,	0x8e7c4adb,	0xd1b6af9e,
0x4abc5f32,	0x81181214,	0xc364896c,	0xc56c4a08,
0xd56aa244,	0x936f0be3,	0x3d0c967b,	0x1578d76a,
0x7cb10003,	0xdf0e8bad,	0x24bc9534,	0x4fbf3524,
0x7052039c,	0x6edb0691,	0x2f10c885,	0xd5adb704,
0x11ff9b52,	0xd6614cf1,	0x1ab2b79f,	0x9c4e93f2,
0x49e3431c,	0x6b80635f,	0x233912ad,	0x05168de1,
0x79e18bd7,	0x4d9d0ce4,	0x1e1d93f7,	0x041c93ca,
0x7109b31c,	0x98af2848,	0x012fd82e,	0xc134e4b1,
0x73cbf75a,	0xbc2ac259,	0xeb5f1138,	0xed0038a1,
0xa75bbad0,	0x9698ef09,	0x37b21e97,	0xe7d971e9,
0x3184de0a,	0x1d64395d,	0x005a6d27,	0xf26dfc59,
0x838ba96f,	0x4f0239d3,	0xf295395e,	0xb3c38631,
0x7ea7a143,	0x157a4e43,	0x46f8173f,	0xfbc18d4a,
0xc401e17a,	0xc4620358,	0xd2ab5437,	0xa01db06f,
0x58ce91fc,	0x850de1a3,	0x9b542dba,	0xee77f038,
0xddd3ced6,	0xc225d2ce,	0x63a3f765,	0x3342a06c,
0x6a780c2f,	0xfaa925b2,	0x366ebeec,	0xbcc9abea,
0xc7b3fa4e,	0xf4f1123d,	0x5198702c,	0x3e3458b7,
0x0b1ce9a1,	0x51b1bd7f,	0x711e791e,	0x927d8bed,
0x91dbaea9,	0x7eefbda9,	0x7a19edd9,	0xdf7b8dce,
0x5bb40613,	0x0b0c1e0f,	0x85b82c98,	0x18da4dc1,
0xc5fd78ac,	0x57c1e31d,	0x4c4001b5,	0xe31d2643,
0xa6afbf58,	0xad200e68,	0xf0114ba4,	0xd6a620f2,
0xc753a720,	0xac9022a0,	0x28a41f01,	0x22a4ba95,
0xc00b7531,	0x23d42795,	0xcd836a86,	0x90262708,
0x3292cad0,	0x40022e39,	0xc1581b0a,	0xe5101550,
0x6538096b,	0x208c549d,	0x3ce2bf88,	0xa71df38e,
0x3dec3685,	0xca3949f1,	0x79f3ad1b,	0x3ee8b300,
0x9d305fc6,	0x7a2e5288,	0xbe81a2f2,	0x7ada0c06,
0x191c7f01,	0x58dfcbd1,	0xc78dee72,	0x72364226,
0x1866de12,	0x8d22305c,	0x943a0f0e,	0xc81967ff,
0x4d55fb0f,	0xaf199be1,	0x90bbda61,	0x4e7c234f,
0x90cfec16,	0x9b4bcf26,	0x21622023,	0x0926f0fa,
0x1d504377,	0xa58db427,	0x8d93ce2b,	0x90bfe900,
0x29e67397,	0x2c1261ed,	0x4ace9474,	0xd5c60282,
0xe53fb300,	0x8a61a0ab,	0xa7aa0918,	0x4389d7c5,
0xd09d605c,	0x6c5bedb5,	0xd6d54c51,	0x433dea21,
0x7ad9e677,	0x813bff76,	0x5a162c75,	0x1ee0661f,
0x9b6c2030,	0x8e8dc989,	0xcd4bc9fc,	0x4454675b,
0x8d583c9c,	0xe3400094,	0x116ebb83,	0xe847bc9a,
0x2a4622dd,	0x2a901e6f,	0xd789b1c0,	0x094e2bbb,
0x056e563f,	0x9f17e606,	0x8bc79b8d,	0xd2c535c1,
0x06a45a27,	0x9dc56771,	0xa06649e2,	0x5ff25ac8,
0x6554961e,	0x98e583d9,	0x38ba93da,	0xdee1de18,
0x037cb9d5,	0x6b17f195,	0x3431faaf,	0x13860a0d,
0x28bca10d,	0x0a54c011,	0x9957cdb6,	0x3aa1f429,
0x9d41b7b3,	0x9aea5be2,	0x60c7ce6b,	0x4cd1c10b,
0x24ddddcd,	0xe28412ba,	0xa03a5466,	0xa1896879,
0x59edcb87,	0x1b241765,	0x157bf161,	0xf219f950,
0xe86ff526,	0x262005d9,	0x11769531,	0xbca15d95,
0x28f5ef17,	0x1f27e725,	0xc32631d2,	0x07249e61,
0x1ba851e3,	0x4f49b577,	0xe2a1df5e,	0x826fa7ff,
0xc34e1e2e,	0x7fe26024,	0xbc19800f,	0x0d368dc9,
0xe03da0c6,	0xadaa4f9c,	0x9ad1e43c,	0x96f84e44,
0x0b6cd695,	0x1bb46971,	0x942d6e5b,	0x6316170d,
0x3164509f,	0xc6659450,	0xb2a0370a,	0xabc208e8,
0x6d479811,	0x3684bc0e,	0x80b7b101,	0xa50b7bb5,
0x43d21233,	0xb423559d,	0xf41dcd16,	0xdfd3c276,
0x3e586469,	0xd9b7630a,	0xb88f9e44,	0x0cda6f4d,
0xe5bf5844,	0x8709f788,	0xdae37da6,	0x1fb41777,
0x1d903f69,	0x34383b69,	0xd409ae70,	0xd1c99758,
0xdedfd7a4,	0xa4bdf018,	0xf4058202,	0x8565d66f,
0x5365aed9,	0xfa69742e,	0x2cfbfbcf,	0x88a00b60,
0x506c0713,	0x2866475b,	0x3e1df573,	0xb86f7feb,
0x31d23a7f,	0xc6320e6a,	0x3ebbc2a5,	0x83a1d4ef,
0x15169f5f,	0x42a61753,	0x893e553e,	0x4ddbc66d,
0x7449ec1f,	0x76f65d22,	0x0622e13b,	0x32986f89,
0x21181b4b,	0x99a80c0a,	0xd6fe00b0,	0x282c0e81,
0x9fc1cf88,	0x919b855d,	0x618257d8,	0x82c448b8,
0xe22537a1,	0xa90de388,	0xba73b90c,	0xd765eeb0,
0x62b2727e,	0xa08dfe20,	0x70b3c8c5,	0x3ef04007,
0x9f73732b,	0x2201edd7,	0xb836219c,	0xf913af7c,
0xf50f64ca,	0x93ac107a,	0xf509f84a,	0x6f6026f6,
0xd9bb8eac,	0x4b268cfa,	0xa65a3fa6,	0x9837cb75,
0x784fb835,	0x2060576d,	0xb1604cae,	0xb9da4116,
0xab320cf2,	0x60a1b501,	0x0c73fa79,	0x8d5a6f1e,
0x57688086,	0x218e4005,	0xca054e3d,	0xc1a3c3ec,



/*  MU168a01.inc  */
0x00000001,	0x00000001,	0x11022000,	0x0000068a,
0x80fc9e3b,	0x00000001,	0x00000010,	0x00000000,
0x00000000,	0x00000000,	0x00000000,	0x00000000,
0x4efad552,	0x58a399f1,	0xf144f845,	0xfdb9117d,
0xb230677d,	0x1136f756,	0x8298a1b2,	0xb0c9cffc,
0x1e77875e,	0x2ea286ab,	0x6943a0b5,	0x41e37874,
0xfad4205d,	0xbc2d4993,	0xe5ac11e8,	0xa81a4aa8,
0x977a1e24,	0xd78cb1a7,	0xea9b7600,	0x280582ee,
0x04779e3e,	0x4af7afda,	0xeba0b976,	0x40f8ed1c,
0x9801c81d,	0xf500eb15,	0x74eb0918,	0x9b17c81f,
0x9d5dd38f,	0x17410757,	0xf843bed3,	0x2c401670,
0x6a428a9d,	0x28640d65,	0x35840c58,	0xcae15773,
0xcad83b47,	0x304765ea,	0x36da3de4,	0xaca34c0f,
0x61950b2a,	0x13ff21a5,	0x0817c1bb,	0x7e68e7a3,
0x89d484f7,	0xa2c84945,	0xbdd500eb,	0x0f7aaaef,
0x43b3cc4d,	0x55aaf9b2,	0xb8e9831f,	0xf093b0b9,
0x8266e028,	0x5242bbd4,	0xccd1f798,	0x385ee185,
0x15b897df,	0xedcc4e3e,	0x5028068b,	0xe3fc6555,
0x24c2ded3,	0xf9ddf6aa,	0x1256f316,	0x21829113,
0x17bd6a35,	0x252bdbdf,	0x9d356e62,	0xe02c900a,
0xa3f04a7d,	0xd607feeb,	0xb2938296,	0x63192310,
0x0aa601be,	0xe75ba498,	0xe844f6cc,	0xd9016ef6,
0x0ee53a7b,	0x4109ef16,	0x06f14b3a,	0x28185283,
0x97abaed9,	0xb6aaf076,	0xdb485b2d,	0x64213aa4,
0xd95491d1,	0x79495ede,	0x0f6d13d2,	0x409172b3,
0x71ff4426,	0x39482f22,	0x7411a8a8,	0x1d33b47f,
0xd1b42e84,	0xec7754cf,	0x89116c0f,	0x2c09c658,
0x99c8564f,	0x6b901f71,	0x83a077bd,	0xd50ac9fe,
0x53427f66,	0x93447a6a,	0xa72bfaf2,	0x33e743e8,
0x240588c1,	0xd74f75fb,	0xbf90f7a5,	0x75c3c8a2,
0x9d0c5193,	0x43b92dd1,	0x2c00a47a,	0xfffce742,
0x5d3ac1fa,	0xcdc46584,	0x712af8c7,	0x3733fe09,
0xbb301419,	0x2bb6a944,	0x3edd7c53,	0x31157d4a,
0xba14f3a0,	0xa385a286,	0xa6ac6f44,	0xb09ee00a,
0x4fb68608,	0x5eba43d6,	0xeddde198,	0x688e46eb,
0x4f4cef08,	0xd3dd5f9d,	0x8c0d995b,	0xb1688d6d,
0x40f050f3,	0x064f8c26,	0x2acbc04b,	0xe3be1052,
0x81765ee9,	0x38ec4036,	0x4aebe9e4,	0x700aee4d,
0x0ddee69f,	0x32a8240c,	0xf1aadda5,	0x79d64bf0,
0x79bca80b,	0x42ba8186,	0x5093b355,	0xc6bc148a,
0x60bbbcf0,	0x58843416,	0x68fe124e,	0x551551b5,
0x2ee3310b,	0x3fe684e4,	0xd2669d2f,	0x6d32a6ec,
0x3c038661,	0xdfce797f,	0xb44f91b9,	0x6b054e2c,
0x6c8a55b0,	0x53d4f5cf,	0xa9ef5cc9,	0x6a1497e3,
0xdad943af,	0x7ac80ff7,	0x0a233ada,	0xdd162f79,
0x654e8707,	0x6e0d72dc,	0xa7f16610,	0x64af2199,
0x43cbc05a,	0xa082d85a,	0xa0ecc319,	0xed5fb102,
0x50e03123,	0x1e691374,	0x76cca719,	0x96a54140,
0xe637f7ac,	0x0bdceb2c,	0x2509562e,	0xdc493727,
0x9ae44e2b,	0xbe7c82e6,	0xdd903312,	0x16182680,
0xab131706,	0x00753d5a,	0x4f018f8a,	0x768bbd06,
0xda089985,	0x9ec0bf68,	0xcf0ca6d6,	0xef21a479,
0x10f990bb,	0x976257b1,	0x448acbd0,	0xd6a49e41,
0x146a9f84,	0x1c462ffe,	0xc1e13fc2,	0x33a89da1,
0xefe418ba,	0x2157e31e,	0xc9dab388,	0x7a5175f7,
0x8fca565c,	0x3badf7fa,	0xb6b3ad3c,	0xcdc7c3db,
0x75c1db40,	0x9f93463f,	0x869e7c18,	0xe3841a98,
0x47f4b382,	0x5b708e12,	0xb704f263,	0x0977410d,
0x510dad8c,	0x6e6e5abb,	0x523171ed,	0x0641bebd,
0x03f8ab45,	0xffb1561a,	0xbac7c413,	0x893143e7,
0x78f8702e,	0xf3a1a5dc,	0x154f9e24,	0xecee7df8,
0x887b465c,	0x31ea2f2d,	0x58e06b7f,	0x3e53c9d3,
0x838ba96f,	0x4f0239d3,	0xf295395e,	0xb3c38631,
0x7ea7a143,	0x157a4e43,	0x46f8173f,	0xfbc18d4a,
0xc401e17a,	0xc4620358,	0xd2ab5437,	0xa01db06f,
0x58ce91fc,	0x850de1a3,	0x9b542dba,	0xee77f038,
0xddd3ced6,	0xc225d2ce,	0x63a3f765,	0x3342a06c,
0x6a780c2f,	0xfaa925b2,	0x366ebeec,	0xbcc9abea,
0xc7b3fa4e,	0xf4f1123d,	0x5198702c,	0x3e3458b7,
0x0b1ce9a1,	0x51b1bd7f,	0x711e791e,	0x927d8bed,
0x91dbaea9,	0x7eefbda9,	0x7a19edd9,	0xdf7b8dce,
0x5bb40613,	0x0b0c1e0f,	0x85b82c98,	0x18da4dc1,
0xc5fd78ac,	0x57c1e31d,	0x4c4001b5,	0xe31d2643,
0xa6afbf58,	0xad200e68,	0xf0114ba4,	0xd6a620f2,
0xc753a720,	0xac9022a0,	0x28a41f01,	0x22a4ba95,
0xc00b7531,	0x23d42795,	0xcd836a86,	0x90262708,
0x3292cad0,	0x40022e39,	0xc1581b0a,	0xe5101550,
0x6538096b,	0x208c549d,	0x3ce2bf88,	0xa71df38e,
0x3dec3685,	0xca3949f1,	0x79f3ad1b,	0x3ee8b300,
0x9d305fc6,	0x7a2e5288,	0xbe81a2f2,	0x7ada0c06,
0x191c7f01,	0x58dfcbd1,	0xc78dee72,	0x72364226,
0x1866de12,	0x8d22305c,	0x943a0f0e,	0xc81967ff,
0x4d55fb0f,	0xaf199be1,	0x90bbda61,	0x4e7c234f,
0x90cfec16,	0x9b4bcf26,	0x21622023,	0x0926f0fa,
0x1d504377,	0xa58db427,	0x8d93ce2b,	0x90bfe900,
0x29e67397,	0x2c1261ed,	0x4ace9474,	0xd5c60282,
0xe53fb300,	0x8a61a0ab,	0xa7aa0918,	0x4389d7c5,
0xd09d605c,	0x6c5bedb5,	0xd6d54c51,	0x433dea21,
0x7ad9e677,	0x813bff76,	0x5a162c75,	0x1ee0661f,
0x9b6c2030,	0x8e8dc989,	0xcd4bc9fc,	0x4454675b,
0x8d583c9c,	0xe3400094,	0x116ebb83,	0xe847bc9a,
0x2a4622dd,	0x2a901e6f,	0xd789b1c0,	0x094e2bbb,
0x056e563f,	0x9f17e606,	0x8bc79b8d,	0xd2c535c1,
0x06a45a27,	0x9dc56771,	0xa06649e2,	0x5ff25ac8,
0x6554961e,	0x98e583d9,	0x38ba93da,	0xdee1de18,
0x037cb9d5,	0x6b17f195,	0x3431faaf,	0x13860a0d,
0x28bca10d,	0x0a54c011,	0x9957cdb6,	0x3aa1f429,
0x9d41b7b3,	0x9aea5be2,	0x60c7ce6b,	0x4cd1c10b,
0x24ddddcd,	0xe28412ba,	0xa03a5466,	0xa1896879,
0x59edcb87,	0x1b241765,	0x157bf161,	0xf219f950,
0xe86ff526,	0x262005d9,	0x11769531,	0xbca15d95,
0x28f5ef17,	0x1f27e725,	0xc32631d2,	0x07249e61,
0x1ba851e3,	0x4f49b577,	0xe2a1df5e,	0x826fa7ff,
0xc34e1e2e,	0x7fe26024,	0xbc19800f,	0x0d368dc9,
0xe03da0c6,	0xadaa4f9c,	0x9ad1e43c,	0x96f84e44,
0x0b6cd695,	0x1bb46971,	0x942d6e5b,	0x6316170d,
0x3164509f,	0xc6659450,	0xb2a0370a,	0xabc208e8,
0x6d479811,	0x3684bc0e,	0x80b7b101,	0xa50b7bb5,
0x43d21233,	0xb423559d,	0xf41dcd16,	0xdfd3c276,
0x3e586469,	0xd9b7630a,	0xb88f9e44,	0x0cda6f4d,
0xe5bf5844,	0x8709f788,	0xdae37da6,	0x1fb41777,
0x1d903f69,	0x34383b69,	0xd409ae70,	0xd1c99758,
0xdedfd7a4,	0xa4bdf018,	0xf4058202,	0x8565d66f,
0x5365aed9,	0xfa69742e,	0x2cfbfbcf,	0x88a00b60,
0x506c0713,	0x2866475b,	0x3e1df573,	0xb86f7feb,
0x31d23a7f,	0xc6320e6a,	0x3ebbc2a5,	0x83a1d4ef,
0x15169f5f,	0x42a61753,	0x893e553e,	0x4ddbc66d,
0x7449ec1f,	0x76f65d22,	0x0622e13b,	0x32986f89,
0x21181b4b,	0x99a80c0a,	0xd6fe00b0,	0x282c0e81,
0x9fc1cf88,	0x919b855d,	0x618257d8,	0x82c448b8,
0xe22537a1,	0xa90de388,	0xba73b90c,	0xd765eeb0,
0x62b2727e,	0xa08dfe20,	0x70b3c8c5,	0x3ef04007,
0x9f73732b,	0x2201edd7,	0xb836219c,	0xf913af7c,
0xf50f64ca,	0x93ac107a,	0xf509f84a,	0x6f6026f6,
0xd9bb8eac,	0x4b268cfa,	0xa65a3fa6,	0x9837cb75,
0x784fb835,	0x2060576d,	0xb1604cae,	0xb9da4116,
0xab320cf2,	0x60a1b501,	0x0c73fa79,	0x8d5a6f1e,
0x57688086,	0x218e4005,	0xca054e3d,	0xc1a3c3ec,





};
 
 
 
void display_cpuid_update_microcode(void)
{
	unsigned int eax, ebx, ecx, edx;
	unsigned int pf, rev, sig, val[2];
	unsigned int x86_model, x86_family, i;
	struct microcode *m;
	int found = 0 ;
	/* cpuid sets msr 0x8B iff a microcode update has been loaded. */
	wrmsr(0x8B, 0, 0);
	cpuid(1, &eax, &ebx, &ecx, &edx);
	rdmsr(0x8B, val[0], rev);
	x86_model = (eax >>4) & 0x0f;
	x86_family = (eax >>8) & 0x0f;
	sig = eax;

	pf = 0;
	if ((x86_model >= 5)||(x86_family>6)) {
		rdmsr(0x17, val[0], val[1]);
		pf = 1 << ((val[1] >> 18) & 7);
	}
//	printk("\n\n");
//	printk("microcode_info: sig = 0x%08x pf=0x%08x rev = 0x%08x\n",sig, pf, rev);
  
	m = (struct microcode *)microcode_updates;
	// We have 2 microocde Tables
	for(i = 0; i < 2; i++) {
		if ((m[i].sig == sig) && (m[i].pf == pf)) {
			wrmsr(0x79, (unsigned int)&m[i].bits, 0);
			__asm__ __volatile__ ("cpuid" : : : "ax", "bx", "cx", "dx");
			rdmsr(0x8B, val[0], val[1]);
			//printk("microcode updated from revision %d to %d\n", rev, val[1]);
			found = 1;
		}
	}
//	if (found == 0) printk("No Valid Microcode Update for this processor found\n")
}


