/* vi: set sw=4 ts=4:
 *
 * Copyright (C) 2001 - 2010 Christian Hohnstaedt.
 *
 * All rights reserved.
 */

#ifndef __PKI_EXCEPTION_H
#define __PKI_EXCEPTION_H

#include <QtCore/QString>
#include <QtCore/QObject>
#include "base.h"

#define E_PASSWD 1

class errorEx
{
	private:
		QString msg;
	public:
		int info;
		errorEx(QString txt = "", QString className = "", int inf = 0)
		{
			msg = txt;
			if (!className.isEmpty())
				msg += " (" + className + ")";
			info = inf;
		}
		errorEx(const errorEx &e)
		{
			msg = e.msg;
			info = e.info;
		}
		void appendString(QString s)
		{
			msg = msg + " " + s;
		}
		QString getString() const
		{
			return msg;
		}
		const char *getCString() const
		{
			return msg.toAscii();
		}
		bool isEmpty() const
		{
			return msg.isEmpty();
		}
};

#define check_oom(ptr) \
	if(!ptr) { \
		throw errorEx(QObject::tr("Out of Memory at %1:%2").\
			arg(__FILE__).arg(__LINE__)); \
	}

#endif
