 /*
 * file      : cd_normalise.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#include <gtk/gtk.h>

#include "support.h"

#include <pthread.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <stdio.h>
#include <signal.h>

#include "global.h"
#include "cd_audio.h"
#include "cd_normalise.h"



typedef struct {
	
	GList	*ListPeakGroup;		/* Pointeur sur AUDIO */
	gint	 MaxElements;
	gint	 NumExtract;
	
} VAR_CD_NORMALISE;

VAR_CD_NORMALISE VarCdNormalise = { NULL, 0, 0 };



/* PEAK GROUP
*/
void CdNormalise_set_list_PeakGroup (AUDIO *Audio)
{
	/*PRINT_FUNC_LF();*/
	
	VarCdNormalise.ListPeakGroup = g_list_append (VarCdNormalise.ListPeakGroup, Audio);
	VarCdNormalise.MaxElements ++;
}

void CdNormalise_add_PeakGroup (void)
{
	VarCdNormalise.NumExtract ++;
}

void CdNormalise_set_list_collectif_remove (void)
{
	GList         *List = NULL;

	List = g_list_first (VarCdNormalise.ListPeakGroup);
	while (List) {
		/*List->data = NULL;*/
		List = g_list_next(List);
	}
	g_list_free (VarCdNormalise.ListPeakGroup);
	VarCdNormalise.ListPeakGroup = NULL;
	
	VarCdNormalise.MaxElements = 0;
	VarCdNormalise.NumExtract = 0;
}

gboolean CdNormalise_list_PeakGroup_is_ready (void)
{
	if (VarCdNormalise.MaxElements == VarCdNormalise.NumExtract) return (TRUE);
	return (FALSE);
}

gboolean CdNormalise_get_is_list_PeakGroup (void)
{
	return (VarCdNormalise.ListPeakGroup == NULL ? FALSE : TRUE);
}

GList *CdNormalise_get_list_PeakGroup (void)
{
	GList	*List = NULL;
	GList	*ListPeakGroup = NULL;
	AUDIO	*Audio = NULL;

	ListPeakGroup = g_list_first (VarCdNormalise.ListPeakGroup);
	while (ListPeakGroup) {
		Audio = (AUDIO *)ListPeakGroup->data;
		List = g_list_append (List, g_strdup (Audio->PathName_Dest_Wav));
		ListPeakGroup = g_list_next(ListPeakGroup);
	}

	return ((GList *)List);
}

void CdNormalise_set_normalise_ok (void)
{
	GList	*List = NULL;
	AUDIO	*Audio = NULL;
	
	List = g_list_first (VarCdNormalise.ListPeakGroup);
	while (List) {
		if ((Audio = (AUDIO *)List->data)) {
			Audio->EtatNormalise = FALSE;
			Audio->EtatPeak = CD_NORM_PEAK_NONE;
		}
		List = g_list_next(List);
	}
	gtk_combo_box_set_active (GTK_COMBO_BOX (var_cd.Adr_combobox_normalise_cd), 0);
}







