 /*
 * file      : dvd_audio.h
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifndef __dvd_audio_h__
#define __dvd_audio_h__ 1

typedef enum {
	_DVD_NAME=0,						/* Le nom du DVD					*/
	_DVD_TITLE,						/* Le titre						*/
	_DVD_CHAPTER,						/* Le chapitre						*/
	_DVD_DATA,						/* Les datas pour une extraction partielle		*/
	_DVD_DATA_ALL						/* Les datas pour une extraction complete		*/
} TYPE_LIST_DVD;

typedef enum {
	_INCONNU_ = 0,						/**/
	_DTS_,							/**/
	_AC3_							/**/
} FORMAT_ID;

typedef enum {
	_COCHE_ = 0,						/* Pret a etre selectionne				*/
	_SELECTED_,						/* En selection avec le canal d'origine			*/
	_CH_2_							/* En selection avec le canal 2				*/
} ETAT_CHOIX;

typedef struct {
	TYPE_LIST_DVD		 type_list_dvd;			/* Le type			*/
	gchar			*def;				/* La chaine d'info		*/
	gchar			*time;				/* La duree			*/
	guint			 GUINT_TempsTotal;		/* Duree totale en secondes	*/
	gchar			*name_file;			/* Le nom du fichier		*/
	FORMAT_ID		 format_id;			/* _INCONNU_, _DTS_ ou _AC3_	*/
	gchar			*StrNumerateTitle;		/* Le numero du titre		*/
	gint			 NumerateTitle;			/* Le numero du titre		*/
	gchar			*StrNumerateChapter;		/* Le numero du chapitre	*/
	gint			 NumerateChapter;		/* Le numero du chapitre	*/
	gchar			*StrNumberChannel;		/* Le nombre de canaux		*/
	gchar			*StrNumerateStreamId;		/* La langue			*/
	gint			 OldChannels;			/* Le canal d'origine		*/
	gint			 NewChannels;			/* Le nouveau canal		*/
	ETAT_CHOIX		 EtatChoix;			/* _COCHE_, _SELECTED_, _CH_2_	*/
	gint			 NumStruct;			/* Numero pour dvdaudio_event	*/
	gboolean		 BoolDvdPlay;			/* TRUE = Play, FALSE = NONE	*/
	gint			 DebutLecture;			/**/
	/*ETAT_NORMALISE_DVD	 EtatNormalise;*/			/**/
	gboolean		 EtatNormalise;			/**/
	
} VAR;

typedef enum {
	_DVDAUDIO_DVD_ = 0,					/* La source = DVD		*/
	_DVDAUDIO_FILE_						/* La source = dossier (DVD)	*/
} DVDAUDIO_SOURCE;

typedef struct {
	gboolean		 bool_dvd;			/* */
	gchar			*path;				/* */
} INFO_DVDAUDIO;

typedef struct {
	gdouble			 double_TempsTotal;		/* */
	guint			 guint_TempsTotal;		/* */
	GList			*list;				/* */
} PLAY_DVDAUDIO;

typedef struct {

	GtkComboBox		*Adr_combobox_normalise_dvd;	/* Adresse */
	
	GtkTreeModel		*Adr_Tree_Model;		/* */
	GtkWidget		*Adr_TreeView;			/* */
	GtkWidget		*Adr_scroll;			/* Adresse */
	GtkTreeSelection	*Adr_Line_Selected;		/* Adresse */

	GdkPixbuf		*Pixbuf_FilePlay;		/* */
	GdkPixbuf		*Pixbuf_FileStop;		/* */
	GdkPixbuf		*Pixbuf_Coche;			/* */
	GdkPixbuf		*Pixbuf_Coche_Exist;		/* */
	GdkPixbuf		*Pixbuf_Selected;		/* */
	GdkPixbuf		*Pixbuf_2ch;			/* */

	GtkButton		*Adr_button_destination_dvd;	/* */
	GtkComboBox		*Adr_ComboBox_Reader;		/* */
	
	GtkComboBox		*Adr_combobox_sub_dvd;		/* */
	GtkComboBox		*Adr_combobox_ambiance_dvd;	/* */

	gboolean		 bool_click;			/* */
	GtkWidget		*Adr_progressbar_dvd;		/* */

	gint			 total_selected_2ch;		/* */
	gint			 total_selected;		/* */
	gboolean		 bool_selected;			/* */
	gboolean		 bool_sa;			/* */

	guint			 Handler_Timeout;		/* */
	gboolean		 bool_end_pthread;		/* */
	gboolean		 bool_read_dvd;			/* */
	gboolean		 bool_halt;			/* */

	gint			 int_temp;			/* */

	INFO_DVDAUDIO		 from;				/* */

	gint			 NumStruct;			/* Numero pour dvdaudio_event	*/
	gboolean		 bool_dedans;			/* */
	
	gint			 bool_err;			/* */

	GtkTreeViewColumn	*Adr_Column_Titres;		/* */
	GtkTreeViewColumn	*Adr_Column_Play;		/* */
	GtkTreeViewColumn	*Adr_Column_Temps;		/* */
	GtkTreeViewColumn	*Adr_Column_Format;		/* */
	GtkTreeViewColumn	*Adr_Column_Choix;		/* */
	GtkTreeViewColumn	*Adr_Column_Normalise;		/* */
	GtkCellRenderer		*renderer;			/* */
	GtkTreeViewColumn	*Adr_Column_Nom;		/* */
		
	/* PLAYER ONGLET CD */
	/*
	GtkObject         *AdrAdjustDVD;
	GtkWidget         *AdrHscaleDVD;
	GtkWidget         *AdrLabelTimeDVD;
	GtkWidget         *AdrButtonStopDVD;
	*/
	
	guint			 GUINT_TempsTotal;		/* Duree totale en secondes		*/
	
	PLAY_DVDAUDIO		 PlayDvdAudio;			/* */
	
	gint			 TTNormPeak;			/* Nombre total de Peak			*/
	gint			 TTNormPeakCollectif;		/* Nombre total de Peak Collectif	*/
	
	gboolean		 BoolNormIsSelected;
	
	gchar			*PathDvd;
	
} VAR_DVDAUDIO;

extern VAR_DVDAUDIO var_dvdaudio;				/* */

extern GList *GlistDvd;						/* */

typedef struct {
	VAR			*Var;				/*					*/
	/*ETAT_NORMALISE_DVD	 EtatNormalise;*/
	gboolean		 EtatNormalise;
	gchar			*Path;				/* Nom du fichier final			*/
	GList			*list;				/* Glist pour l'extraction		*/
} NEW_DVD_EXTRACT;

extern GList *GlistDvdExtract;


/*
typedef struct {
	gint			 NormPeak;
	gint			 NormPeakCollectif;
	GList			*List;
} DVD_GLIST_EXTRACTION;

extern DVD_GLIST_EXTRACTION DvdGlistExtraction;
*/

/*
DvdGlistExtraction.NormPeak		-- Nombre total de Peak
DvdGlistExtraction.NormPeakCollectif	-- Nombre total de Peak Collectif
DvdGlistExtraction.List->Path		-- Nom du fichier final
DvdGlistExtraction.List->list		-- Glist pour l'extraction
*/

/*
*---------------------------------------------------------------------------
* DVD_AUDIO_EXTRACT.C
*---------------------------------------------------------------------------
*/
void dvdaudioextract_dvd_to_file (void);
void dvdaudioextract_halt (void);

/*
*---------------------------------------------------------------------------
* DVD_EXEC.C
*---------------------------------------------------------------------------
*/
void     dvdexec_create_list (TYPE_LIST_DVD type_list_dvd,
				gchar *def,
				gchar *time,
				gchar *name_file,
				gint   format_id,
				gint   NumerateTitle,
				gint   NumerateChapter,
				gint   NumberChannel,
				gchar *StrNumerateStreamId);
void     dvdexec_remove_list (void);
gboolean dvdexec_dvd_found (void);
gboolean dvdexec_dvd_read (void);

/*
*---------------------------------------------------------------------------
* DVD_AUDIO.C
*---------------------------------------------------------------------------
*/

typedef enum {
	_STATUSBAR_RESTITUE_ = 0,			/**/
	_STATUSBAR_SAVE_,				/**/
	_STATUSBAR_SET_					/**/
} STATUSBAR_FLAG;

void      dvdaudio_make_scrolledwindow_realize (GtkWidget *widget);
void      dvdaudio_combobox_peripherique_dvd_realize (GtkWidget *widget);
void      dvdaudio_reffresh_list_dvd (void);
void      dvdaudio_button_destination_dvd_realize (GtkWidget *widget);
void      dvdaudio_button_destination_dvd_clicked (void);
void      dvdaudio_puts_label_statusbar (STATUSBAR_FLAG StatusbarFlag, gchar *mess_label_status);
void      dvdaudio_button_extraction_dvd_clicked (void);
void      dvdaudio_button_annuler_lecture_dvd_clicked (void);
void      dvdaudio_set_flag_buttons_dvd (void);
void      dvdaudio_remove_GtkTree (void);
void      dvdaudio_set_new_channels (gint channel);
void      dvdaudio_combobox_sub_dvd_realize (GtkWidget *widget);
void      dvdaudio_combobox_ambiance_dvd_realize (GtkWidget *widget);
gboolean  dvdaudio_bool_read_dvd_from_directory (void);
void      dvdaudio_pixbuf_stop_play (void);
void      dvdaudio_set_etat_music_pixbuf (gboolean *PtrBoolDvdPlay, gboolean p_BoolDvdPlay);
void      dvdaudio_set_flag_normalise (gboolean EtatNormalise);
void      dvdaudio_update (void);
void      dvdaudio_combobox_normalise_dvd_realize (GtkWidget *widget);
gint      dvdaudio_get_value_normalise_dvd (void);
void      dvdaudio_button_eject_dvd_clicked (void);

/*
*---------------------------------------------------------------------------
* DVD_TABLE.C
*---------------------------------------------------------------------------
*/
gchar *dvdtable_get (gint channel, gint pan);

#endif
