 /*
 * file      : play_file.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include "support.h"
#include "interface.h"

#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include <pthread.h>

#include "global.h"
#include "utils.h"
#include "play_file.h"


typedef struct {
	pthread_t	 nmr_tid;
	gchar		*Playeur;
	gchar		*Param;
	gchar		*PathNameFile;
} VAR_PLAYFILE ;

VAR_PLAYFILE PlayFile;


void PlayFile_call (void)
{
	pid_t  pid;

	if ((pid = fork ()) == 0) {
		if (PlayFile.Param != NULL && *PlayFile.Param != '\0') {
			execlp (PlayFile.Playeur,
				PlayFile.Playeur,
				PlayFile.Param,
				PlayFile.PathNameFile,
				NULL);
			_exit (0);
		}
		else {
			execlp (PlayFile.Playeur,
				PlayFile.Playeur,
				PlayFile.PathNameFile,
				NULL);
			_exit (0);
		}
	}
}

static void PlayFile_thread (void *arg)
{
	PlayFile_call ();
	pthread_exit(0);
}

void PlayFile_play (gchar *Playeur, gchar *Param, gchar *PathNameFile)
{
	PRINT_FUNC_LF();
	g_print ("\t%s %s %s\n", Playeur, Param, PathNameFile);
	
	
	if (PlayFile.Playeur != NULL) {
		g_free (PlayFile.Playeur);
		PlayFile.Playeur = NULL;
	}
	if (PlayFile.Param != NULL) {
		g_free (PlayFile.Param);
		PlayFile.Param = NULL;
	}
	if (PlayFile.PathNameFile != NULL) {
		g_free (PlayFile.PathNameFile);
		PlayFile.PathNameFile = NULL;
	}
	PlayFile.Playeur      = g_strdup (Playeur);
	PlayFile.Param        = g_strdup (Param);
	PlayFile.PathNameFile = g_strdup (PathNameFile);
	pthread_create (&PlayFile.nmr_tid, NULL ,(void *)PlayFile_thread, (void *)NULL);
}
















