 /*
 * file      : player_exec.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include <pthread.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>

#include "interface.h"
#include "support.h"
#include "global.h"
#include "file.h"
#include "cd_audio.h"
#include "dvd_audio.h"
#include "secu.h"
#include "get.h"
#include "win_control.h"
#include "options.h"
#include "utils.h"
#include "split.h"
#include "win_play.h"
#include "player.h"



/*
*---------------------------------------------------------------------------
* EXTERNAL REF
*---------------------------------------------------------------------------
*/
extern int kill(pid_t pid, int sig);


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/
void PlayerExec_print_type_ListPlayFrom (LIST_PLAY_FROM ListPlayFrom)
{
	g_print ("----------------------------------------------------------------------------\n");
	switch(ListPlayFrom) {
	case LIST_PLAY_FROM_NONE :	g_print ("LIST_PLAY_FROM_NONE\n");	break;
	case LIST_PLAY_FROM_DVD :	g_print ("LIST_PLAY_FROM_DVD\n");	break;
	case LIST_PLAY_FROM_CD :	g_print ("LIST_PLAY_FROM_CD\n");	break;
	case LIST_PLAY_FROM_FILE :	g_print ("LIST_PLAY_FROM_FILE\n");	break;
	case LIST_PLAY_FROM_SPLIT :	g_print ("LIST_PLAY_FROM_SPLIT\n");	break;
	}
	g_print ("----------------------------------------------------------------------------\n");
}

/*
*---------------------------------------------------------------------------
* SIGNAL ET EXECUTE EXTERNAL
*---------------------------------------------------------------------------
*/

/* synchronisation */
void PlayerExec_sigchld (gint signum)
{
	gint status;
        wait(&status);
	/* PRINT_FUNC_LF(); */
        /* if there are still children waiting
        *  re-install the signal handler
	*/
	VarPlayer.SignalNumchildren --;
        if (VarPlayer.SignalNumchildren > 0)
        {
                /* re-install the signal handler */
                signal (SIGCHLD, PlayerExec_sigchld);
        }
}
/* Execution mplayer */
int PlayerExec_call_exec (PLAYER_ARGS *args, pid_t *p, gint p_output)
{
	gchar **ptr = (gchar **)args;

	VarPlayer.SignalNumchildren = 0;
	if (pipe (VarPlayer.Tube) != 0)
	{
		fprintf (stderr, "error: pipe\n");
		exit (1);
	}
	if ((*p = fork()) == 0)
	{
		dup2 (VarPlayer.Tube [ 1 ], p_output);
		close (VarPlayer.Tube [ 1 ]);
		execvp ((gchar *)*(ptr+0), ptr);
		fprintf (stderr, "error: exec");
		exit (2);
	}
	VarPlayer.SignalNumchildren ++;
	signal (SIGCHLD, PlayerExec_sigchld);
	close (VarPlayer.Tube [ 1 ]);
	return (VarPlayer.Tube [ 0 ]);
}

/*
*---------------------------------------------------------------------------
* COMMANDES FIFO
*---------------------------------------------------------------------------
*/

void PlayerExec_create_fifo (void)
{
	gchar *args[ 10 ];
	gint   pos = 0;
	gint   status;
	pid_t  NumFork;		

	if (infosong_access_mode (AM_FILE_EXIST, "/tmp/cmd", NULL) == TRUE) return;

	args [ pos++ ] = "mkfifo";
	args [ pos++ ] = "/tmp/cmd";
	args [ pos++ ] = NULL;
	args [ pos++ ] = NULL;
	/*
	for (pos = 0; args[ pos ] != NULL; pos++)
		g_print ("args [ %02d ] = '%s'\n", pos, args [ pos ]);
	g_print ("\n");
	*/
	if ((NumFork = fork ()) == 0) {
		execvp (args[0], args);
		exit (2);
	}

	waitpid (NumFork, &status, WUNTRACED);
}

void PlayerExec_remove_fifo (void)
{
	gchar *args[ 10 ];
	gint   pos = 0;
	gint   status;
	pid_t  NumFork;		

	if (infosong_access_mode (AM_FILE_EXIST, "/tmp/cmd", NULL) == FALSE) return;

	args [ pos++ ] = "rm";
	args [ pos++ ] = "-rf";
	args [ pos++ ] = "/tmp/cmd";
	args [ pos++ ] = NULL;
	args [ pos++ ] = NULL;
	/*
	for (pos = 0; args[ pos ] != NULL; pos++)
		g_print ("args [ %02d ] = '%s'\n", pos, args [ pos ]);
	g_print ("\n");
	*/
	if ((NumFork = fork ()) == 0) {
		execvp (args[0], args);
		exit (2);
	}

	waitpid (NumFork, &status, WUNTRACED);
}

void PlayerExec_DEBUG (void)
{
return;
	g_print ("VarPlayer.Button = ");
	switch (VarPlayer.Button) {
	case GDK_BUTTON_PRESS	: g_print ("GDK_BUTTON_PRESS\n");	break;
	case GDK_BUTTON_RELEASE	: g_print ("GDK_BUTTON_RELEASE\n");	break;
	default			: g_print ("%d\n", VarPlayer.Button);	break;
	}
	g_print ("VarPlayer.BoolPushButton = ");
	switch (VarPlayer.BoolPushButton) {
	case PUSH_BUTTON_NONE	: g_print ("PUSH_BUTTON_NONE\n");	break;
	case PUSH_BUTTON_PLAY	: g_print ("PUSH_BUTTON_PLAY\n");	break;
	case PUSH_BUTTON_PAUSE	: g_print ("PUSH_BUTTON_PAUSE\n");	break;
	case PUSH_BUTTON_STOP	: g_print ("PUSH_BUTTON_STOP\n");	break;
	default			: g_print ("PUSH default\n");
	}
	
}

void PlayerExec_set_fifo (gchar *str)
{
	if (VarPlayer.BoolErreurMplayer == TRUE) return;
	if (VarPlayer.BoolThreadActivate == FALSE) return;

PlayerExec_DEBUG ();

	if (infosong_access_mode (AM_FILE_EXIST, "/tmp/cmd", NULL) == TRUE) {
		FILE *fp = NULL;
		if ((fp = fopen ("/tmp/cmd", "w")) != NULL) {
			/*
			g_print ("%s\n", str);
			*/
			fprintf (fp, "%s\n", str);
			fclose (fp);
		}
	}
}
void PlayerExec_fifo_quit (void)
{
	PlayerExec_set_fifo ("quit");
	VarPlayer.ListPlayFrom = LIST_PLAY_FROM_NONE;
	/*PlayerExec_print_type_ListPlayFrom (VarPlayer.ListPlayFrom);*/
}
void PlayerExec_fifo_pause (void)
{
	PlayerExec_set_fifo ("pause");
}
void PlayerExec_fifo_get_percent_pos (void)
{
	PlayerExec_set_fifo ("get_percent_pos");
}
void PlayerExec_fifo_get_time_pos (void)
{
	PlayerExec_set_fifo ("get_time_pos");
}
void PlayerExec_fifo_get_time_length (void)
{
	PlayerExec_set_fifo ("get_time_length");
}
void PlayerExec_fifo_seek (gdouble PercentValue)
{
	gchar *Str = NULL;
	guint sec;
	
	if (PercentValue < 0.0) PercentValue = 0.0;
	if (PercentValue > 100.0) PercentValue = 100.0;
	
	sec = (gint) ((VarPlayer.DOUBLE_TempsTotal * PercentValue) / 100.0);

	/*Str = g_strdup_printf ("seek +%d:%d 2", (guint)value / 60, (guint)value % 60);*/
	Str = g_strdup_printf ("seek %d 2", sec);
/*g_print("\t%s\n", Str);*/
	PlayerExec_set_fifo (Str);
	g_free (Str);
	Str = NULL;
}


void PlayerExec_fifo_seek_with_hundr (gdouble PercentValue)
{
	gchar  *Mess = NULL;
	gint    sec;
	gdouble dsec;
	gint    hundr;
	
	if (PercentValue < 0.0) PercentValue = 0.0;
	if (PercentValue > 100.0) PercentValue = 100.0;
	
	sec = (gint) ((VarPlayer.DOUBLE_TempsTotal * PercentValue) / 100.0);
	dsec  = (VarPlayer.DOUBLE_TempsTotal * PercentValue) / 100.0;
	hundr = (dsec - (gdouble)sec) * 1000.0;
	if (hundr >= 1000) hundr = 999;

	Mess = g_strdup_printf ("seek %d.%d 2", sec, hundr);
/*g_print("%s\n",Mess);*/
	PlayerExec_set_fifo (Mess);

	g_free (Mess);
	Mess = NULL;
}

/*
*---------------------------------------------------------------------------
* THREAD
*---------------------------------------------------------------------------
*/
#define MAX_BUF_PLAYER 1024

static void PlayerExec_do_thread (void *arg)
{
	gint		 pos = 0;
	gint		 fd;
	gint		 size;
	gchar		 buf [ MAX_BUF_PLAYER + 10 ];
	gchar		*Ptr = NULL;
	guint		 Sec;
	guint		 Hundr;
	gdouble		 SecondesTempsActuel = 0.0;
	gboolean         BoolEndRead = FALSE;
	
	PRINT("DEBUT THREAD");
	VarPlayer.BoolThreadActivate = TRUE;

	fd = PlayerExec_call_exec (VarPlayer.PlayerArgs, &VarPlayer.CodeFork, STDOUT_FILENO);

	do {
		if (fd < 0) {
			VarPlayer.BoolErreurMplayer = TRUE;
			break;
		}
		
		pos = -1;
		do {			
			pos++;
			if (pos >= MAX_BUF_PLAYER) {
				PRINT_FUNC_LF();
				g_print ("pos(%d) >= CONV_MAX_CARS(%d)\n", pos, MAX_BUF_PLAYER);
				pos --;
			}
			size = read (fd, &buf[pos], 1);
			
			if (strstr(buf,"Audio: no sound")) {
				VarPlayer.BoolErreurMplayer = TRUE;
				g_print("\tAudio: no sound\n");
				break;
			}
			if (strstr(buf,"Cannot sync MAD frame")) {
				VarPlayer.BoolErreurMplayer = TRUE;
				g_print("\tCannot sync MAD frame\n");
				break;
			}
		} while (VarPlayer.BoolThreadActivate == TRUE && (buf[pos] != '\b') && (buf[pos] != '\r') && (buf[pos] != '\n') && (size > 0));

		if (VarPlayer.BoolErreurMplayer == TRUE) {
			break;
		}
	
		if (strstr(buf,"A:") == NULL && VarPlayer.PercentTempsActuel > 0. && *buf == '\n') {
			PRINT("");
			break;
		}

		/*
		ANS_PERCENT_POSITION=8.0 (04:36.0)  0.8%
		*/
		if ((Ptr = strstr(buf,"ANS_PERCENT_POSITION=")) != NULL) {
			if (VarPlayer.ListPlayFrom == LIST_PLAY_FROM_DVD) {
				while (*Ptr != '=') Ptr++;
				if (*Ptr == '=') Ptr++;
				/*VarPlayer.PercentTempsActuel = (gdouble)atoi(Ptr);*/
				/*
				g_print("buf = %s", buf);
				g_print("atoi(Ptr) = %d\n", atoi(Ptr) );
				*/
				if (atoi(Ptr) >= 99) {
					PRINT("FIN ET ARRET LECTURE DVD-AUDIO");
					/*PlayerExec_set_fifo ("quit");*/
					/*VarPlayer.BoolErreurMplayer = TRUE;*/
					BoolEndRead = TRUE;
					break;
				}
			}
		}

		/*
		ANS_TIME_POSITION=0.0.0 (01:25.0) ??,?% 
		ANS_TIME_POSITION=72.785.0 (01:25.0)  3.3% 
		*/
		if ((Ptr = strstr(buf,"ANS_TIME_POSITION=")) != NULL && strstr(buf,"??,?") == NULL) {
			// g_print("%s\n", Ptr);
			while (*Ptr != '=') Ptr++;
			if (*Ptr == '=') Ptr++;
			Sec = atoi (Ptr);
			while (*Ptr != '.') Ptr++;
			if (*Ptr == '.') Ptr++;
			Hundr = atoi (Ptr);
			SecondesTempsActuel = (gdouble)Sec + ((gdouble)Hundr / 10.0);
			VarPlayer.PercentTempsActuel = (SecondesTempsActuel / VarPlayer.DOUBLE_TempsTotal) * 100.0;
			
			// g_print ("-----------------------------------------------VarPlayer.PercentTempsActuel = %f\n", VarPlayer.PercentTempsActuel);
			// g_print ("-----------------------------------------------VarPlayer.DOUBLE_TempsTotal  = %f\n", VarPlayer.DOUBLE_TempsTotal);
			// g_print ("-----------------------------------------------SecondesTempsActuel          = %f\n", SecondesTempsActuel);
			
			if (VarPlayer.BeginPercentTempsActuel == -1.) {
				VarPlayer.BeginPercentTempsActuel = VarPlayer.PercentTempsActuel;
				// g_print ("VarPlayer.BeginPercentTempsActuel = %f\n\tVarPlayer.PercentTempsActuel = %f\n", VarPlayer.BeginPercentTempsActuel, VarPlayer.PercentTempsActuel);
				// g_print("--> %f\n", VarPlayer.PercentTempsActuel - VarPlayer.BeginPercentTempsActuel);
			}
			/*
			if (VarPlayer.BeginPercentTempsActuel  > -1.) {
				g_print ("VarPlayer.BeginPercentTempsActuel = %f\n\tVarPlayer.PercentTempsActuel = %f\n", VarPlayer.BeginPercentTempsActuel, VarPlayer.PercentTempsActuel);
				g_print("--> %f\n", VarPlayer.PercentTempsActuel - VarPlayer.BeginPercentTempsActuel);
			}
			*/
			
			if (VarPlayer.ListPlayFrom == LIST_PLAY_FROM_FILE) {
				if (VarPlayer.PercentTempsActuel >=  100.0) {
					VarPlayer.PercentTempsActuel = 0.0;
					BoolEndRead = TRUE;
					break;
				}
			}
			else if (VarPlayer.ListPlayFrom == LIST_PLAY_FROM_SPLIT) {
				if (VarPlayer.PercentTempsActuel >= VarPlayer.DOUBLE_TempsTotalSection || VarPlayer.PercentTempsActuel >=  99.855072) {
					// g_print("\nFIN\n\tVarPlayer.PercentTempsActuel       = %f\n\tVarPlayer.DOUBLE_TempsTotalSection = %f\n",
					// 		VarPlayer.PercentTempsActuel, VarPlayer.DOUBLE_TempsTotalSection);
					VarPlayer.PercentTempsActuel = 100.0;
					BoolEndRead = TRUE;
					break;
				}
			}
			else if (VarPlayer.ListPlayFrom != LIST_PLAY_FROM_DVD) {
				if (VarPlayer.PercentTempsActuel >=  99.855072) {
					/*VarPlayer.PercentTempsActuel = 100.0;*/
					BoolEndRead = TRUE;
					break;
				}
			}
		}
		
		/*
		ANS_LENGTH=85.00of 85.0 (01:25.0)  2.7% 
		*/
		else if ((Ptr = strstr(buf,"ANS_LENGTH=")) != NULL) {
			// g_print("%s",Ptr);
			while (*Ptr != '=') Ptr++;
			if (*Ptr == '=') Ptr++;
			Sec = atoi (Ptr);
			while (*Ptr != '.') Ptr++;
			if (*Ptr == '.') Ptr++;
			Hundr = atoi (Ptr);
			/*VarPlayer.DOUBLE_TempsTotal = (gdouble)Sec + ((gdouble)Hundr / 10.0);*/
			VarPlayer.DOUBLE_TempsTotal = (gdouble)Sec;
			VarPlayer.GUINT_TempsTotal = (guint)VarPlayer.DOUBLE_TempsTotal;
		}
		
		if (buf[pos] != '\n') {
			pos ++;
			buf[pos++] = '\n';
			buf[pos] = '\0';
		}
	} while (VarPlayer.BoolThreadActivate == TRUE && (size > 0));

	close(fd);
	
	if (BoolEndRead == TRUE) {
		PlayerExec_set_fifo ("quit");
	}
	VarPlayer.PercentTempsActuel = 100.0;
	BoolEndRead = TRUE;
	
	VarPlayer.BoolThreadActivate = FALSE;
	PRINT("FIN THREAD");
	VarPlayer.Button = -1;
	
	if (VarPlayer.BoolErreurMplayer == TRUE) {
		g_print("\n");
		g_print("KILL Process mplayer = ");
		if ((kill (VarPlayer.CodeFork, SIGKILL) != 0))
			g_print ("ERREUR\n");
		else	g_print ("OK\n");
		g_print("\n");
	}

	pthread_exit (0);
}

/*
*---------------------------------------------------------------------------
* TIMEOUT
*---------------------------------------------------------------------------
*/

static gint PlayerExec_do_timeout (gpointer data)
{
	static gint cpt = -1;

	if (VarPlayer.Button == GDK_BUTTON_PRESS) return (TRUE);
	if (VarPlayer.BoolPushButton == PUSH_BUTTON_PAUSE) return (TRUE);
	if (VarPlayer.Button != -1) return (TRUE);
	
	if (cpt ++ == 0) PlayerExec_fifo_get_percent_pos ();
	if (cpt >= 10) cpt = -1;

	switch (VarPlayer.ListPlayFrom) {
	case LIST_PLAY_FROM_NONE :
		break;
	
	case  LIST_PLAY_FROM_DVD :
		PlayerExec_fifo_get_time_pos ();
		/*Player_set_value_time (VarPlayer.PercentTempsActuel);*/
		WinPlay_set_value_time (VarPlayer.PercentTempsActuel);
		break;
		
	case  LIST_PLAY_FROM_CD :
		if (VarPlayer.DOUBLE_TempsTotal == 0.0) PlayerExec_fifo_get_time_length ();
		else 					PlayerExec_fifo_get_time_pos ();
		/*Player_set_value_time (VarPlayer.PercentTempsActuel);*/
		WinPlay_set_value_time (VarPlayer.PercentTempsActuel);
		break;
		
	case  LIST_PLAY_FROM_FILE :
		if (VarPlayer.DOUBLE_TempsTotal == 0.0) PlayerExec_fifo_get_time_length ();
		else 					PlayerExec_fifo_get_time_pos ();
		/*Player_set_value_time (VarPlayer.PercentTempsActuel);*/
		WinPlay_set_value_time (VarPlayer.PercentTempsActuel);
		break;
		
	case  LIST_PLAY_FROM_SPLIT :
		if (VarPlayer.DOUBLE_TempsTotal == 0.0) PlayerExec_fifo_get_time_length ();
		else 					PlayerExec_fifo_get_time_pos ();
		
		// split_with_mplayer (VarPlayer.PercentTempsActuel);
		
		if (VarPlayer.DOUBLE_TempsTotal > 0. && VarPlayer.PercentTempsActuel > 0.) {
			split_with_mplayer (VarPlayer.PercentTempsActuel - VarPlayer.BeginPercentTempsActuel);
		}
		break;
	}
	
	if (VarPlayer.BoolThreadActivate == FALSE) {
		
		VarPlayer.BeginPercentTempsActuel = -1.;
		VarPlayer.DOUBLE_TempsTotal = 0.;
		
		/*VarPlayer.PercentTempsActuel = 0.0;*/
		Player_set_value_time (VarPlayer.PercentTempsActuel);

		gtk_timeout_remove (VarPlayer.HandlerTimeout);
		VarPlayer.BoolTimeoutActivate = FALSE;
		PRINT("FIN TIMEOUT");

		/* Widget de l'onglet dvd, cd ou fichiers sur ATTENTE */
		switch (VarPlayer.OLDListPlayFrom) {
		case LIST_PLAY_FROM_NONE :
			break;
		case LIST_PLAY_FROM_DVD :
			VarPlayer.PercentTempsActuel = 0.0;
			WinPlay_set_value_time (VarPlayer.PercentTempsActuel);
			dvdaudio_set_etat_music_pixbuf (NULL, FALSE);
			WinPlay_after_end ();
			break;
		case LIST_PLAY_FROM_CD :
			VarPlayer.PercentTempsActuel = 0.0;
			WinPlay_set_value_time (VarPlayer.PercentTempsActuel);
			cdaudio_set_etat_music_pixbuf_with_detail (NULL, CD_ETAT_PLAY_ATTENTE);
			WinPlay_after_end ();
			break;
		case LIST_PLAY_FROM_FILE :
			VarPlayer.PercentTempsActuel = 0.0;
			WinPlay_set_value_time (VarPlayer.PercentTempsActuel);
			file_set_etat_music_pixbuf_with_detail (NULL, FILE_ETAT_PLAY_ATTENTE);
			WinPlay_after_end ();
			break;
		case LIST_PLAY_FROM_SPLIT :
			/*VarPlayer.PercentTempsActuel = 100.0;*/
			VarPlayer.PercentTempsActuel = 0.0;
			split_with_mplayer (VarPlayer.PercentTempsActuel);
			file_set_etat_music_pixbuf_with_detail (NULL, FILE_ETAT_PLAY_ATTENTE);
			gtk_widget_show (GTK_WIDGET (VarSplit.AdrButtonPlay));
			gtk_widget_hide (GTK_WIDGET (VarSplit.AdrButtonStop));
			gtk_widget_set_sensitive (GTK_WIDGET (VarSplit.AdrButtonStop), FALSE);
			gtk_widget_set_sensitive (GTK_WIDGET (VarSplit.AdrButtonPlay), TRUE);
			break;
		}
		
		VarPlayer.OLDListPlayFrom = VarPlayer.ListPlayFrom;
	}
	return (TRUE);
}

/*
*---------------------------------------------------------------------------
* INTERFACE UTILISATEUR -> MPLAYER VIA LE TIMEOUT
*---------------------------------------------------------------------------
*/

void PlayerExec_user_to_quit (void)
{
	VarPlayer.BoolPushButton = PUSH_BUTTON_STOP;
	PlayerExec_fifo_quit ();
	/*VarPlayer.PercentTempsActuel = 0.0;*/
}
void PlayerExec_user_to_pause (void)
{
	VarPlayer.BoolPushButton = PUSH_BUTTON_PAUSE;
	PlayerExec_fifo_pause ();
}
void PlayerExec_user_to_seek (void)
{
}
void PlayerExec_user_to_get_time_pos (void)
{
	PlayerExec_fifo_get_time_pos ();
}
gboolean PlayerExec_is_activate (void)
{
	return (VarPlayer.BoolThreadActivate);
}

gboolean PlayerExec_is_activate_from_split (void)
{
	return (VarPlayer.ListPlayFrom == LIST_PLAY_FROM_SPLIT ? TRUE : FALSE);
}

/*
void DEBUG_PRINT_LIST (GList *p_list)
{
	GList *list = NULL;
	gchar *ptr = NULL;
	
	list = g_list_first (p_list);
	while (list) {
		if ((ptr = (gchar *)list->data)) {
			g_print ("%s\n", ptr);
		}
		list = g_list_next (list);
	}
}
*/

/*
*---------------------------------------------------------------------------
* PREPARATION DE LA LISTE ET EXECUTION
*---------------------------------------------------------------------------
*/

/* Construit la nouvelle liste d'arguments et
*  detruit en sortie la liste en parametres
*/
void PlayerExec_set_list (LIST_PLAY_FROM ListPlayFrom, gdouble p_TempsTotalSection, guint p_TempsTotalSurface, GList *p_list)
{
	GList	*list = NULL;
	gchar	*ptr = NULL;
	guint	 elements = 0;
	gint	 pos = 0;
	
	/* PRINT_FUNC_LF(); */

	VarPlayer.DOUBLE_TempsTotalSection = p_TempsTotalSection;
	VarPlayer.BeginPercentTempsActuel = -1.;

	/* Detruit mplayer via fifo */
	PlayerExec_fifo_quit ();
	VarPlayer.BoolPushButton = PUSH_BUTTON_PLAY;
	
	/* Creation du fichier de controle de mplayer */
	PlayerExec_create_fifo ();
	while (VarPlayer.BoolThreadActivate == TRUE) {
		if (VarPlayer.BoolThreadActivate == FALSE) break;
	}
	
	if (ListPlayFrom != LIST_PLAY_FROM_DVD)		dvdaudio_set_etat_music_pixbuf (NULL, FALSE);
	if (ListPlayFrom != LIST_PLAY_FROM_CD)		cdaudio_set_etat_music_pixbuf_with_detail (NULL, CD_ETAT_PLAY_ATTENTE);
	if (ListPlayFrom != LIST_PLAY_FROM_FILE)	file_set_etat_music_pixbuf_with_detail (NULL, FILE_ETAT_PLAY_ATTENTE);
	if (ListPlayFrom != LIST_PLAY_FROM_SPLIT)	split_button_stop_lecture_split_clicked ();

	/* Stocke le type d'appel */
	VarPlayer.OLDListPlayFrom =
	VarPlayer.ListPlayFrom = ListPlayFrom;
	PlayerExec_print_type_ListPlayFrom (VarPlayer.ListPlayFrom);
	
	/* Detruit l'ancienne liste */
	g_free (VarPlayer.PlayerArgs);
	VarPlayer.PlayerArgs = NULL;
	/* Detruit la liste des arguments */
	VarPlayer.ArgsPlay = utils_clear_list (VarPlayer.ArgsPlay);
	VarPlayer.ArgsPlay = NULL;

	/* Construit la nouvelle liste */
	VarPlayer.ArgsPlay = g_list_append (VarPlayer.ArgsPlay, g_strdup ("nice"));
	VarPlayer.ArgsPlay = g_list_append (VarPlayer.ArgsPlay, g_strdup ("-n"));
	VarPlayer.ArgsPlay = g_list_append (VarPlayer.ArgsPlay, g_strdup_printf ("%d", options_get_val_nice ()));
	VarPlayer.ArgsPlay = g_list_append (VarPlayer.ArgsPlay, g_strdup ("mplayer"));
	// VarPlayer.ArgsPlay = g_list_append (VarPlayer.ArgsPlay, g_strdup ("-ao"));
	// VarPlayer.ArgsPlay = g_list_append (VarPlayer.ArgsPlay, g_strdup ("sdl"));
	/*
	@Shankarius
	Mplayer -nojoystick -nolirc -nortc -noautosub -nomouseinput
	*/
	VarPlayer.ArgsPlay = g_list_append (VarPlayer.ArgsPlay, g_strdup ("-nojoystick"));
	VarPlayer.ArgsPlay = g_list_append (VarPlayer.ArgsPlay, g_strdup ("-nolirc"));
	VarPlayer.ArgsPlay = g_list_append (VarPlayer.ArgsPlay, g_strdup ("-nortc"));
	VarPlayer.ArgsPlay = g_list_append (VarPlayer.ArgsPlay, g_strdup ("-noautosub"));
	VarPlayer.ArgsPlay = g_list_append (VarPlayer.ArgsPlay, g_strdup ("-nomouseinput"));
	
	/*
	VarPlayer.ArgsPlay = g_list_append (VarPlayer.ArgsPlay, g_strdup ("-af"));	// http://forum.hardware.fr/hfr/VideoSon/Traitement-Audio/valeur-bitrate-sujet_72413_1.htm
	VarPlayer.ArgsPlay = g_list_append (VarPlayer.ArgsPlay, g_strdup ("-srate"));	// 44100 hertz x 16 bits x 2 voies = 1411200 bits, soit 1411,2 kbps.
	VarPlayer.ArgsPlay = g_list_append (VarPlayer.ArgsPlay, g_strdup ("4000"));	// 22050  4000 * 16 * 2 = 128000
	*/
	
	VarPlayer.ArgsPlay = g_list_append (VarPlayer.ArgsPlay, g_strdup ("-slave"));
	VarPlayer.ArgsPlay = g_list_append (VarPlayer.ArgsPlay, g_strdup ("-idle"));

	VarPlayer.ArgsPlay = g_list_append (VarPlayer.ArgsPlay, g_strdup ("-cache"));
	VarPlayer.ArgsPlay = g_list_append (VarPlayer.ArgsPlay, g_strdup ("8192"));	// 2048

	/* Recuperation des infos de la liste en parametre */
	list = g_list_first (p_list);
	while (list) {
		if ((ptr = (gchar *)list->data)) {
			switch (ListPlayFrom) {
			case LIST_PLAY_FROM_NONE :
				break;
			case LIST_PLAY_FROM_DVD :
				VarPlayer.ArgsPlay = g_list_append (VarPlayer.ArgsPlay, g_strdup_printf ("%s", ptr));
				break;
			case LIST_PLAY_FROM_CD :
				VarPlayer.ArgsPlay = g_list_append (VarPlayer.ArgsPlay, g_strdup_printf ("%s", ptr));
				break;
			case LIST_PLAY_FROM_FILE :
				VarPlayer.ArgsPlay = g_list_append (VarPlayer.ArgsPlay, g_strdup_printf ("%s", ptr));
				break;
			case LIST_PLAY_FROM_SPLIT :
				VarPlayer.ArgsPlay = g_list_append (VarPlayer.ArgsPlay, g_strdup_printf ("%s", ptr));
				break;
			}
		}
		list = g_list_next (list);
	}

	/* Termine la construction de la liste */
	VarPlayer.ArgsPlay = g_list_append (VarPlayer.ArgsPlay, g_strdup ("-input"));
	VarPlayer.ArgsPlay = g_list_append (VarPlayer.ArgsPlay, g_strdup ("file=/tmp/cmd"));

	/* Nombre d'elements dans la liste d'arguments PLUS DEUX */
	elements = g_list_length (VarPlayer.ArgsPlay);
	elements += 2;

	VarPlayer.PlayerArgs = (PLAYER_ARGS *)g_malloc0(sizeof(PLAYER_ARGS) * (elements));
	
	/* Construit la table des arguments pour exec */
	pos = 0;
	list = g_list_first (VarPlayer.ArgsPlay);
	while (list) {
		if ((ptr = (gchar *)list->data)) {
			VarPlayer.PlayerArgs[ pos++ ].str = (gchar *)ptr;
			g_print ("arg [ %02d ] =  %s\n", pos, ptr);
		}
		list = g_list_next (list);
	}
	VarPlayer.PlayerArgs[ pos++ ].str = NULL;

g_print ("----------------------------------------------------------------------------\n");
	list = g_list_first (VarPlayer.ArgsPlay);
	while (list) {
		if ((ptr = (gchar *)list->data)) {
			g_print ("%s ", ptr);
		}
		list = g_list_next (list);
	}
g_print ("\n----------------------------------------------------------------------------\n");

	if (VarPlayer.ListPlayFrom == LIST_PLAY_FROM_DVD) {
		VarPlayer.DOUBLE_TempsTotal = (gdouble)p_TempsTotalSurface;
		VarPlayer.GUINT_TempsTotal = p_TempsTotalSurface;
	}
	else if (VarPlayer.ListPlayFrom != LIST_PLAY_FROM_SPLIT) {
		VarPlayer.DOUBLE_TempsTotal = 0.0;
		VarPlayer.GUINT_TempsTotal = 0;
	}

	if (VarPlayer.PercentTempsActuel < 0.0) VarPlayer.PercentTempsActuel = 0.0;
	
	VarPlayer.BoolErreurMplayer = FALSE;

	/* Avtivation thread et timeout */
	if (VarPlayer.BoolThreadActivate == FALSE) {
		VarPlayer.BoolThreadActivate = TRUE;
		pthread_create (&VarPlayer.NmrTid, NULL ,(void *)PlayerExec_do_thread, (void *)NULL);
	}
	if (VarPlayer.BoolTimeoutActivate == FALSE) {
		VarPlayer.BoolTimeoutActivate = TRUE;
		PRINT("DEBUT TIMEOUT");
		VarPlayer.HandlerTimeout = gtk_timeout_add (100, PlayerExec_do_timeout, 0);
	}
	if (ListPlayFrom != LIST_PLAY_FROM_DVD	) {
		/*
		VarPlayer.PercentTempsActuel = (VarPlayer.DOUBLE_TempsTotalSection / VarPlayer.DOUBLE_TempsTotal) * 100.0;
		VarPlayer.PercentTempsActuel = 0.0;
		PlayerExec_fifo_seek_with_hundr (VarPlayer.PercentTempsActuel);
		*/
	}
	if (ListPlayFrom == LIST_PLAY_FROM_SPLIT) {
		// file_set_etat_music_pixbuf_with_detail (VarSplit.DetailActif, FILE_ETAT_PLAY);
	}
	
	VarPlayer.Button = -1;
	VarPlayer.BoolPushButton = PUSH_BUTTON_PLAY;
}

void PlayerExec_init (void)
{
	VarPlayer.ListPlayFrom = LIST_PLAY_FROM_NONE;
}

void PlayerExec_set_time_in_seconds (gdouble TimeSec)
{
	VarPlayer.DOUBLE_TempsTotal = TimeSec;
}




