 /*
 * file    : poche_gen.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <glib.h>
#include <glib/gprintf.h>
#include <string.h>
#include <stdlib.h>

#include <unistd.h>
#include <dirent.h>
#include <sys/stat.h>
#include <signal.h>
#include <sys/wait.h>
#include <sys/types.h>

#include "support.h"
#include "global.h"
#include "info_song.h"
#include "config_user.h"
#include "win_info.h"
#include "prg_init.h"
#include "poche.h"


/*
*---------------------------------------------------------------------------
* EXTERN
*---------------------------------------------------------------------------
*/

extern int kill (pid_t pid, int sig);




/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

typedef struct {				/* LES CHAMPS DE LA POCHETTE	*/
	gchar *author;				/* Auteur			*/
	gchar *title;				/* Titre de la chanson		*/
	gchar *time;				/* Duree			*/
} FIELDS_PS;

typedef struct {
	gchar    *str_package;			/* PARAM_PACKAGE 		*/
	gchar    *str_version;			/* PARAM_VERSION		*/
	gchar    *str_title;			/* PARAM_TITLE			*/
	gboolean  bool_title_cover;		/* PARAM_BOOL_TITLE_COVER	*/
	gboolean  bool_title_back;		/* PARAM_BOOL_TITLE_BACK	*/
	gchar    *str_foottext;			/* PARAM_FOOTTEXT		*/
	gboolean  bool_foottext_cover;		/* PARAM_BOOL_FOOTTEXT_COVER	*/
	gboolean  bool_foottext_back;		/* PARAM_BOOL_FOOTTEXT_BACK	*/
	gboolean  bool_textdata_cover;		/* PARAM_BOOL_TEXTDATA_COVER	*/
	gboolean  bool_textdata_back;		/* PARAM_BOOL_TEXTDATA_BACK	*/
	gboolean  bool_line_cover;		/* PARAM_BOOL_LINE_COVER	*/
	gboolean  bool_line_back;		/* PARAM_BOOL_LINE_BACK		*/
	GList    *glist_fields;			/* PARAM_TEXTDATA		*/
	gint      num_choicefieldscover;	/* PARAM_CHOICEFIELDSCOVER	*/
	gint      num_choicefieldsback;		/* PARAM_CHOICEFIELDSBACK	*/
} PS;


/*
*---------------------------------------------------------------------------
* STRUCTURE
*---------------------------------------------------------------------------
*/

PS *pochegen_remove_struct_ps (PS *p_ps)
{
	GList      *List = NULL;
	FIELDS_PS  *fps = NULL;

	/*PRINT_FUNC_LF();*/

	if (p_ps) {
		g_free (p_ps->str_package);
		p_ps->str_package = NULL;		/* PARAM_PACKAGE 		*/
		g_free (p_ps->str_version);
		p_ps->str_version = NULL;		/* PARAM_VERSION		*/
		g_free (p_ps->str_title);
		p_ps->str_title = NULL;			/* PARAM_TITLE			*/
		g_free (p_ps->str_foottext);
		p_ps->str_foottext = NULL;		/* PARAM_FOOTTEXT		*/

		List = g_list_first (p_ps->glist_fields);
		while (List) {
			if ((fps = (FIELDS_PS *)List->data)) {
				g_free (fps->author);
				g_free (fps->title);
				g_free (fps->time);
				List->data = NULL;
			}
			List = g_list_next (List);
		}
		g_list_free (p_ps->glist_fields);
		p_ps->glist_fields = NULL;		/* PARAM_TEXTDATA		*/

		g_free (p_ps);
		p_ps = NULL;
	}
	return (NULL);
}

PS *pochegen_allocate_struct_ps (void)
{
	PS *new = (PS *)g_malloc0 (sizeof (PS));

	/*PRINT_FUNC_LF();*/

	if (new) {
		new->str_package = NULL;		/* PARAM_PACKAGE 		*/
		new->str_version = NULL;		/* PARAM_VERSION		*/
		new->str_title = NULL;			/* PARAM_TITLE			*/
		new->bool_title_cover = FALSE;		/* PARAM_BOOL_TITLE_COVER	*/
		new->bool_title_back = FALSE;		/* PARAM_BOOL_TITLE_BACK	*/
		new->str_foottext = NULL;		/* PARAM_FOOTTEXT		*/
		new->bool_foottext_cover = FALSE;	/* PARAM_BOOL_FOOTTEXT_COVER	*/
		new->bool_foottext_back = FALSE;	/* PARAM_BOOL_FOOTTEXT_BACK	*/
		new->bool_textdata_cover = FALSE;	/* PARAM_BOOL_TEXTDATA_COVER	*/
		new->bool_textdata_back = FALSE;	/* PARAM_BOOL_TEXTDATA_BACK	*/
		new->bool_line_cover = FALSE;		/* PARAM_BOOL_LINE_COVER	*/
		new->bool_line_back = FALSE;		/* PARAM_BOOL_LINE_BACK		*/
		new->glist_fields = NULL;		/* PARAM_TEXTDATA		*/
		new->num_choicefieldscover = 0;		/* PARAM_CHOICEFIELDSCOVER	*/
		new->num_choicefieldsback = 0;		/* PARAM_CHOICEFIELDSBACK	*/
	}
	return ((PS *)new);
}

/* Lecture du buffer textview ligne par ligne pour le stocker dans des
*  structures 'TEXTDATA' qui seront chainees dans un GList
*/
GList *pochegen_get_glist_from_textview (void)
{
	GList         *List = NULL;
	GList         *NList = NULL;
	GtkTextBuffer *Buf = NULL;
	GtkTextIter    Start;
	GtkTextIter    End;
	gint           Total_Line = 0;
	gint           Cpt;
	gchar         *Ptr_buf = NULL;
	gchar         *Ptr = NULL;
	gchar        **Larrbuf = NULL;
	gint           i;
	gint           separator = 0;
	FIELDS_PS     *ps = NULL;

	/*PRINT_FUNC_LF();*/

	/* Suppression des lignes vides en fin de texte */
	for (Cpt = Total_Line; Cpt > 1; Cpt --) {
		Buf = gtk_text_view_get_buffer (GTK_TEXT_VIEW (poche.Adr_textview));
		gtk_text_buffer_get_iter_at_line_offset (Buf, &Start, Cpt, 0);
		gtk_text_buffer_get_end_iter (Buf, &End);
		Ptr_buf = g_locale_from_utf8 (gtk_text_buffer_get_text (Buf, &Start, &End, FALSE), -1, NULL, NULL, NULL);

		if (*Ptr_buf == '\n' || *Ptr_buf == '\0')
			gtk_text_buffer_delete (Buf, &Start, &End);
		else	break;
	}

	/* Get start-end buffer text with coord. in utf8 */
	Buf = gtk_text_view_get_buffer (GTK_TEXT_VIEW (poche.Adr_textview));
	gtk_text_buffer_get_bounds (Buf, &Start, &End);
	Ptr_buf = g_locale_from_utf8 (gtk_text_buffer_get_text (Buf, &Start, &End, FALSE), -1, NULL, NULL, NULL);

	/* Decompose le buffer en lignes de texte */
	Larrbuf = g_strsplit(Ptr_buf, "\n", 0);

	for (i=0; Larrbuf[i]; i++) {
		/* delette end cars line */
		if ((Ptr = strrchr (Larrbuf[i], 13))) *Ptr = '\0';
		if ((Ptr = strrchr (Larrbuf[i], 10))) *Ptr = '\0';

		/* total car '-' in Larrbuf[i] pour 'separator' */
		for (separator = 0, Ptr = Larrbuf[i]; ; ) {
			/* Ptr = strchr (Ptr, '-'); */
			Ptr = strstr (Ptr, " - ");
			if (!Ptr) break;
			Ptr++;
			Ptr++;
			Ptr++;
			separator ++;
		}

		ps = (FIELDS_PS *)g_malloc0 (sizeof (FIELDS_PS));

		/* DEUX CHAMPS */
		if (separator == 1) {
			/* champs UN pour: ps->author */
			ps->author = g_strdup (Larrbuf[i]);
			/* Ptr = strchr (ps->author, '-'); */
			Ptr = strstr (ps->author, " - ");
			Ptr--;
			while (Ptr > ps->author && (*Ptr == ' ' || *Ptr == '\t')) Ptr--;
			Ptr++;
			*Ptr = '\0';
			/* champs DEUX pour: ps->title */
			/* Ptr = strchr (Larrbuf[i], '-'); */
			Ptr = strstr (Larrbuf[i], " - ");
			Ptr ++;
			Ptr ++;
			Ptr ++;
			while (*Ptr && (*Ptr == ' ' || *Ptr == '\t')) Ptr++;
			ps->title = g_strdup (Ptr);
			/* champs TROIS FICTIF pour: ps->time */
			ps->time = g_strdup ("00:00");
		}
		/* TROIS CHAMPS */
		else if (separator == 2) {
			/* champs UN pour: td->author */
			ps->author = g_strdup (Larrbuf[i]);
			/* Ptr = strchr (ps->author, '-'); */
			Ptr = strstr (ps->author, " - ");
			Ptr--;
			while (Ptr > ps->author && (*Ptr == ' ' || *Ptr == '\t')) Ptr--;
			Ptr++;
			*Ptr = '\0';
			/* champs DEUX pour: ps->title */
			/* Ptr = strchr (Larrbuf[i], '-'); */
			Ptr = strstr (Larrbuf[i], " - ");
			Ptr ++;
			Ptr ++;
			Ptr ++;
			while (*Ptr && (*Ptr == ' ' || *Ptr == '\t')) Ptr++;
			ps->title = g_strdup (Ptr);
			/* Ptr = strchr (ps->title, '-'); */
			Ptr = strstr (ps->title, " - ");
			Ptr--;
			while (Ptr > ps->title && (*Ptr == ' ' || *Ptr == '\t')) Ptr--;
			Ptr++;
			*Ptr = '\0';
			/* champs TROIS pour: ps->time */
			Ptr = strrchr (Larrbuf[i], '-');
			if (Ptr > Larrbuf[i] && *(Ptr -1) == ' ' && *(Ptr -1) == ' ')
			Ptr ++;
			while (*Ptr && (*Ptr == ' ' || *Ptr == '\t')) Ptr++;
			ps->time = g_strdup (Ptr);
		}
		/* ON NE CONSIDERE QU'UN SEUL CHAMPS */
		else {
			/* champs UN pour: ps->author */
			ps->author = g_strdup (Larrbuf[i]);
			ps->title = g_strdup ("");
			ps->time = g_strdup ("00:00");
		}

		List = g_list_append (List, ps);
	}

	/* Suppression des structures vides en fin de liste */
	NList = g_list_last (List);
	while (NList) {
		ps = (FIELDS_PS *)NList->data;
		if (ps && *ps->author == '\0' && *ps->title == '\0') {
			g_free (ps->author); ps->author = NULL;
			g_free (ps->title); ps->title = NULL;
			g_free (ps->time); ps->time = NULL;
			g_free (ps); ps = NULL;
			NList->data = NULL;
		}
		else {
			break;
		}
		NList = g_list_previous (NList);
	}
	g_strfreev(Larrbuf);

	return (List);
}

PS *pochegen_get_struct_ps (void)
{
	PS   *new = NULL;
	gint  num;

	if ((new = pochegen_allocate_struct_ps ()) == NULL) {
		g_print ("ERREUR D'ALLOCATION MEMOIRE\n");
		return (NULL);
	}

	/*PRINT_FUNC_LF();*/

	new->str_package = g_strdup (PACKAGE);
	new->str_version = g_strdup (VERSION);
	new->str_title = g_strdup (pocheevnt_get_entry_titre_ps ());
	new->str_foottext = g_strdup (pocheevnt_get_entry_foottext_ps ());
	/*
	if (GTK_WIDGET_IS_SENSITIVE(GTK_COMBO_BOX (poche.Adr_combobox_text_recto)) ||
	    GTK_WIDGET_IS_SENSITIVE(GTK_COMBO_BOX (poche.Adr_combobox_text_verso))) {
		new->glist_fields = pochegen_get_glist_from_textview ();
	}
	*/
	new->glist_fields = pochegen_get_glist_from_textview ();
	
	/* Titre sur recto / verso */
	switch (gtk_combo_box_get_active (GTK_COMBO_BOX (poche.Adr_combobox_entry_title))) {
	case 0 :
		new->bool_title_cover = TRUE;
		new->bool_title_back = FALSE;
		break;
	case 1 :
		new->bool_title_cover = FALSE;
		new->bool_title_back = TRUE;
		break;
	case 2 :
		new->bool_title_cover = TRUE;
		new->bool_title_back = TRUE;
		break;
	case 3 :
		new->bool_title_cover = FALSE;
		new->bool_title_back = FALSE;
		break;
	}
	/*
	if (GTK_WIDGET_IS_SENSITIVE(GTK_COMBO_BOX (poche.Adr_combobox_entry_title)) == FALSE) {
		new->bool_title_cover = FALSE;
		new->bool_title_back = FALSE;
	}
	*/
	
	/* Pied de page sur recto / verso */
	switch (gtk_combo_box_get_active (GTK_COMBO_BOX (poche.Adr_combobox_entry_foottext))) {
	case 0 :
		new->bool_foottext_cover = TRUE;
		new->bool_foottext_back = FALSE;
		break;
	case 1 :
		new->bool_foottext_cover = FALSE;
		new->bool_foottext_back = TRUE;
		break;
	case 2 :
		new->bool_foottext_cover = TRUE;
		new->bool_foottext_back = TRUE;
		break;
	case 3 :
		new->bool_foottext_cover = FALSE;
		new->bool_foottext_back = FALSE;
		break;
	}
	/*
	if (GTK_WIDGET_IS_SENSITIVE(GTK_COMBO_BOX (poche.Adr_combobox_entry_foottext)) == FALSE) {
		new->bool_foottext_cover = FALSE;
		new->bool_foottext_back = FALSE;
	}
	*/

	/* liste au recto */
	num = gtk_combo_box_get_active (GTK_COMBO_BOX (poche.Adr_combobox_text_recto));
	switch (num) {
	case 0 :
	case 1 :
	case 2 :
	case 3 :
	case 4 :
	case 5 :
		new->num_choicefieldscover = num;
		new->bool_textdata_cover = TRUE;
		break;
	default :
		new->num_choicefieldscover = 0;
		new->bool_textdata_cover = FALSE;
	}
	/*
	if (GTK_WIDGET_IS_SENSITIVE(GTK_COMBO_BOX (poche.Adr_combobox_text_recto)) == FALSE) {
		new->num_choicefieldscover = 0;
		new->bool_textdata_cover = FALSE;
	}
	*/

	/* liste au verso */
	num = gtk_combo_box_get_active (GTK_COMBO_BOX (poche.Adr_combobox_text_verso));
	switch (num) {
	case 0 :
	case 1 :
	case 2 :
	case 3 :
	case 4 :
	case 5 :
		new->num_choicefieldsback = num;
		new->bool_textdata_back = TRUE;
		break;
	default :
		new->num_choicefieldsback = 0;
		new->bool_textdata_back = FALSE;
	}
	/*
	if (GTK_WIDGET_IS_SENSITIVE(GTK_COMBO_BOX (poche.Adr_combobox_text_verso)) == FALSE) {
		new->num_choicefieldsback = 0;
		new->bool_textdata_back = FALSE;
	}
	*/

	/* Relier les champs */
	switch (gtk_combo_box_get_active (GTK_COMBO_BOX (poche.Adr_combobox_link_fields))) {
	case 0 :
		new->bool_line_cover = TRUE;
		new->bool_line_back = FALSE;
		break;
	case 1 :
		new->bool_line_cover = FALSE;
		new->bool_line_back = TRUE;
		break;
	case 2 :
		new->bool_line_cover = TRUE;
		new->bool_line_back = TRUE;
		break;
	case 3 :
		new->bool_line_cover = FALSE;
		new->bool_line_back = FALSE;
		break;
	}
	/*
	if (GTK_WIDGET_IS_SENSITIVE(GTK_COMBO_BOX (poche.Adr_combobox_link_fields)) == FALSE) {
		new->bool_line_cover = FALSE;
		new->bool_line_back = FALSE;
	}
	*/

	return ((PS *)new);
}

/*
*---------------------------------------------------------------------------
* GEN CODE IMAGEMAGICK
*---------------------------------------------------------------------------
*/
void pochegen_code_convert_ps (void)
{
	FILE  *fp_preview = NULL;
	guint  line = 0;

	/*PRINT_FUNC_LF();*/
	
	fp_preview = fopen (poche.file_preview_ps, "a");
	while (*code_convert_ps [ line ]) {
		fprintf (fp_preview, "%s\n", code_convert_ps [ line ]);
		line ++;
	}
	fclose (fp_preview);
}

/*
*---------------------------------------------------------------------------
* GEN CODE XCFA
*---------------------------------------------------------------------------
*/

/* Generation du fichier PostScript
*/
void pochegen_code_xcfa_ps (void)
{
	FILE       *fp_preview = NULL;
	gint        line = 0;
	PS         *new = NULL;
	GList      *List = NULL;
	FIELDS_PS  *ps = NULL;

	/*PRINT_FUNC_LF();*/

	if ((new = pochegen_get_struct_ps ()) == NULL) {
		g_print ("ERREUR D'ALLOCATION MEMOIRE\n");
		return;
	}

	/* Creation fichier vierge */
	fp_preview = fopen (poche.file_preview_ps, "a");
	line = 0;

	while (*code_xcfa_ps [ line ]) {

		/* PARAM_PACKAGE	*/
		if (strstr (code_xcfa_ps [ line ], "PARAM_PACKAGE")) {
			fprintf (fp_preview, "/PACKAGE (%s) def\n", new->str_package);
		}
		/* PARAM_VERSION	*/
		else if (strstr (code_xcfa_ps [ line ], "PARAM_VERSION")) {
			fprintf (fp_preview, "/VERSION (%s) def\n", new->str_version);
		}
		/* PARAM_TITLE	*/
		else if (strstr (code_xcfa_ps [ line ], "PARAM_TITLE")) {
			fprintf (fp_preview, "/title (%s) def\n", new->str_title);
		}
		/* PARAM_BOOL_TITLE_COVER	*/
		else if (strstr (code_xcfa_ps [ line ], "PARAM_BOOL_TITLE_COVER")) {
			fprintf (fp_preview, "/bool_title_cover %s def\n", new->bool_title_cover ? "true" : "false");
		}
		/* PARAM_BOOL_TITLE_BACK	*/
		else if (strstr (code_xcfa_ps [ line ], "PARAM_BOOL_TITLE_BACK")) {
			fprintf (fp_preview, "/bool_title_back %s def\n", new->bool_title_back ? "true" : "false");
		}
		/* PARAM_FOOTTEXT	*/
		else if (strstr (code_xcfa_ps [ line ], "PARAM_FOOTTEXT")) {
			fprintf (fp_preview, "/foottext (%s) def\n", new->str_foottext);
		}
		/* PARAM_BOOL_FOOTTEXT_COVER	*/
		else if (strstr (code_xcfa_ps [ line ], "PARAM_BOOL_FOOTTEXT_COVER")) {
			fprintf (fp_preview, "/bool_foottext_cover %s def\n", new->bool_foottext_cover ? "true" : "false");
		}
		/* PARAM_BOOL_FOOTTEXT_BACK	*/
		else if (strstr (code_xcfa_ps [ line ], "PARAM_BOOL_FOOTTEXT_BACK")) {
			fprintf (fp_preview, "/bool_foottext_back %s def\n", new->bool_foottext_back ? "true" : "false");
		}
		/* PARAM_BOOL_TEXTDATA_COVER	*/
		else if (strstr (code_xcfa_ps [ line ], "PARAM_BOOL_TEXTDATA_COVER")) {
			fprintf (fp_preview, "/bool_textdata_cover %s def\n", new->bool_textdata_cover ? "true" : "false");
		}
		/* PARAM_BOOL_TEXTDATA_BACK	*/
		else if (strstr (code_xcfa_ps [ line ], "PARAM_BOOL_TEXTDATA_BACK")) {
			fprintf (fp_preview, "/bool_textdata_back %s def\n", new->bool_textdata_back ? "true" : "false");
		}
		/* PARAM_CHOICEFIELDSCOVER	*/
		else if (strstr (code_xcfa_ps [ line ], "PARAM_CHOICEFIELDSCOVER")) {
			fprintf (fp_preview, "/choicefieldscover %d def\n", new->num_choicefieldscover);
		}
		/* PARAM_CHOICEFIELDSBACK	*/
		else if (strstr (code_xcfa_ps [ line ], "PARAM_CHOICEFIELDSBACK")) {
			fprintf (fp_preview, "/choicefieldsback %d def\n", new->num_choicefieldsback);
		}
		/* PARAM_BOOL_LINE_COVER	*/
		else if (strstr (code_xcfa_ps [ line ], "PARAM_BOOL_LINE_COVER")) {
			fprintf (fp_preview, "/bool_line_cover %s def\n", new->bool_line_cover ? "true" : "false");
		}
		/* PARAM_BOOL_LINE_BACK		*/
		else if (strstr (code_xcfa_ps [ line ], "PARAM_BOOL_LINE_BACK")) {
			fprintf (fp_preview, "/bool_line_back %s def\n", new->bool_line_back ? "true" : "false");
		}
		/* PARAM_TEXTDATA		*/
		else if (strstr (code_xcfa_ps [ line ], "PARAM_TEXTDATA")) {
			/*
			new->glist_fields = NULL;
			fprintf (fp_preview, "/bool_line_back %s def\n", new->bool_line_back ? "true" : "false");
			*/
			List = g_list_first (new->glist_fields);
			if (List) {
				fprintf (fp_preview, "/textdata [\n");
				while (List) {
					if ((ps = (FIELDS_PS *)List->data)) {
						fprintf (fp_preview, "(%s)",  ps->author);
						fprintf (fp_preview, " (%s)", ps->title);
						if (*ps->author || *ps->title)
							fprintf (fp_preview, " (%s)", ps->time);
						else	fprintf (fp_preview, " ()");
						fprintf (fp_preview, "\n");
					}
					List = g_list_next (List);
				}
				fprintf (fp_preview, "] def\n");
			}
			else {
				fprintf (fp_preview, "/textdata [\n");
				fprintf (fp_preview, "() () ()\n");
				fprintf (fp_preview, "] def\n");
			}
		}
		else {
			fprintf (fp_preview, "%s\n", code_xcfa_ps [ line ]);
		}
		line ++;
	}

	fclose (fp_preview);

	new = pochegen_remove_struct_ps (new);
}

/*
*---------------------------------------------------------------------------
* GENERATION DU CODE POSTSCRIPT RECTO / VERSO
*---------------------------------------------------------------------------
*/


GLIST_POCHETTE *pochegen_get_elem_actif (gboolean bool_recto)
{
	GLIST_POCHETTE *ptr = NULL;

	if (bool_recto == TRUE)
		ptr = (GLIST_POCHETTE *)poche.ptr_recto;
	else	ptr = (GLIST_POCHETTE *)poche.ptr_verso;

	return ((GLIST_POCHETTE *)ptr);
}

gboolean pochegen_creation_postscript_recto (void)
{
	GLIST_POCHETTE *gl = NULL;
	gchar          *file_recto_tmp = NULL;
	FILE           *fp_recto = NULL;
	FILE           *fp_recto_tmp = NULL;
#define MAX_CARS 255
	gchar  buf   [ MAX_CARS +1 ];

	/*PRINT_FUNC_LF();*/

	if ((gl = pochegen_get_elem_actif (TRUE))) {

		if (infosong_file_is_reg (poche.file_recto_ps) == TRUE) {
			/*g_print ("PAS DE GENERATION RECTO\n");*/
			return (TRUE);
		}
		/*g_print ("GENERATION RECTO: %s\n", poche.file_recto_ps);*/

		file_recto_tmp = g_strdup_printf ("%s/recto_tmp.ps", poche.Path_pochette_ps);
		pocheexec_convert_to_postscript (gl->name_img, file_recto_tmp);
	}
	else {
		infosong_delete_file (poche.file_recto_ps);
		return (FALSE);
	}

	fp_recto = fopen (poche.file_recto_ps, "w");
	fp_recto_tmp = fopen (file_recto_tmp, "r");

	while (fgets (buf, MAX_CARS, fp_recto_tmp) != NULL) {
		if (buf[0]  == 'D' &&
		    buf[1]  == 'i' &&
		    buf[2]  == 's' &&
		    buf[3]  == 'p' &&
		    buf[4]  == 'l' &&
		    buf[5]  == 'a' &&
		    buf[6]  == 'y' &&
		    buf[7]  == 'I' &&
		    buf[8]  == 'm' &&
		    buf[9]  == 'a' &&
		    buf[10] == 'g' &&
		    buf[11] == 'e') {
			/*g_print ("\n%s\n", buf);*/
			break;
		}
	}
	fgets (buf, MAX_CARS, fp_recto_tmp);
	fgets (buf, MAX_CARS, fp_recto_tmp);
	while (fgets (buf, MAX_CARS, fp_recto_tmp) != NULL) {
		if (buf [ 0 ] == '%' && buf [ 1 ] == '%') break;
		fprintf (fp_recto, "%s", buf);
	}
	fprintf (fp_recto, "\n");

	fclose (fp_recto);
	fclose (fp_recto_tmp);

	infosong_delete_file (file_recto_tmp);

	g_free (file_recto_tmp);
	file_recto_tmp = NULL;

	return (TRUE);
}

gboolean pochegen_creation_postscript_verso (void)
{
	GLIST_POCHETTE *gl = NULL;
	gchar          *file_verso_tmp = NULL;
	FILE           *fp_verso = NULL;
	FILE           *fp_verso_tmp = NULL;
#define MAX_CARS 255
	gchar  buf   [ MAX_CARS +1 ];

	/*PRINT_FUNC_LF();*/

	if ((gl = pochegen_get_elem_actif (FALSE))) {

		if (infosong_file_is_reg (poche.file_verso_ps) == TRUE) {
			/*g_print ("PAS DE GENERATION VERSO\n");*/
			return (TRUE);
		}
		/*g_print ("GENERATION VERSO: %s\n", poche.file_verso_ps);*/

		file_verso_tmp = g_strdup_printf ("%s/verso_tmp.ps", poche.Path_pochette_ps);
		pocheexec_convert_to_postscript (gl->name_img, file_verso_tmp);
	}
	else {
		infosong_delete_file (poche.file_verso_ps);
		return (FALSE);
	}

	fp_verso = fopen (poche.file_verso_ps, "w");
	fp_verso_tmp = fopen (file_verso_tmp, "r");

	while (fgets (buf, MAX_CARS, fp_verso_tmp) != NULL) {
		if (buf[0]  == 'D' &&
		    buf[1]  == 'i' &&
		    buf[2]  == 's' &&
		    buf[3]  == 'p' &&
		    buf[4]  == 'l' &&
		    buf[5]  == 'a' &&
		    buf[6]  == 'y' &&
		    buf[7]  == 'I' &&
		    buf[8]  == 'm' &&
		    buf[9]  == 'a' &&
		    buf[10] == 'g' &&
		    buf[11] == 'e') {
			/*g_print ("\n%s\n", buf);*/
			break;
		}
	}
	fgets (buf, MAX_CARS, fp_verso_tmp);
	fgets (buf, MAX_CARS, fp_verso_tmp);
	while (fgets (buf, MAX_CARS, fp_verso_tmp) != NULL) {
		if (buf [ 0 ] == '%' && buf [ 1 ] == '%') break;
		fprintf (fp_verso, "%s", buf);
	}
	fprintf (fp_verso, "\n");

	fclose (fp_verso);
	fclose (fp_verso_tmp);

	infosong_delete_file (file_verso_tmp);

	g_free (file_verso_tmp);
	file_verso_tmp = NULL;

	return (TRUE);
}

gchar *pochegen_get_coordonees_recto (void)
{
	gchar *str = NULL;

	str = g_strdup_printf ("%d %d\n%d %d\n",
			poche.tab_recto [ 0 ],
			poche.tab_recto [ 1 ],
			poche.tab_recto [ 2 ],
			poche.tab_recto [ 3 ]);
	strcpy (poche.coord_recto, str);
	g_free (str);
	str = NULL;
	return (&poche.coord_recto[0]);
}

gchar *pochegen_get_coordonees_verso (gint choice)
{
	gchar *str = NULL;

	str = g_strdup_printf ("%d %d\n%d %d\n",
			poche.tab_verso [ 0 ],
			poche.tab_verso [ 1 ],
			poche.tab_verso [ 2 ],
			poche.tab_verso [ 3 ]);
	strcpy (poche.coord_verso, str);
	g_free (str);
	str = NULL;
	return (&poche.coord_verso[0]);
}

void pochegen_code_entete_ps (void)
{
	FILE  *fp_preview = NULL;
	guint  line = 0;

	/*PRINT_FUNC_LF();*/
	
	fp_preview = fopen (poche.file_preview_ps, "w");
	while (*code_entete_ps [ line ]) {
		fprintf (fp_preview, "%s\n", code_entete_ps [ line ]);
		line ++;
	}
	fclose (fp_preview);
}

/*
*---------------------------------------------------------------------------
* GENERATION DU CODE POSTSCRIPT
*---------------------------------------------------------------------------
*/

void pochegen_gen_code_postscript (void)
{
	FILE     *fp_recto = NULL;
	FILE     *fp_verso = NULL;
	FILE     *fp_preview = NULL;
#define MAX_CARS 255
	gchar     buf   [ MAX_CARS +1 ];
	gboolean  bool_file_recto = FALSE;
	gboolean  bool_file_verso = FALSE;

	/*PRINT_FUNC_LF();*/

	pochegen_code_entete_ps ();
	bool_file_recto = pochegen_creation_postscript_recto ();
	bool_file_verso = pochegen_creation_postscript_verso ();

	if (bool_file_recto || bool_file_verso) {
		pochegen_code_convert_ps ();
	}

	if (bool_file_verso) {
		fp_verso = fopen (poche.file_verso_ps, "r");
		fp_preview = fopen (poche.file_preview_ps, "a");
		fprintf (fp_preview, "DisplayImage\n");
		fprintf (fp_preview, "%s", pochegen_get_coordonees_verso (1));
		while (fgets (buf, MAX_CARS, fp_verso) != NULL) {
			fprintf (fp_preview, "%s", buf);
		}
		fprintf (fp_preview, "\n");
		fclose (fp_verso);
		fclose (fp_preview);
	}
	
	if (bool_file_recto) {
		fp_recto = fopen (poche.file_recto_ps, "r");
		fp_preview = fopen (poche.file_preview_ps, "a");
		fprintf (fp_preview, "DisplayImage\n");
		fprintf (fp_preview, "%s", pochegen_get_coordonees_recto ());
		while (fgets (buf, MAX_CARS, fp_recto) != NULL) {
			fprintf (fp_preview, "%s", buf);
		}
		fprintf (fp_preview, "\n");
		fclose (fp_recto);
		fclose (fp_preview);
	}

	pochegen_code_xcfa_ps ();
}

/*
*---------------------------------------------------------------------------
* AFFICHAGE DE L'IMAGE DU PREVIEW
*---------------------------------------------------------------------------
*/

/* Dimensionne l'image et affichage dans le preview
*/
void pochegen_affiche_image (void)
{
	gdouble  percent = pocheevnt_get_percent_zoom ();
	gint     hauteur;
	gint     largeur;
	gchar   *dimension = NULL;
	gchar   *LineCommand = NULL;
	/*GError  *error = NULL;*/
	
	/*PRINT_FUNC_LF();*/

	/* Calculs dimension */
	largeur = (percent * 612.0) / 100.0;
	hauteur = (percent * 792.0) / 100.0;
	dimension = g_strdup_printf ("%dx%d", largeur, hauteur);

	/* Generation fichier preview.png */
	pocheexec_convert_to_png (poche.file_preview_ps, poche.file_preview_png, dimension);
	g_free (dimension);
	dimension = NULL;

	gdk_window_clear (poche.Adr_image_preview->window);

	/* Afficher le fichier preview.png */

	LineCommand = g_strdup (poche.file_preview_png);
	gtk_image_set_from_file (GTK_IMAGE (poche.Adr_image_preview), LineCommand);
	/*gtk_widget_show(poche.Adr_image_preview);*/
	g_free (LineCommand);
	LineCommand = NULL;
	
	poche.bool_with_get_grille_img = TRUE;
}

void pochegen_file_postscript (void)
{
	gchar *newname = NULL;
	gchar *PtrName = NULL;
	
	/*PRINT_FUNC_LF();*/
	
	PtrName = strrchr (poche.file_preview_ps, '/');
	PtrName ++;
	newname = g_strdup_printf ("%s/%s", Config_User.Path_Dest_File_PostScript, PtrName);
	infosong_copy_file (poche.file_preview_ps, newname);
	g_free (newname);
	newname = NULL;
}

void pochegen_file_pdf (void)
{
	/*PRINT_FUNC_LF();*/
	
	/* Test si ps2pdf est present */
	if (PrgInit.bool_ps2pdf == FALSE) {
		wininfo_create (
			_("ps2pdf est absent"),
			  "\n",
			_("   Production du fichier PDF impossible car Le programme"),
			  "         \n",
			_("   'ps2pdf' est absent de votre configuration."),
			  "\n\n",
		 	_("   SOLUTION:"),
		 	  "\n",
			_("   Installez 'ps2pdf'."),
			  "\n\n",
			  "");
		return;
	}
	/* Fabrication du PDF */
	pocheexec_make_pdf_file (poche.file_preview_ps, Config_User.Path_Dest_File_PostScript);
}

void pochegen_file_postscript_pdf (void)
{
	/*PRINT_FUNC_LF();*/
	
	pochegen_file_postscript ();
	pochegen_file_pdf ();
}
















