 /*
 * file      : secu.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include "support.h"
#include "global.h"
#include "secu.h"

gint     secu_count_thread = 0;
gboolean secu_bool_authorized = FALSE;

void secu_thread_add (void)
{
	secu_count_thread ++;
	/*
	g_print("[----\n");
	PRINT_FUNC_LF();
	g_print ("\tsecu_count_thread = %d\n", secu_count_thread);
	g_print("----]\n");
	*/
}
void secu_thread_sub (void)
{
	secu_count_thread --;
	/*
	g_print("[----\n");
	PRINT_FUNC_LF();
	g_print ("\tsecu_count_thread = %d\n", secu_count_thread);
	g_print("----]\n");
	*/
}
void secu_set_authorized (gboolean bool_authorized)
{
	secu_bool_authorized = bool_authorized;
}
gint secu_get_count_thread (void)
{
	if (secu_bool_authorized == TRUE) return ((gint)-1);
	return ((gint)secu_count_thread);	
}
gboolean secu_test_warning (void)
{
	gboolean bool_error = FALSE;
	
	if (secu_get_count_thread () == -1) {
		g_print ("\n");
		g_print ("!------------------------------------------------------------!\n");
		g_print ("!             secu_get_count_thread () = %d                   !\n", secu_get_count_thread ());
		g_print ("!------------------------------------------------------------!\n");
		g_print ("!------------------------------------------------------------!\n");
		g_print ("!                 AUTORISATION EST OK                        !\n");
		g_print ("!       POUR  CREATION  GTK  DEPUIS  UN  TIMEOUT             !\n");
		g_print ("!------------------------------------------------------------!\n");
		g_print ("\n");	
		bool_error = FALSE;
	}
	else if (secu_get_count_thread () > 0) {
		g_print ("\7\7\7\7\7\7\7\7\7\7\7\7\7\7\7\7\7\7\7\7\7\7\7\7");
		g_print ("\n");
		g_print ("!------------------------------------------------------------!\n");
		g_print ("!             secu_get_count_thread () = %d                   !\n", secu_get_count_thread ());
		g_print ("!------------------------------------------------------------!\n");
		g_print ("!------------------------------------------------------------!\n");
		g_print ("!                  RISQUE DE PLANTAGE                        !\n");
		g_print ("!     LA CREATION GTK N'EST PAS PERMISE DEPUIS UN THREAD     !\n");
		g_print ("!------------------------------------------------------------!\n");
		bool_error = TRUE;
	}
	return (bool_error);
}















