 /*
 * file      : split_action.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <string.h>
#include <stdlib.h>

#include "support.h"
#include "global.h"
#include "file.h"
#include "prg_init.h"
#include "win_control.h"
#include "win_norm_replay.h"
#include "options.h"
#include "utils.h"
#include "split.h"
#include <pthread.h>
#include "win_info.h"
#include "config_user.h"



/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

typedef struct {
	pthread_t	 NmrTid;		/* Numero du Thread	*/
	guint		 HandlerTimeout;	/* Numero du Timeout	*/
	gboolean	 BoolThreadEnd;		/* TRUE = end		*/

	gint             NbrElementsInList;	/* Total elements	*/
	gint             ElementActif;		/* Numero en cours	*/
	double           total_percent;		/* Le pourcentage	*/

} VAR_SPLIT_ACTION;

VAR_SPLIT_ACTION VarSplitAction;


/*
*---------------------------------------------------------------------------
* CODE
*---------------------------------------------------------------------------
*/

void splitaction_deallocate_GList (void)
{
	gint	 i;

	if (VarSplitAlloc == NULL) return;
PRINT_FUNC_LF();
	for (i = 0; i < VarSplitAlloc [ 0 ].NbrAlloc; i++) {
		VarSplitAlloc [ i ].list   = utils_clear_list (VarSplitAlloc [ i ].list);
	}
	g_free (VarSplitAlloc [ i ].PathNameFileSong);
	g_free (VarSplitAlloc [ i ].StrfileBash);
	g_free (VarSplitAlloc);
	VarSplitAlloc = NULL;

}

void SplitAction_create_file_cue (gint index)
{
	FILE	*fp = NULL;
	gchar	*Ptr = NULL;
	gchar	*PathNameFile = NULL;
	gchar	*LineCommand = NULL;
	GList	*list = NULL;

	/* PRINT_FUNC_LF(); */

	/* Creation du fichier CUE */

	PathNameFile = g_strdup_printf ("%s/XCFA.cue", VarSplit.TmpRep);
	fp = fopen (PathNameFile, "w");
	list = g_list_first (VarSplitAlloc [ index ].list);
	while (list) {
		if ((Ptr = (gchar *)list->data)) {
			fprintf (fp, "%s", Ptr);
		}
		list = g_list_next (list);
	}
	fclose (fp);

	/* Free memory */

	g_free (PathNameFile);
	PathNameFile = NULL;

	/* Creation du fichier BASH */

	PathNameFile = g_strdup_printf ("%s/XCFA.sh", VarSplit.TmpRep);
	fp = fopen (PathNameFile, "w");
	fprintf (fp, "%s\n", VarSplitAlloc [ index ].StrfileBash);
	fclose (fp);
g_print("%s", VarSplitAlloc [ index ].StrfileBash);

	/* Rendre le fichier executable */
GDK_THREADS_ENTER();
	LineCommand = g_strdup_printf ("chmod +x %s", PathNameFile);
	system (LineCommand);

	/* Free memory */

	g_free (LineCommand);
	LineCommand = NULL;
GDK_THREADS_LEAVE();

	/* Free memory */

	g_free (PathNameFile);
	PathNameFile = NULL;
}

static void SplitAction_thread (void *arg)
{
	gint	 index;
	gchar	*PathNameFile = NULL;
	gchar	*PathNameFileCUE = NULL;

	/* PRINT_FUNC_LF(); */
	VarSplitAction.BoolThreadEnd = FALSE;

	PathNameFile    = g_strdup_printf ("%s/XCFA.sh", VarSplit.TmpRep);
	PathNameFileCUE = g_strdup_printf ("%s/MESS_TACHE_EN_COURS", VarSplit.TmpRep);

	for (index = 0; index < VarSplitAlloc [ 0 ].NbrAlloc; ) {

		if (VarSplitAlloc [ index ].list != NULL) {

			if (VarSplitAlloc [ index ].TypeFileIs == FILE_IS_OGG ||
			    VarSplitAlloc [ index ].TypeFileIs == FILE_IS_MP3) {

				VarSplitAction.ElementActif = index;
			
			GDK_THREADS_ENTER();
				conv.ArgConv = conv_alloc_arg ( VarSplitAlloc [ index ].list);
			GDK_THREADS_LEAVE();
				conv_exec (FALSE, SPLIT, VarSplitAlloc [ index ].list, "SPLIT");
				
				g_free (conv.ArgConv);
				conv.ArgConv = NULL;

				index ++;
			}
			else {
				if (infosong_file_is_dir (PathNameFileCUE) == FALSE) {

					VarSplitAction.ElementActif = index;

					SplitAction_create_file_cue (index);

					/* Execution du fichier bash */

					/* system (PathNameFile); */
					conv_bash (PathNameFile);

					index ++;
				}
			}
		}
	}

	VarSplitAction.BoolThreadEnd = TRUE;
PRINT("END OF THREAD");

	g_free (PathNameFile);
	PathNameFile = NULL;
	g_free (PathNameFileCUE);
	PathNameFileCUE = NULL;
	pthread_exit(0);
}

static gint SplitAction_timeout (gpointer data)
{
	if (WinNormReplay_is_get_close () == TRUE) {
		conv_stop_conversion ();

	}

	if (conv.bool_percent_conv == TRUE) {
		gchar *Str = NULL;

		VarSplitAction.total_percent = (double) (VarSplitAction.ElementActif + 1)/ (double)VarSplitAction.NbrElementsInList;
		WinNormReplay_set_data_progressBar (VarSplitAction.total_percent);

		Str = g_strdup_printf ("Etat: %d / %d", VarSplitAction.ElementActif +1, VarSplitAction.NbrElementsInList);

		WinNormReplay_set_compteur (Str);
		g_free (Str);
		Str = NULL;

		/*WinNormReplay_set_etat ("Split ...");*/

		conv.bool_percent_conv = FALSE;
		return (TRUE);
	}

	if (VarSplitAction.BoolThreadEnd == TRUE) {

		WinNormReplay_close ();

		utils_puts_statusbar_global ("EN COURS");

		splitaction_deallocate_GList ();
		VarSplit.TmpRep  = utils_remove_temporary_rep (VarSplit.TmpRep);
		gtk_timeout_remove (VarSplitAction.HandlerTimeout);
PRINT("END OF TIMEOUT");
		conv_set_struct_not_used ();
	}

	return (TRUE);
}

void SplitAction_action (VAR_SPLIT_ALLOC *VarSplitAlloc)
{
	/*PRINT_FUNC_LF();*/

	if (VarSplitAlloc == NULL) return;

	WinNormReplay_Create ("Split");
	WinNormReplay_reset_progressBar ();

	conv_reset_struct ();
	g_snprintf (conv.valuenice , 4, "%d", options_get_val_nice ());

	VarSplitAction.BoolThreadEnd = FALSE;

	VarSplitAction.NbrElementsInList = VarSplitAlloc [ 0 ].NbrAlloc;
	VarSplitAction.ElementActif = 0;
	VarSplitAction.total_percent = 0.0;
	/*WinNormReplay_set_etat ("Split ...");*/
	WinNormReplay_set_data_progressBar (VarSplitAction.total_percent);

PRINT("BEGIN OF TIMEOUT");
	VarSplitAction.HandlerTimeout = gtk_timeout_add (100, SplitAction_timeout, 0);
PRINT("BEGIN OF THREAD");
	pthread_create (&VarSplitAction.NmrTid, NULL ,(void *)SplitAction_thread, (void *)NULL);
}

void splitaction_button_action_split_clicked (void)
{
	gint		 NmrSplitAlloc = 0;
	guint		 NbrElement = 0;
	// GtkTreeIter	 iter;
	// gboolean	 valid;
	DETAIL		*detail = NULL;
	// gchar		*Element = NULL;
	FIC_SPLIT	*FicSplit = NULL;
	FIC_SPLIT	*SplitDetail = NULL;
	GList		*list = NULL;
	GList		*ListEntete = NULL;
	gchar		*TimeDebut = NULL;
	gchar		*TimeFin = NULL;
	gint		 sec;
	gdouble		 dsec;
	gint		 hundr;
	gchar		*PathName = NULL;
	gchar		*Ptr = NULL;
	gchar		*NewRep = NULL;
	gchar		*NewPathName = NULL;
	gchar		*NewName = NULL;
	gchar		*NameFile = NULL;
	gchar		*Path = NULL;
	gchar		*StrTimeDebut = NULL;
	gchar		*StrTimeFin = NULL;
	gchar		*PtrNameSong = NULL;
	gchar		 StrTypeFile [ 10 ];
	gint		 num;
	gint		 NumPlage;
	gint		 Minutes;
	gint		 Secondes;
	gint		 Centiemes;

	PRINT_FUNC_LF();

	if (VarSplit.Adr_Tree_Model == NULL) return;
	if (PrgInit.bool_mp3splt == FALSE  ||
	    PrgInit.bool_shntool == FALSE  ||
	    PrgInit.bool_cuetools == FALSE ||
	    PrgInit.bool_checkmp3 == FALSE) {
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")), NOTEBOOK_PRGEXTERNES);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_app_externes")), NOTEBOOK_OPTIONS_PRGEXTERNES);

		wininfo_create (
			_("PACKAGE(s) ABSENT(s) pour SPLIT"),
			_("   Veuillez verifier la presence de ces packages  "),
			  "               \n",
			_("   pour pouvoir utiliser la fonction Split:"),
			  "               \n",
			  "   <b>mp3splt, shntool, cuetools, checkmp3</b>",
			  "\n\n",
			_("   Veuillez installer et recommencer."),
			  "\n",
			"");
		return;
	}

	/**
	PlayerExec_user_to_quit ();*/

	/*if (VarSplit.TmpRep)  VarSplit.TmpRep  = utils_remove_temporary_rep (VarSplit.TmpRep);*/
	if (!VarSplit.TmpRep) VarSplit.TmpRep  = utils_create_temporary_rep (PATH_TMP_XCFA_SHNSPLIT);

	// RECUPERAION DU NOMBRE TOTAL DE TACHES
	
	NbrElement = split_get_elements ();
	
	// valid = gtk_tree_model_get_iter_first (VarSplit.Adr_Tree_Model, &iter);
	// while (valid) {
	// 	gtk_tree_model_get (VarSplit.Adr_Tree_Model, &iter, split_get_SPLIT_POINTER_STRUCT_DETAIL (), &detail, -1);
	// 	if (detail) {
	// 			gtk_tree_model_get (VarSplit.Adr_Tree_Model, &iter, split_get_SPLIT_NBRCOUPE_FILE (), &Element, -1);
	// 			Ptr = Element;
	// 			if (*Ptr == '<') Ptr += 3;
	// 			NbrElement += atoi (Ptr);
	// 	}
	// 	valid = gtk_tree_model_iter_next (VarSplit.Adr_Tree_Model, &iter);
	// }

	/* Deallocation precedante si elle existe*/
	splitaction_deallocate_GList ();

	/* ALlocation structure de reception des GLIST et init */
	VarSplitAlloc = (VAR_SPLIT_ALLOC *)g_malloc0 (sizeof (VAR_SPLIT_ALLOC) * (NbrElement +2));
	for (num = 0; num < NbrElement; num ++) {
		VarSplitAlloc [ num ].list = NULL;
		VarSplitAlloc [ num ].NbrAlloc = NbrElement;
		VarSplitAlloc [ num ].TypeFileIs = FILE_IS_NONE;
	}

	// PARCOURT DE TOUS LES GLIST OU UNE TACHE EXISTE
	
	ListEntete = g_list_first (entetefile);
	while (ListEntete) {
		if ((detail = (DETAIL *)ListEntete->data) != NULL) {
	
	// valid = gtk_tree_model_get_iter_first (VarSplit.Adr_Tree_Model, &iter);
	// while (valid) {
	// 	gtk_tree_model_get (VarSplit.Adr_Tree_Model, &iter, split_get_SPLIT_POINTER_STRUCT_DETAIL (), &detail, -1);
	// 	if (detail) {
	// 		gtk_tree_model_get (VarSplit.Adr_Tree_Model, &iter, split_get_SPLIT_NBRCOUPE_FILE (), &Element, -1);
	// 		Ptr = Element;
	// 		if (*Ptr == '<') Ptr += 3;
	// 		if ((NbrElement = atoi (Ptr)) == 0) {
	// 			valid = gtk_tree_model_iter_next (VarSplit.Adr_Tree_Model, &iter);
	// 			continue;
	// 		}
			if ((FicSplit = (FIC_SPLIT *)detail->fic_split) != NULL) {
				if (FicSplit->ListDecoupes == NULL) {
					ListEntete = g_list_next (ListEntete);
					continue;
				}
			
				NumPlage = 0;
				
				list = g_list_first (FicSplit->ListDecoupes);
				while (list) {
					/* Si glist est NULL, liste suivante */
					if ((SplitDetail = (FIC_SPLIT *)list->data) == NULL) {
						list = g_list_next(list);
						continue;
					}

					/*-- TIME DEBUT */

					sec   = (gint) (((gdouble)FicSplit->GUINT_TempsTotal * SplitDetail->AdrValueMarkA) / 100.0);
					dsec  = ((gdouble)FicSplit->GUINT_TempsTotal * SplitDetail->AdrValueMarkA) / 100.0;
					hundr = (dsec - (gdouble)sec) * 100.0;

					if (detail->type_infosong_file_is == FILE_IS_MP3 || detail->type_infosong_file_is == FILE_IS_OGG) {
						/*TimeDebut = g_strdup_printf ("%d.%d.%d", sec/60, sec%60, hundr);*/
						Minutes   = sec/60;
						Secondes  = sec%60;
						Centiemes = hundr;
						while (Centiemes > 99) {
							Centiemes -= 100;
							Secondes ++;
						}
						while (Secondes > 59) {
							Secondes -= 60;
							Minutes ++;
						}
						TimeDebut = g_strdup_printf ("%d.%d.%d", Minutes, Secondes, Centiemes);
					}

					/*-- TIME FIN */

					sec   = (gint) (((gdouble)FicSplit->GUINT_TempsTotal * SplitDetail->AdrValueMarkB) / 100.0);
					dsec  = ((gdouble)FicSplit->GUINT_TempsTotal * SplitDetail->AdrValueMarkB) / 100.0;
					hundr = (dsec - (gdouble)sec) * 100.0;

					if (detail->type_infosong_file_is == FILE_IS_MP3 || detail->type_infosong_file_is == FILE_IS_OGG) {
						/*TimeFin = g_strdup_printf ("%d.%d.%d", sec/60, sec%60, hundr);*/
						Minutes   = sec/60;
						Secondes  = sec%60;
						Centiemes = hundr;
						while (Centiemes > 99) {
							Centiemes -= 100;
							Secondes ++;
						}
						while (Secondes > 59) {
							Secondes -= 60;
							Minutes ++;
						}
						TimeFin = g_strdup_printf ("%d.%d.%d", Minutes, Secondes, Centiemes);
					}
					
					NumPlage ++;
					
					/* -- CHERCHE LA DESTINATION */

					if (gtk_combo_box_get_active (VarSplit.AdrComboboxDest) == 2) {
						if (detail->type_infosong_file_is == FILE_IS_MP3)
							PathName = g_strdup_printf ("%s/%02d_%s.mp3", Config_User.Path_Destination_split, NumPlage, SplitDetail->Name);
						else if (detail->type_infosong_file_is == FILE_IS_OGG)
							PathName = g_strdup_printf ("%s/%02d_%s.ogg", Config_User.Path_Destination_split, NumPlage, SplitDetail->Name);
						else if (detail->type_infosong_file_is == FILE_IS_WAV)
							PathName = g_strdup_printf ("%s/%02d_%s.wav", Config_User.Path_Destination_split, NumPlage, SplitDetail->Name);
						else if (detail->type_infosong_file_is == FILE_IS_FLAC)
							PathName = g_strdup_printf ("%s/%02d_%s.flac", Config_User.Path_Destination_split, NumPlage, SplitDetail->Name);
						else if (detail->type_infosong_file_is == FILE_IS_SHN)
							PathName = g_strdup_printf ("%s/%02d_%s.shn", Config_User.Path_Destination_split, NumPlage, SplitDetail->Name);
						else if (detail->type_infosong_file_is == FILE_IS_WAVPACK)
							PathName = g_strdup_printf ("%s/%02d_%s.wv", Config_User.Path_Destination_split, NumPlage, SplitDetail->Name);
					}
					else {
						Path = g_strdup (detail->namefile);
						Ptr = strrchr (Path, '/');
						*Ptr = '\0';
						if (detail->type_infosong_file_is == FILE_IS_MP3)
							PathName = g_strdup_printf ("%s/%02d_%s.mp3", Path, NumPlage, SplitDetail->Name);
						else if (detail->type_infosong_file_is == FILE_IS_OGG)
							PathName = g_strdup_printf ("%s/%02d_%s.ogg", Path, NumPlage, SplitDetail->Name);
						else if (detail->type_infosong_file_is == FILE_IS_WAV)
							PathName = g_strdup_printf ("%s/%02d_%s.wav", Path, NumPlage, SplitDetail->Name);
						else if (detail->type_infosong_file_is == FILE_IS_FLAC)
							PathName = g_strdup_printf ("%s/%02d_%s.flac", Path, NumPlage, SplitDetail->Name);
						else if (detail->type_infosong_file_is == FILE_IS_SHN)
							PathName = g_strdup_printf ("%s/%02d_%s.shn", Path, NumPlage, SplitDetail->Name);
						else if (detail->type_infosong_file_is == FILE_IS_WAVPACK)
							PathName = g_strdup_printf ("%s/%02d_%s.wv", Path, NumPlage, SplitDetail->Name);
						
						g_free (Path);
						Path = NULL;
					}
					
					/* Le Path */
					Path = g_strdup (PathName);
					if ((Ptr = strrchr (Path, '/')) != NULL) {
						*Ptr = '\0';
						/* Le nom */
						Ptr ++;
						NameFile = g_strdup (Ptr);
					}
					else {
						NameFile = g_strdup (PathName);
					}

					/*-- NEW REP*/

					NewRep = g_strdup (PathName);
					if ((Ptr = strrchr (NewRep, '/')) != NULL) {
						*Ptr = '\0';
					}

					/*-- NEW PATHNAME */

					/* Trouver un nom de fichier qui n existe pas dans la destination */

					num = 1;
					NewPathName = g_strdup (PathName);
					while (infosong_file_is_reg (NewPathName) == TRUE) {
						g_free (NewPathName);
						NewPathName = NULL;
						NewPathName = g_strdup_printf ("%s/%d_%s", Path, num, NameFile);
						num ++;
					}
					Ptr = strrchr (NewPathName, '/');
					Ptr ++;
					NewName = g_strdup (Ptr);

					VarSplitAlloc [ NmrSplitAlloc ].PathNameFileSong = g_strdup (detail->namefile);

					if (detail->type_infosong_file_is == FILE_IS_WAV ||
						detail->type_infosong_file_is == FILE_IS_SHN ||
						detail->type_infosong_file_is == FILE_IS_FLAC ||
						detail->type_infosong_file_is == FILE_IS_WAVPACK) {

						if (detail->type_infosong_file_is == FILE_IS_WAV)
							strcpy (StrTypeFile, "wav");
						if (detail->type_infosong_file_is == FILE_IS_SHN)
							strcpy (StrTypeFile, "shn");
						if (detail->type_infosong_file_is == FILE_IS_FLAC)
							strcpy (StrTypeFile, "flac");
						if (detail->type_infosong_file_is == FILE_IS_WAVPACK)
							strcpy (StrTypeFile, "wv");

						VarSplitAlloc [ NmrSplitAlloc ].TimeDebut = SplitDetail->AdrValueMarkA;
						VarSplitAlloc [ NmrSplitAlloc ].TimeFin   = SplitDetail->AdrValueMarkB;

						/*-- TIME DEBUT */

						sec   = (gint) (((gdouble)FicSplit->GUINT_TempsTotal * SplitDetail->AdrValueMarkA) / 100.0);
						dsec  = ((gdouble)FicSplit->GUINT_TempsTotal * SplitDetail->AdrValueMarkA) / 100.0;
						hundr = (dsec - (gdouble)sec) * 100.0;
						/*StrTimeDebut = g_strdup_printf ("%02d:%02d:%02d", sec/60, sec%60, hundr);*/

						Minutes   = sec/60;
						Secondes  = sec%60;
						Centiemes = hundr;
						while (Centiemes > 99) {
							Centiemes -= 100;
							Secondes ++;
						}
						while (Secondes > 59) {
							Secondes -= 60;
							Minutes ++;
						}
						StrTimeDebut = g_strdup_printf ("%02d:%02d:%02d", Minutes, Secondes, Centiemes);

						/*-- TIME FIN */

						sec   = (gint) (((gdouble)FicSplit->GUINT_TempsTotal * SplitDetail->AdrValueMarkB) / 100.0);
						dsec  = ((gdouble)FicSplit->GUINT_TempsTotal * SplitDetail->AdrValueMarkB) / 100.0;
						hundr = (dsec - (gdouble)sec) * 100.0;
						/*StrTimeFin   = g_strdup_printf ("%02d:%02d:%02d", sec/60, sec%60, hundr);*/

						Minutes   = sec/60;
						Secondes  = sec%60;
						Centiemes = hundr;
						while (Centiemes > 99) {
							Centiemes -= 100;
							Secondes ++;
						}
						while (Secondes > 59) {
							Secondes -= 60;
							Minutes ++;
						}
						StrTimeFin = g_strdup_printf ("%02d:%02d:%02d", Minutes, Secondes, Centiemes);

						/*
						REM
						REM Si DEBUT == 0
						REM
						REM cuebreakpoints Debut.cue | shnsplit -o wv Sorry.wv -O always -a xxx -x 1
						REM
						REM Cue file written by Xcfa
						PERFORMER "Xcfa"
						TITLE "Xcfa Hits"
						FILE "Sorry.wv"
						    TRACK 01 AUDIO
						        REM ---------------------> TEMPS DEBUT
						        INDEX 00 00:00:00
						    TRACK 02 AUDIO
						        REM ---------------------> TEMPS FIN
						        INDEX 00 01:01:00
						*/
						if (SplitDetail->AdrValueMarkA == 0.0) {

							/* Chaine pour le fichier XCFA.sh */

							VarSplitAlloc [ NmrSplitAlloc ].StrfileBash =
							g_strdup_printf (
							"#!/bin/sh\n"
							"set -e\n\n"
							"touch MESS_TACHE_EN_COURS\n\n"
							"nice -n %d cuebreakpoints %s/XCFA.cue | shnsplit -o %s \"%s\" -O always -d %s/ -a xcfa_out_file -x 1\n\n"
							"mv \"%s/xcfa_out_file01.%s\" \"%s/%s\"\n\n"
							"rm -f MESS_TACHE_EN_COURS\n\n"
							"exit 0",
							options_get_val_nice (),
							VarSplit.TmpRep,
							StrTypeFile,
							detail->namefile,
							VarSplit.TmpRep,

							VarSplit.TmpRep,
							StrTypeFile,
							NewRep,
							NewName
							);
							/*
							g_print("VarSplitAlloc [ NmrSplitAlloc ].StrfileBash =\n%s", VarSplitAlloc [ NmrSplitAlloc ].StrfileBash);
							*/

							/* Extraction du nom sans le pathname */

							PtrNameSong = strrchr (detail->namefile, '/');
							PtrNameSong ++;

							/* Contenu du fichier XCFA.cue */

							VarSplitAlloc [ NmrSplitAlloc ].list =
								g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list,
								g_strdup        ("REM Cue file written by Xcfa\n"));
							VarSplitAlloc [ NmrSplitAlloc ].list =
								g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list,
								g_strdup        ("PERFORMER \"Xcfa\"\n"));
							VarSplitAlloc [ NmrSplitAlloc ].list =
								g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list,
								g_strdup        ("TITLE \"Xcfa Hits\"\n"));
							VarSplitAlloc [ NmrSplitAlloc ].list =
								g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list,
								g_strdup_printf ("FILE \"%s\"\n", PtrNameSong));
							VarSplitAlloc [ NmrSplitAlloc ].list =
								g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list,
								g_strdup        ("    TRACK 01 AUDIO\n"));
							VarSplitAlloc [ NmrSplitAlloc ].list =
								g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list,
								g_strdup        ("        REM ---------------------> TEMPS DEBUT\n"));
							VarSplitAlloc [ NmrSplitAlloc ].list =
								g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list,
								g_strdup_printf ("        INDEX 00 %s\n", StrTimeDebut));
							VarSplitAlloc [ NmrSplitAlloc ].list =
								g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list,
								g_strdup        ("    TRACK 02 AUDIO\n"));
							VarSplitAlloc [ NmrSplitAlloc ].list =
								g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list,
								g_strdup        ("        REM ---------------------> TEMPS FIN\n"));
							VarSplitAlloc [ NmrSplitAlloc ].list =
								g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list,
								g_strdup_printf ("        INDEX 00 %s\n", StrTimeFin));

							VarSplitAlloc [ NmrSplitAlloc ].TypeFileIs = detail->type_infosong_file_is;
							VarSplitAlloc [ NmrSplitAlloc ].TypeStruct = _SPLIT_TYPE_BEGIN_ZERO_;
							NmrSplitAlloc ++;
						}
						/*
						REM
						REM Si DEBUT > 0
						REM
						REM cuebreakpoints Sorry.cue | shnsplit -o wv Sorry.wv -O always -a zzz -x 2
						REM
						REM Cue file written by Xcfa
						PERFORMER "Xcfa"
						TITLE "Xcfa Hits"
						FILE "Sorry.wv"
						    TRACK 01 AUDIO
						        INDEX 00 00:00:00
						    TRACK 02 AUDIO
						        INDEX 00 01:00:00
						        REM ---------------------> TEMPS DEBUT
						        INDEX 01 00:45:00
						    TRACK 03 AUDIO
						        REM ---------------------> TEMPS FIN
						        INDEX 00 02:45:00
						*/
						else {

							/* Chaine pour le fichier XCFA.sh */

							VarSplitAlloc [ NmrSplitAlloc ].StrfileBash =
							g_strdup_printf (
							"#!/bin/sh\n"
							"set -e\n\n"
							"touch MESS_TACHE_EN_COURS\n\n"
							"nice -n %d cuebreakpoints %s/XCFA.cue | shnsplit -o %s \"%s\" -O always -d %s/ -a xcfa_out_file -x 2\n\n"
							"mv \"%s/xcfa_out_file02.%s\" \"%s/%s\"\n\n"
							"rm -f MESS_TACHE_EN_COURS\n\n"
							"exit 0",
							options_get_val_nice (),
							VarSplit.TmpRep,
							StrTypeFile,
							detail->namefile,
							VarSplit.TmpRep,

							VarSplit.TmpRep,
							StrTypeFile,
							NewRep,
							NewName
							);
							/*
							g_print("VarSplitAlloc [ NmrSplitAlloc ].StrfileBash =\n%s", VarSplitAlloc [ NmrSplitAlloc ].StrfileBash);
							*/

							/* Extraction du nom sans le pathname */

							PtrNameSong = strrchr (detail->namefile, '/');
							PtrNameSong ++;

							/* Contenu du fichier XCFA.cue */

							VarSplitAlloc [ NmrSplitAlloc ].list =
								g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list,
								g_strdup        ("REM Cue file written by Xcfa\n"));
							VarSplitAlloc [ NmrSplitAlloc ].list =
								g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list,
								g_strdup        ("PERFORMER \"Xcfa\"\n"));
							VarSplitAlloc [ NmrSplitAlloc ].list =
								g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list,
								g_strdup        ("TITLE \"Xcfa Hits\"\n"));
							VarSplitAlloc [ NmrSplitAlloc ].list =
								g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list,
								g_strdup_printf ("FILE \"%s\"\n", PtrNameSong));
							VarSplitAlloc [ NmrSplitAlloc ].list =
								g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list,
								g_strdup        ("    TRACK 01 AUDIO\n"));
							VarSplitAlloc [ NmrSplitAlloc ].list =
								g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list,
								g_strdup        ("        INDEX 00 00:00:00\n"));
							VarSplitAlloc [ NmrSplitAlloc ].list =
								g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list,
								g_strdup        ("    TRACK 02 AUDIO\n"));
							VarSplitAlloc [ NmrSplitAlloc ].list =
								g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list,
								g_strdup_printf ("        INDEX 00 01:00:00\n"));
							VarSplitAlloc [ NmrSplitAlloc ].list =
								g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list,
								g_strdup        ("        REM ---------------------> TEMPS DEBUT\n"));
							VarSplitAlloc [ NmrSplitAlloc ].list =
								g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list,
								g_strdup_printf ("        INDEX 01 %s\n", StrTimeDebut));
							VarSplitAlloc [ NmrSplitAlloc ].list =
								g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list,
								g_strdup        ("    TRACK 03 AUDIO\n"));
							VarSplitAlloc [ NmrSplitAlloc ].list =
								g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list,
								g_strdup        ("        REM ---------------------> TEMPS FIN\n"));
							VarSplitAlloc [ NmrSplitAlloc ].list =
								g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list,
								g_strdup_printf ("        INDEX 00 %s\n", StrTimeFin));
						
							VarSplitAlloc [ NmrSplitAlloc ].TypeFileIs = detail->type_infosong_file_is;
							VarSplitAlloc [ NmrSplitAlloc ].TypeStruct = _SPLIT_TYPE_ELSE_;
							NmrSplitAlloc ++;
						}
					}
					else if (detail->type_infosong_file_is == FILE_IS_MP3 || detail->type_infosong_file_is == FILE_IS_OGG) {

						/*VarSplitAlloc [ NmrSplitAlloc ].BoolFileWav = FALSE;*/

						/*
						!-----------------------------------------------------------!
						!  [ 0 .. 11 .. 13 ]
						!-----------------------------------------------------------!
						!  --Without Expert Parameters--
						!  SPLIT
						!-----------------------------------------------------------!
						ArgConv[ 00 ] = nice
						ArgConv[ 01 ] = -n
						ArgConv[ 02 ] = 0
						ArgConv[ 03 ] = mp3splt
						ArgConv[ 04 ] = /home/cat/Musique/DOROTHEE.mp3
						ArgConv[ 05 ] = -e
						ArgConv[ 06 ] = 0.3.8
						ArgConv[ 07 ] = 0.4.56
						ArgConv[ 08 ] = -d
						ArgConv[ 09 ] = /home/cat/Musique/EXTRACTIONS
						ArgConv[ 10 ] = -o
						ArgConv[ 11 ] = 001_split_[0_3_8 to 0_4_56]_DOROTHEE.mp3

						mp3splt -f -d /home/cat/Musique/EXTRACTIONS/ 01.mp3 0.3.8 0.4.0 -o _01.mp3
						mp3splt -f -d /home/cat/Musique/EXTRACTIONS/ 01.ogg 0.3.8 0.4.0 -o _01.ogg
						*/
						VarSplitAlloc [ NmrSplitAlloc ].list = g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list, g_strdup ("nice"));
						VarSplitAlloc [ NmrSplitAlloc ].list = g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list, g_strdup ("-n"));
						VarSplitAlloc [ NmrSplitAlloc ].list = g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list, g_strdup_printf ("%d", options_get_val_nice ()));
						VarSplitAlloc [ NmrSplitAlloc ].list = g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list, g_strdup ("mp3splt"));

						VarSplitAlloc [ NmrSplitAlloc ].list = g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list, g_strdup ("-f"));
						VarSplitAlloc [ NmrSplitAlloc ].list = g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list, g_strdup ("-d"));
						VarSplitAlloc [ NmrSplitAlloc ].list = g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list, g_strdup (NewRep));
						VarSplitAlloc [ NmrSplitAlloc ].list = g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list, g_strdup (detail->namefile));
						VarSplitAlloc [ NmrSplitAlloc ].list = g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list, g_strdup (TimeDebut));
						VarSplitAlloc [ NmrSplitAlloc ].list = g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list, g_strdup (TimeFin));
						VarSplitAlloc [ NmrSplitAlloc ].list = g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list, g_strdup ("-o"));
						VarSplitAlloc [ NmrSplitAlloc ].list = g_list_append (VarSplitAlloc [ NmrSplitAlloc ].list, g_strdup (NewName));

						VarSplitAlloc [ NmrSplitAlloc ].TypeFileIs = detail->type_infosong_file_is;

						if (detail->type_infosong_file_is == FILE_IS_OGG)
							VarSplitAlloc [ NmrSplitAlloc ].TypeStruct = _SPLIT_TYPE_OGG_;
						else	VarSplitAlloc [ NmrSplitAlloc ].TypeStruct = _SPLIT_TYPE_MP3_;
						NmrSplitAlloc ++;
					}

					g_free (TimeDebut);	TimeDebut = NULL;
					g_free (TimeFin);	TimeFin = NULL;
					g_free (PathName);	PathName = NULL;
					g_free (NewRep);	NewRep = NULL;
					g_free (NewPathName);	NewPathName = NULL;
					g_free (NewName);	NewName = NULL;
					g_free (NameFile);	NameFile = NULL;
					g_free (Path);		Path = NULL;
					g_free (StrTimeDebut);	StrTimeDebut = NULL;
					g_free (StrTimeFin);	StrTimeFin = NULL;
					Ptr = NULL;
					PtrNameSong = NULL;

					list = g_list_next(list);
				}
			}
		}
		// valid = gtk_tree_model_iter_next (VarSplit.Adr_Tree_Model, &iter);
		ListEntete = g_list_next (ListEntete);
	}

	for (num = 0; num < VarSplitAlloc [ 0 ].NbrAlloc; num ++) {

		if (VarSplitAlloc [ num ].TypeFileIs == FILE_IS_WAV ||
		    VarSplitAlloc [ num ].TypeFileIs == FILE_IS_MP3 ||
		    VarSplitAlloc [ num ].TypeFileIs == FILE_IS_OGG ||
		    VarSplitAlloc [ num ].TypeFileIs == FILE_IS_FLAC ||
		    VarSplitAlloc [ num ].TypeFileIs == FILE_IS_SHN ||
		    VarSplitAlloc [ num ].TypeFileIs == FILE_IS_WAVPACK) {

			g_print("\n");
			list = g_list_first (VarSplitAlloc [ num ].list);
			switch (VarSplitAlloc [ num ].TypeStruct) {
			case _SPLIT_TYPE_BEGIN_ZERO_ :
				g_print("!---------------------------------\n");
				g_print("! LE DEBUT EST ZERO\n");
				g_print("!---------------------------------\n");
				break;
			case _SPLIT_TYPE_ELSE_ :
				g_print("!---------------------------------\n");
				g_print("! LE DEBUT EST SUPERIEUR A ZERO\n");
				g_print("!---------------------------------\n");
				break;
			case _SPLIT_TYPE_OGG_ :
				g_print("!---------------------------------\n");
				g_print("! DECOUPE OGG\n");
				g_print("!---------------------------------\n");
				break;
			case _SPLIT_TYPE_MP3_ :
				g_print("!---------------------------------\n");
				g_print("! DECOUPE MP3\n");
				g_print("!---------------------------------\n");
				break;
			}

			while (list) {
				if ((Ptr = (gchar *)list->data)) {
					/*g_print ("[ %02d ] %s", num, Ptr);*/
					// g_print ("%s ", Ptr);
				}
				list = g_list_next (list);
			}
		}
	}
	g_print("\n");
	for (num = 0; num < VarSplitAlloc [ 0 ].NbrAlloc; num ++) {
		if (VarSplitAlloc [ num ].TypeFileIs == FILE_IS_WAV ||
		    VarSplitAlloc [ num ].TypeFileIs == FILE_IS_MP3 ||
		    VarSplitAlloc [ num ].TypeFileIs == FILE_IS_OGG ||
		    VarSplitAlloc [ num ].TypeFileIs == FILE_IS_FLAC ||
		    VarSplitAlloc [ num ].TypeFileIs == FILE_IS_SHN ||
		    VarSplitAlloc [ num ].TypeFileIs == FILE_IS_WAVPACK) {
			g_print("\n");
			list = g_list_first (VarSplitAlloc [ num ].list);
			while (list) {
				if ((Ptr = (gchar *)list->data)) {
					g_print ("%s ", Ptr);
				}
				list = g_list_next (list);
			}
		}
	}
	g_print("\n");

	/* Go to SPLIT */

	SplitAction_action (VarSplitAlloc);
	// splitaction_deallocate_GList ();
}

void splitaction_button_clicked (void)
{
	PRINT_FUNC_LF();
	
	// if (split_get_elements () == 0) {
	// 	split_button_ajouter_tache_clicked ();
	// }
	splitaction_button_action_split_clicked ();
}



