 /*
 * file      : utils.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#include <gtk/gtk.h>
#include <glib.h>
#include <glib/gstdio.h>

#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <ctype.h>
#include <sys/utsname.h>
#include <sys/sysinfo.h>

#include "support.h"

#include "global.h"
#include "secu.h"
#include "info_song.h"
#include "cd_audio.h"
#include "get.h"
#include "config_user.h"
#include "win_info.h"
#include "options.h"
#include "utils.h"

	
/*
*---------------------------------------------------------------------------
* FILE.C
*---------------------------------------------------------------------------
*/

VAR_UTILS var_utils = {NULL, NULL};



void utils_puts_statusbar_global (gchar *mess_label_status)
{
	if (var_utils.AdrLabelStatusbarGlobal) {
		
		gchar *New_Str = NULL;
		gchar *NewName = g_strnfill (strlen(mess_label_status) * 4, '\0');
		gchar *NewPtr = NewName;
		gchar *ptr = mess_label_status;
		
		while (*ptr) {
			if (*ptr == '&') {
				*NewPtr ++ = *ptr ++;
				*NewPtr ++ = 'a';
				*NewPtr ++ = 'm';
				*NewPtr ++ = 'p';
				*NewPtr ++ = ';';
			}
			else {
				*NewPtr ++ = *ptr ++;
			}
		}
		
		/*
		New_Str = g_strdup_printf (" <span font_desc=\"Courier bold %d\"><span color=\"black\"><b>%s</b></span></span>",
					SIZE_CAR_STATUSBAR,
					mess_label_status);
		*/
		New_Str = g_strdup_printf (" <span font_desc=\"sans %d\"><span color=\"black\"><b>%s</b></span></span>",
					SIZE_CAR_STATUSBAR,
					NewName);

		gtk_label_set_use_markup (GTK_LABEL (var_utils.AdrLabelStatusbarGlobal), TRUE);
		gtk_label_set_justify (GTK_LABEL (var_utils.AdrLabelStatusbarGlobal), GTK_JUSTIFY_CENTER);
		gtk_label_set_markup (GTK_LABEL (var_utils.AdrLabelStatusbarGlobal), New_Str);

		g_free (New_Str);
		New_Str = NULL;
		
		g_free (NewName);
		NewName = NULL;
	}
}


/* Execute WHICH Name_Prg et si 'gchar **Pathname_Prg' est non null retourne le resultat
*  --
*/
gboolean utils_scan_by_which (gchar *Name_Prg, gchar **Pathname_Prg)
{
	gchar      *PathName = NULL;
	gboolean    BoolFind = FALSE;
	
	if (Name_Prg == NULL) return (FALSE);
	if (*Name_Prg == '\0') return (FALSE);
	
	/* MODIF SUITE A TEST SOUS UBUNTU HARDY-HERON (8.04 LTS)
	*
	if (strcmp (Name_Prg, "w32codecs") == 0) {
		return (infosong_file_is_dir ("/usr/lib/win32"));
	}
	else if (strcmp (Name_Prg, "w64codecs") == 0) {
		return (infosong_file_is_dir ("/usr/lib/codecs"));
	}
	*/
	if (strcmp (Name_Prg, "w32codecs") == 0) {
		if (infosong_file_is_dir ("/usr/lib/codecs") == TRUE) return (TRUE);
		else if (infosong_file_is_dir ("/usr/lib/win32") == TRUE) return (TRUE);
		else return (FALSE);
	}
	else if (strcmp (Name_Prg, "w64codecs") == 0) {
		return (infosong_file_is_dir ("/usr/lib/codecs"));
	}
	
	PathName = g_strdup_printf ("/usr/bin/%s", Name_Prg);
	BoolFind = infosong_file_is_reg (PathName);
	g_free (PathName);
	PathName = NULL;
	if (BoolFind == TRUE) return (TRUE);
	
	PathName = g_strdup_printf ("/usr/sbin/%s", Name_Prg);
	BoolFind = infosong_file_is_reg (PathName);
	g_free (PathName);
	PathName = NULL;
	if (BoolFind == TRUE) return (TRUE);
	
	PathName = g_strdup_printf ("/usr/local/bin/%s", Name_Prg);
	BoolFind = infosong_file_is_reg (PathName);
	g_free (PathName);
	PathName = NULL;
	if (BoolFind == TRUE) return (TRUE);
	
	return (FALSE);
}

/* Renvoie la date du jour sous la forme '31/12/06'
*  --
*  entree :  -
*  retour :
*      gchar * : contient la date
*
struct tm {
	int     tm_sec;         -- secondes
	int     tm_min;         -- minutes
	int     tm_hour;        -- heures
	int     tm_mday;        -- quantième du mois
	int     tm_mon;         -- mois (0 à 11 !)
	int     tm_year;        -- année
	int     tm_wday;        -- jour de la semaine
	int     tm_yday;        -- jour de l’année
	int     tm_isdst;       -- décalage horaire
};
*/
gchar *utils_get_str_date (void)
{
	static gchar StrDate [ 40 ];
	time_t temps;
	struct tm *tm;

	/* PRINT_FUNC_LF(); */
	time (&temps);
	tm = localtime (&temps);
	sprintf (StrDate, "%02d/%02d/%02d", tm->tm_mday, tm->tm_mon+1, tm->tm_year % 100);

	return (&StrDate [ 0 ]);
}
gchar *utils_get_str_time (void)
{
	static gchar StrTime [ 40 ];
	time_t temps;
	struct tm *tm;

	/* PRINT_FUNC_LF(); */
	time (&temps);
	tm = localtime (&temps);
	sprintf (StrTime, "%02d:%02d:%02d", tm->tm_hour, tm->tm_min, tm->tm_sec);

	return (&StrTime [ 0 ]);
}


/* Delete carriage return
*  IL faudra, un jour, que j'essaye 'Perl' ;-)
*  --
*  entree :
*      gchar *Astr : pointeur sur une chaine
*  retour :
*      gchar * : pointeur sur la chaine de retour
*/
gchar *sc_chomp(gchar *Astr)
{
	gchar *s;

	/* PRINT_FUNC_LF(); */
	if ((s = strrchr(Astr, 13))) *s = '\0';
	if ((s = strrchr(Astr, 10))) *s = '\0';

	return Astr;
}

/* retourne un pointeur sur le contenu d'un combobox
*  --
*  entree :
*      GtkWidget *Acombo : pointeur sur un widget combobox
*  retour :
*      gpointer : pointeur sur la chaine du widget combobox
*/
gpointer get_combo_value(GtkWidget *Acombo)
{
	GtkTreeModel *Lmodel = gtk_combo_box_get_model(GTK_COMBO_BOX(Acombo));
	GtkTreeIter Liter;
	gpointer *Lvalue = NULL;

	/* PRINT_FUNC_LF(); */
	if (!gtk_combo_box_get_active_iter(GTK_COMBO_BOX(Acombo), &Liter)) return NULL;

	gtk_tree_model_get(Lmodel, &Liter, 0, &Lvalue, -1);

	return Lvalue;
}

/* retourne la valeur d'un combo sous forme numerique
*/
gint get_combo_intvalue(GtkWidget *Acombo)
{
	GtkTreeModel *Lmodel = gtk_combo_box_get_model(GTK_COMBO_BOX(Acombo));
	GtkTreeIter Liter;
	gint Lvalue = -1;

	/* PRINT_FUNC_LF(); */

	if (!gtk_combo_box_get_active_iter(GTK_COMBO_BOX(Acombo), &Liter)) return -1;

	gtk_tree_model_get(Lmodel, &Liter, 0, &Lvalue, -1);

	return Lvalue;
}

/* retourne la valeur d'un combo
*/
gchar *get_combo_value_pos(GtkWidget *Acombo, gint Apos)
{
	GtkTreeModel *Lmodel = gtk_combo_box_get_model(GTK_COMBO_BOX(Acombo));
	GtkTreeIter Liter;
	gchar *Lvalue = NULL;

	/* PRINT_FUNC_LF(); */

	if (!gtk_combo_box_get_active_iter(GTK_COMBO_BOX(Acombo), &Liter)) return g_strdup("");

	gtk_tree_model_get(Lmodel, &Liter, Apos, &Lvalue, -1);

	return Lvalue;
}

/* utils_hexa_to_int : convertit en entier la chaine pointee par 'gchar *Ptr_Hexa' en hexa
*  La chaine doit commencer par 0x..
*  VALUES A = 65  et   a = 97
*/
gint utils_hexa_to_int (gchar *Ptr_Hexa)
{
	gint     chiffre_hexa = 0;
	/*gint     cpt = 0;*/
	gint     Gint_Ret = 0;
	gboolean Bool_dans_hexa = FALSE;

	/* PRINT_FUNC_LF(); */

	if (Ptr_Hexa == NULL) return (0);
	if (!*Ptr_Hexa || !*(Ptr_Hexa+1) || !*(Ptr_Hexa+2) || !*(Ptr_Hexa+3))  return (0);

	if (*Ptr_Hexa == '0' && (*(Ptr_Hexa+1) == 'x' || *(Ptr_Hexa+1) == 'X')) {
		Ptr_Hexa += 2;
		Bool_dans_hexa = TRUE;
	}

	Gint_Ret = 0;
	while (Bool_dans_hexa) {
		if (g_ascii_isdigit (*Ptr_Hexa)) {
			chiffre_hexa = *Ptr_Hexa - '0';
		}
		else if (g_ascii_isxdigit (*Ptr_Hexa)) {
			if ((gint)*Ptr_Hexa >= 'a')
				chiffre_hexa = *Ptr_Hexa - 'a' + 10;
			else    chiffre_hexa = *Ptr_Hexa - 'A' + 10;
		}
		else Bool_dans_hexa = FALSE;

		if (Bool_dans_hexa) {
			Gint_Ret = 16 * Gint_Ret + chiffre_hexa;
			Ptr_Hexa ++;
		}
	}

	return (Gint_Ret);
}

gchar *utils_get_infos_ordi (gboolean bool_uname, gboolean bool_sysinfo, gboolean bool)
{
	struct utsname utsname;
	struct sysinfo info;
	gchar  *ptruname = NULL;
	gchar  *ptrsysinfo = NULL;
	gchar  *ptr = NULL;
	
	HostConf.NbCpu   = sysconf(_SC_NPROCESSORS_ONLN);
	HostConf.TypeCpu = 8 * sizeof(void*);
	
	if (bool_uname && uname (&utsname) == 0) {
		
		strcpy (HostConf.Machine, utsname.machine);
		if (strcmp (HostConf.Machine, "x86_64") == 0)
			HostConf.BoolCpuIs64Bits = TRUE;
		else	HostConf.BoolCpuIs64Bits = FALSE;
		
		if (bool) {
			ptruname = g_strdup_printf (
					"<span foreground=\"#0000FF\"><b>Informations machine:</b></span>\n\n"
					"sysname\n\t<b> %s</b>\n"
					"nodename\n\t<b> %s</b>\n"
					"release\n\t<b> %s</b>\n"
					"version\n\t<b> %s</b>\n"
					"machine\n\t<b> %s</b>\n"
					"\t<b> %d CPU (%d bits)</b>\n",
				utsname.sysname, utsname.nodename, utsname.release, utsname.version, utsname.machine,
				HostConf.NbCpu, HostConf.TypeCpu);
		}
		else {
			ptruname = g_strdup_printf (
					"\nINFORMATIONS MACHINE:\n\n"
					"sysname\t\t= %s\n"
					"nodename\t= %s\n"
					"release\t\t= %s\n"
					"version\t\t= %s\n"
					"machine\t\t= %s\n"
					"       \t\t= %d CPU (%d bits)\n",
				utsname.sysname, utsname.nodename, utsname.release, utsname.version, utsname.machine,
				HostConf.NbCpu, HostConf.TypeCpu);
		}
	}
	if (bool_sysinfo && sysinfo (&info) == 0) {
		ptrsysinfo = g_strdup_printf (
				"Nb secondes depuis boot           : %ld\n"
				"Charge systeme depuis  1 minute   : %.2f%%\n"
				"Charge systeme depuis  5 minutes  : %.2f%%\n"
				"Charge systeme depuis 10 minutes  : %.2f%%\n"
				"Memoire disponible                : %ld Mo\n"
				"Memoire partagee                  : %ld Mo\n"
				"Memoire dans buffer               : %ld Mo\n"
				"Espace de swap total              : %ld Mo\n"
				"Espace de swap libre              : %ld Mo\n"
				"Nb processus en cours             : %d\n",
				info.uptime,
				info.loads[0] / 655.36,
				info.loads[1] / 655.36,
				info.loads[2] / 655.36,
				info.freeram >> 20,
				info.sharedram >> 20,
				info.bufferram >> 20,
				info.totalswap >> 20,
				info.freeswap >> 20,
				info.procs);
	}
	if (bool_uname && bool_sysinfo) {
		ptr = g_strdup_printf ("%s\n%s",
				ptruname ? ptruname : "ERREUR APPEL A: uname",
				ptrsysinfo ? ptrsysinfo : "ERREUR APPEL A: sysinfo");
	}
	else if (bool_uname) {
		ptr = g_strdup_printf ("%s\n", ptruname ? ptruname : "ERREUR APPEL A: uname");
	}
	else if (bool_sysinfo) {
		ptr = g_strdup_printf ("%s\n", ptrsysinfo ? ptrsysinfo : "ERREUR APPEL A: sysinfo");
	}

	g_free (ptruname);
	ptruname = NULL;
	g_free (ptrsysinfo);
	ptrsysinfo = NULL;
	return (ptr);
}
void utils_infos_ordi (void)
{
	gchar *ptr = NULL;

	ptr = utils_get_infos_ordi (TRUE, TRUE, FALSE);
	g_print ("%s\n", ptr);
	g_free (ptr);
	ptr = NULL;
}

/*******************************************************************
*  gboolean utils_new_strcmp (gchar *src, gchar *dest)
*-------------------------------------------------------------------
*
*  call   : utils_new_strcmp ("Test", "tEst"); => FALSE
*
*  action : Recherche de 2 memes sequences comprises dans les intervales:
*           'a' .. 'z'
*           'A' .. 'Z'
*           '0' .. '9'
*           '_'
*
* params  : gchar *src   doit etre non-nulle et terminee par '\0'
*           gchar *dest  doit etre non-nulle et terminee par '\0'
*
*  return : TRUE si les sequences sont identiques
*
*******************************************************************/
gboolean utils_new_strcmp (gchar *src, gchar *dest)
{
	gchar    *ptr = NULL;
	gchar    *ptrsrc = NULL;
	gchar    *ptrdest = NULL;
	gint      lensrc = 0;
	gint      lendest = 0;
	gboolean  etat = FALSE;

	/*PRINT_FUNC_LF();*/

	if (!src || !*src) return (etat);
	if (!dest || !*dest) return (etat);

	/* SOURCE */
	/* aller au premier caractere valide */
	for (ptrsrc = src; *ptrsrc; ptrsrc ++) {
		if ((*ptrsrc >= 'A' && *ptrsrc <= 'Z') || (*ptrsrc >= 'a' && *ptrsrc <= 'z') ||
					(*ptrsrc >= '0' && *ptrsrc <= '9') || *ptrsrc == '_' || *ptrsrc == '%') break;
	}
	
	/* cherche le nombre de caracteres valides */
	for (lensrc = 0, ptr = ptrsrc; *ptr; ptr ++) {
		if ((*ptr >= 'a' && *ptr <= 'z') || (*ptr >= 'A' && *ptr <= 'Z') || (*ptr >= '0' && *ptr <= '9') || *ptr == '_' || *ptr == '%')
			lensrc++;
		else	break;
	}
	/* DESTINATION */
	/* aller au premier caractere valide */
	for (ptrdest = dest; *ptrdest; ptrdest ++) {
		if ((*ptrdest >= 'A' && *ptrdest <= 'Z') || (*ptrdest >= 'a' && *ptrdest <= 'z') ||
					(*ptrdest >= '0' && *ptrdest <= '9') || *ptrdest == '_' || *ptrdest == '%') break;
	}
	/* cherche le nombre de caracteres valides */
	for (lendest = 0, ptr = ptrdest; *ptr; ptr ++) {
		if ((*ptr >= 'a' && *ptr <= 'z') || (*ptr >= 'A' && *ptr <= 'Z') || (*ptr >= '0' && *ptr <= '9') || *ptr == '_' || *ptr == '%')
			lendest++;
		else	break;
	}
	/* comparaison possible */
	if (lensrc == lendest) {
		while (lensrc > 0 && *ptrsrc ++ == *ptrdest ++) lensrc --;
		ptrsrc --;
		ptrdest --;
		etat = lensrc == 0 && *ptrsrc == *ptrdest;
	}

	return (etat);
}

/* Affiche l'icone XCFA a gauche dans la barre de titre
*/
void utils_set_default_icone_xcfa (GtkWidget *win)
{
	gchar     *LineCommand = NULL;
	GError    *error = NULL;
	/*
	void        gtk_window_set_icon (GtkWindow *window, GdkPixbuf *icon);
	GdkPixbuf  *gdk_pixbuf_new_from_file (const char *filename, GError **error);
	gboolean    gtk_window_set_icon_from_file (GtkWindow *window, const gchar *filename, GError **err);
	*/

	LineCommand = utils_get_pathname ("xcfa.png");
	
 	gtk_window_set_icon_from_file (GTK_WINDOW(win), LineCommand, &error);
 	if (error) {
 		GDK_PIXBUF_ERROR;
		g_critical ("Could not load pixbuf: %s\n", error->message);
		g_error_free (error);
	}
	g_free (LineCommand);
	LineCommand = NULL;
}

gchar *utils_get_pathname (gchar *file)
{
	gchar *LineCommand = NULL;
	
	LineCommand = g_strdup_printf ("%s/pixmaps/xcfa/%s", PACKAGE_DATA_DIR, file);
	return (LineCommand);
}

void utils_clear_elements_combobox (GtkWidget *widget)
{
	if (GTK_COMBO_BOX (widget) != NULL) {
		while (TRUE) {
			gtk_combo_box_set_active (GTK_COMBO_BOX (widget), 0);
			if (gtk_combo_box_get_active (GTK_COMBO_BOX (widget)) > -1)
				gtk_combo_box_remove_text (GTK_COMBO_BOX (widget), 0);
			else	break;
		}
	}
}

/*
*---------------------------------------------------------------------------
* Fonctions communes a cd_audio et file
*---------------------------------------------------------------------------
*/

gboolean utils_set_prg_not_found (gchar *name, gboolean bool_prg)
{
	GList  *list = NULL;
	gchar  *ptr = NULL;
	
	if (bool_prg == TRUE) return (FALSE);
	
	/*PRINT_FUNC_LF();*/
	list = g_list_first (var_utils.list_prg_not_found);
	while (list) {
		if ((ptr = (gchar*)list->data)) {
			if (strcmp (ptr, name) == 0) return (TRUE);
		}
		list = g_list_next(list);
	}
	ptr = NULL;
	ptr = g_strdup (name);
	var_utils.list_prg_not_found = g_list_append (var_utils.list_prg_not_found, ptr);
	
	return (TRUE);
}
void utils_remove_prg_not_found (void)
{
	GList  *list = NULL;
	
	/*PRINT_FUNC_LF();*/
	list = g_list_first (var_utils.list_prg_not_found);
	while (list) {
		if ((gchar*)list->data) {
			g_free ((gchar*)list->data);
			list->data = NULL;
		}
		list = g_list_next(list);
	}
	g_list_free (var_utils.list_prg_not_found);
	var_utils.list_prg_not_found = NULL;
}
void utils_print_prg_not_found (void)
{
	GList  *list = NULL;
	gchar  *ptr = NULL;
	
	/*PRINT_FUNC_LF();*/
	list = g_list_first (var_utils.list_prg_not_found);
	while (list) {
		if ((ptr = (gchar*)list->data)) {
			g_print ("%s\n", ptr);
		}
		list = g_list_next(list);
	}
	g_print ("\n");
}
gboolean utils_put_error_statusbar (gboolean is_file)
{
	GString  *gstr = NULL;
	GList    *list = NULL;
	gchar    *ptr = NULL;

	if (var_utils.list_prg_not_found == NULL) return (FALSE);

	/*PRINT_FUNC_LF();*/
	gstr = g_string_new (NULL);
	g_string_append_printf (gstr, _("Pas installes:"));
	list = g_list_first (var_utils.list_prg_not_found);
	while (list) {
		if ((ptr = (gchar*)list->data)) {
			g_string_append_printf (gstr, " %s", ptr);
		}
		list = g_list_next(list);
	}
	g_string_append_printf (gstr, "  /  Installation depuis [ Applications externes ]");
	
	if (is_file == TRUE)
		utils_puts_statusbar_global (gstr->str);
	else	cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, gstr->str);
	
	g_string_free (gstr, TRUE);

	utils_remove_prg_not_found ();
	return (TRUE);
}

void utils_set_mess_from_file_ETAT_TRASH (ETAT_TRASH_FILE etat)
{
	gchar *str = NULL;

	switch (etat) {
	case FILE_TRASH_NONE :
		str = g_strdup_printf (_("Cliquez ici pour envoyer ce fichier apres traitement vers: %s"), filetrash_get_trash ());
		break;
	case FILE_TRASH_OK :
		str = g_strdup_printf (_("Ce fichier sera dirige apres traitement vers le dossier %s"), filetrash_get_trash ());
		break;
	case FILE_TRASH_VERIF_OK :
		str = g_strdup ("");
		break;
	}
	utils_puts_statusbar_global (str);
	g_free (str);
	str = NULL;
}

void utils_set_mess_from_file_ETAT_SELECTION (ETAT_SELECTION etat, gboolean BoolRepIdentique)
{
	gchar *str = NULL;

	if (utils_put_error_statusbar (TRUE) == TRUE) return;
	switch (etat) {
	case ETAT_PRG_NONE :
		str = g_strdup ("");
		break;
	case ETAT_PRG_ABSENT :
		str = g_strdup ("");
		break;
	case ETAT_ATTENTE :
		str = g_strdup_printf (_("%s(Click Droit = Menu) / En attente de selection."), BoolRepIdentique ? _("CONVERSION VERS LA SOURCE - ") : "");
		break;
	case ETAT_ATTENTE_EXIST :
		str = g_strdup_printf (_("%s(Click Droit = Menu) / En attente de selection. Le fichier existe."), BoolRepIdentique ? _("CONVERSION VERS LA SOURCE - ") : "");
		break;
	case ETAT_SELECT :
		str = g_strdup_printf (_("%s(Click Droit = Menu) / Selection."), BoolRepIdentique ? _("CONVERSION VERS LA SOURCE - ") : "");
		break;
	case ETAT_SELECT_EXIST :
		str = g_strdup_printf (_("%s(Click Droit = Menu) / Selection. Le fichier existe."), BoolRepIdentique ? _("CONVERSION VERS LA SOURCE - ") : "");
		break;
	case ETAT_SELECT_EXPERT :
		str = g_strdup_printf (_("%s(Click Droit = Menu) / Selection avec options expert."), BoolRepIdentique ? _("CONVERSION VERS LA SOURCE - ") : "");
		break;
	case ETAT_SELECT_EXPERT_EXIST :
		str = g_strdup_printf (_("%s(Click Droit = Menu) / Selection avec options expert. Le fichier existe."), BoolRepIdentique ? _("CONVERSION VERS LA SOURCE - ") : "");
		break;
	}
	
	utils_puts_statusbar_global (str);
	g_free (str);
	str = NULL;
}

void utils_set_mess_from_file_ETAT_NORMALISE (DETAIL *Detail, FIC *fic, ETAT_NORMALISE etat, gboolean BoolRepIdentique)
{
	gchar       *str = NULL;
	
	if (utils_put_error_statusbar (TRUE) == TRUE) return;
/*	
PEAK/ALBUM
    Amplification maximale du volume pour un groupe de fichiers en respectant les écarts de niveau entre chacun d'eux.
PEAK
    Amplification maximale du volume pour chaque de fichier
RMS/ALBUM
    Ajustement du volume moyen pour un groupe de fichiers en respectant les écarts de niveau moyen entre chacun d'eux
RMS
    Ajustement du volume moyen de chaque de fichier
*/
	switch (fic->Etat_Normalise) {
	case NORM_NONE :
		if (Detail->type_infosong_file_is == FILE_IS_WAV ||
		    Detail->type_infosong_file_is == FILE_IS_MP3 ||
		    Detail->type_infosong_file_is == FILE_IS_OGG) {
		    str = g_strdup (_("En attente de selection."));
		}
		else {
		    str = g_strdup ("");
		}
		break;
	case NORM_READY_FOR_SELECT :
		str = g_strdup (_("En attente de selection."));
		break;
	case NORM_RMS_FIX :
		str = g_strdup_printf (_("%sRMS: Ajustement du volume moyen de chaque de fichier"), BoolRepIdentique ? _("CONVERSION VERS LA SOURCE / ") : "");
		break;
	case NORM_RMS_MIX_ALBUM :
		str = g_strdup_printf (_("%sRMS-ALBUM: Ajustement du volume moyen pour un groupe de fichiers en respectant les ecarts de niveau moyen entre chacun d'eux"), BoolRepIdentique ? _("CONVERSION VERS LA SOURCE / ") : "");
		break;
	case NORM_PEAK :
		str = g_strdup_printf (_("%sPEAK: Amplification maximale du volume pour chaque de fichier"), BoolRepIdentique ? _("CONVERSION VERS LA SOURCE / ") : "");
		break;
	case NORM_PEAK_ALBUM :
		if (file_peak_get_size_is_ok (NORM_PEAK_ALBUM, NULL) == FALSE) {
			str = g_strdup (_("ATTENTION: Pas assez de place dans le dossier temporaire"));
		}
		else {
			str = g_strdup_printf (_("%sPEAK-ALBUM: Amplification maximale du volume pour un groupe de fichiers en respectant les ecarts de niveau entre chacun d'eux."), BoolRepIdentique ? _("CONVERSION VERS LA SOURCE / ") : "");
		}
		break;
	default:
		str = g_strdup ("Oo");
	}
	
	utils_puts_statusbar_global (str);
	g_free (str);
	str = NULL;
}

void utils_set_mess_from_file_ETAT_PLAY (ETAT_PLAY_FILE etat)
{
	gchar *str = NULL;

	if (utils_put_error_statusbar (TRUE) == TRUE) return;
	switch (etat) {
	case FILE_ETAT_PLAY_NONE :
		str = g_strdup ("");
		break;
	case FILE_ETAT_PLAY_PRG_ABSENT :
		str = g_strdup ("FILE_ETAT_PLAY_PRG_ABSENT");
		break;
	case FILE_ETAT_PLAY_ATTENTE :
		str = g_strdup (_("En attente de selection."));
		break;
	case FILE_ETAT_PLAY :
		str = g_strdup (_("En ecoute."));
		break;
	}
	
	utils_puts_statusbar_global (str);
	g_free (str);
	str = NULL;
}

void utils_set_mess_from_file_ETAT_REPLAYGAIN (ETAT_REPLAYGAIN etat, gboolean BoolRepIdentique)
{
	gchar *str = NULL;

	if (utils_put_error_statusbar (TRUE) == TRUE) return;
	switch (etat) {
	case RPG_NONE :
		str = g_strdup ("");
		break;
	case RPG_ATTENTE :
		str = g_strdup_printf (_("%s(Click Droit = Menu) / En attente de selection."), BoolRepIdentique ? _("CONVERSION VERS LA SOURCE - ") : "");
		break;
	case RPG_PISTE :
		str = g_strdup_printf (_("%s(Click Droit = Menu) / Mode piste."), BoolRepIdentique ? _("CONVERSION VERS LA SOURCE - ") : "");
		break;
	case RPG_ALBUM :
		str = g_strdup_printf (_("%s(Click Droit = Menu) / Mode album."), BoolRepIdentique ? _("CONVERSION VERS LA SOURCE - ") : "");
		break;
	case RPG_EFFACER :
		str = g_strdup_printf (_("%s(Click Droit = Menu) / Mode effacer."), BoolRepIdentique ? _("CONVERSION VERS LA SOURCE - ") : "");
		break;
	}
	utils_puts_statusbar_global (str);
	g_free (str);
	str = NULL;
}

void utils_set_mess_from_cd_ETAT_SELECTION_CD (ETAT_SELECTION_CD etat)
{
	gchar *str = NULL;

	if (utils_put_error_statusbar (FALSE) == TRUE) return;
	/*
	if(BoolColIsWav)
		PRINT("BoolColIsWav");
	*/
	switch (etat) {
	case CD_ETAT_NONE :
		str = g_strdup ("");
		break;
	case CD_ETAT_PRG_ABSENT :
		str = g_strdup ("");
		break;
	case CD_ETAT_ATTENTE :
		str = g_strdup_printf (_("%s En attente de selection."), options_extract_by_name ());
		break;
	case CD_ETAT_ATTENTE_EXIST :
		str = g_strdup_printf (_("%s En attente de selection. Le fichier existe."), options_extract_by_name ());
		break;
	case CD_ETAT_SELECT :
		str = g_strdup_printf (_("%s Selection."), options_extract_by_name ());
		break;
	case CD_ETAT_SELECT_EXIST :
		str = g_strdup_printf (_("%s Selection. Le fichier existe."), options_extract_by_name ());
		break;
	case CD_ETAT_SELECT_EXPERT :
		str = g_strdup_printf (_("%s Selection avec options expert."), options_extract_by_name ());
		break;
	case CD_ETAT_SELECT_EXPERT_EXIST :
		str = g_strdup_printf (_("%s Selection avec options expert. Le fichier existe."), options_extract_by_name ());
		break;
	}
	
	cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, str);
	g_free (str);
	str = NULL;
}

void utils_set_mess_from_cd_ETAT_PLAY_CD (ETAT_PLAY_CD etat)
{
	gchar *str = NULL;

	if (utils_put_error_statusbar (FALSE) == TRUE) return;
	switch (etat) {
	case CD_ETAT_PLAY_NONE :
		str = g_strdup ("");
		break;
	case CD_ETAT_PLAY_PRG_ABSENT :
		str = g_strdup ("");
		break;
	case CD_ETAT_PLAY_ATTENTE :
		str = g_strdup (_("En attente de selection."));
		break;
	case CD_ETAT_PLAY :
		str = g_strdup (_("En ecoute."));
		break;
	}
	
	cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, str);
	g_free (str);
	str = NULL;
}

void utils_set_mess_from_cd_ETAT_NORMALISE_CD (ETAT_NORMALISE_CD EtatNormalise)
{
	gchar *str = NULL;

	if (EtatNormalise == TRUE) {
		str = g_strdup (_("(Click Droit = Menu) / POPUP."));
	}
	else {
		str = g_strdup (_("En attente de selection."));
	}
	
	cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, str);
	g_free (str);
	str = NULL;
	
}


/*
*---------------------------------------------------------------------------
* Gestion du Temps
*---------------------------------------------------------------------------
*/

clock_t start, end;

void utils_time_start (void)
{
	start = clock ();
}
void utils_time_end (gchar *Def)
{
	end = clock ();
	g_print ("TEMPS D'INIT DE [%s]: \n\tTemps en secondes : %4.2f\n", Def, (end - start) / (double)CLOCKS_PER_SEC);
}

/*
*---------------------------------------------------------------------------
* Gestion UTF-8
*---------------------------------------------------------------------------
*/

/* Fonctions reprises (et adaptees) depuis EasyTag v1.99.12
 *
 * Main part of code, written by:
 * Copyright (C) 1999-2001  Håvard Kvålen <havardk@xmms.org>
 *
 * Length must be passed, as the string might be Unicode, in which case we can't
 * count zeroes (see strlen call below).
 */
gchar *utils_convert_to_utf8 (const gchar *string)
{
	gchar	*ptr = NULL;
	GError	*error = NULL;
	gchar	*output = NULL;
	gsize    bytes_written;
	
	if (!string) return ((gchar *)NULL);
	
	/* Suppression des ESPACES de fin de chaine	*/
	for (ptr = (gchar *)string; *ptr; ptr ++);
	ptr --;
	while (ptr >= string && *ptr == ' ') ptr --;
	ptr ++;
	*ptr = '\0';
	
	/* Si transformation deja faite quit */
	if (g_utf8_validate(string, -1, NULL)) return ((gchar *)g_strdup(string));
	
	output = g_convert(string, -1, "utf-8", "iso-8859-1", NULL, &bytes_written, &error);
	if (output == NULL) {
		
		gchar *escaped_str = g_strescape(string, NULL);
		
		g_warning("convert_string(): Failed conversion from charset 'iso-8859-1' to 'utf-8'. String '%s'. Errcode %d (%s).\n",
					escaped_str,
					error->code,
					error->message);
		g_free(escaped_str);
		g_error_free(error);
		/*
		Return the input string without converting it. If the string is displayed in the UI, it must be in UTF-8!
		*/
		if ((g_ascii_strcasecmp("utf-8", "UTF-8")) ||   (g_utf8_validate(string, -1, NULL)) )
		{
			return ((gchar *)g_strdup(string));
		}
	}
	else {
		/* Patch from Alexey Illarionov:
			g_convert returns null-terminated string only with one \0 at the
			end. It can cause some garbage at the end of a string for UTF-16.
			The second \0 should be set manually.
		*/
		output = g_realloc(output, bytes_written + 2);
		if (output != NULL) output[bytes_written] = output[bytes_written + 1] = 0;
	}
	
	return ((gchar *)output);
}

gchar *utils_convert_from_utf8 (const char *string)
{
	gchar	*ptr = NULL;
	GError	*error = NULL;
	gchar	*output = NULL;
	gsize    bytes_written;
	
	if (!string) return ((gchar *)NULL);
	
	/* Suppression des ESPACES de fin de chaine	*/
	for (ptr = (gchar *)string; *ptr; ptr ++);
	ptr --;
	while (ptr >= string && *ptr == ' ') ptr --;
	ptr ++;
	*ptr = '\0';
	
	output = g_convert(string, -1, "iso-8859-1", "utf-8", NULL, &bytes_written, &error);
	if (output == NULL) {
		return ((gchar *)g_strdup(string));
	}
	else if (output != NULL) {
		/* Patch from Alexey Illarionov:
			g_convert returns null-terminated string only with one \0 at the
			end. It can cause some garbage at the end of a string for UTF-16.
			The second \0 should be set manually.
		*/
		output = g_realloc(output, bytes_written + 2);
		if (output != NULL) output[bytes_written] = output[bytes_written + 1] = 0;
	}
	
	return ((gchar *)output);
}

/* Fonctions reprises (et adaptees) depuis EasyTag v1.99.12
 *
 * Main part of code, written by:
 * Copyright (C) 1999-2001  Håvard Kvålen <havardk@xmms.org>
 *
 * Length must be passed, as the string might be Unicode, in which case we can't
 * count zeroes (see strlen call below).
 */
gchar *utils_convert_string_1 (const gchar *string,
				gssize length,
				const gchar *from_codeset,
                         	const gchar *to_codeset,
                         	const gboolean display_error)
{
	gchar  *ptr = NULL;
	gchar  *output = NULL;
	GError *error = NULL;
	gsize   bytes_written;

	if (!string) return NULL;

	/* Adaptation pour Xcfa v3.2.x
	*/
	/* Suppression des ESPACES de fin de chaine */
	for (ptr = (gchar *)string; *ptr; ptr ++);
	ptr --;
	while (ptr >= string && *ptr == ' ') ptr --;
	ptr ++;
	*ptr = '\0';
	/* Si transformation deja faite quit */
	if (g_utf8_validate(string, -1, NULL)) return ((gchar *)g_strdup(string));

	output = g_convert(string, length, to_codeset, from_codeset, NULL, &bytes_written, &error);
	/*output = g_convert_with_fallback(string, length, to_codeset, from_codeset, "?", NULL, &bytes_written, &error);*/

	if (output == NULL)
	{
		gchar *escaped_str = g_strescape(string, NULL);
		if (display_error)
		{
			g_warning("convert_string(): Failed conversion from charset '%s' to '%s'. String '%s'. Errcode %d (%s).\n",
					from_codeset, to_codeset, escaped_str, error->code, error->message);
		}
		g_free(escaped_str);
		g_error_free(error);
		/*
		Return the input string without converting it. If the string is displayed in the UI, it must be in UTF-8!
		*/
		if ( (g_ascii_strcasecmp(to_codeset, "UTF-8"))
		||   (g_utf8_validate(string, -1, NULL)) )
		{
			return ((gchar *)g_strdup(string));
		}
	}else
	{
		/* Patch from Alexey Illarionov:
			g_convert returns null-terminated string only with one \0 at the
			end. It can cause some garbage at the end of a string for UTF-16.
			The second \0 should be set manually.
		*/
		output = g_realloc(output, bytes_written + 2);
		if (output != NULL) output[bytes_written] = output[bytes_written + 1] = 0;
	}

	/*g_print("from %s => len: %d, string: '%s'\n     (%x %x %x %x %x %x %x %x)\n",from_codeset,length,string,string[0],string[1],string[2],string[3],string[4],string[5],string[6],string[7]);*/
	/*g_print("to   %s => len: %d, output: '%s'\n     (%x %x %x %x %x %x %x %x)\n\n",to_codeset,bytes_written+2,output,output[0],output[1],output[2],output[3],output[4],output[5],output[6],output[7]);*/

	return ((gchar *)output);
}
/*
 * convert_string : (don't use with UTF-16 strings)
 *  - display_error : if TRUE, may return an escaped string and display an error 
 *                    message (if conversion fails).
 */
gchar *utils_convert_string (const gchar *string, gboolean bool)
{
	/*
	convert_string(copy, "iso-8859-1", "utf-8",TRUE);
	*/
	return ((gchar *)utils_convert_string_1 (string, -1, "iso-8859-1", "utf-8", bool));
}

/*
*---------------------------------------------------------------------------
* Ecriture de datas sur disk, recuperation puis effacement du fichier
*---------------------------------------------------------------------------
*/

void utils_add_datas_on_disk (gchar *data)
{
	FILE *fp = NULL;
	
	fp = fopen ("/tmp/data_xcfa.txt", "a");
	fprintf (fp, "%s", data);
	fclose (fp);
}
gchar *utils_get_datas_on_disk (void)
{
	FILE   *fp = NULL;
	gchar  *buf = NULL;
	size_t  size;
	
	size = infosong_get_size_file ("/tmp/data_xcfa.txt");
	buf = (gchar *)g_malloc0 (sizeof(gchar) * (size + 10));
	fp = fopen ("/tmp/data_xcfa.txt", "r");
	fread (buf, 1, size, fp);
	fclose (fp);
	
	infosong_delete_file ("/tmp/data_xcfa.txt");

	return ((gchar  *)buf);
}

/*
*---------------------------------------------------------------------------
* Test si l'ecriture est possible dans ce PathName
*---------------------------------------------------------------------------
*
*  Retour:
*      FALSE -> BAD
*      TRUE  -> OK
*/

gboolean utils_test_write (gchar *path)
{
	gboolean  BoolWriteOk = FALSE;
	FILE     *fp = NULL;
	gchar    *str = NULL;
	
	if (path[ 0 ] == '/' && path[ 1 ] != '\0') {
		str = g_strdup_printf ("%s/xcfa_tst_write.txt", path);
		fp = fopen (str, "w");
		if (fp) {
			BoolWriteOk = TRUE;
			fclose (fp);
			infosong_delete_file (str);
		}
		g_free (str);
		str = NULL;
	}
	
	if (BoolWriteOk == FALSE) {
		wininfo_create (
			_("Erreur choix lieu de stockage !"),
			_("   Le lieu de stockage temporaire doit pouvoir   "),
			  "\n",
			_("   etre accessible en ecriture."),
			  "\n\n",
			_("   Veuillez recommencer."),
			  "\n",
			  "");
	}
	
	return (BoolWriteOk);
}

/*
*---------------------------------------------------------------------------
* Creation d'un dossier temporaire
*---------------------------------------------------------------------------
*
*  Le parametre est reference sous cette forme:
*      
*      #define PATH_TMP_XCFA_AUDIOCD "xcfa_cdaudio"
*      ou
*      #define PATH_TMP_XCFA_AUDIOCD "xcfa/cdaudio"
*
*  L'appel:
*
*      utils_create_temporary_rep (PATH_TMP_XCFA_AUDIOCD);
*
*  Retour:
*      Renvoie le PathName complet
*/

/*  #include <sys/stat.h>
 *  #include <sys/types.h>
 *  
 *  int mkdir(const char *pathname, mode_t mode);
 */

gchar *utils_create_temporary_rep (gchar *path_tmprep)
{
	gchar *LineCommand = NULL;
	gchar *Path = NULL;

	/* PRINT_FUNC_LF(); */
	if (path_tmprep != NULL) {
		Path = g_strdup_printf ("%s/%s", Config_User.Path_TMP, path_tmprep);
		if (infosong_file_is_dir (Path) == FALSE) {
			g_print ("CREATE TEMPORARY REP:\n\t%s\n", Path);
			LineCommand = g_strdup_printf ("mkdir -p %s", Path);
			system (LineCommand);
			g_free (LineCommand);
			LineCommand = NULL;
		}
	}
	return ((gchar *)Path);
}
gchar *utils_remove_temporary_rep (gchar *path_tmprep)
{
	/*
	gchar *LineCommand = NULL;

	LineCommand = g_strdup_printf ("rm -rf %s", path_tmprep);
	g_print ("REMOVE TEMPORARY REP: %s\n", path_tmprep);
	system (LineCommand);
	g_free (LineCommand);
	LineCommand = NULL;

	g_rmdir (path_tmprep);
	*/
	pid_t  pid;

	if (path_tmprep != NULL) {
		if ((pid = fork ()) == 0) {
			execlp (
				"rm",
				"rm",
				"-rf",
				path_tmprep,
				NULL
				);
		}
		g_print ("REMOVE TEMPORARY REP:\n\t%s\n", path_tmprep);
		g_free (path_tmprep);
		path_tmprep = NULL;
	}

	return ((gchar *)NULL);
}

GList *utils_clear_list (GList *p_list)
{
	GList	*list = NULL;
	gchar	*ptr = NULL;

	if ((list = g_list_first (p_list)) != NULL) {
	while (list) {
		if ((ptr = (gchar *)list->data)) {
			g_free (ptr);
			ptr = NULL;
			list->data = NULL;
		}
		list = g_list_next (list);
	}

	g_list_free (p_list);
	p_list = NULL;
	}
	return ((GList *)NULL);
}




