 /*
 * file      : win_info.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#include <gtk/gtk.h>
#include <string.h>
#include "support.h"
#include "global.h"
#include "win_control.h"
#include "utils.h"
#include "win_info.h"

/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

typedef struct {

	gchar    *title;
	GString  *text;
	
} WININFO;

WININFO wininfo;


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

gboolean wininfo_on_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	PRINT_FUNC_LF();
	gtk_widget_destroy (wincontrol_get_last_adr ());
	wincontrol_remove_last ();
	return FALSE;
}
gboolean wininfo_on_destroy_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	PRINT_FUNC_LF();
	gtk_widget_destroy (wincontrol_get_last_adr ());
	wincontrol_remove_last ();
	return FALSE;
}
void wininfo_on_ok_button_clicked (GtkButton *button, gpointer user_data)
{
	PRINT_FUNC_LF();
	gtk_widget_destroy (wincontrol_get_last_adr ());
	wincontrol_remove_last ();
}

void wininfo_create_window (void)
{
	GtkWidget *dialog;
	GtkWidget *dialog_vbox1;
	GtkWidget *vbox1;
	GtkWidget *label_text;
	GtkWidget *dialog_action_area1;
	GtkWidget *ok_button;
	/*GtkWidget *ok_cancel;*/

	/* PRINT_FUNC_LF(); */

	dialog = gtk_dialog_new ();

	wincontrol_set_adr (
		dialog,			/* Window adress                */
		"wininfo_create",	/* Window name			*/
		TRUE,			/* gtk_window_set_transient_for */
		TRUE			/* gtk_window_set_modal         */
		);

	gtk_window_set_title (GTK_WINDOW (dialog), wininfo.title);
	/*gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);*/
	gtk_window_set_resizable (GTK_WINDOW (dialog), FALSE);
	gtk_window_set_type_hint (GTK_WINDOW (dialog), GDK_WINDOW_TYPE_HINT_DIALOG);

	dialog_vbox1 = GTK_DIALOG (dialog)->vbox;
	gtk_widget_show (dialog_vbox1);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

	/*label_text = gtk_label_new (wininfo.text->str);*/
	label_text = gtk_label_new (NULL);
	gtk_label_set_use_markup (GTK_LABEL (label_text), TRUE);
	gtk_label_set_markup (GTK_LABEL (label_text), wininfo.text->str);
	gtk_widget_show (label_text);
	gtk_box_pack_start (GTK_BOX (vbox1), label_text, FALSE, FALSE, 0);

	dialog_action_area1 = GTK_DIALOG (dialog)->action_area;
	gtk_widget_show (dialog_action_area1);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_SPREAD);

	/*ok_cancel = gtk_button_new_from_stock ("gtk-cancel");
	gtk_widget_show (ok_cancel);
	gtk_dialog_add_action_widget (GTK_DIALOG (dialog), ok_cancel, 0);*/
	
	ok_button = gtk_button_new_from_stock ("gtk-ok");
	gtk_widget_show (ok_button);
	gtk_dialog_add_action_widget (GTK_DIALOG (dialog), ok_button, GTK_RESPONSE_OK);
	GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (ok_button);

	g_signal_connect ((gpointer) dialog, "delete_event",
			G_CALLBACK (wininfo_on_delete_event),
			(gpointer)dialog);
	g_signal_connect ((gpointer) dialog, "destroy_event",
			G_CALLBACK (wininfo_on_destroy_event),
			(gpointer)dialog);
	g_signal_connect ((gpointer) ok_button, "clicked",
			G_CALLBACK (wininfo_on_ok_button_clicked),
			(gpointer)dialog);

	/* Store pointers to all widgets, for use by lookup_widget().
	*/
	GLADE_HOOKUP_OBJECT_NO_REF (dialog, dialog, "dialog");
	GLADE_HOOKUP_OBJECT_NO_REF (dialog, dialog_vbox1, "dialog_vbox1");
	GLADE_HOOKUP_OBJECT (dialog, vbox1, "vbox1");
	GLADE_HOOKUP_OBJECT (dialog, label_text, "label_text");
	GLADE_HOOKUP_OBJECT_NO_REF (dialog, dialog_action_area1, "dialog_action_area1");
	GLADE_HOOKUP_OBJECT (dialog, ok_button, "ok_button");

	utils_set_default_icone_xcfa (dialog);
	gtk_widget_show (dialog);
}

void wininfo_create (gchar *title, ...)
{
	va_list    Arguments;
	gchar     *PtrArg = NULL;
	
	/* PRINT_FUNC_LF(); */

	wininfo.title = g_strdup (title);				/* Stokage du titre		*/
	wininfo.text  = g_string_new (NULL);				/* Creation du GString		*/
	
	g_string_sprintfa (wininfo.text, "\n<b>   %s</b>\n\n", title);	/* Titre -> en-tete en gras	*/
	
	va_start (Arguments, title);					/* Debut des arguments		*/
	while ( *(PtrArg = va_arg (Arguments, gchar *)) != '\0') {	/* TANSQUE message ALORS	*/
		g_string_sprintfa (wininfo.text, "%s", &PtrArg[0]);	/* 	message.stock		*/
	}								/* FIN_TANSQUE			*/
	va_end (Arguments);						/* Fin des arguments		*/
	
	wininfo_create_window ();					/* Creation fenetre		*/
	
	/*
	g_print ("%s\n",  wininfo.title);
	g_print ("%s", wininfo.text->str);
	*/
	
	g_free (wininfo.title);						/* Suppression des informations	*/
	wininfo.title = NULL;						/* de la structure		*/
	g_string_free (wininfo.text, TRUE);
	wininfo.text = NULL;
}












