#include "XCText.h"
#include "XCPoint.h"

#include <stdio.h>
#include <prototypes.h>

#undef QUERY_CODE
#define QUERY_CODE XCOBJ_QUERY_CODE

BEGIN_XC_IMPL(XCText)

STDMETHODIMP XCText_get_position(IXCText *This, IXCPoint **pt)
{
	HRESULT hres;
	long handle;
	XCPoint *point;

	if ((hres = IXCText_get_object_handle(This, &handle)) != S_OK)
		return hres;
	point = (XCPoint*)make_XCPoint();
	IXCText_QueryInterface(This, &IID_IXCObject, &point->object);
	point->pt = &TOLABEL(&handle)->position;

	IXCPoint_QueryInterface(&point->iface, &IID_IXCPoint, (void**)pt);
	
	return S_OK;
}

static wchar_t *halign_values[] = { L"left", L"center", L"", L"right" };
static wchar_t *valign_values[] = { L"bottom", L"middle", L"", L"top" };

STDMETHODIMP XCText_get_halign(IXCText *This, BSTR *pVal)
{
	long handle;
	HRESULT hres;

	if (*pVal != NULL) {
		SysFreeString(*pVal);
		*pVal = NULL;
	}
	if ((hres = IXCText_get_object_handle(This, &handle)) != S_OK)
		return hres;
	*pVal = SysAllocString(halign_values[(TOLABEL(&handle)->justify & RLJUSTFIELD)]);

	return S_OK;
}

STDMETHODIMP XCText_put_halign(IXCText *This, BSTR newVal)
{
	long handle, idx;
	HRESULT hres;

	if ((hres = IXCText_get_object_handle(This, &handle)) != S_OK)
		return hres;
	if ((idx = get_wide_string_index(newVal, halign_values, 4)) < 0)
		return ECODE(XC_E_JUSTIFY);
	TOLABEL(&handle)->justify &= ~RLJUSTFIELD;
	TOLABEL(&handle)->justify |= idx;
	IXCText_update(This, 1);

	return S_OK;
}

STDMETHODIMP XCText_get_valign(IXCText *This, BSTR *pVal)
{
	long handle;
	HRESULT hres;

	if (*pVal != NULL) {
		SysFreeString(*pVal);
		*pVal = NULL;
	}
	if ((hres = IXCText_get_object_handle(This, &handle)) != S_OK)
		return hres;
	*pVal = SysAllocString(valign_values[(TOLABEL(&handle)->justify & TBJUSTFIELD) >> 2]);

	return S_OK;
}

STDMETHODIMP XCText_put_valign(IXCText *This, BSTR newVal)
{
	long handle, idx;
	HRESULT hres;

	if ((hres = IXCText_get_object_handle(This, &handle)) != S_OK)
		return hres;
	if ((idx = get_wide_string_index(newVal, valign_values, 4)) < 0)
		return ECODE(XC_E_JUSTIFY);
	TOLABEL(&handle)->justify &= ~TBJUSTFIELD;
	TOLABEL(&handle)->justify |= (idx<<2);
	IXCText_update(This, 1);

	return S_OK;
}

PROPERTY_IMPL(XCText, rotation, rotation, short, TOLABEL)
PROPERTY_IMPL(XCText, scale, scale, float, TOLABEL)

STDMETHODIMP XCText_get_text(IXCText *This, BSTR *pVal)
{
	long handle;
	HRESULT hres;
	char *cstr;

	if (*pVal != NULL) {
		SysFreeString(*pVal);
		*pVal = NULL;
	}
	if ((hres = IXCText_get_object_handle(This, &handle)) != S_OK)
		return hres;
	cstr = string_from_parts(TOLABEL(&handle)->string);
	*pVal = convert_to_bstr(cstr);
	free(cstr);

	return S_OK;
}

STDMETHODIMP XCText_put_text(IXCText *This, BSTR newVal)
{
	long handle;
	HRESULT hres;
	stringpart **spart;

	if ((hres = IXCText_get_object_handle(This, &handle)) != S_OK)
		return hres;
	spart = &TOLABEL(&handle)->string;
	if ((*spart)->type == FONT_NAME)
		spart = &((*spart)->nextpart);
	freelabel(*spart);
	*spart = (stringpart*)malloc(sizeof(stringpart));
	(*spart)->type = TEXT_STRING;
	(*spart)->nextpart = NULL;
	(*spart)->data.string = convert_from_bstr(newVal);
	IXCText_update(This, 1);

	return S_OK;
}

XCOBJ_VTBL_BEGIN(XCText)
	XCText_get_position,
	XCText_get_halign,
	XCText_put_halign,
	XCText_get_valign,
	XCText_put_valign,
	XCText_get_rotation,
	XCText_put_rotation,
	XCText_get_scale,
	XCText_put_scale,
	XCText_get_text,
	XCText_put_text,
XCOBJ_VTBL_END()

END_XC_IMPL(XCText)
