#!/bin/bash

TEXTDOMAIN=`basename $0`
#if [ -d "./locale" ]; then
#  TEXTDOMAINDIR="./locale"
#fi

. /etc/cxacru

echo $">>> Inits Conexant AccessRunner <<<"
echo

FLOAD_NAME=cxload
MODULE_NAME=cxacru
MODULE_NAMEDBG=cxacrudbg

# Load usb host controller if is not loaded
KERNEL_VERSION=`uname -r | cut -d'.' -f1-2`
if [ "$KERNEL_VERSION" = "2.4" ]; then
  usbcon=`lsmod | cut -d ' ' -f1 | grep -E "^uhci|usb-uhci|usb-ohci|ehci-hcd$"`
  if [ "$usbcon" = "" ]; then
    echo $">>> Loading USB controller..."
    modprobe uhci > /dev/null || modprobe usb-ohci > /dev/null || modprobe ehci-hcd > /dev/null 
    sleep 5s
    echo
  fi
else
  usbcon=`lsmod | cut -d ' ' -f1 | grep -E "^uhci_hcd|ohci_hcd|ehci_hcd$"`
  if [ "$usbcon" = "" ]; then
    echo $">>> Loading USB controller..."
    modprobe uhci-hcd
    modprobe ohci-hcd
    modprobe ehci-hcd
    sleep 5s
    echo
  fi
fi

# Mount USB file systems if is not mounted
mt_old=`mount -t usbdevfs`
mt_new=`mount -t usbfs`
if [ "$mt_old" = "" ] && [ "$mt_new" = "" ]; then
  echo $">>> Mounting USB file system..."
  mount -t usbfs usbfs /proc/bus/usb || mount -t usbdevfs none /proc/bus/usb || exit 1
  echo
fi

# Remove module if it is loaded, we only have 1 interface, this is need to load firmware
driver=`lsmod | cut -d' ' -f1 | grep -E "^$MODULE_NAME|$MODULE_NAMEDBG$"`
if [ "$driver" != "" ]; then
  echo $">>> Removing cxacru driver..."
  rmmod $driver || exit 1
  echo
  sleep 1s
fi

# Load firmware
echo $">>> Loading firmware..."
if [ "$OPEN_MODE" = "" ]; then
  $FLOAD_NAME || exit 1
else
  $FLOAD_NAME $OPEN_MODE || exit 1
fi

. /tmp/cxacru.params

# Wait processor (?)
#sleep 5s
#echo

# Load Conexant module
echo $">>> Loading driver..."

if [ "$KERNEL_VERSION" != "2.4" ]; then
  crc32=`lsmod | cut -d ' ' -f1 | grep -E "^crc32$"`
  if [ "$crc32" = "" ]; then
    modprobe crc32
  fi
fi

case "$DRIVER_MODE" in
  1)
     # normal mode:
     echo $"Launching driver in normal mode...";
     MODULE_RUN=$MODULE_NAME
     SPEED_OPTION=0
     ;;

  2)
     # debug mode:
     echo $"Launching driver in debug mode...";
     MODULE_RUN=$MODULE_NAMEDBG
     SPEED_OPTION=0
     ;;
  3)
     # normal + max speed mode:
     echo $"Launching driver in normal + max speed mode...";
     MODULE_RUN=$MODULE_NAME
     SPEED_OPTION=1
     ;;

  4)
     # debug + max speed mode:
     echo $"Launching driver in debug + max speed mode...";
     MODULE_RUN=$MODULE_NAMEDBG
     SPEED_OPTION=1
     ;;
esac
modprobe $MODULE_RUN speed=$SPEED_OPTION open=$PARAM_0a || exit 1
sleep 3s 

echo
echo $0 $"successful"

