#!/bin/bash

TEXTDOMAIN=`basename $0`
#if [ -d "./locale" ]; then
#  TEXTDOMAINDIR="./locale"
#fi

. /etc/cxacru

if [ "$PROTOCOL_MODE" = "" ]; then
  echo $"Error: PROTOCOL_MODE not defined" 1>&2
  exit 1
else
  if [ "$PROTOCOL_MODE" -eq 1 ]; then
    echo $"Stopping RFC1483/2684 routed..." 
    cxnetdown.sh || exit 1 
  else
    if [ "$PROTOCOL_MODE" -eq 2 ]; then
      echo $"Stopping PPP over ATM..."
      cxnet2down.sh || exit 1 
    else
      if [ "$PROTOCOL_MODE" -eq 3 ]; then
        echo $"Stopping RFC1483/2684 bridged..."
        cxnet3down.sh || exit 1 
      else
        if [ "$PROTOCOL_MODE" -eq 4 ]; then
          echo $"Stopping PPP over Ethernet..."
          cxnet4down.sh || exit 1 
        else
          echo $"Error: unknow protocol mode" 1>&2
          exit 1
        fi
      fi
    fi
  fi
fi

cxunload.sh || exit 1

if [ "$1" = "service" ]; then
  rm -f /var/lock/subsys/cxacru
fi

