#ifndef STRING_UTILS_H_
#define STRING_UTILS_H_

#include "xdvi-config.h"
#include "kpathsea/c-vararg.h"

extern Boolean str_is_prefix(const char *, const char *, Boolean case_sensitive);
extern Boolean str_is_suffix(const char *, const char *, Boolean case_sensitive);
extern Boolean is_spaces_only(const char *);

extern char *my_stristr(const char *haystack, const char *needle);

typedef enum { USE_DVI_PATH, USE_CWD_PATH } expandPathTypeT;

/* remove `file:[//localhost/]' prefix from filename, and append `.dvi'
   extension if no extension is present */
extern char *filename_append_dvi(const char *fname);
/* prepend a path of type `type' (either CVW, or directory of dvi file)
   to `fname' */
extern char *expand_filename(const char *fname, expandPathTypeT type);

/* do both of the above */
extern char *expand_filename_append_dvi(const char *fname, expandPathTypeT type, Boolean must_exist);

/* normalize `../' `./' `//' from path */
extern char *canonicalize_path(const char *path);

extern char *format_arg(const char *fmt, const char *arg, int *match);
extern char *escape_format_arg(const char *arg);
extern char *unquote_arg(const char *fmt, const char *arg, int *match, int *len);
extern char *get_dir_component(const char *path);
extern char **get_separated_list(const char *source, const char *sep, Boolean do_unquote);
extern const char *find_format_str(const char *input, const char *fmt);
extern Boolean src_compare(const char *src, int src_len, const char *target, const char *path, size_t path_len);
extern char *shell_escape_string(const char *str);
extern void replace_extension(const char *fname, const char *extension, char *buf, size_t name_len);
extern int length_of_int(int n);

extern char *get_string_va(const char *fmt, ...);
extern char *get_string_argp(const char *fmt, va_list argp);
extern double my_atof(const char *str);
#endif /* STRING_UTILS_H_ */
