/*
 * RT2X00 Compatability fixes for specific kernels.
 */
#ifndef RT2X00_COMPAT_H
#define RT2X00_COMPAT_H

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/version.h>

#if LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 13)
#error Please refer to README file for minimal requirements.
#endif /* LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 13) */

#if LINUX_VERSION_CODE == KERNEL_VERSION(2, 6, 13)
typedef unsigned __nocast gfp_t;

static inline void *kzalloc(size_t size, gfp_t flags)
{
	void *ret = kmalloc(size, flags);
	if (ret)
		memset(ret, 0, size);
	return ret;
}

static inline int is_broadcast_ether_addr(const u8 *addr)
{
	return (addr[0] & addr[1] & addr[2] & addr[3] & addr[4] & addr[5]) == 0xff;
}

#include <linux/input.h>

/*
 * Both input.h as dscape stack provide BIT macro.
 */
#ifdef BIT
#undef BIT
#endif /* BIT */

static inline struct input_dev *input_allocate_device(void)
{
	struct input_dev *dev;

	dev = kzalloc(sizeof(struct input_dev), GFP_KERNEL);
	if (dev) {
		INIT_LIST_HEAD(&dev->h_list);
		INIT_LIST_HEAD(&dev->node);
	}

	return dev;
}

static inline void input_free_device(struct input_dev *dev)
{
	kfree(dev);
}

#define input_register_device(__input_dev) \
	({ \
		input_register_device(__input_dev); \
		0; \
	})

#endif /* LINUX_VERSION_CODE == KERNEL_VERSION(2, 6, 13) */

/*
 * Backward compatibility define for delayed firmware loading.
 */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 14)
#define _request_firmware_nowait(__module, __uevent, __name,	\
	__device, __rt2x00, __handler)					\
		request_firmware_nowait((__module), (__uevent),		\
		(__name), (__device), (__rt2x00), (__handler))
#else /* LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 14) */
#define _request_firmware_nowait(__module, __uevent, __name,	\
	__device, __rt2x00, __handler)					\
		request_firmware_nowait((__module),			\
		(__name), (__device), (__rt2x00), (__handler))
#endif /* LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 14) */

#endif /* RT2X00_COMPAT_H */
