Summary: A graphical Xen management tool
Name: xenman
Version: 0.6
License: GPL
Group: Applications/System
Packager: Haphazard <haphazard1@users.sourceforge.net>
URL: http://xenman.sourceforge.net/
BuildArchitectures: noarch
Source: http://prdownloads.sourceforge.net/%{name}/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-buildroot
%if "%{_vendor}" == "suse"
Release: 1.suse
Requires: python >= 2.4, xen >= 3.0.2, python-gtk, vte, python-curses
Requires: install-initrd
Requires: python-paramiko >= 1.6.1
%define distext suse
%else
Release: 1.fedora
Requires: python >= 2.4, xen >= 3.0.2, pygtk2, vte
Requires: python-paramiko >= 1.6.1
%define distext fedora
%endif

%description
XenMan is an intuitive, graphical management tool aimed at operational 
lifecycle management for the Xen virtualization platform. XenMan is built 
on the firm design philosophy that ease-of-use and sophistication can, 
and should, co-exist in a single management tool. So, XenMan should 
hopefully prove valuable to both seasoned Xen Administrators as well as 
those just seeking an introduction to Xen Virtualization.

%prep
%setup -q

%install
[ %{buildroot} != / ] && %{__rm} -rf %{buildroot}

%{__mkdir_p} %{buildroot}%{_datadir}/%{name}/pixmaps
%{__mkdir_p} %{buildroot}%{_datadir}/%{name}/doc
%{__mkdir_p} %{buildroot}%{_datadir}/%{name}/patches
%{__mkdir_p} %{buildroot}%{_datadir}/%{name}/src
%{__mkdir_p} %{buildroot}%{_localstatedir}/cache/%{name}
%{__mkdir_p} %{buildroot}%{_localstatedir}/cache/%{name}/image_store
%{__mkdir_p} %{buildroot}%{_bindir}

%{__install} -Dp -m0644 distros/%{distext}/%{name}.conf %{buildroot}%{_sysconfdir}/%{name}.conf
%{__install} -Dp -m0644 src/* %{buildroot}%{_datadir}/%{name}/src
%{__install} -Dp -m0644 %{name}.glade %{buildroot}%{_datadir}/%{name}/%{name}.glade
%{__install} -Dp -m0644 pixmaps/* %{buildroot}%{_datadir}/%{name}/pixmaps
%{__install} -Dp -m0644 doc/* %{buildroot}%{_datadir}/%{name}/doc
%{__install} -Dp -m0644 patches/* %{buildroot}%{_datadir}/%{name}/patches
find image_store | %{__cpio} -pdm %{buildroot}%{_localstatedir}/cache/%{name}


%{__chmod} 0755 %{buildroot}%{_datadir}/%{name}/src/%{name}.py
%{__chmod} 0544 %{buildroot}%{_datadir}/%{name}/patches/patch_paramiko
imagelist="Windows_CD_Install Fedora_Core_Install Linux_CD_Install"
for image in $imagelist
do
%{__chmod} 0744 %{buildroot}%{_localstatedir}/cache/%{name}/image_store/$image/provision.sh
done 


%{__ln_s} ../share/%{name}/src/%{name}.py %{buildroot}%{_bindir}/%{name}

%if "%{_vendor}" == "suse"
%{__install} -p -m0755 distros/%{_vendor}/configure_defaults-suse.sh %{buildroot}%{_datadir}/%{name}/
%endif


%clean
[ %{buildroot} != / ] && %{__rm} -rf %{buildroot}

%if "%{_vendor}" == "suse"
%post
if [ "$1" = 1 ]; then
  %{_datadir}/%{name}/configure_defaults-suse.sh > /dev/null
fi

%preun
if [ "$1" = 0 ]; then
  %{__rm} -rf %{_localstatedir}/cache/%{name}/*
fi
%endif

%files
%defattr(-,root,root,-)
%doc doc/* 
%config %{_sysconfdir}/%{name}.conf
%{_bindir}/%{name}
%{_datadir}/%{name}
%{_localstatedir}/cache/%{name}/image_store
%dir %{_localstatedir}/cache/%{name}

%changelog
* Mon Dec 28 2006 Haphazard <haphazard1@users.sourceforge.net> 0.6-1
- new version

* Thu Sep 28 2006 Haphazard <haphazard1@users.sourceforge.net> 0.5-1
- new version

* Thu Aug 24 2006 Jd <jd_jedi@users.sourceforge.net> 0.4.2.2
- hotfix for start up problem.

* Sun Aug 13 2006 Haphazard <haphazard1@users.sourceforge.net> 0.4.2-1
- extended SUSE dependency list.

* Tue Jul 25 2006 Yves Perrenoud <yves@xpand.org> 0.4.1-2
- added some SUSE specific elements to ultimately support the post-install
  creating of an install initial ramdisk
- now marks the config file as one

* Mon Jul 24 2006 Yves Perrenoud <yves@xpand.org> 0.4.1-1
- new version
- added Suse support

* Wed Jul 19 2006 Yves Perrenoud <yves@xpand.org> 0.4-1
- new version
- added the change log to the doc files

* Thu Jun 8 2006 Yves Perrenoud <yves@xpand.org> 0.3-1
- Initial build.
