#!/usr/bin/env python
#
#   XenMan   -  Copyright (c) 2007 Jd & Hap Hazard
#   ======
#
# XenMan is a Xen management tool with a GTK based graphical interface
# that allows for performing the standard set of domain operations
# (start, stop, pause, kill, shutdown, reboot, snapshot, etc...). It
# also attempts to simplify certain aspects such as the creation of
# domains, as well as making the consoles available directly within the
# tool's user interface.
#
#
# This software is subject to the GNU Lesser General Public License (LGPL)
# and for details, please consult it at:
#
#    http://www.fsf.org/licensing/licenses/lgpl.txt
#
# author : Jd <jd_jedi@users.sourceforge.net>
#

from  httplib import HTTPConnection, HTTP
from  xmlrpclib import Transport

from SimpleXMLRPCServer import SimpleXMLRPCServer, SimpleXMLRPCRequestHandler
import xmlrpclib, socket, os, stat
import SocketServer


import xen.xend.XendClient
from xen.xend.XendLogging import log

from xen.util.xmlrpclib2 import ServerProxy 
from getpass import getuser

from phelper import PHelper
import xml.parsers.expat   
# A new ServerProxy that also supports ssh tunneling using paramiko. 
# The ssh_tunnel URL comes in the
# form:
#
# ssh_tunnel://user@host:port/RPC2
#
# It assumes that the RPC handler is /RPC2.  
# This is implemented in a fashion similar to other transports in xmlrpclib2.
# Note : This one does not require corresponding server side implementation
#        as it uses the ssh tunneling mechanism. It would be nice though to
#        have another paramiko based server implemeted and shipped by Xen
#        to which we can directly connect.

class VMOperationException:
   def __init__(self, message, errno = None):
      self.message = message
      self.errno = errno

   def __repr__(self):
      if self.errno != None:
         return "[Error %s]: %s" % (str(self.errno), self.message)
      else:
         return self.message
      
   




DEFAULT_LOCAL_PORT_START = 2000
DEFAULT_LOCAL_PORT_END   = 2000

class SSHTunnelConnection(HTTPConnection):
   def set_ssh_transport(self, ssh_transport):
      self.ssh_transport = ssh_transport

   def set_local_port(self, localport):
      self.localport = localport

   def connect(self):
      # We already have a transport to the remote machine.
      # lets create a tunnel on the remote node to forward traffic from
      # localhost, localport  ==> localhost, xen port
      # (NOTE : localhost is interpreted on the remote node.)
      self.sock =  PHelper.open_channel(self.ssh_transport, "direct-tcpip",
                                        ("localhost",self.port),
                                        ("localhost",self.localport))

class SSHTunnel(HTTP):
   
    _connection_class = SSHTunnelConnection
    
    def __init__(self, ssh_transport, host='', port=None, strict=None,
                 localport=DEFAULT_LOCAL_PORT_START):
       self.localport = localport
       self.ssh_transport = ssh_transport
       HTTP.__init__(self, host, port, strict)

    # take this oppertunity to associate transport with the connection.
    def _setup(self, conn):
        HTTP._setup(self, conn)
        conn.set_ssh_transport(self.ssh_transport)
        conn.set_local_port(self.localport)
    


class SSHTunnelTransport(Transport):

    # static variable. TODO : Need to be protected by mutex
    current_local_port = DEFAULT_LOCAL_PORT_START
      
    def __init__(self,hostname,port,user=None, password=None,
                 ssh_transport=None):
       """ constructor, takes in host and port to which the tunnel
           is to be opened. Assumes ssh on 22 for now.
           An already authenticated paramiko transport can be passed.
           It is assumed that the transport is to the same host as specified
           by hostname.
       """
       self.hostname = hostname
       self.ssh_port = 22
       self.username = user
       self.port = port
       self.transport_created=False
       if ssh_transport == None:
          self.transport = PHelper.init_ssh_transport(self.hostname,
                                                      username=self.username,
                                                      password = password)
          self.transport_created=True
       else:
          self.transport = ssh_transport

          
    def request(self, host, handler, request_body, verbose=0):
        self.__handler = handler
        return Transport.request(self, host, '/RPC2', request_body, verbose)

    def make_connection(self, host):
       """ return the connection paramiko connection object """
       SSHTunnelTransport.current_local_port += 1
       if SSHTunnelTransport.current_local_port >= DEFAULT_LOCAL_PORT_END:
          SSHTunnelTransport.current_local_port = DEFAULT_LOCAL_PORT_START
          
       return SSHTunnel(self.transport,host,
                        localport=SSHTunnelTransport.current_local_port)


    def cleanup(self):
       """ clean up transport if we created it."""
       if self.transport != None and self.transport_created:
          self.transport.close()
            


## copied _Method from xmlrpc and 
class _Dispatcher:
  # some magic to bind an XML-RPC method to an RPC server.
  # supports "nested" methods (e.g. examples.getStateName)
  def __init__(self, orig_object, send, name):
     self.__send = send
     self.__name = name
     self.__orig_object = orig_object
  def __getattr__(self, name):
     return _Dispatcher(self.__orig_object,
                        self.__send, "%s.%s" % (self.__name, name))
  def __call__(self, *args):
     try:
        ret = self.__send(self.__name, args)
     except xmlrpclib.Fault, ex:
        raise VMOperationException(str(ex))
     except xml.parsers.expat.ExpatError, expat:
        print "got expat error ", expat
        raise
     except Exception, ex1:
        print "setting last_error", ex1
        self.__orig_object._last_error = ex1
        raise
     else:
        if self.__orig_object._last_error is not None:
           print "resetting last_error"
           self.__orig_object._last_error = None

     return ret
  
## class _Dispatcher(xmlrpclib._Method):
##   def __init__(self, send, name):
##      xmlrpclib._Method.__init__(self, send, name)


##   def __getattr__(self, name):
##      return _Dispatcher(self.__send, "%s.%s" % (self.__name, name))
     
##   def __call__(self, *args):
##      print "intercepting actual call"
##      return xmlrpclib._Method.__call(self, *args)

      



# TODO : Improve parsing.. may be just used http url parsing code from
#        say httplib

class ServerProxy(xen.util.xmlrpclib2.ServerProxy):
   """ Class derives from  xen.util.xmlrpclib2 and adds paramiko ssh_tunnel
       access to a remote Xen managed node
   """
   def __init__(self, uri, transport=None, encoding=None, verbose=0,
                 allow_none=1, user=None, password=None):

      self._last_error = None

      (protocol, rest) = uri.split(':', 1)
      #print protocol, rest
      if protocol == 'ssh_tunnel':
         uri = 'http:' + rest
         if not rest.startswith('//'):
             raise ValueError("Invalid SSHTunnel URL '%s'" % uri)
         rest = rest[2:]
         if user == None:
            user = getuser()
         port = "8005"
         path = 'RPC2'
         if rest.find('@') != -1:
             (user, rest) = rest.split('@', 1)
             #print "rest after user ", rest
         if rest.find(':') != -1:
             (host, rest) = rest.split(':',1)
             if rest.find('/') != -1:
                (port, rest) = rest.split('/', 1)
                if len(rest) > 0:
                   path = rest
         else:
            if rest.find('/') != -1:
               (host, rest) = rest.split('/', 1)
               if len(rest) > 0:
                  path = rest
            else:      
               host = rest

         # adjust uri for base class
         uri = 'http://%s:%s/%s' % (host, port,path)

      # now call the base class with transport
      xen.util.xmlrpclib2.ServerProxy.__init__(self, uri,
                                              transport, encoding,
                                              verbose, allow_none)


   def get_last_error(self):
      return self._last_error
   
   def __getattr__(self, name):
      # magic method dispatcher
      return _Dispatcher(self, self.__request, name)


