/*
 *	xeno_theme.h
 */

#ifndef XENO_THEME_H
#define XENO_THEME_H


/*
 *	Options that may affect stability. Not all combinations may work.
 */

#define XENO_CONFIG_DIRTY_GRADIENTS			1
#define XENO_CONFIG_COUNT_GRADIENT_STYLE	1

#define XENO_CONFIG_TRIANGULAR_TABS 		1
#define	XENO_CONFIG_TRIANGULAR_TABS_OVERLAP	0



/*
 *	Glib and GTK stuff
 */
#include <math.h>
#include <gtk/gtk.h>

#ifdef G_LOG_DOMAIN
#undef G_LOG_DOMAIN
#endif

#define	G_LOG_DOMAIN	"Xenophilia-Theme"


#if GTK_CHECK_VERSION(1, 3, 2)
#define XENO_GTK2		1
#else
#define XENO_GTK2		0
#endif

#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define XENO_GNUC		1
#else
#define	XENO_GNUC		0
#endif

#if XENO_GNUC || defined(__cplusplus)
#define	XENO_INLINE		inline
#else
#define	XENO_INLINE		/* empty */
#endif

/*
 *	Useful macros
 */
#ifndef M_PI
#define M_PI    3.1415926535897932384626433
#endif
#ifndef M_PI_4
#define M_PI_4  0.78539816339744830962
#endif
#define XENO_EPSILON 1.0e-5

#ifdef LERP
#undef LERP
#endif
#define LERP(a, b, f)		((a) + (f) * ((b) - (a)))


/*
 *	Exported from xeno_theme_main.c
 */
extern		gboolean		xeno_theme_pseudocolor;
extern		GdkVisual		*xeno_theme_visual;
extern		GdkColormap		*xeno_theme_colormap;
extern		GtkThemeEngine	*xeno_theme_engine;

/* this value is guaranteed to not point to a theme engine ;-) */
#define XENO_THEME_ENGINE_NONE	((GtkThemeEngine *)&xeno_theme_engine)

#endif /* XENO_THEME_H */

