#ifndef DOMChildNode_HEADER_GUARD_
#define DOMChildNode_HEADER_GUARD_

/*
 * Copyright 2001-2002,2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * $Id: DOMChildNode.hpp 176026 2004-09-08 13:57:07Z peiyongz $
 */

//
//  This file is part of the internal implementation of the C++ XML DOM.
//  It should NOT be included or used directly by application programs.
//
//  Applications should include the file <xercesc/dom/DOM.hpp> for the entire
//  DOM API, or xercesc/dom/DOM*.hpp for individual DOM classes, where the class
//  name is substituded for the *.
//

/**
 * ChildNode adds to NodeImpl the capability of being a child, this is having
 * siblings.
 **/

#include <xercesc/util/XercesDefs.hpp>

XERCES_CPP_NAMESPACE_BEGIN


class DOMDocument;
class DOMNode;


class CDOM_EXPORT DOMChildNode {

public:
    DOMNode                *previousSibling;
    DOMNode                *nextSibling;

    DOMChildNode();
    DOMChildNode(const DOMChildNode &other);
    ~DOMChildNode();

    DOMNode * getNextSibling() const;
    DOMNode * getParentNode(const DOMNode *thisNode) const;
    DOMNode * getPreviousSibling(const DOMNode *thisNode) const;

private:
    // -----------------------------------------------------------------------
    // Unimplemented constructors and operators
    // -----------------------------------------------------------------------
    DOMChildNode & operator = (const DOMChildNode &);   
};


XERCES_CPP_NAMESPACE_END

#endif
