/* application.c generated by valac 0.56.14, the Vala compiler
 * generated from application.vala, do not modify */

/*
 *  Notes - panel plugin for Xfce Desktop Environment
 *  Copyright (c) 2009-2010  Mike Massonnet <mmassonnet@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include "libnotes.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <xfconf/xfconf.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <config.h>
#include <libxfce4util/libxfce4util.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <errno.h>
#include <float.h>
#include <math.h>
#include <signal.h>

enum  {
	XNP_APPLICATION_0_PROPERTY,
	XNP_APPLICATION_NOTES_PATH_PROPERTY,
	XNP_APPLICATION_CONFIG_FILE_PROPERTY,
	XNP_APPLICATION_SKIP_TASKBAR_HINT_PROPERTY,
	XNP_APPLICATION_NEXT_FOCUS_PROPERTY,
	XNP_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* xnp_application_properties[XNP_APPLICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;

struct _XnpApplicationPrivate {
	gchar* _notes_path;
	gchar* _config_file;
	GSList* window_monitor_list;
	GSList* window_list;
	GSList* focus_order;
	XfconfChannel* xfconf_channel;
	gboolean lock_focus_order;
	guint save_config_timeout;
	gchar* default_notes_path;
	XnpTheme* theme;
	gboolean _skip_taskbar_hint;
};

struct _Block1Data {
	int _ref_count_;
	XnpApplication* self;
	XnpWindow* window;
};

struct _Block2Data {
	int _ref_count_;
	XnpApplication* self;
	GtkMenu* menu;
};

static gint XnpApplication_private_offset;
static gpointer xnp_application_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
static void xnp_application_update_version (XnpApplication* self);
static void xnp_application_update_notes_path (XnpApplication* self);
static gboolean xnp_application_get_main_instance (XnpApplication* self);
static void xnp_application_notes_path_error (XnpApplication* self,
                                       const gchar* message);
static void xnp_application_update_color (XnpApplication* self);
static void xnp_application_sort_groups_by_focus_order (XnpApplication* self,
                                                 GSList** groups);
static void _g_free0_ (gpointer var);
static inline void _g_slist_free__g_free0_ (GSList* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean xnp_application_window_name_exists (XnpApplication* self,
                                             const gchar* name);
static void xnp_application_load_window_data (XnpApplication* self,
                                       XnpWindow* window);
static void xnp_application_destroy_window (XnpApplication* self,
                                     XnpWindow* window);
static void xnp_application_window_monitor_list_add (XnpApplication* self,
                                              XnpWindow* window);
static void __lambda9_ (Block1Data* _data1_,
                 XnpWindow* win,
                 const gchar* action);
static void xnp_application_rename_window (XnpApplication* self,
                                    XnpWindow* window);
static void xnp_application_set_data_value (XnpApplication* self,
                                     GObject* object,
                                     const gchar* data,
                                     gboolean val);
static void xnp_application_delete_window (XnpApplication* self,
                                    XnpWindow* window);
static void xnp_application_refresh_notes (XnpApplication* self,
                                    XnpWindow* window);
static void ___lambda9__xnp_window_action (XnpWindow* _sender,
                                    const gchar* action,
                                    gpointer self);
static void __lambda10_ (XnpApplication* self,
                  XnpWindow* win,
                  XnpNote* note);
static gboolean xnp_application_get_data_value (XnpApplication* self,
                                         GObject* object,
                                         const gchar* data);
static void xnp_application_save_note (XnpApplication* self,
                                XnpWindow* window,
                                XnpNote* note);
static void ___lambda10__xnp_window_save_data (XnpWindow* _sender,
                                        XnpNote* note,
                                        gpointer self);
static void __lambda11_ (XnpApplication* self,
                  XnpWindow* win,
                  XnpNote* note);
static void ___lambda11__xnp_window_note_inserted (XnpWindow* _sender,
                                            XnpNote* note,
                                            gpointer self);
static void __lambda12_ (XnpApplication* self,
                  XnpWindow* win,
                  XnpNote* note);
static void ___lambda12__xnp_window_note_deleted (XnpWindow* _sender,
                                           XnpNote* note,
                                           gpointer self);
static void __lambda13_ (XnpApplication* self,
                  XnpWindow* win,
                  XnpNote* note,
                  const gchar* name);
static gboolean xnp_application_name_is_valid (XnpApplication* self,
                                        const gchar* name);
static void ___lambda13__xnp_window_note_renamed (XnpWindow* _sender,
                                           XnpNote* note,
                                           const gchar* name,
                                           gpointer self);
static void __lambda14_ (Block1Data* _data1_);
static gboolean _xnp_application_save_windows_configuration_gsource_func (gpointer self);
static void ___lambda14__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static gboolean __lambda15_ (XnpApplication* self,
                      XnpWindow* to_win,
                      XnpWindow* from_win,
                      XnpNote* note);
static gboolean ___lambda15__xnp_window_note_moved (XnpWindow* _sender,
                                             XnpWindow* src_win,
                                             XnpNote* note,
                                             gpointer self);
static void xnp_application_window_monitor_list_remove (XnpApplication* self,
                                                 XnpWindow* window);
static void __lambda8_ (XnpApplication* self,
                 XnpWindow* window);
static void ___lambda8__xnp_window_monitor_window_updated (XnpWindowMonitor* _sender,
                                                    XnpWindow* window,
                                                    gpointer self);
static XnpWindowMonitor* xnp_application_window_monitor_list_lookup (XnpApplication* self,
                                                              XnpWindow* window);
static void xnp_application_present_windows (XnpApplication* self);
static void xnp_application_show_windows (XnpApplication* self);
static void xnp_application_hide_windows (XnpApplication* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda16_ (Block2Data* _data2_);
static void __lambda17_ (XnpApplication* self,
                  GtkWidget* w);
static void ___lambda17__gtk_callback (GtkWidget* widget,
                                gpointer self);
static void ____lambda18_ (XnpApplication* self,
                    GtkMenuItem* i);
static void _____lambda18__gtk_menu_item_activate (GtkMenuItem* _sender,
                                            gpointer self);
static void __lambda19_ (XnpApplication* self);
static void ___lambda19__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void ___lambda16__gtk_widget_show (GtkWidget* _sender,
                                   gpointer self);
static void _xnp_application_main_instance___lambda5_ (XnpApplication* self);
static void __xnp_application_main_instance___lambda5__g_application_activate (GApplication* _sender,
                                                                        gpointer self);
static GObject * xnp_application_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void _xnp_application_quit_xfce_posix_signal_handler (gint signal,
                                                      gpointer self);
static void _xnp_application___lambda20_ (XnpApplication* self);
static void __xnp_application___lambda20__xfconf_g__channel_property_changed (XfconfChannel* _sender,
                                                                       const gchar* property,
                                                                       GValue* value,
                                                                       gpointer self);
static void _xnp_application___lambda21_ (XnpApplication* self);
static void __xnp_application___lambda21__xfconf_g__channel_property_changed (XfconfChannel* _sender,
                                                                       const gchar* property,
                                                                       GValue* value,
                                                                       gpointer self);
static void xnp_application_finalize (GObject * obj);
static GType xnp_application_get_type_once (void);
static void _vala_xnp_application_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_xnp_application_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
xnp_application_get_instance_private (XnpApplication* self)
{
	return G_STRUCT_MEMBER_P (self, XnpApplication_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

XnpApplication*
xnp_application_construct (GType object_type,
                           const gchar* config_file)
{
	XnpApplication * self = NULL;
	g_return_val_if_fail (config_file != NULL, NULL);
	self = (XnpApplication*) g_object_new (object_type, "config-file", config_file, NULL);
	return self;
}

XnpApplication*
xnp_application_new (const gchar* config_file)
{
	return xnp_application_construct (XNP_TYPE_APPLICATION, config_file);
}

XnpApplication*
xnp_application_construct_with_notes_path (GType object_type,
                                           const gchar* config_file,
                                           const gchar* notes_path)
{
	XnpApplication * self = NULL;
	g_return_val_if_fail (config_file != NULL, NULL);
	g_return_val_if_fail (notes_path != NULL, NULL);
	self = (XnpApplication*) g_object_new (object_type, "config-file", config_file, "notes-path", notes_path, NULL);
	return self;
}

XnpApplication*
xnp_application_new_with_notes_path (const gchar* config_file,
                                     const gchar* notes_path)
{
	return xnp_application_construct_with_notes_path (XNP_TYPE_APPLICATION, config_file, notes_path);
}

static void
xnp_application_update_version (XnpApplication* self)
{
	gchar* version = NULL;
	XfconfChannel* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	XfconfChannel* _tmp17_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->xfconf_channel;
	_tmp1_ = xfconf_channel_get_string (_tmp0_, "/global/version", "0");
	version = _tmp1_;
	_tmp2_ = version;
	if (g_strcmp0 (_tmp2_, PACKAGE_VERSION) == 0) {
		_g_free0 (version);
		return;
	}
	_tmp3_ = version;
	if (g_strcmp0 (_tmp3_, "1.11") < 0) {
		{
			gchar* css = NULL;
			gchar* _tmp4_;
			GFile* css_file = NULL;
			const gchar* _tmp5_;
			GFile* _tmp6_;
			GFile* _tmp7_;
			gchar* old_save_location = NULL;
			gchar* _tmp8_;
			GFile* old_save_location_file = NULL;
			const gchar* _tmp9_;
			GFile* _tmp10_;
			GFile* _tmp11_;
			_tmp4_ = xfce_resource_save_location (XFCE_RESOURCE_CONFIG, "xfce4/xfce4-notes.css", FALSE);
			css = _tmp4_;
			_tmp5_ = css;
			_tmp6_ = g_file_new_for_path (_tmp5_);
			css_file = _tmp6_;
			_tmp7_ = css_file;
			g_file_delete (_tmp7_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (css_file);
				_g_free0 (css);
				goto __catch0_g_error;
			}
			_tmp8_ = xfce_resource_save_location (XFCE_RESOURCE_CONFIG, "xfce4/xfce4-notes.rc", FALSE);
			old_save_location = _tmp8_;
			_tmp9_ = old_save_location;
			_tmp10_ = g_file_new_for_path (_tmp9_);
			old_save_location_file = _tmp10_;
			_tmp11_ = old_save_location_file;
			if (g_file_query_exists (_tmp11_, NULL)) {
				gchar* save_location = NULL;
				gchar* _tmp12_;
				GFile* save_location_file = NULL;
				const gchar* _tmp13_;
				GFile* _tmp14_;
				GFile* _tmp15_;
				GFile* _tmp16_;
				_tmp12_ = xfce_resource_save_location (XFCE_RESOURCE_CONFIG, "xfce4/notes/xfce4-notes.rc", TRUE);
				save_location = _tmp12_;
				_tmp13_ = save_location;
				_tmp14_ = g_file_new_for_path (_tmp13_);
				save_location_file = _tmp14_;
				_tmp15_ = old_save_location_file;
				_tmp16_ = save_location_file;
				g_file_move (_tmp15_, _tmp16_, G_FILE_COPY_NONE, NULL, NULL, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (save_location_file);
					_g_free0 (save_location);
					_g_object_unref0 (old_save_location_file);
					_g_free0 (old_save_location);
					_g_object_unref0 (css_file);
					_g_free0 (css);
					goto __catch0_g_error;
				}
				_g_object_unref0 (save_location_file);
				_g_free0 (save_location);
			}
			_g_object_unref0 (old_save_location_file);
			_g_free0 (old_save_location);
			_g_object_unref0 (css_file);
			_g_free0 (css);
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (version);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp17_ = self->priv->xfconf_channel;
	xfconf_channel_set_string (_tmp17_, "/global/version", PACKAGE_VERSION);
	_g_free0 (version);
}

static void
xnp_application_update_notes_path (XnpApplication* self)
{
	gchar* new_notes_path = NULL;
	XfconfChannel* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gchar* dirname = NULL;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gboolean _tmp17_ = FALSE;
	const gchar* _tmp18_;
	const gchar* _tmp24_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->xfconf_channel;
	_tmp1_ = self->priv->default_notes_path;
	_tmp2_ = xfconf_channel_get_string (_tmp0_, "/global/notes-path", _tmp1_);
	new_notes_path = _tmp2_;
	_tmp3_ = self->priv->_notes_path;
	_tmp4_ = new_notes_path;
	if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
		_g_free0 (new_notes_path);
		return;
	}
	_tmp5_ = xnp_application_get_main_instance (self);
	_tmp6_ = _tmp5_;
	if (!_tmp6_) {
		const gchar* _tmp7_;
		_tmp7_ = new_notes_path;
		xnp_application_set_notes_path (self, _tmp7_);
		_g_free0 (new_notes_path);
		return;
	}
	{
		GDir* dir = NULL;
		const gchar* _tmp8_;
		GDir* _tmp9_;
		GDir* _tmp10_;
		const gchar* _tmp11_;
		_tmp8_ = new_notes_path;
		_tmp9_ = g_dir_open (_tmp8_, (guint) 0, &_inner_error0_);
		dir = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp10_ = dir;
		_tmp11_ = g_dir_read_name (_tmp10_);
		if (_tmp11_ != NULL) {
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp12_ = new_notes_path;
			_tmp13_ = g_strdup_printf (_ ("The selected directory (%s) for the new notes path already contains fi" \
"les. " "You must select or create an empty directory."), _tmp12_);
			_tmp14_ = _tmp13_;
			xnp_application_notes_path_error (self, _tmp14_);
			_g_free0 (_tmp14_);
			_g_dir_close0 (dir);
			_g_free0 (new_notes_path);
			return;
		}
		_g_dir_close0 (dir);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (new_notes_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp15_ = new_notes_path;
	_tmp16_ = g_path_get_dirname (_tmp15_);
	dirname = _tmp16_;
	_tmp18_ = dirname;
	if (g_mkdir_with_parents (_tmp18_, 0700) != 0) {
		_tmp17_ = TRUE;
	} else {
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		_tmp19_ = self->priv->_notes_path;
		_tmp20_ = new_notes_path;
		_tmp17_ = g_rename (_tmp19_, _tmp20_) != 0;
	}
	if (_tmp17_) {
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp21_ = g_strerror (errno);
		_tmp22_ = g_strdup_printf (_ ("Unable to select directory for new notes path: %s"), _tmp21_);
		_tmp23_ = _tmp22_;
		xnp_application_notes_path_error (self, _tmp23_);
		_g_free0 (_tmp23_);
		_g_free0 (dirname);
		_g_free0 (new_notes_path);
		return;
	}
	_tmp24_ = new_notes_path;
	xnp_application_set_notes_path (self, _tmp24_);
	_g_free0 (dirname);
	_g_free0 (new_notes_path);
}

static void
xnp_application_notes_path_error (XnpApplication* self,
                                  const gchar* message)
{
	GtkMessageDialog* error_dialog = NULL;
	GtkMessageDialog* _tmp0_;
	GtkMessageDialog* _tmp1_;
	GtkMessageDialog* _tmp2_;
	GtkMessageDialog* _tmp3_;
	GtkMessageDialog* _tmp4_;
	GtkMessageDialog* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, 0, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", _ ("Notes path is unacceptable"));
	g_object_ref_sink (_tmp0_);
	error_dialog = _tmp0_;
	_tmp1_ = error_dialog;
	gtk_message_dialog_format_secondary_text (_tmp1_, "%s", message);
	_tmp2_ = error_dialog;
	gtk_window_set_icon_name ((GtkWindow*) _tmp2_, "gtk-dialog-error");
	_tmp3_ = error_dialog;
	gtk_window_set_title ((GtkWindow*) _tmp3_, _ ("Error"));
	_tmp4_ = error_dialog;
	gtk_dialog_run ((GtkDialog*) _tmp4_);
	_tmp5_ = error_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->_notes_path;
	_tmp7_ = self->priv->default_notes_path;
	if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
		XfconfChannel* _tmp8_;
		_tmp8_ = self->priv->xfconf_channel;
		xfconf_channel_reset_property (_tmp8_, "/global/notes-path", FALSE);
	} else {
		XfconfChannel* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = self->priv->xfconf_channel;
		_tmp10_ = self->priv->_notes_path;
		xfconf_channel_set_string (_tmp9_, "/global/notes-path", _tmp10_);
	}
	_g_object_unref0 (error_dialog);
}

static void
xnp_application_update_color (XnpApplication* self)
{
	gchar* color = NULL;
	XfconfChannel* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->xfconf_channel;
	_tmp1_ = xfconf_channel_get_string (_tmp0_, "/global/background-color", "#F7EB96");
	color = _tmp1_;
	_tmp2_ = color;
	if (g_strcmp0 (_tmp2_, "GTK+") == 0) {
		XnpTheme* _tmp3_;
		_tmp3_ = self->priv->theme;
		xnp_theme_use_gtk_style (_tmp3_);
	} else {
		XnpTheme* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = self->priv->theme;
		_tmp5_ = color;
		xnp_theme_use_color (_tmp4_, _tmp5_);
	}
	_g_free0 (color);
}

/**
 * sort_groups_by_focus_order:
 *
 * Sort groups by last memorized windows focus order.
 */
static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_slist_free__g_free0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
xnp_application_sort_groups_by_focus_order (XnpApplication* self,
                                            GSList** groups)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GSList* last_focus_order = NULL;
		GKeyFile* keyfile = NULL;
		GKeyFile* _tmp0_;
		GSList* entry = NULL;
		const gchar* _tmp1_;
		gsize _tmp2_ = 0;
		gchar** _tmp3_;
		last_focus_order = NULL;
		_tmp0_ = g_key_file_new ();
		keyfile = _tmp0_;
		_tmp1_ = self->priv->_config_file;
		g_key_file_load_from_file (keyfile, _tmp1_, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (keyfile);
			(last_focus_order == NULL) ? NULL : (last_focus_order = (_g_slist_free__g_free0_ (last_focus_order), NULL));
			goto __catch0_g_error;
		}
		_tmp3_ = g_key_file_get_groups (keyfile, &_tmp2_);
		{
			gchar** name_collection = NULL;
			gint name_collection_length1 = 0;
			gint _name_collection_size_ = 0;
			gint name_it = 0;
			name_collection = _tmp3_;
			name_collection_length1 = _tmp2_;
			for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
				gchar* _tmp4_;
				gchar* name = NULL;
				_tmp4_ = g_strdup (name_collection[name_it]);
				name = _tmp4_;
				{
					const gchar* _tmp5_;
					gchar* _tmp6_;
					_tmp5_ = name;
					_tmp6_ = g_strdup (_tmp5_);
					last_focus_order = g_slist_prepend (last_focus_order, _tmp6_);
					_g_free0 (name);
				}
			}
			name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		{
			GSList* name_collection = NULL;
			GSList* name_it = NULL;
			name_collection = last_focus_order;
			for (name_it = name_collection; name_it != NULL; name_it = name_it->next) {
				gchar* _tmp7_;
				gchar* name = NULL;
				_tmp7_ = g_strdup ((const gchar*) name_it->data);
				name = _tmp7_;
				{
					const gchar* _tmp8_;
					GCompareFunc _tmp9_;
					GSList* _tmp10_;
					GSList* _tmp11_;
					_tmp8_ = name;
					_tmp9_ = ((GCompareFunc) g_strcmp0);
					_tmp10_ = g_slist_find_custom (*groups, _tmp8_, _tmp9_);
					entry = _tmp10_;
					_tmp11_ = entry;
					if (_tmp11_ != NULL) {
						GSList* _tmp12_;
						gconstpointer _tmp13_;
						gchar* _tmp14_;
						GSList* _tmp15_;
						_tmp12_ = entry;
						_tmp13_ = _tmp12_->data;
						_tmp14_ = g_strdup ((const gchar*) _tmp13_);
						*groups = g_slist_prepend (*groups, _tmp14_);
						_tmp15_ = entry;
						*groups = g_slist_remove_link (*groups, _tmp15_);
					}
					_g_free0 (name);
				}
			}
		}
		_g_key_file_unref0 (keyfile);
		(last_focus_order == NULL) ? NULL : (last_focus_order = (_g_slist_free__g_free0_ (last_focus_order), NULL));
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
xnp_application_quit (XnpApplication* self)
{
	g_return_if_fail (self != NULL);
	xnp_application_save_notes (self);
	xnp_application_save_windows_configuration (self);
	gtk_main_quit ();
}

/**
 * create_window:
 *
 * Creates a new Xnp.Window and stores it inside window_list.
 * If a name is given, it assumes it can load existing notes.
 */
static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		XnpApplication* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->window);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static GSList*
vala_g_slist_remove_full (GSList* self,
                          gconstpointer data,
                          GFreeFunc func)
{
	GSList* l = NULL;
	GSList* result;
	l = self;
	while (TRUE) {
		GSList* _tmp0_;
		GSList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GSList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GSList* _tmp3_;
			GSList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GSList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GSList* _tmp5_;
			gconstpointer _tmp6_;
			GSList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GSList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_slist_delete_link (self, (GSList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

static void
__lambda9_ (Block1Data* _data1_,
            XnpWindow* win,
            const gchar* action)
{
	XnpApplication* self;
	self = _data1_->self;
	g_return_if_fail (win != NULL);
	g_return_if_fail (action != NULL);
	if (g_strcmp0 (action, "hide") == 0) {
		gint hidden_windows = 0;
		GSList* _tmp0_;
		XnpWindow* _tmp4_;
		XnpWindow* _tmp5_;
		XnpWindow* _tmp6_;
		if (self->priv->lock_focus_order) {
			return;
		}
		hidden_windows = 0;
		_tmp0_ = self->priv->focus_order;
		{
			GSList* w_collection = NULL;
			GSList* w_it = NULL;
			w_collection = _tmp0_;
			for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
				XnpWindow* _tmp1_;
				XnpWindow* w = NULL;
				_tmp1_ = _g_object_ref0 ((XnpWindow*) w_it->data);
				w = _tmp1_;
				{
					XnpWindow* _tmp2_;
					_tmp2_ = w;
					if (!gtk_widget_get_visible ((GtkWidget*) _tmp2_)) {
						gint _tmp3_;
						_tmp3_ = hidden_windows;
						hidden_windows = _tmp3_ + 1;
					}
					_g_object_unref0 (w);
				}
			}
		}
		_tmp4_ = _data1_->window;
		self->priv->focus_order = vala_g_slist_remove_full (self->priv->focus_order, _tmp4_, _g_object_unref0_);
		_tmp5_ = _data1_->window;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		self->priv->focus_order = g_slist_insert (self->priv->focus_order, _tmp6_, hidden_windows - 1);
	} else {
		if (g_strcmp0 (action, "rename") == 0) {
			xnp_application_rename_window (self, win);
			xnp_application_set_data_value (self, (GObject*) win, "internal-change", TRUE);
		} else {
			if (g_strcmp0 (action, "delete") == 0) {
				xnp_application_delete_window (self, win);
				xnp_application_set_data_value (self, (GObject*) win, "internal-change", TRUE);
			} else {
				if (g_strcmp0 (action, "create-new-window") == 0) {
					XnpWindow* new_win = NULL;
					XnpWindow* _tmp7_;
					XnpWindow* _tmp8_;
					XnpWindow* _tmp9_;
					_tmp7_ = xnp_application_create_window (self, NULL);
					new_win = _tmp7_;
					_tmp8_ = new_win;
					if (_tmp8_ == NULL) {
						_g_object_unref0 (new_win);
						return;
					}
					_tmp9_ = new_win;
					gtk_widget_show ((GtkWidget*) _tmp9_);
					xnp_application_set_data_value (self, (GObject*) win, "internal-change", TRUE);
					_g_object_unref0 (new_win);
				} else {
					if (g_strcmp0 (action, "refresh-notes") == 0) {
						xnp_application_refresh_notes (self, win);
					} else {
						if (g_strcmp0 (action, "properties") == 0) {
							xnp_application_open_settings_dialog (self);
						} else {
							if (g_strcmp0 (action, "about") == 0) {
								xnp_application_open_about_dialog (self);
							}
						}
					}
				}
			}
		}
	}
}

static void
___lambda9__xnp_window_action (XnpWindow* _sender,
                               const gchar* action,
                               gpointer self)
{
	__lambda9_ (self, _sender, action);
}

static void
__lambda10_ (XnpApplication* self,
             XnpWindow* win,
             XnpNote* note)
{
	g_return_if_fail (win != NULL);
	g_return_if_fail (note != NULL);
	if (!xnp_application_get_data_value (self, (GObject*) win, "external-change")) {
		xnp_application_set_data_value (self, (GObject*) win, "internal-change", TRUE);
		xnp_application_save_note (self, win, note);
	}
}

static void
___lambda10__xnp_window_save_data (XnpWindow* _sender,
                                   XnpNote* note,
                                   gpointer self)
{
	__lambda10_ ((XnpApplication*) self, _sender, note);
}

static void
__lambda11_ (XnpApplication* self,
             XnpWindow* win,
             XnpNote* note)
{
	XfconfChannel* _tmp0_;
	XnpHypertextView* _tmp1_;
	gchar* path = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (win != NULL);
	g_return_if_fail (note != NULL);
	_tmp0_ = self->priv->xfconf_channel;
	_tmp1_ = note->text_view;
	xfconf_g_property_bind (_tmp0_, "/global/font-description", G_TYPE_STRING, _tmp1_, "font");
	_tmp2_ = self->priv->_notes_path;
	_tmp3_ = xnp_window_get_name (win);
	_tmp4_ = _tmp3_;
	_tmp5_ = xnp_note_get_name (note);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("%s/%s/%s", _tmp2_, _tmp4_, _tmp6_);
	path = _tmp7_;
	{
		note->backed = FALSE;
		g_file_set_contents (path, "", (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		xnp_application_set_data_value (self, (GObject*) win, "internal-change", TRUE);
		note->backed = TRUE;
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		xnp_window_popup_error (win, _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (path);
}

static void
___lambda11__xnp_window_note_inserted (XnpWindow* _sender,
                                       XnpNote* note,
                                       gpointer self)
{
	__lambda11_ ((XnpApplication*) self, _sender, note);
}

static void
__lambda12_ (XnpApplication* self,
             XnpWindow* win,
             XnpNote* note)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (win != NULL);
	g_return_if_fail (note != NULL);
	{
		gchar* path = NULL;
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		_tmp0_ = self->priv->_notes_path;
		_tmp1_ = xnp_window_get_name (win);
		_tmp2_ = _tmp1_;
		_tmp3_ = xnp_note_get_name (note);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("%s/%s/%s", _tmp0_, _tmp2_, _tmp4_);
		path = _tmp5_;
		_tmp6_ = g_file_new_for_path (path);
		_tmp7_ = _tmp6_;
		g_file_delete (_tmp7_, NULL, &_inner_error0_);
		_g_object_unref0 (_tmp7_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (path);
			goto __catch0_g_error;
		}
		xnp_application_set_data_value (self, (GObject*) win, "internal-change", TRUE);
		note->backed = FALSE;
		_g_free0 (path);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		xnp_window_popup_error (win, _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda12__xnp_window_note_deleted (XnpWindow* _sender,
                                      XnpNote* note,
                                      gpointer self)
{
	__lambda12_ ((XnpApplication*) self, _sender, note);
}

static void
__lambda13_ (XnpApplication* self,
             XnpWindow* win,
             XnpNote* note,
             const gchar* name)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (win != NULL);
	g_return_if_fail (note != NULL);
	g_return_if_fail (name != NULL);
	if (!xnp_application_name_is_valid (self, name)) {
		return;
	}
	{
		gchar* path = NULL;
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		GFile* note_file = NULL;
		const gchar* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
		_tmp0_ = self->priv->_notes_path;
		_tmp1_ = xnp_window_get_name (win);
		_tmp2_ = _tmp1_;
		_tmp3_ = xnp_note_get_name (note);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("%s/%s/%s", _tmp0_, _tmp2_, _tmp4_);
		path = _tmp5_;
		_tmp6_ = path;
		_tmp7_ = g_file_new_for_path (_tmp6_);
		note_file = _tmp7_;
		_tmp8_ = note_file;
		_tmp9_ = g_file_set_display_name (_tmp8_, name, NULL, &_inner_error0_);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp10_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (note_file);
			_g_free0 (path);
			goto __catch0_g_error;
		}
		xnp_application_set_data_value (self, (GObject*) win, "internal-change", TRUE);
		xnp_note_set_name (note, name);
		_g_object_unref0 (note_file);
		_g_free0 (path);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		xnp_window_popup_error (win, _tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda13__xnp_window_note_renamed (XnpWindow* _sender,
                                      XnpNote* note,
                                      const gchar* name,
                                      gpointer self)
{
	__lambda13_ ((XnpApplication*) self, _sender, note, name);
}

static gboolean
_xnp_application_save_windows_configuration_gsource_func (gpointer self)
{
	gboolean result;
	result = xnp_application_save_windows_configuration ((XnpApplication*) self);
	return result;
}

static void
__lambda14_ (Block1Data* _data1_)
{
	XnpApplication* self;
	XnpWindow* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data1_->self;
	if (self->priv->save_config_timeout > ((guint) 0)) {
		g_source_remove (self->priv->save_config_timeout);
		self->priv->save_config_timeout = (guint) 0;
	}
	_tmp0_ = _data1_->window;
	g_object_get ((GtkWindow*) _tmp0_, "is-active", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		XnpWindow* _tmp3_;
		XnpWindow* _tmp4_;
		XnpWindow* _tmp5_;
		_tmp3_ = _data1_->window;
		self->priv->focus_order = vala_g_slist_remove_full (self->priv->focus_order, _tmp3_, _g_object_unref0_);
		_tmp4_ = _data1_->window;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		self->priv->focus_order = g_slist_append (self->priv->focus_order, _tmp5_);
	} else {
		if (self->system_tray_mode) {
			self->priv->save_config_timeout = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, _xnp_application_save_windows_configuration_gsource_func, g_object_ref (self), g_object_unref);
		}
	}
}

static void
___lambda14__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda14_ (self);
}

static gboolean
__lambda15_ (XnpApplication* self,
             XnpWindow* to_win,
             XnpWindow* from_win,
             XnpNote* note)
{
	gchar* from_path = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* to_path = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GFile* from_file = NULL;
	GFile* _tmp12_;
	GFile* to_file = NULL;
	GFile* _tmp13_;
	gboolean _tmp19_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (to_win != NULL, FALSE);
	g_return_val_if_fail (from_win != NULL, FALSE);
	g_return_val_if_fail (note != NULL, FALSE);
	_tmp0_ = self->priv->_notes_path;
	_tmp1_ = xnp_window_get_name (from_win);
	_tmp2_ = _tmp1_;
	_tmp3_ = xnp_note_get_name (note);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s/%s/%s", _tmp0_, _tmp2_, _tmp4_);
	from_path = _tmp5_;
	_tmp6_ = self->priv->_notes_path;
	_tmp7_ = xnp_window_get_name (to_win);
	_tmp8_ = _tmp7_;
	_tmp9_ = xnp_note_get_name (note);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup_printf ("%s/%s/%s", _tmp6_, _tmp8_, _tmp10_);
	to_path = _tmp11_;
	_tmp12_ = g_file_new_for_path (from_path);
	from_file = _tmp12_;
	_tmp13_ = g_file_new_for_path (to_path);
	to_file = _tmp13_;
	{
		GtkEventBox* tab_evbox = NULL;
		GtkEventBox* _tmp14_;
		GtkEventBox* _tmp15_;
		GtkEventBox* _tmp16_;
		g_file_move (from_file, to_file, G_FILE_COPY_NONE, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		xnp_application_set_data_value (self, (GObject*) from_win, "internal-change", TRUE);
		xnp_application_set_data_value (self, (GObject*) to_win, "internal-change", TRUE);
		_tmp14_ = xnp_window_get_tab_evbox (from_win, note);
		tab_evbox = _tmp14_;
		_tmp15_ = tab_evbox;
		xnp_window_disconnect_note_signals (from_win, note, _tmp15_);
		_tmp16_ = tab_evbox;
		xnp_window_connect_note_signals (to_win, note, _tmp16_);
		result = TRUE;
		_g_object_unref0 (tab_evbox);
		_g_object_unref0 (to_file);
		_g_object_unref0 (from_file);
		_g_free0 (to_path);
		_g_free0 (from_path);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		xnp_window_popup_error (to_win, _tmp18_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (to_file);
		_g_object_unref0 (from_file);
		_g_free0 (to_path);
		_g_free0 (from_path);
		return result;
	}
	__finally0:
	_g_object_unref0 (to_file);
	_g_object_unref0 (from_file);
	_g_free0 (to_path);
	_g_free0 (from_path);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp19_;
}

static gboolean
___lambda15__xnp_window_note_moved (XnpWindow* _sender,
                                    XnpWindow* src_win,
                                    XnpNote* note,
                                    gpointer self)
{
	gboolean result;
	result = __lambda15_ ((XnpApplication*) self, _sender, src_win, note);
	return result;
}

XnpWindow*
xnp_application_create_window (XnpApplication* self,
                               const gchar* name)
{
	Block1Data* _data1_;
	XnpWindow* _tmp0_;
	XnpWindow* _tmp18_;
	XnpWindow* _tmp19_;
	XnpWindow* _tmp20_;
	XnpWindow* _tmp21_;
	XnpWindow* _tmp22_;
	gchar* window_path = NULL;
	const gchar* _tmp23_;
	XnpWindow* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gboolean _tmp28_ = FALSE;
	XnpWindow* _tmp43_;
	XfconfChannel* _tmp44_;
	XnpWindow* _tmp45_;
	XnpWindow* _tmp46_;
	gboolean _tmp47_;
	gboolean _tmp48_;
	XnpWindow* _tmp49_;
	XnpWindow* _tmp50_;
	XnpWindow* _tmp51_;
	XnpWindow* _tmp52_;
	XnpWindow* _tmp53_;
	XnpWindow* _tmp54_;
	XnpWindow* _tmp55_;
	XnpWindow* _tmp56_;
	XnpWindow* _tmp57_;
	GError* _inner_error0_ = NULL;
	XnpWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = xnp_window_new (self);
	g_object_ref_sink (_tmp0_);
	_data1_->window = _tmp0_;
	if (name == NULL) {
		XnpWindow* _tmp1_;
		XfconfChannel* _tmp2_;
		XnpWindow* _tmp3_;
		XfconfChannel* _tmp4_;
		gint width = 0;
		XfconfChannel* _tmp5_;
		gint height = 0;
		XfconfChannel* _tmp6_;
		gboolean _tmp7_ = FALSE;
		_tmp1_ = _data1_->window;
		_tmp2_ = self->priv->xfconf_channel;
		xnp_window_set_above (_tmp1_, xfconf_channel_get_bool (_tmp2_, "/new-window/always-on-top", FALSE));
		_tmp3_ = _data1_->window;
		_tmp4_ = self->priv->xfconf_channel;
		xnp_window_set_sticky (_tmp3_, xfconf_channel_get_bool (_tmp4_, "/new-window/sticky", TRUE));
		_tmp5_ = self->priv->xfconf_channel;
		width = (gint) xfconf_channel_get_int (_tmp5_, "/new-window/width", (gint32) 0);
		_tmp6_ = self->priv->xfconf_channel;
		height = (gint) xfconf_channel_get_int (_tmp6_, "/new-window/height", (gint32) 0);
		if (width > 0) {
			_tmp7_ = height > 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			XnpWindow* _tmp8_;
			_tmp8_ = _data1_->window;
			gtk_window_resize ((GtkWindow*) _tmp8_, width, height);
		}
	}
	if (name == NULL) {
		gchar* window_name = NULL;
		gchar* _tmp9_;
		gint len = 0;
		GSList* _tmp10_;
		XnpWindow* _tmp15_;
		const gchar* _tmp16_;
		_tmp9_ = g_strdup (_ ("Notes"));
		window_name = _tmp9_;
		_tmp10_ = self->priv->window_list;
		len = (gint) g_slist_length (_tmp10_);
		{
			gint id = 0;
			id = 1;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					const gchar* _tmp14_;
					if (!_tmp11_) {
						gint _tmp12_;
						_tmp12_ = id;
						id = _tmp12_ + 1;
					}
					_tmp11_ = FALSE;
					if (!(id <= (len + 1))) {
						break;
					}
					if (id > 1) {
						gchar* _tmp13_;
						_tmp13_ = g_strdup_printf (_ ("Notes %d"), id);
						_g_free0 (window_name);
						window_name = _tmp13_;
					}
					_tmp14_ = window_name;
					if (!xnp_application_window_name_exists (self, _tmp14_)) {
						break;
					}
				}
			}
		}
		_tmp15_ = _data1_->window;
		_tmp16_ = window_name;
		xnp_window_set_name (_tmp15_, _tmp16_);
		_g_free0 (window_name);
	} else {
		XnpWindow* _tmp17_;
		_tmp17_ = _data1_->window;
		xnp_window_set_name (_tmp17_, name);
	}
	_tmp18_ = _data1_->window;
	_tmp19_ = _g_object_ref0 (_tmp18_);
	_tmp20_ = _data1_->window;
	self->priv->window_list = g_slist_insert_sorted (self->priv->window_list, _tmp19_, (GCompareFunc) xnp_window_compare_func);
	_tmp21_ = _data1_->window;
	_tmp22_ = _g_object_ref0 (_tmp21_);
	self->priv->focus_order = g_slist_append (self->priv->focus_order, _tmp22_);
	_tmp23_ = self->priv->_notes_path;
	_tmp24_ = _data1_->window;
	_tmp25_ = xnp_window_get_name (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_strdup_printf ("%s/%s", _tmp23_, _tmp26_);
	window_path = _tmp27_;
	if (name == NULL) {
		_tmp28_ = TRUE;
	} else {
		const gchar* _tmp29_;
		_tmp29_ = window_path;
		_tmp28_ = !g_file_test (_tmp29_, G_FILE_TEST_IS_DIR | G_FILE_TEST_EXISTS);
	}
	if (_tmp28_) {
		{
			const gchar* _tmp30_;
			gchar* note_path = NULL;
			const gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			const gchar* _tmp36_;
			XnpWindow* _tmp37_;
			_tmp30_ = window_path;
			g_mkdir_with_parents (_tmp30_, 0700);
			_tmp31_ = window_path;
			_tmp32_ = g_strdup_printf (_ ("Note %d"), 1);
			_tmp33_ = _tmp32_;
			_tmp34_ = g_strdup_printf ("%s/%s", _tmp31_, _tmp33_);
			_tmp35_ = _tmp34_;
			_g_free0 (_tmp33_);
			note_path = _tmp35_;
			_tmp36_ = note_path;
			g_file_set_contents (_tmp36_, "", (gssize) -1, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (note_path);
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				_g_free0 (window_path);
				block1_data_unref (_data1_);
				_data1_ = NULL;
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp37_ = _data1_->window;
			xnp_application_load_window_data (self, _tmp37_);
			_g_free0 (note_path);
		}
		goto __finally0;
		__catch0_g_file_error:
		{
			GError* e = NULL;
			XnpWindow* _tmp38_;
			GError* _tmp39_;
			const gchar* _tmp40_;
			XnpWindow* _tmp41_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp38_ = _data1_->window;
			_tmp39_ = e;
			_tmp40_ = _tmp39_->message;
			xnp_window_popup_error (_tmp38_, _tmp40_);
			_tmp41_ = _data1_->window;
			xnp_application_destroy_window (self, _tmp41_);
			result = NULL;
			_g_error_free0 (e);
			_g_free0 (window_path);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (window_path);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	} else {
		XnpWindow* _tmp42_;
		_tmp42_ = _data1_->window;
		xnp_application_load_window_data (self, _tmp42_);
	}
	_tmp43_ = _data1_->window;
	xnp_application_window_monitor_list_add (self, _tmp43_);
	_tmp44_ = self->priv->xfconf_channel;
	_tmp45_ = _data1_->window;
	xfconf_g_property_bind (_tmp44_, "/global/tabs-position", G_TYPE_INT, _tmp45_, "tabs-position");
	_tmp46_ = _data1_->window;
	_tmp47_ = xnp_application_get_skip_taskbar_hint (self);
	_tmp48_ = _tmp47_;
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) _tmp46_, _tmp48_);
	_tmp49_ = _data1_->window;
	g_signal_connect_data (_tmp49_, "action", (GCallback) ___lambda9__xnp_window_action, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp50_ = _data1_->window;
	g_signal_connect_object (_tmp50_, "save-data", (GCallback) ___lambda10__xnp_window_save_data, self, 0);
	_tmp51_ = _data1_->window;
	g_signal_connect_object (_tmp51_, "note-inserted", (GCallback) ___lambda11__xnp_window_note_inserted, self, 0);
	_tmp52_ = _data1_->window;
	g_signal_connect_object (_tmp52_, "note-deleted", (GCallback) ___lambda12__xnp_window_note_deleted, self, 0);
	_tmp53_ = _data1_->window;
	g_signal_connect_object (_tmp53_, "note-renamed", (GCallback) ___lambda13__xnp_window_note_renamed, self, 0);
	_tmp54_ = _data1_->window;
	g_signal_connect_data ((GObject*) _tmp54_, "notify::is-active", (GCallback) ___lambda14__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp55_ = _data1_->window;
	g_signal_connect_object (_tmp55_, "note-moved", (GCallback) ___lambda15__xnp_window_note_moved, self, 0);
	_tmp56_ = _data1_->window;
	_tmp57_ = _g_object_ref0 (_tmp56_);
	result = _tmp57_;
	_g_free0 (window_path);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

/**
 * load_window_data:
 *
 * Load existing notes and configuration inside the window.
 */
static void
xnp_application_load_window_data (XnpApplication* self,
                                  XnpWindow* window)
{
	gchar* name = NULL;
	gchar* path = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp30_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->_notes_path;
	_tmp1_ = xnp_window_get_name (window);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%s/%s", _tmp0_, _tmp2_);
	path = _tmp3_;
	{
		GDir* dir = NULL;
		const gchar* _tmp4_;
		GDir* _tmp5_;
		_tmp4_ = path;
		_tmp5_ = g_dir_open (_tmp4_, (guint) 0, &_inner_error0_);
		dir = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (path);
			_g_free0 (name);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		while (TRUE) {
			GDir* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			const gchar* _tmp9_;
			_tmp6_ = dir;
			_tmp7_ = g_dir_read_name (_tmp6_);
			_tmp8_ = g_strdup (_tmp7_);
			_g_free0 (name);
			name = _tmp8_;
			_tmp9_ = name;
			if (!(_tmp9_ != NULL)) {
				break;
			}
			{
				gchar* contents = NULL;
				GFile* file = NULL;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				GFile* _tmp14_;
				GFile* _tmp15_;
				GFile* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_ = NULL;
				XnpNote* note = NULL;
				const gchar* _tmp20_;
				XnpNote* _tmp21_;
				XnpNote* _tmp22_;
				const gchar* _tmp23_;
				XfconfChannel* _tmp24_;
				XnpNote* _tmp25_;
				XnpHypertextView* _tmp26_;
				XnpNote* _tmp27_;
				_tmp10_ = path;
				_tmp11_ = name;
				_tmp12_ = g_strdup_printf ("%s/%s", _tmp10_, _tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = g_file_new_for_path (_tmp13_);
				_tmp15_ = _tmp14_;
				_g_free0 (_tmp13_);
				file = _tmp15_;
				_tmp16_ = file;
				_tmp17_ = g_file_get_path (_tmp16_);
				_tmp18_ = _tmp17_;
				g_file_get_contents (_tmp18_, &_tmp19_, NULL, &_inner_error0_);
				_g_free0 (contents);
				contents = _tmp19_;
				_g_free0 (_tmp18_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (file);
					_g_free0 (contents);
					if (_inner_error0_->domain == G_FILE_ERROR) {
						goto __catch1_g_file_error;
					}
					_g_dir_close0 (dir);
					_g_free0 (path);
					_g_free0 (name);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_tmp20_ = name;
				_tmp21_ = xnp_window_insert_note (window, _tmp20_);
				note = _tmp21_;
				_tmp22_ = note;
				_tmp23_ = contents;
				xnp_note_set_text (_tmp22_, _tmp23_);
				_tmp24_ = self->priv->xfconf_channel;
				_tmp25_ = note;
				_tmp26_ = _tmp25_->text_view;
				xfconf_g_property_bind (_tmp24_, "/global/font-description", G_TYPE_STRING, _tmp26_, "font");
				_tmp27_ = note;
				_tmp27_->backed = TRUE;
				_g_object_unref0 (note);
				_g_object_unref0 (file);
				_g_free0 (contents);
			}
			goto __finally1;
			__catch1_g_file_error:
			{
				GError* e = NULL;
				GError* _tmp28_;
				const gchar* _tmp29_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp28_ = e;
				_tmp29_ = _tmp28_->message;
				g_warning ("application.vala:512: %s", _tmp29_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_dir_close0 (dir);
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				_g_free0 (path);
				_g_free0 (name);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_g_dir_close0 (dir);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (path);
		_g_free0 (name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp30_ = g_key_file_new ();
	keyfile = _tmp30_;
	{
		GKeyFile* _tmp31_;
		const gchar* _tmp32_;
		gint winx = 0;
		GKeyFile* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		gint winy = 0;
		GKeyFile* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		gint width = 0;
		GKeyFile* _tmp39_;
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		gint height = 0;
		GKeyFile* _tmp42_;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		gchar** tabs_order = NULL;
		GKeyFile* _tmp45_;
		const gchar* _tmp46_;
		const gchar* _tmp47_;
		gsize _tmp48_ = 0;
		gchar** _tmp49_;
		gint tabs_order_length1;
		gint _tabs_order_size_;
		gint last_page = 0;
		GKeyFile* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		gboolean above = FALSE;
		GKeyFile* _tmp53_;
		const gchar* _tmp54_;
		const gchar* _tmp55_;
		gboolean sticky = FALSE;
		GKeyFile* _tmp56_;
		const gchar* _tmp57_;
		const gchar* _tmp58_;
		gint _tmp59_ = 0;
		GKeyFile* _tmp60_;
		const gchar* _tmp61_;
		const gchar* _tmp62_;
		gdouble opacity = 0.0;
		gboolean visible = FALSE;
		GKeyFile* _tmp63_;
		const gchar* _tmp64_;
		const gchar* _tmp65_;
		_tmp31_ = keyfile;
		_tmp32_ = self->priv->_config_file;
		g_key_file_load_from_file (_tmp31_, _tmp32_, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp33_ = keyfile;
		_tmp34_ = xnp_window_get_name (window);
		_tmp35_ = _tmp34_;
		winx = g_key_file_get_integer (_tmp33_, _tmp35_, "PosX", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp36_ = keyfile;
		_tmp37_ = xnp_window_get_name (window);
		_tmp38_ = _tmp37_;
		winy = g_key_file_get_integer (_tmp36_, _tmp38_, "PosY", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp39_ = keyfile;
		_tmp40_ = xnp_window_get_name (window);
		_tmp41_ = _tmp40_;
		width = g_key_file_get_integer (_tmp39_, _tmp41_, "Width", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp42_ = keyfile;
		_tmp43_ = xnp_window_get_name (window);
		_tmp44_ = _tmp43_;
		height = g_key_file_get_integer (_tmp42_, _tmp44_, "Height", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp45_ = keyfile;
		_tmp46_ = xnp_window_get_name (window);
		_tmp47_ = _tmp46_;
		_tmp49_ = g_key_file_get_string_list (_tmp45_, _tmp47_, "TabsOrder", &_tmp48_, &_inner_error0_);
		tabs_order = _tmp49_;
		tabs_order_length1 = _tmp48_;
		_tabs_order_size_ = tabs_order_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp50_ = keyfile;
		_tmp51_ = xnp_window_get_name (window);
		_tmp52_ = _tmp51_;
		last_page = g_key_file_get_integer (_tmp50_, _tmp52_, "LastTab", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
			goto __catch2_g_error;
		}
		_tmp53_ = keyfile;
		_tmp54_ = xnp_window_get_name (window);
		_tmp55_ = _tmp54_;
		above = g_key_file_get_boolean (_tmp53_, _tmp55_, "Above", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
			goto __catch2_g_error;
		}
		_tmp56_ = keyfile;
		_tmp57_ = xnp_window_get_name (window);
		_tmp58_ = _tmp57_;
		sticky = g_key_file_get_boolean (_tmp56_, _tmp58_, "Sticky", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
			goto __catch2_g_error;
		}
		_tmp60_ = keyfile;
		_tmp61_ = xnp_window_get_name (window);
		_tmp62_ = _tmp61_;
		_tmp59_ = g_key_file_get_integer (_tmp60_, _tmp62_, "Transparency", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
			goto __catch2_g_error;
		}
		opacity = 1 - (((gdouble) _tmp59_) / 100);
		_tmp63_ = keyfile;
		_tmp64_ = xnp_window_get_name (window);
		_tmp65_ = _tmp64_;
		visible = g_key_file_get_boolean (_tmp63_, _tmp65_, "Visible", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
			goto __catch2_g_error;
		}
		gtk_window_move ((GtkWindow*) window, winx, winy);
		gtk_window_resize ((GtkWindow*) window, width, height);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp66_ = FALSE;
				_tmp66_ = TRUE;
				while (TRUE) {
					gchar** _tmp68_;
					gint _tmp68__length1;
					gchar** _tmp69_;
					gint _tmp69__length1;
					const gchar* _tmp70_;
					if (!_tmp66_) {
						gint _tmp67_;
						_tmp67_ = i;
						i = _tmp67_ + 1;
					}
					_tmp66_ = FALSE;
					_tmp68_ = tabs_order;
					_tmp68__length1 = tabs_order_length1;
					if (!(i < _tmp68__length1)) {
						break;
					}
					_tmp69_ = tabs_order;
					_tmp69__length1 = tabs_order_length1;
					_tmp70_ = _tmp69_[i];
					xnp_window_move_note (window, _tmp70_, i);
				}
			}
		}
		xnp_window_set_current_page (window, last_page);
		xnp_window_set_above (window, above);
		xnp_window_set_sticky (window, sticky);
		gtk_widget_set_opacity ((GtkWidget*) window, opacity);
		if (visible) {
			gtk_widget_show ((GtkWidget*) window);
		}
		tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally2;
	__catch2_g_error:
	{
		XfconfChannel* _tmp71_;
		XfconfChannel* _tmp72_;
		gint width = 0;
		XfconfChannel* _tmp73_;
		gint height = 0;
		XfconfChannel* _tmp74_;
		gboolean _tmp75_ = FALSE;
		g_clear_error (&_inner_error0_);
		_tmp71_ = self->priv->xfconf_channel;
		xnp_window_set_above (window, xfconf_channel_get_bool (_tmp71_, "/new-window/always-on-top", FALSE));
		_tmp72_ = self->priv->xfconf_channel;
		xnp_window_set_sticky (window, xfconf_channel_get_bool (_tmp72_, "/new-window/sticky", TRUE));
		_tmp73_ = self->priv->xfconf_channel;
		width = (gint) xfconf_channel_get_int (_tmp73_, "/new-window/width", (gint32) 0);
		_tmp74_ = self->priv->xfconf_channel;
		height = (gint) xfconf_channel_get_int (_tmp74_, "/new-window/height", (gint32) 0);
		if (width > 0) {
			_tmp75_ = height > 0;
		} else {
			_tmp75_ = FALSE;
		}
		if (_tmp75_) {
			gtk_window_resize ((GtkWindow*) window, width, height);
		}
		gtk_widget_show ((GtkWidget*) window);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (keyfile);
		_g_free0 (path);
		_g_free0 (name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_key_file_unref0 (keyfile);
	_g_free0 (path);
	_g_free0 (name);
}

/**
 * save_windows_configuration:
 *
 * Save window configuration inside rc file.
 */
gboolean
xnp_application_save_windows_configuration (XnpApplication* self)
{
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp0_;
	gchar* old_contents = NULL;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_key_file_new ();
	keyfile = _tmp0_;
	{
		const gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
		_tmp1_ = self->priv->_config_file;
		g_file_get_contents (_tmp1_, &_tmp2_, NULL, &_inner_error0_);
		_g_free0 (old_contents);
		old_contents = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp3_ = FALSE;
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (old_contents);
			_g_key_file_unref0 (keyfile);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		_g_free0 (old_contents);
		_g_key_file_unref0 (keyfile);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
	{
		GSList* _tmp5_;
		gchar* contents = NULL;
		gchar* _tmp57_;
		const gchar* _tmp58_;
		_tmp5_ = self->priv->focus_order;
		{
			GSList* win_collection = NULL;
			GSList* win_it = NULL;
			win_collection = _tmp5_;
			for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
				XnpWindow* _tmp6_;
				XnpWindow* win = NULL;
				_tmp6_ = _g_object_ref0 ((XnpWindow*) win_it->data);
				win = _tmp6_;
				{
					gint winx = 0;
					gint winy = 0;
					gint width = 0;
					gint height = 0;
					XnpWindow* _tmp7_;
					gint _tmp8_ = 0;
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
					gint _tmp11_ = 0;
					gchar** tabs_order = NULL;
					XnpWindow* _tmp12_;
					gint _tmp13_ = 0;
					gchar** _tmp14_;
					gint tabs_order_length1;
					gint _tabs_order_size_;
					gint last_page = 0;
					XnpWindow* _tmp15_;
					gint transparency = 0;
					XnpWindow* _tmp16_;
					gdouble _tmp17_;
					gdouble _tmp18_;
					gboolean visible = FALSE;
					XnpWindow* _tmp19_;
					XnpWindow* _tmp20_;
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					XnpWindow* _tmp23_;
					const gchar* _tmp24_;
					const gchar* _tmp25_;
					XnpWindow* _tmp26_;
					const gchar* _tmp27_;
					const gchar* _tmp28_;
					XnpWindow* _tmp29_;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					XnpWindow* _tmp32_;
					const gchar* _tmp33_;
					const gchar* _tmp34_;
					gchar** _tmp35_;
					gint _tmp35__length1;
					XnpWindow* _tmp36_;
					const gchar* _tmp37_;
					const gchar* _tmp38_;
					XnpWindow* _tmp39_;
					const gchar* _tmp40_;
					const gchar* _tmp41_;
					XnpWindow* _tmp42_;
					gboolean _tmp43_;
					gboolean _tmp44_;
					XnpWindow* _tmp45_;
					const gchar* _tmp46_;
					const gchar* _tmp47_;
					XnpWindow* _tmp48_;
					gboolean _tmp49_;
					gboolean _tmp50_;
					XnpWindow* _tmp51_;
					const gchar* _tmp52_;
					const gchar* _tmp53_;
					XnpWindow* _tmp54_;
					const gchar* _tmp55_;
					const gchar* _tmp56_;
					_tmp7_ = win;
					xnp_window_get_geometry (_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_);
					winx = _tmp8_;
					winy = _tmp9_;
					width = _tmp10_;
					height = _tmp11_;
					_tmp12_ = win;
					_tmp14_ = xnp_window_get_note_names (_tmp12_, &_tmp13_);
					tabs_order = _tmp14_;
					tabs_order_length1 = _tmp13_;
					_tabs_order_size_ = tabs_order_length1;
					_tmp15_ = win;
					last_page = xnp_window_get_current_page (_tmp15_);
					_tmp16_ = win;
					_tmp17_ = gtk_widget_get_opacity ((GtkWidget*) _tmp16_);
					_tmp18_ = _tmp17_;
					transparency = (gint) ((1 - _tmp18_) * 100);
					_tmp19_ = win;
					visible = gtk_widget_get_visible ((GtkWidget*) _tmp19_);
					_tmp20_ = win;
					_tmp21_ = xnp_window_get_name (_tmp20_);
					_tmp22_ = _tmp21_;
					g_key_file_set_integer (keyfile, _tmp22_, "PosX", winx);
					_tmp23_ = win;
					_tmp24_ = xnp_window_get_name (_tmp23_);
					_tmp25_ = _tmp24_;
					g_key_file_set_integer (keyfile, _tmp25_, "PosY", winy);
					_tmp26_ = win;
					_tmp27_ = xnp_window_get_name (_tmp26_);
					_tmp28_ = _tmp27_;
					g_key_file_set_integer (keyfile, _tmp28_, "Width", width);
					_tmp29_ = win;
					_tmp30_ = xnp_window_get_name (_tmp29_);
					_tmp31_ = _tmp30_;
					g_key_file_set_integer (keyfile, _tmp31_, "Height", height);
					_tmp32_ = win;
					_tmp33_ = xnp_window_get_name (_tmp32_);
					_tmp34_ = _tmp33_;
					_tmp35_ = tabs_order;
					_tmp35__length1 = tabs_order_length1;
					g_key_file_set_string_list (keyfile, _tmp34_, "TabsOrder", (const gchar* const*) _tmp35_, (gint) _tmp35__length1);
					_tmp36_ = win;
					_tmp37_ = xnp_window_get_name (_tmp36_);
					_tmp38_ = _tmp37_;
					g_key_file_set_integer (keyfile, _tmp38_, "LastTab", last_page);
					_tmp39_ = win;
					_tmp40_ = xnp_window_get_name (_tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = win;
					_tmp43_ = xnp_window_get_above (_tmp42_);
					_tmp44_ = _tmp43_;
					g_key_file_set_boolean (keyfile, _tmp41_, "Above", _tmp44_);
					_tmp45_ = win;
					_tmp46_ = xnp_window_get_name (_tmp45_);
					_tmp47_ = _tmp46_;
					_tmp48_ = win;
					_tmp49_ = xnp_window_get_sticky (_tmp48_);
					_tmp50_ = _tmp49_;
					g_key_file_set_boolean (keyfile, _tmp47_, "Sticky", _tmp50_);
					_tmp51_ = win;
					_tmp52_ = xnp_window_get_name (_tmp51_);
					_tmp53_ = _tmp52_;
					g_key_file_set_double (keyfile, _tmp53_, "Transparency", (gdouble) transparency);
					_tmp54_ = win;
					_tmp55_ = xnp_window_get_name (_tmp54_);
					_tmp56_ = _tmp55_;
					g_key_file_set_boolean (keyfile, _tmp56_, "Visible", visible);
					tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (win);
				}
			}
		}
		_tmp57_ = g_key_file_to_data (keyfile, NULL, NULL);
		contents = _tmp57_;
		_tmp58_ = contents;
		if (g_strcmp0 (_tmp58_, old_contents) != 0) {
			const gchar* _tmp59_;
			const gchar* _tmp60_;
			_tmp59_ = self->priv->_config_file;
			_tmp60_ = contents;
			g_file_set_contents (_tmp59_, _tmp60_, (gssize) -1, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp61_ = FALSE;
				_g_free0 (contents);
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch1_g_file_error;
				}
				_g_free0 (old_contents);
				_g_key_file_unref0 (keyfile);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp61_;
			}
		}
		_g_free0 (contents);
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError* e = NULL;
		const gchar* _tmp62_;
		GError* _tmp63_;
		const gchar* _tmp64_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp62_ = self->priv->_config_file;
		_tmp63_ = e;
		_tmp64_ = _tmp63_->message;
		g_message ("application.vala:595: Unable to save window configuration from %s: %s", _tmp62_, _tmp64_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp65_ = FALSE;
		_g_free0 (old_contents);
		_g_key_file_unref0 (keyfile);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp65_;
	}
	if (self->priv->save_config_timeout > ((guint) 0)) {
		g_source_remove (self->priv->save_config_timeout);
		self->priv->save_config_timeout = (guint) 0;
	}
	result = FALSE;
	_g_free0 (old_contents);
	_g_key_file_unref0 (keyfile);
	return result;
}

/**
 * save_notes:
 *
 * Save the contents of every existing notes.
 */
void
xnp_application_save_notes (XnpApplication* self)
{
	GSList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window_list;
	{
		GSList* win_collection = NULL;
		GSList* win_it = NULL;
		win_collection = _tmp0_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* _tmp1_;
			XnpWindow* win = NULL;
			_tmp1_ = _g_object_ref0 ((XnpWindow*) win_it->data);
			win = _tmp1_;
			{
				XnpWindow* _tmp2_;
				XnpWindow* _tmp3_;
				_tmp2_ = win;
				xnp_application_set_data_value (self, (GObject*) _tmp2_, "external-change", FALSE);
				_tmp3_ = win;
				xnp_window_save_notes (_tmp3_);
				_g_object_unref0 (win);
			}
		}
	}
}

/**
 * save_note:
 *
 * Save the contents of the given note.
 */
static void
xnp_application_save_note (XnpApplication* self,
                           XnpWindow* window,
                           XnpNote* note)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* old_contents = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	g_return_if_fail (note != NULL);
	_tmp0_ = self->priv->_notes_path;
	_tmp1_ = xnp_window_get_name (window);
	_tmp2_ = _tmp1_;
	_tmp3_ = xnp_note_get_name (note);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s/%s/%s", _tmp0_, _tmp2_, _tmp4_);
	path = _tmp5_;
	{
		gchar* _tmp6_ = NULL;
		g_file_get_contents (path, &_tmp6_, NULL, &_inner_error0_);
		_g_free0 (old_contents);
		old_contents = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (old_contents);
			_g_free0 (path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (old_contents);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		gchar* contents = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp7_ = xnp_note_get_text (note);
		_tmp8_ = _tmp7_;
		contents = _tmp8_;
		_tmp9_ = contents;
		if (g_strcmp0 (_tmp9_, old_contents) != 0) {
			const gchar* _tmp10_;
			_tmp10_ = contents;
			g_file_set_contents (path, _tmp10_, (gssize) -1, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (contents);
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch1_g_file_error;
				}
				_g_free0 (old_contents);
				_g_free0 (path);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		xnp_note_set_dirty (note, FALSE);
		note->backed = TRUE;
		_g_free0 (contents);
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		xnp_window_popup_error (window, _tmp12_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (old_contents);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (old_contents);
	_g_free0 (path);
}

/**
 * rename_window:
 *
 * Rename the window.
 */
static void
xnp_application_rename_window (XnpApplication* self,
                               XnpWindow* window)
{
	GtkDialog* dialog = NULL;
	GtkDialog* _tmp0_;
	GtkBox* content_area = NULL;
	GtkDialog* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkDialog* _tmp4_;
	GtkDialog* _tmp5_;
	GtkDialog* _tmp6_;
	GtkDialog* _tmp7_;
	GtkEntry* entry = NULL;
	GtkEntry* _tmp8_;
	GtkEntry* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GtkEntry* _tmp12_;
	GtkBox* _tmp13_;
	GtkEntry* _tmp14_;
	GtkBox* _tmp15_;
	gint res = 0;
	GtkDialog* _tmp16_;
	GtkDialog* _tmp17_;
	GtkDialog* _tmp39_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = (GtkDialog*) gtk_dialog_new_with_buttons (_ ("Rename group"), (GtkWindow*) window, GTK_DIALOG_DESTROY_WITH_PARENT, "gtk-cancel", GTK_RESPONSE_CANCEL, "gtk-ok", GTK_RESPONSE_OK, NULL);
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	_tmp1_ = dialog;
	_tmp2_ = gtk_dialog_get_content_area (_tmp1_);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_box_get_type (), GtkBox));
	content_area = _tmp3_;
	_tmp4_ = dialog;
	gtk_dialog_set_default_response (_tmp4_, (gint) GTK_RESPONSE_OK);
	_tmp5_ = dialog;
	gtk_window_set_resizable ((GtkWindow*) _tmp5_, FALSE);
	_tmp6_ = dialog;
	gtk_window_set_icon_name ((GtkWindow*) _tmp6_, "gtk-edit");
	_tmp7_ = dialog;
	gtk_container_set_border_width ((GtkContainer*) _tmp7_, (guint) 4);
	_tmp8_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp8_);
	entry = _tmp8_;
	_tmp9_ = entry;
	_tmp10_ = xnp_window_get_name (window);
	_tmp11_ = _tmp10_;
	gtk_entry_set_text (_tmp9_, _tmp11_);
	_tmp12_ = entry;
	gtk_entry_set_activates_default (_tmp12_, TRUE);
	_tmp13_ = content_area;
	_tmp14_ = entry;
	gtk_container_add ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = content_area;
	gtk_widget_show_all ((GtkWidget*) _tmp15_);
	_tmp16_ = dialog;
	res = gtk_dialog_run (_tmp16_);
	_tmp17_ = dialog;
	xnp_window_dialog_hide (window, _tmp17_);
	if (res == ((gint) GTK_RESPONSE_OK)) {
		const gchar* name = NULL;
		GtkEntry* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		_tmp18_ = entry;
		_tmp19_ = gtk_entry_get_text (_tmp18_);
		_tmp20_ = _tmp19_;
		name = _tmp20_;
		_tmp21_ = name;
		if (xnp_application_window_name_exists (self, _tmp21_)) {
			const gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp22_ = name;
			_tmp23_ = g_strdup_printf (_ ("The name %s is already in use"), _tmp22_);
			_tmp24_ = _tmp23_;
			xnp_window_popup_error (window, _tmp24_);
			_g_free0 (_tmp24_);
		} else {
			const gchar* _tmp25_;
			_tmp25_ = name;
			if (!xnp_application_name_is_valid (self, _tmp25_)) {
				_g_object_unref0 (entry);
				_g_object_unref0 (content_area);
				_g_object_unref0 (dialog);
				return;
			}
			{
				gchar* path = NULL;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				gchar* _tmp29_;
				GFile* group_dir = NULL;
				const gchar* _tmp30_;
				GFile* _tmp31_;
				GFile* _tmp32_;
				const gchar* _tmp33_;
				GFile* _tmp34_;
				GFile* _tmp35_;
				const gchar* _tmp36_;
				_tmp26_ = self->priv->_notes_path;
				_tmp27_ = xnp_window_get_name (window);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strdup_printf ("%s/%s", _tmp26_, _tmp28_);
				path = _tmp29_;
				_tmp30_ = path;
				_tmp31_ = g_file_new_for_path (_tmp30_);
				group_dir = _tmp31_;
				_tmp32_ = group_dir;
				_tmp33_ = name;
				_tmp34_ = g_file_set_display_name (_tmp32_, _tmp33_, NULL, &_inner_error0_);
				_tmp35_ = _tmp34_;
				_g_object_unref0 (_tmp35_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (group_dir);
					_g_free0 (path);
					goto __catch0_g_error;
				}
				_tmp36_ = name;
				xnp_window_set_name (window, _tmp36_);
				self->priv->window_list = g_slist_sort (self->priv->window_list, (GCompareFunc) xnp_window_compare_func);
				xnp_application_window_monitor_list_remove (self, window);
				xnp_application_window_monitor_list_add (self, window);
				_g_object_unref0 (group_dir);
				_g_free0 (path);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp37_;
				const gchar* _tmp38_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp37_ = e;
				_tmp38_ = _tmp37_->message;
				xnp_window_popup_error (window, _tmp38_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (entry);
				_g_object_unref0 (content_area);
				_g_object_unref0 (dialog);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_tmp39_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp39_);
	_g_object_unref0 (entry);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
}

/**
 * delete_window:
 *
 * Delete the window.
 */
static void
xnp_application_delete_window (XnpApplication* self,
                               XnpWindow* window)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gchar* name = NULL;
	gchar* path = NULL;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GSList* _tmp37_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = xnp_window_get_empty (window);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		GtkMessageDialog* dialog = NULL;
		GtkMessageDialog* _tmp2_;
		GtkMessageDialog* _tmp3_;
		GtkMessageDialog* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gint res = 0;
		GtkMessageDialog* _tmp7_;
		GtkMessageDialog* _tmp8_;
		_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, "%s", _ ("Are you sure you want to delete this group?"));
		g_object_ref_sink (_tmp2_);
		dialog = _tmp2_;
		_tmp3_ = dialog;
		gtk_window_set_icon_name ((GtkWindow*) _tmp3_, "gtk-delete");
		_tmp4_ = dialog;
		_tmp5_ = xnp_window_get_name (window);
		_tmp6_ = _tmp5_;
		gtk_window_set_title ((GtkWindow*) _tmp4_, _tmp6_);
		_tmp7_ = dialog;
		res = gtk_dialog_run ((GtkDialog*) _tmp7_);
		_tmp8_ = dialog;
		xnp_window_dialog_destroy (window, (GtkDialog*) _tmp8_);
		if (res != ((gint) GTK_RESPONSE_YES)) {
			_g_object_unref0 (dialog);
			return;
		}
		_g_object_unref0 (dialog);
	}
	_tmp9_ = self->priv->_notes_path;
	_tmp10_ = xnp_window_get_name (window);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("%s/%s", _tmp9_, _tmp11_);
	path = _tmp12_;
	{
		GDir* dir = NULL;
		const gchar* _tmp13_;
		GDir* _tmp14_;
		const gchar* _tmp25_;
		GFile* _tmp26_;
		GFile* _tmp27_;
		_tmp13_ = path;
		_tmp14_ = g_dir_open (_tmp13_, (guint) 0, &_inner_error0_);
		dir = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		while (TRUE) {
			GDir* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			GFile* _tmp23_;
			GFile* _tmp24_;
			_tmp15_ = dir;
			_tmp16_ = g_dir_read_name (_tmp15_);
			_tmp17_ = g_strdup (_tmp16_);
			_g_free0 (name);
			name = _tmp17_;
			_tmp18_ = name;
			if (!(_tmp18_ != NULL)) {
				break;
			}
			_tmp19_ = path;
			_tmp20_ = name;
			_tmp21_ = g_strdup_printf ("%s/%s", _tmp19_, _tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_file_new_for_path (_tmp22_);
			_tmp24_ = _tmp23_;
			g_file_delete (_tmp24_, NULL, &_inner_error0_);
			_g_object_unref0 (_tmp24_);
			_g_free0 (_tmp22_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_dir_close0 (dir);
				goto __catch0_g_error;
			}
		}
		_tmp25_ = path;
		_tmp26_ = g_file_new_for_path (_tmp25_);
		_tmp27_ = _tmp26_;
		g_file_delete (_tmp27_, NULL, &_inner_error0_);
		_g_object_unref0 (_tmp27_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_dir_close0 (dir);
			goto __catch0_g_error;
		}
		_g_dir_close0 (dir);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		XnpWindow* win = NULL;
		const gchar* _tmp33_;
		XnpWindow* _tmp34_;
		XnpWindow* _tmp35_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp28_ = e;
		_tmp29_ = _tmp28_->message;
		xnp_window_popup_error (window, _tmp29_);
		_tmp30_ = xnp_window_get_name (window);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strdup (_tmp31_);
		_g_free0 (name);
		name = _tmp32_;
		xnp_application_destroy_window (self, window);
		_tmp33_ = name;
		_tmp34_ = xnp_application_create_window (self, _tmp33_);
		win = _tmp34_;
		_tmp35_ = win;
		if (_tmp35_ != NULL) {
			XnpWindow* _tmp36_;
			_tmp36_ = win;
			gtk_widget_show ((GtkWidget*) _tmp36_);
		}
		_g_object_unref0 (win);
		_g_error_free0 (e);
		_g_free0 (path);
		_g_free0 (name);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (path);
		_g_free0 (name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp37_ = self->priv->window_list;
	if (g_slist_length (_tmp37_) < ((guint) 2)) {
		XnpWindow* new_win = NULL;
		XnpWindow* _tmp38_;
		XnpWindow* _tmp39_;
		xnp_application_destroy_window (self, window);
		_tmp38_ = xnp_application_create_window (self, NULL);
		new_win = _tmp38_;
		_tmp39_ = new_win;
		if (_tmp39_ != NULL) {
			XnpWindow* _tmp40_;
			_tmp40_ = new_win;
			gtk_widget_show ((GtkWidget*) _tmp40_);
		}
		_g_object_unref0 (new_win);
	} else {
		XnpWindow* new_focus = NULL;
		XnpWindow* _tmp41_;
		XnpWindow* _tmp42_;
		XnpWindow* _tmp43_;
		XnpWindow* _tmp44_;
		_tmp41_ = xnp_application_get_next_focus (self);
		_tmp42_ = _tmp41_;
		_tmp43_ = _g_object_ref0 (_tmp42_);
		new_focus = _tmp43_;
		_tmp44_ = new_focus;
		if (_tmp44_ != NULL) {
			XnpWindow* _tmp45_;
			XnpWindow* _tmp46_;
			gboolean _tmp47_;
			gboolean _tmp48_;
			_tmp45_ = new_focus;
			gtk_window_set_skip_taskbar_hint ((GtkWindow*) _tmp45_, FALSE);
			xnp_application_destroy_window (self, window);
			_tmp46_ = new_focus;
			_tmp47_ = xnp_application_get_skip_taskbar_hint (self);
			_tmp48_ = _tmp47_;
			gtk_window_set_skip_taskbar_hint ((GtkWindow*) _tmp46_, _tmp48_);
		} else {
			xnp_application_destroy_window (self, window);
		}
		_g_object_unref0 (new_focus);
	}
	_g_free0 (path);
	_g_free0 (name);
}

/**
 * destroy_window:
 *
 * Destroy window and forget it exists.
 */
static void
xnp_application_destroy_window (XnpApplication* self,
                                XnpWindow* window)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	xnp_application_window_monitor_list_remove (self, window);
	self->priv->window_list = vala_g_slist_remove_full (self->priv->window_list, window, _g_object_unref0_);
	self->priv->focus_order = vala_g_slist_remove_full (self->priv->focus_order, window, _g_object_unref0_);
	gtk_widget_destroy ((GtkWidget*) window);
}

/**
 * refresh_notes:
 *
 * Prompt for reloading notes from disk.
 */
static void
xnp_application_refresh_notes (XnpApplication* self,
                               XnpWindow* window)
{
	GtkMessageDialog* dialog = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GtkMessageDialog* _tmp2_;
	GtkMessageDialog* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GtkMessageDialog* _tmp6_;
	GtkMessageDialog* _tmp7_;
	gint res = 0;
	GtkMessageDialog* _tmp8_;
	GtkMessageDialog* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = xnp_window_get_name (window);
	_tmp1_ = _tmp0_;
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, _ ("The group \"%s\" has been modified on the disk"), _tmp1_);
	g_object_ref_sink (_tmp2_);
	dialog = _tmp2_;
	_tmp3_ = dialog;
	_tmp4_ = xnp_window_get_name (window);
	_tmp5_ = _tmp4_;
	gtk_window_set_title ((GtkWindow*) _tmp3_, _tmp5_);
	_tmp6_ = dialog;
	gtk_window_set_icon_name ((GtkWindow*) _tmp6_, "org.xfce.notes");
	_tmp7_ = dialog;
	gtk_message_dialog_format_secondary_text (_tmp7_, "%s", _ ("Do you want to reload the group?"));
	_tmp8_ = dialog;
	res = gtk_dialog_run ((GtkDialog*) _tmp8_);
	_tmp9_ = dialog;
	xnp_window_dialog_destroy (window, (GtkDialog*) _tmp9_);
	if (res == ((gint) GTK_RESPONSE_YES)) {
		gchar* name = NULL;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		XnpWindow* win = NULL;
		const gchar* _tmp13_;
		XnpWindow* _tmp14_;
		XnpWindow* _tmp15_;
		xnp_application_save_windows_configuration (self);
		_tmp10_ = xnp_window_get_name (window);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup (_tmp11_);
		name = _tmp12_;
		xnp_application_destroy_window (self, window);
		_tmp13_ = name;
		_tmp14_ = xnp_application_create_window (self, _tmp13_);
		win = _tmp14_;
		_tmp15_ = win;
		if (_tmp15_ != NULL) {
			XnpWindow* _tmp16_;
			_tmp16_ = win;
			gtk_widget_show ((GtkWidget*) _tmp16_);
		}
		_g_object_unref0 (win);
		_g_free0 (name);
	} else {
		xnp_application_set_data_value (self, (GObject*) window, "external-change", FALSE);
		xnp_window_set_show_refresh_button (window, FALSE);
		xnp_window_save_notes (window);
	}
	_g_object_unref0 (dialog);
}

/**
 * get_window_list:
 *
 * Get the window_list property value.
 */
GSList*
xnp_application_get_window_list (XnpApplication* self)
{
	GSList* _tmp0_;
	GSList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->window_list;
	result = _tmp0_;
	return result;
}

/**
 * window_monitor_list_add:
 *
 * Creates an Xnp.WindowMonitor object and stores it inside window_monitor_list.
 */
static void
__lambda8_ (XnpApplication* self,
            XnpWindow* window)
{
	g_return_if_fail (window != NULL);
	if (xnp_application_get_data_value (self, (GObject*) window, "internal-change")) {
		xnp_application_set_data_value (self, (GObject*) window, "internal-change", FALSE);
	} else {
		xnp_application_set_data_value (self, (GObject*) window, "external-change", TRUE);
		xnp_window_set_show_refresh_button (window, TRUE);
	}
}

static void
___lambda8__xnp_window_monitor_window_updated (XnpWindowMonitor* _sender,
                                               XnpWindow* window,
                                               gpointer self)
{
	__lambda8_ ((XnpApplication*) self, window);
}

static void
xnp_application_window_monitor_list_add (XnpApplication* self,
                                         XnpWindow* window)
{
	GFile* file = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	XnpWindowMonitor* monitor = NULL;
	XnpWindowMonitor* _tmp7_;
	XnpWindowMonitor* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->_notes_path;
	_tmp1_ = xnp_window_get_name (window);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%s/%s", _tmp0_, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_new_for_path (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	file = _tmp6_;
	_tmp7_ = xnp_window_monitor_new (window, file);
	monitor = _tmp7_;
	g_signal_connect_object (monitor, "window-updated", (GCallback) ___lambda8__xnp_window_monitor_window_updated, self, 0);
	_tmp8_ = _g_object_ref0 (monitor);
	self->priv->window_monitor_list = g_slist_prepend (self->priv->window_monitor_list, _tmp8_);
	_g_object_unref0 (monitor);
	_g_object_unref0 (file);
}

/**
 * window_monitor_list_remove:
 *
 * Removes a monitor from window_monitor_list matching @window.
 */
static void
xnp_application_window_monitor_list_remove (XnpApplication* self,
                                            XnpWindow* window)
{
	XnpWindowMonitor* monitor = NULL;
	XnpWindowMonitor* _tmp0_;
	XnpWindowMonitor* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = xnp_application_window_monitor_list_lookup (self, window);
	monitor = _tmp0_;
	_tmp1_ = monitor;
	if (_tmp1_ != NULL) {
		XnpWindowMonitor* _tmp2_;
		_tmp2_ = monitor;
		self->priv->window_monitor_list = vala_g_slist_remove_full (self->priv->window_monitor_list, _tmp2_, _g_object_unref0_);
	}
	_g_object_unref0 (monitor);
}

/**
 * window_monitor_list_lookup:
 *
 * Returns the window_monitor object that contains @window from the window_monitor_list.
 */
static XnpWindowMonitor*
xnp_application_window_monitor_list_lookup (XnpApplication* self,
                                            XnpWindow* window)
{
	XnpWindowMonitor* window_monitor = NULL;
	GSList* _tmp0_;
	XnpWindowMonitor* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	window_monitor = NULL;
	_tmp0_ = self->priv->window_monitor_list;
	{
		GSList* monitor_collection = NULL;
		GSList* monitor_it = NULL;
		monitor_collection = _tmp0_;
		for (monitor_it = monitor_collection; monitor_it != NULL; monitor_it = monitor_it->next) {
			XnpWindowMonitor* _tmp1_;
			XnpWindowMonitor* monitor = NULL;
			_tmp1_ = _g_object_ref0 ((XnpWindowMonitor*) monitor_it->data);
			monitor = _tmp1_;
			{
				XnpWindowMonitor* _tmp2_;
				XnpWindow* _tmp3_;
				_tmp2_ = monitor;
				_tmp3_ = _tmp2_->window;
				if (_tmp3_ == window) {
					XnpWindowMonitor* _tmp4_;
					XnpWindowMonitor* _tmp5_;
					_tmp4_ = monitor;
					_tmp5_ = _g_object_ref0 (_tmp4_);
					_g_object_unref0 (window_monitor);
					window_monitor = _tmp5_;
					_g_object_unref0 (monitor);
					break;
				}
				_g_object_unref0 (monitor);
			}
		}
	}
	result = window_monitor;
	return result;
}

/**
 * get_data_value:
 *
 * Convenience function to return a GObject data boolean value.
 */
static gboolean
xnp_application_get_data_value (XnpApplication* self,
                                GObject* object,
                                const gchar* data)
{
	gconstpointer _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (object != NULL, FALSE);
	g_return_val_if_fail (data != NULL, FALSE);
	_tmp0_ = g_object_get_data (object, data);
	result = (gboolean) ((gintptr) _tmp0_);
	return result;
}

/**
 * set_data_value:
 *
 * Convenience function to set a GObject data boolean value.
 */
static void
xnp_application_set_data_value (XnpApplication* self,
                                GObject* object,
                                const gchar* data,
                                gboolean val)
{
	void* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = GINT_TO_POINTER ((gint) val);
	g_object_set_data_full (object, data, _tmp0_, NULL);
}

/**
 * window_name_exists:
 *
 * Verify if the given name already exists in the window list.
 */
static gboolean
xnp_application_window_name_exists (XnpApplication* self,
                                    const gchar* name)
{
	GSList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->window_list;
	{
		GSList* win_collection = NULL;
		GSList* win_it = NULL;
		win_collection = _tmp0_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* _tmp1_;
			XnpWindow* win = NULL;
			_tmp1_ = _g_object_ref0 ((XnpWindow*) win_it->data);
			win = _tmp1_;
			{
				XnpWindow* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp2_ = win;
				_tmp3_ = xnp_window_get_name (_tmp2_);
				_tmp4_ = _tmp3_;
				if (g_strcmp0 (_tmp4_, name) == 0) {
					result = TRUE;
					_g_object_unref0 (win);
					return result;
				}
				_g_object_unref0 (win);
			}
		}
	}
	result = FALSE;
	return result;
}

/**
 * name_is_valid:
 *
 * Verify if the given name is valid for window and notes.
 */
static gboolean
xnp_application_name_is_valid (XnpApplication* self,
                               const gchar* name)
{
	gboolean res = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	res = g_regex_match_simple ("^[^*|/\\:\"<>?]+$", name, 0, 0);
	if (!res) {
		GtkMessageDialog* error_dialog = NULL;
		GtkMessageDialog* _tmp0_;
		GtkMessageDialog* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GtkMessageDialog* _tmp4_;
		GtkMessageDialog* _tmp5_;
		GtkMessageDialog* _tmp6_;
		GtkMessageDialog* _tmp7_;
		_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, 0, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _ ("The name \"%s\" is invalid."), name);
		g_object_ref_sink (_tmp0_);
		error_dialog = _tmp0_;
		_tmp1_ = error_dialog;
		_tmp2_ = g_strdup_printf (_ ("The invalid characters are: %s"), "<tt>*|/\\:\"&lt;&gt;?</tt>");
		_tmp3_ = _tmp2_;
		gtk_message_dialog_format_secondary_markup (_tmp1_, "%s", _tmp3_);
		_g_free0 (_tmp3_);
		_tmp4_ = error_dialog;
		gtk_window_set_icon_name ((GtkWindow*) _tmp4_, "gtk-dialog-error");
		_tmp5_ = error_dialog;
		gtk_window_set_title ((GtkWindow*) _tmp5_, _ ("Error"));
		_tmp6_ = error_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp6_);
		_tmp7_ = error_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp7_);
		_g_object_unref0 (error_dialog);
	}
	result = res;
	return result;
}

/**
 * show_hide_notes:
 *
 * Show all the notes or hide them if they are all shown.
 */
void
xnp_application_show_hide_notes (XnpApplication* self)
{
	gboolean invisible_found = FALSE;
	gboolean visible_found = FALSE;
	gboolean active_found = FALSE;
	GSList* _tmp0_;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	invisible_found = FALSE;
	visible_found = FALSE;
	active_found = FALSE;
	_tmp0_ = self->priv->window_list;
	{
		GSList* win_collection = NULL;
		GSList* win_it = NULL;
		win_collection = _tmp0_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* _tmp1_;
			XnpWindow* win = NULL;
			_tmp1_ = _g_object_ref0 ((XnpWindow*) win_it->data);
			win = _tmp1_;
			{
				XnpWindow* _tmp2_;
				gboolean _tmp3_;
				gboolean _tmp4_;
				XnpWindow* _tmp5_;
				_tmp2_ = win;
				g_object_get ((GtkWindow*) _tmp2_, "is-active", &_tmp3_, NULL);
				_tmp4_ = _tmp3_;
				if (_tmp4_) {
					active_found = TRUE;
				}
				_tmp5_ = win;
				if (!gtk_widget_get_visible ((GtkWidget*) _tmp5_)) {
					invisible_found = TRUE;
				} else {
					visible_found = TRUE;
				}
				_g_object_unref0 (win);
			}
		}
	}
	if (!active_found) {
		_tmp6_ = visible_found;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		xnp_application_present_windows (self);
	} else {
		if (invisible_found) {
			xnp_application_show_windows (self);
		} else {
			xnp_application_hide_windows (self);
		}
	}
}

/**
 * present_windows:
 *
 * Present visible notes windows.
 */
static void
xnp_application_present_windows (XnpApplication* self)
{
	GSList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->focus_order;
	{
		GSList* win_collection = NULL;
		GSList* win_it = NULL;
		win_collection = _tmp0_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* _tmp1_;
			XnpWindow* win = NULL;
			_tmp1_ = _g_object_ref0 ((XnpWindow*) win_it->data);
			win = _tmp1_;
			{
				XnpWindow* _tmp2_;
				_tmp2_ = win;
				if (gtk_widget_get_visible ((GtkWidget*) _tmp2_)) {
					XnpWindow* _tmp3_;
					_tmp3_ = win;
					gtk_window_present ((GtkWindow*) _tmp3_);
				}
				_g_object_unref0 (win);
			}
		}
	}
}

/**
 * show_windows:
 *
 * Show all notes windows.
 */
static void
xnp_application_show_windows (XnpApplication* self)
{
	XnpWindow* focus = NULL;
	GSList* _tmp0_;
	GSList* _tmp1_;
	gconstpointer _tmp2_;
	XnpWindow* _tmp3_;
	GSList* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->focus_order;
	_tmp1_ = g_slist_last (_tmp0_);
	_tmp2_ = _tmp1_->data;
	_tmp3_ = _g_object_ref0 ((XnpWindow*) _tmp2_);
	focus = _tmp3_;
	_tmp4_ = self->priv->focus_order;
	{
		GSList* win_collection = NULL;
		GSList* win_it = NULL;
		win_collection = _tmp4_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* _tmp5_;
			XnpWindow* win = NULL;
			_tmp5_ = _g_object_ref0 ((XnpWindow*) win_it->data);
			win = _tmp5_;
			{
				XnpWindow* _tmp6_;
				XnpWindow* _tmp7_;
				_tmp6_ = win;
				_tmp7_ = focus;
				if (_tmp6_ != _tmp7_) {
					XnpWindow* _tmp8_;
					XnpWindow* _tmp9_;
					XnpWindow* _tmp10_;
					_tmp8_ = win;
					gtk_window_set_focus_on_map ((GtkWindow*) _tmp8_, FALSE);
					_tmp9_ = win;
					gtk_widget_show ((GtkWidget*) _tmp9_);
					_tmp10_ = win;
					gtk_window_set_focus_on_map ((GtkWindow*) _tmp10_, TRUE);
				} else {
					XnpWindow* _tmp11_;
					XnpWindow* _tmp12_;
					_tmp11_ = win;
					gtk_widget_show ((GtkWidget*) _tmp11_);
					_tmp12_ = win;
					gtk_window_present ((GtkWindow*) _tmp12_);
				}
				_g_object_unref0 (win);
			}
		}
	}
	_g_object_unref0 (focus);
}

/**
 * hide_windows:
 *
 * Hide all notes windows.
 */
static void
xnp_application_hide_windows (XnpApplication* self)
{
	GSList* _tmp0_;
	GSList* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->lock_focus_order = TRUE;
	_tmp0_ = self->priv->focus_order;
	_tmp1_ = g_slist_copy (_tmp0_);
	{
		GSList* win_collection = NULL;
		GSList* win_it = NULL;
		win_collection = _tmp1_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* win = NULL;
			win = (XnpWindow*) win_it->data;
			{
				XnpWindow* _tmp2_;
				_tmp2_ = win;
				xnp_window_hide (_tmp2_);
			}
		}
		(win_collection == NULL) ? NULL : (win_collection = (g_slist_free (win_collection), NULL));
	}
	self->priv->lock_focus_order = FALSE;
}

/**
 * open_settings_dialog:
 *
 * Open the settings dialog.
 */
void
xnp_application_open_settings_dialog (XnpApplication* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		g_spawn_command_line_async ("xfce4-notes-settings", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GtkMessageDialog* error_dialog = NULL;
		GtkMessageDialog* _tmp0_;
		GtkMessageDialog* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		GtkMessageDialog* _tmp4_;
		GtkMessageDialog* _tmp5_;
		GtkMessageDialog* _tmp6_;
		GtkMessageDialog* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", _ ("Unable to open the settings dialog"));
		g_object_ref_sink (_tmp0_);
		error_dialog = _tmp0_;
		_tmp1_ = error_dialog;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		gtk_message_dialog_format_secondary_text (_tmp1_, "%s", _tmp3_);
		_tmp4_ = error_dialog;
		gtk_window_set_icon_name ((GtkWindow*) _tmp4_, "gtk-dialog-error");
		_tmp5_ = error_dialog;
		gtk_window_set_title ((GtkWindow*) _tmp5_, _ ("Error"));
		_tmp6_ = error_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp6_);
		_tmp7_ = error_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp7_);
		_g_object_unref0 (error_dialog);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
 * open_about_dialog:
 *
 * Open the about dialog.
 */
void
xnp_application_open_about_dialog (XnpApplication* self)
{
	gchar** authors = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gint authors_length1;
	gint _authors_size_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("© 2003 Jakob Henriksson");
	_tmp1_ = g_strdup ("© 2006 Mike Massonnet");
	_tmp2_ = g_strdup ("© 2023 Arthur Demchenkov");
	_tmp3_ = g_new0 (gchar*, 4 + 1);
	_tmp3_[0] = _tmp0_;
	_tmp3_[1] = _tmp1_;
	_tmp3_[2] = _tmp2_;
	_tmp3_[3] = NULL;
	authors = _tmp3_;
	authors_length1 = 4;
	_authors_size_ = authors_length1;
	_tmp4_ = xfce_get_license_text (XFCE_LICENSE_TEXT_GPL);
	gtk_show_about_dialog (NULL, "program-name", _ ("Notes"), "logo-icon-name", "org.xfce.notes.logo", "comments", _ ("Ideal for your quick notes"), "version", PACKAGE_VERSION, "copyright", "Copyright © 2003-2024 The Xfce development team", "license", _tmp4_, "website", "https://docs.xfce.org/panel-plugins/xfce4-notes-plugin", "website-label", "docs.xfce.org", "authors", authors, "translator-credits", _ ("translator-credits"), NULL, NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}

/**
 * context_menu:
 *
 * Provides a GtkMenu to be used for right click context menus
 * like in trayicons. Its items are destroyed/refreshed every
 * time the menu is shown.
 */
static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		XnpApplication* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->menu);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda17_ (XnpApplication* self,
             GtkWidget* w)
{
	g_return_if_fail (w != NULL);
	gtk_widget_destroy (w);
}

static void
___lambda17__gtk_callback (GtkWidget* widget,
                           gpointer self)
{
	__lambda17_ ((XnpApplication*) self, widget);
}

static void
____lambda18_ (XnpApplication* self,
               GtkMenuItem* i)
{
	XnpWindow* w = NULL;
	gconstpointer _tmp0_;
	XnpWindow* _tmp1_;
	g_return_if_fail (i != NULL);
	_tmp0_ = g_object_get_data ((GObject*) i, "window");
	_tmp1_ = _g_object_ref0 ((XnpWindow*) _tmp0_);
	w = _tmp1_;
	gtk_window_present ((GtkWindow*) w);
	_g_object_unref0 (w);
}

static void
_____lambda18__gtk_menu_item_activate (GtkMenuItem* _sender,
                                       gpointer self)
{
	____lambda18_ ((XnpApplication*) self, _sender);
}

static void
__lambda19_ (XnpApplication* self)
{
	XnpWindow* new_win = NULL;
	XnpWindow* _tmp0_;
	XnpWindow* _tmp1_;
	_tmp0_ = xnp_application_create_window (self, NULL);
	new_win = _tmp0_;
	_tmp1_ = new_win;
	if (_tmp1_ != NULL) {
		XnpWindow* _tmp2_;
		_tmp2_ = new_win;
		gtk_widget_show ((GtkWidget*) _tmp2_);
	}
	_g_object_unref0 (new_win);
}

static void
___lambda19__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda19_ ((XnpApplication*) self);
}

static void
__lambda16_ (Block2Data* _data2_)
{
	XnpApplication* self;
	GSList* _tmp0_;
	GtkSeparatorMenuItem* mi_sep = NULL;
	GtkSeparatorMenuItem* _tmp10_;
	GtkImageMenuItem* mi_add = NULL;
	GtkImageMenuItem* _tmp11_;
	GtkImage* image = NULL;
	GtkImage* _tmp12_;
	self = _data2_->self;
	gtk_container_foreach ((GtkContainer*) _data2_->menu, ___lambda17__gtk_callback, self);
	_tmp0_ = self->priv->window_list;
	{
		GSList* win_collection = NULL;
		GSList* win_it = NULL;
		win_collection = _tmp0_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* _tmp1_;
			XnpWindow* win = NULL;
			_tmp1_ = _g_object_ref0 ((XnpWindow*) win_it->data);
			win = _tmp1_;
			{
				GtkMenuItem* mi = NULL;
				XnpWindow* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				GtkMenuItem* _tmp5_;
				GtkMenuItem* _tmp6_;
				XnpWindow* _tmp7_;
				GtkMenuItem* _tmp8_;
				GtkMenuItem* _tmp9_;
				_tmp2_ = win;
				_tmp3_ = xnp_window_get_name (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp4_);
				g_object_ref_sink (_tmp5_);
				mi = _tmp5_;
				_tmp6_ = mi;
				_tmp7_ = win;
				g_object_set_data_full ((GObject*) _tmp6_, "window", (void*) _tmp7_, NULL);
				_tmp8_ = mi;
				g_signal_connect_object (_tmp8_, "activate", (GCallback) _____lambda18__gtk_menu_item_activate, self, 0);
				_tmp9_ = mi;
				gtk_menu_shell_append ((GtkMenuShell*) _data2_->menu, _tmp9_);
				_g_object_unref0 (mi);
				_g_object_unref0 (win);
			}
		}
	}
	_tmp10_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp10_);
	mi_sep = _tmp10_;
	gtk_menu_shell_append ((GtkMenuShell*) _data2_->menu, (GtkMenuItem*) mi_sep);
	_tmp11_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (_ ("_Add a new group"));
	g_object_ref_sink (_tmp11_);
	mi_add = _tmp11_;
	g_signal_connect_object ((GtkMenuItem*) mi_add, "activate", (GCallback) ___lambda19__gtk_menu_item_activate, self, 0);
	_tmp12_ = (GtkImage*) gtk_image_new_from_icon_name ("gtk-add", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp12_);
	image = _tmp12_;
	gtk_image_menu_item_set_image (mi_add, (GtkWidget*) image);
	gtk_menu_shell_append ((GtkMenuShell*) _data2_->menu, (GtkMenuItem*) mi_add);
	gtk_widget_show_all ((GtkWidget*) _data2_->menu);
	_g_object_unref0 (image);
	_g_object_unref0 (mi_add);
	_g_object_unref0 (mi_sep);
}

static void
___lambda16__gtk_widget_show (GtkWidget* _sender,
                              gpointer self)
{
	__lambda16_ (self);
}

GtkMenu*
xnp_application_context_menu (XnpApplication* self)
{
	Block2Data* _data2_;
	GtkMenu* _tmp0_;
	GtkMenu* _tmp1_;
	GtkMenu* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	_data2_->menu = _tmp0_;
	g_signal_connect_data ((GtkWidget*) _data2_->menu, "show", (GCallback) ___lambda16__gtk_widget_show, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp1_ = _g_object_ref0 (_data2_->menu);
	result = _tmp1_;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}

const gchar*
xnp_application_get_notes_path (XnpApplication* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_notes_path;
	result = _tmp0_;
	return result;
}

void
xnp_application_set_notes_path (XnpApplication* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = xnp_application_get_notes_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_notes_path);
		self->priv->_notes_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, xnp_application_properties[XNP_APPLICATION_NOTES_PATH_PROPERTY]);
	}
}

const gchar*
xnp_application_get_config_file (XnpApplication* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_config_file;
	result = _tmp0_;
	return result;
}

static void
xnp_application_set_config_file (XnpApplication* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = xnp_application_get_config_file (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_config_file);
		self->priv->_config_file = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, xnp_application_properties[XNP_APPLICATION_CONFIG_FILE_PROPERTY]);
	}
}

static void
_xnp_application_main_instance___lambda5_ (XnpApplication* self)
{
}

static void
__xnp_application_main_instance___lambda5__g_application_activate (GApplication* _sender,
                                                                   gpointer self)
{
	_xnp_application_main_instance___lambda5_ ((XnpApplication*) self);
}

static gboolean
xnp_application_get_main_instance (XnpApplication* self)
{
	gboolean result;
	GtkApplication* app = NULL;
	GtkApplication* _tmp0_;
	GtkApplication* _tmp1_;
	GtkApplication* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GtkApplication* _tmp7_;
	GtkApplication* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->system_tray_mode) {
		result = TRUE;
		return result;
	}
	_tmp0_ = gtk_application_new ("org.xfce.Notes", 0);
	app = _tmp0_;
	_tmp1_ = app;
	g_signal_connect_object ((GApplication*) _tmp1_, "activate", (GCallback) __xnp_application_main_instance___lambda5__g_application_activate, self, 0);
	{
		GtkApplication* _tmp2_;
		_tmp2_ = app;
		g_application_register ((GApplication*) _tmp2_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		_g_object_unref0 (app);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp3_;
	}
	_tmp4_ = app;
	_tmp5_ = g_application_get_is_remote ((GApplication*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		result = FALSE;
		_g_object_unref0 (app);
		return result;
	}
	_tmp7_ = app;
	g_application_run ((GApplication*) _tmp7_, (gint) 0, NULL);
	_tmp8_ = app;
	g_application_quit ((GApplication*) _tmp8_);
	result = TRUE;
	_g_object_unref0 (app);
	return result;
}

gboolean
xnp_application_get_skip_taskbar_hint (XnpApplication* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_skip_taskbar_hint;
	return result;
}

void
xnp_application_set_skip_taskbar_hint (XnpApplication* self,
                                       gboolean value)
{
	GSList* _tmp0_;
	g_return_if_fail (self != NULL);
	if (self->priv->_skip_taskbar_hint == value) {
		return;
	}
	self->priv->_skip_taskbar_hint = value;
	_tmp0_ = self->priv->window_list;
	{
		GSList* win_collection = NULL;
		GSList* win_it = NULL;
		win_collection = _tmp0_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* _tmp1_;
			XnpWindow* win = NULL;
			_tmp1_ = _g_object_ref0 ((XnpWindow*) win_it->data);
			win = _tmp1_;
			{
				XnpWindow* _tmp2_;
				_tmp2_ = win;
				gtk_window_set_skip_taskbar_hint ((GtkWindow*) _tmp2_, value);
				_g_object_unref0 (win);
			}
		}
	}
	g_object_notify_by_pspec ((GObject *) self, xnp_application_properties[XNP_APPLICATION_SKIP_TASKBAR_HINT_PROPERTY]);
}

XnpWindow*
xnp_application_get_next_focus (XnpApplication* self)
{
	XnpWindow* result;
	guint win_count = 0U;
	GSList* _tmp0_;
	XnpWindow* window = NULL;
	GSList* _tmp1_;
	gconstpointer _tmp2_;
	XnpWindow* _tmp3_;
	XnpWindow* _tmp4_ = NULL;
	XnpWindow* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->lock_focus_order) {
		result = NULL;
		return result;
	}
	_tmp0_ = self->priv->focus_order;
	win_count = g_slist_length (_tmp0_);
	if (win_count < ((guint) 2)) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->focus_order;
	_tmp2_ = g_slist_nth_data (_tmp1_, win_count - 2);
	_tmp3_ = _g_object_ref0 ((XnpWindow*) _tmp2_);
	window = _tmp3_;
	_tmp5_ = window;
	if (gtk_widget_get_visible ((GtkWidget*) _tmp5_)) {
		XnpWindow* _tmp6_;
		_tmp6_ = window;
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = NULL;
	}
	result = _tmp4_;
	_g_object_unref0 (window);
	return result;
}

static void
_xnp_application_quit_xfce_posix_signal_handler (gint signal,
                                                 gpointer self)
{
	xnp_application_quit ((XnpApplication*) self);
}

static void
_xnp_application___lambda20_ (XnpApplication* self)
{
	xnp_application_update_color (self);
}

static void
__xnp_application___lambda20__xfconf_g__channel_property_changed (XfconfChannel* _sender,
                                                                  const gchar* property,
                                                                  GValue* value,
                                                                  gpointer self)
{
	_xnp_application___lambda20_ ((XnpApplication*) self);
}

static void
_xnp_application___lambda21_ (XnpApplication* self)
{
	xnp_application_update_notes_path (self);
}

static void
__xnp_application___lambda21__xfconf_g__channel_property_changed (XfconfChannel* _sender,
                                                                  const gchar* property,
                                                                  GValue* value,
                                                                  gpointer self)
{
	_xnp_application___lambda21_ ((XnpApplication*) self);
}

static GObject *
xnp_application_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	XnpApplication * self;
	XfconfChannel* _tmp4_;
	XnpTheme* _tmp5_;
	XfconfChannel* _tmp6_;
	XfconfChannel* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	XfconfChannel* _tmp15_;
	gchar* name = NULL;
	gboolean found = FALSE;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (xnp_application_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_APPLICATION, XnpApplication);
	{
		xfce_posix_signal_handler_init (&_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		xfce_posix_signal_handler_set_handler ((gint) SIGTERM, _xnp_application_quit_xfce_posix_signal_handler, self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		xfce_posix_signal_handler_set_handler ((gint) SIGINT, _xnp_application_quit_xfce_posix_signal_handler, self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_critical ("application.vala:97: Unable to connect to UNIX signals. %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	{
		xfconf_init (&_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_critical ("application.vala:104: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp4_ = xfconf_channel_new_with_property_base ("xfce4-panel", "/plugins/notes");
	_g_object_unref0 (self->priv->xfconf_channel);
	self->priv->xfconf_channel = _tmp4_;
	xnp_application_update_version (self);
	_tmp5_ = xnp_theme_new ();
	_g_object_unref0 (self->priv->theme);
	self->priv->theme = _tmp5_;
	xnp_application_update_color (self);
	_tmp6_ = self->priv->xfconf_channel;
	g_signal_connect_object (_tmp6_, "property-changed::/global/background-color", (GCallback) __xnp_application___lambda20__xfconf_g__channel_property_changed, self, 0);
	_tmp7_ = self->priv->xfconf_channel;
	xfconf_g_property_bind (_tmp7_, "/global/skip-taskbar-hint", G_TYPE_BOOLEAN, self, "skip-taskbar-hint");
	_tmp8_ = g_get_user_data_dir ();
	_tmp9_ = g_strdup_printf ("%s/notes", _tmp8_);
	_g_free0 (self->priv->default_notes_path);
	self->priv->default_notes_path = _tmp9_;
	_tmp10_ = self->priv->_notes_path;
	if (_tmp10_ == NULL) {
		XfconfChannel* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp11_ = self->priv->xfconf_channel;
		_tmp12_ = self->priv->default_notes_path;
		_tmp13_ = xfconf_channel_get_string (_tmp11_, "/global/notes-path", _tmp12_);
		_tmp14_ = _tmp13_;
		xnp_application_set_notes_path (self, _tmp14_);
		_g_free0 (_tmp14_);
	}
	_tmp15_ = self->priv->xfconf_channel;
	g_signal_connect_object (_tmp15_, "property-changed::/global/notes-path", (GCallback) __xnp_application___lambda21__xfconf_g__channel_property_changed, self, 0);
	found = FALSE;
	{
		GSList* groups = NULL;
		GDir* dir = NULL;
		const gchar* _tmp16_;
		GDir* _tmp17_;
		GSList* _tmp24_;
		groups = NULL;
		_tmp16_ = self->priv->_notes_path;
		_tmp17_ = g_dir_open (_tmp16_, (guint) 0, &_inner_error0_);
		dir = _tmp17_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			(groups == NULL) ? NULL : (groups = (_g_slist_free__g_free0_ (groups), NULL));
			goto __catch2_g_error;
		}
		while (TRUE) {
			GDir* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp18_ = dir;
			_tmp19_ = g_dir_read_name (_tmp18_);
			_tmp20_ = g_strdup (_tmp19_);
			_g_free0 (name);
			name = _tmp20_;
			_tmp21_ = name;
			if (!(_tmp21_ != NULL)) {
				break;
			}
			_tmp22_ = name;
			_tmp23_ = g_strdup (_tmp22_);
			groups = g_slist_prepend (groups, _tmp23_);
			found = TRUE;
		}
		xnp_application_sort_groups_by_focus_order (self, &groups);
		_tmp24_ = groups;
		{
			GSList* group_name_collection = NULL;
			GSList* group_name_it = NULL;
			group_name_collection = _tmp24_;
			for (group_name_it = group_name_collection; group_name_it != NULL; group_name_it = group_name_it->next) {
				gchar* _tmp25_;
				gchar* group_name = NULL;
				_tmp25_ = g_strdup ((const gchar*) group_name_it->data);
				group_name = _tmp25_;
				{
					const gchar* _tmp26_;
					XnpWindow* _tmp27_;
					XnpWindow* _tmp28_;
					_tmp26_ = group_name;
					_tmp27_ = xnp_application_create_window (self, _tmp26_);
					_tmp28_ = _tmp27_;
					_g_object_unref0 (_tmp28_);
					_g_free0 (group_name);
				}
			}
		}
		_g_dir_close0 (dir);
		(groups == NULL) ? NULL : (groups = (_g_slist_free__g_free0_ (groups), NULL));
	}
	goto __finally2;
	__catch2_g_error:
	{
		const gchar* _tmp29_;
		g_clear_error (&_inner_error0_);
		_tmp29_ = self->priv->_notes_path;
		g_mkdir_with_parents (_tmp29_, 0700);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	if (found == FALSE) {
		XnpWindow* _tmp30_;
		XnpWindow* _tmp31_;
		_tmp30_ = xnp_application_create_window (self, NULL);
		_tmp31_ = _tmp30_;
		_g_object_unref0 (_tmp31_);
	}
	gtk_window_set_default_icon_name ("org.xfce.notes");
	_g_free0 (name);
	return obj;
}

static void
xnp_application_class_init (XnpApplicationClass * klass,
                            gpointer klass_data)
{
	xnp_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &XnpApplication_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_xnp_application_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_xnp_application_set_property;
	G_OBJECT_CLASS (klass)->constructor = xnp_application_constructor;
	G_OBJECT_CLASS (klass)->finalize = xnp_application_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_APPLICATION_NOTES_PATH_PROPERTY, xnp_application_properties[XNP_APPLICATION_NOTES_PATH_PROPERTY] = g_param_spec_string ("notes-path", "notes-path", "notes-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_APPLICATION_CONFIG_FILE_PROPERTY, xnp_application_properties[XNP_APPLICATION_CONFIG_FILE_PROPERTY] = g_param_spec_string ("config-file", "config-file", "config-file", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_APPLICATION_SKIP_TASKBAR_HINT_PROPERTY, xnp_application_properties[XNP_APPLICATION_SKIP_TASKBAR_HINT_PROPERTY] = g_param_spec_boolean ("skip-taskbar-hint", "skip-taskbar-hint", "skip-taskbar-hint", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_APPLICATION_NEXT_FOCUS_PROPERTY, xnp_application_properties[XNP_APPLICATION_NEXT_FOCUS_PROPERTY] = g_param_spec_object ("next-focus", "next-focus", "next-focus", XNP_TYPE_WINDOW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
xnp_application_instance_init (XnpApplication * self,
                               gpointer klass)
{
	self->priv = xnp_application_get_instance_private (self);
	self->system_tray_mode = FALSE;
	self->priv->lock_focus_order = FALSE;
	self->priv->save_config_timeout = (guint) 0;
	self->priv->_skip_taskbar_hint = TRUE;
}

static void
xnp_application_finalize (GObject * obj)
{
	XnpApplication * self;
	GSList* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_APPLICATION, XnpApplication);
	_g_object_unref0 (self->priv->xfconf_channel);
	self->priv->xfconf_channel = NULL;
	xfconf_shutdown ();
	if (self->priv->save_config_timeout != ((guint) 0)) {
		g_source_remove (self->priv->save_config_timeout);
	}
	_tmp0_ = self->priv->window_list;
	{
		GSList* win_collection = NULL;
		GSList* win_it = NULL;
		win_collection = _tmp0_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* _tmp1_;
			XnpWindow* win = NULL;
			_tmp1_ = _g_object_ref0 ((XnpWindow*) win_it->data);
			win = _tmp1_;
			{
				XnpWindow* _tmp2_;
				_tmp2_ = win;
				gtk_widget_destroy ((GtkWidget*) _tmp2_);
				_g_object_unref0 (win);
				win = NULL;
				_g_object_unref0 (win);
			}
		}
	}
	_g_free0 (self->priv->_notes_path);
	_g_free0 (self->priv->_config_file);
	(self->priv->window_monitor_list == NULL) ? NULL : (self->priv->window_monitor_list = (_g_slist_free__g_object_unref0_ (self->priv->window_monitor_list), NULL));
	(self->priv->window_list == NULL) ? NULL : (self->priv->window_list = (_g_slist_free__g_object_unref0_ (self->priv->window_list), NULL));
	(self->priv->focus_order == NULL) ? NULL : (self->priv->focus_order = (_g_slist_free__g_object_unref0_ (self->priv->focus_order), NULL));
	_g_object_unref0 (self->priv->xfconf_channel);
	_g_free0 (self->priv->default_notes_path);
	_g_object_unref0 (self->priv->theme);
	G_OBJECT_CLASS (xnp_application_parent_class)->finalize (obj);
}

static GType
xnp_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (XnpApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xnp_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XnpApplication), 0, (GInstanceInitFunc) xnp_application_instance_init, NULL };
	GType xnp_application_type_id;
	xnp_application_type_id = g_type_register_static (G_TYPE_OBJECT, "XnpApplication", &g_define_type_info, 0);
	XnpApplication_private_offset = g_type_add_instance_private (xnp_application_type_id, sizeof (XnpApplicationPrivate));
	return xnp_application_type_id;
}

GType
xnp_application_get_type (void)
{
	static volatile gsize xnp_application_type_id__once = 0;
	if (g_once_init_enter (&xnp_application_type_id__once)) {
		GType xnp_application_type_id;
		xnp_application_type_id = xnp_application_get_type_once ();
		g_once_init_leave (&xnp_application_type_id__once, xnp_application_type_id);
	}
	return xnp_application_type_id__once;
}

static void
_vala_xnp_application_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	XnpApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, XNP_TYPE_APPLICATION, XnpApplication);
	switch (property_id) {
		case XNP_APPLICATION_NOTES_PATH_PROPERTY:
		g_value_set_string (value, xnp_application_get_notes_path (self));
		break;
		case XNP_APPLICATION_CONFIG_FILE_PROPERTY:
		g_value_set_string (value, xnp_application_get_config_file (self));
		break;
		case XNP_APPLICATION_SKIP_TASKBAR_HINT_PROPERTY:
		g_value_set_boolean (value, xnp_application_get_skip_taskbar_hint (self));
		break;
		case XNP_APPLICATION_NEXT_FOCUS_PROPERTY:
		g_value_set_object (value, xnp_application_get_next_focus (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_xnp_application_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	XnpApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, XNP_TYPE_APPLICATION, XnpApplication);
	switch (property_id) {
		case XNP_APPLICATION_NOTES_PATH_PROPERTY:
		xnp_application_set_notes_path (self, g_value_get_string (value));
		break;
		case XNP_APPLICATION_CONFIG_FILE_PROPERTY:
		xnp_application_set_config_file (self, g_value_get_string (value));
		break;
		case XNP_APPLICATION_SKIP_TASKBAR_HINT_PROPERTY:
		xnp_application_set_skip_taskbar_hint (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

