#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */
#ifdef HAVE_STRING_H
#include <string.h>
#endif /* HAVE_STRING_H */
#include <libxfce4util/libxfce4util.h>
#include <libxfcegui4/libxfcegui4.h>
#include <assert.h>
#include <ctype.h>
#include "xfce-launcher-command-entry.h"

struct _XfceLauncherCommandEntry {
    GtkVBox parent;

    GtkEntry* exec_widget;
    
    /*char *name;
    char *comment;*/
    
    char *exec;

    /*LauncherIcon icon; */
    void* pad_1;
    void* pad_2;
    void* pad_3;
    void* pad_4;
};

static GtkVBox* parent_class = 0;

static void
xfce_launcher_command_entry_init(XfceLauncherCommandEntry* xfce_launcher_command_entry)
{
    /*gtk_container_set_border_width (GTK_CONTAINER (xfce_launcher_command_entry->widget), 7);*/
    xfce_launcher_command_entry->exec_widget = GTK_ENTRY (gtk_entry_new ());
    gtk_widget_show (GTK_WIDGET (xfce_launcher_command_entry->exec_widget));

    gtk_box_pack_start (GTK_BOX (xfce_launcher_command_entry), 
                        GTK_WIDGET (xfce_launcher_command_entry->exec_widget), 
                        TRUE, TRUE, 5);
    /* TODO xfce_launcher_command_entry_data_received */
    
}

static void
xfce_launcher_command_entry_update_data_from_gui(XfceLauncherCommandEntry* e)
{
  gchar const* exec = gtk_entry_get_text(GTK_ENTRY(e->exec_widget));

  if (e->exec != NULL) {
    g_free (e->exec);
    e->exec = NULL;
  }
  
  if (exec != NULL) {
    e->exec = g_strdup (exec);
  }
  
}

static void
xfce_launcher_command_entry_update_gui_from_data(XfceLauncherCommandEntry* e)
{
  gtk_entry_set_text(GTK_ENTRY(e->exec_widget), e->exec);
}

void
xfce_launcher_command_entry_set_command (XfceLauncherCommandEntry *e, gchar const* command)
{
    if (e->exec) {
      g_free (e->exec);
      e->exec = NULL;
    }
    
    assert (command != NULL);
    e->exec = g_strdup (command);
    
    xfce_launcher_command_entry_update_gui_from_data(e);
}

static void
xfce_launcher_command_entry_finalize (XfceLauncherCommandEntry *e)
{
      
/*    g_free (e->name);
    g_free (e->comment);
    if (e->icon.type == LAUNCHER_ICON_TYPE_NAME)
        g_free (e->icon.icon.name);
*/
    g_free (e->exec);

    g_free (e);
}

static void
xfce_launcher_command_entry_drop_cb (GdkScreen *screen, XfceLauncherCommandEntry *entry, 
                        GPtrArray *files)
{
    char **argv;
    int i, n;
    GError *error = NULL;

    n = files->len;
    
    argv = g_new (char *, n + 2);
    argv[0] = entry->exec;
    n = 1;

    for (i = 0; i < files->len; ++i)
        argv[n+i] = g_ptr_array_index (files, i);

    argv[n+i] = NULL;
    
    if (!xfce_exec_argv (argv, FALSE, FALSE, &error))
    {
        char *first = 
            g_strdup_printf (_("Could not run \"%s\""), entry->exec);
    
        xfce_message_dialog (NULL, _("Xfce Panel"), 
                             GTK_STOCK_DIALOG_ERROR, first, error->message,
                             GTK_STOCK_CLOSE, GTK_RESPONSE_OK, NULL);

        g_free (first);
                                    
        g_error_free (error);
    }

    g_free (argv);
}

GPtrArray *
launcher_get_file_list_from_selection_data (GtkSelectionData *data)
{
    GPtrArray *files;
    const char *s1, *s2;

    if (data->length < 1)
        return NULL;

    files = g_ptr_array_new ();

    /* Assume text/uri-list (RFC2483):
     * - Commented lines are allowed; they start with #.
     * - Lines are separated by CRLF (\r\n)
     * - We also allow LF (\n) as separator
     * - We strip "file:" and multiple slashes ("/") at the start
     */
    for (s1 = (const char *)data->data; s1 != NULL && strlen(s1); ++s1)
    {
        if (*s1 != '#')
        {
            while (isspace ((int)*s1))
                ++s1;
            
            if (!strncmp (s1, "file:", 5))
            {
                s1 += 5;
                while (*(s1 + 1) == '/')
                    ++s1;
            }
            
            for (s2 = s1; *s2 != '\0' && *s2 != '\r' && *s2 != '\n'; ++s2)
                /* */;
            
            if (s2 > s1)
            {
                while (isspace ((int)*(s2-1)))
                    --s2;
                
                if (s2 > s1)
                {
                    int len, i;
                    char *file;
                    
                    len = s2 - s1;
                    file = g_new (char, len + 1);
                    
                    /* decode % escaped characters */
                    for (i = 0, s2 = s1; s2 - s1 <= len; ++i, ++s2)
                    {
                        if (*s2 != '%' || s2 + 3 -s1 > len)
                        {
                            file[i] = *s2;
                        }
                        else
                        {
                            guint c;
                            
                            if (sscanf (s2+1, "%2x", &c) == 1)
                                file[i] = (char)c;

                            s2 += 2;
                        }
                    }

                    file[i-1] = '\0';
                    g_ptr_array_add (files, file);
                }
            }
        }
        
        if (!(s1 = strchr (s1, '\n')))
            break;
    }
    
    if (files->len > 0)
    {
        return files;
    }

    g_ptr_array_free (files, TRUE);

    return NULL;    
}

static void
xfce_launcher_command_entry_data_received (GtkWidget *widget, GdkDragContext *context, 
                              gint x, gint y, GtkSelectionData *data, 
                              guint info, guint time, XfceLauncherCommandEntry *entry)
{
    GPtrArray *files;
    
    if (!data || data->length < 1)
        return;
    
    files = launcher_get_file_list_from_selection_data (data);

    if (files)
    {
        xfce_launcher_command_entry_drop_cb (gtk_widget_get_screen (widget), entry, files);
        g_ptr_array_free (files, TRUE);
    }

/*    if (open_launcher)
    {
        gtk_widget_hide (GTK_MENU (open_launcher->menu)->toplevel);
        gtk_toggle_button_set_active (
                GTK_TOGGLE_BUTTON (open_launcher->arrowbutton), FALSE);
        open_launcher = NULL;
    }*/
}

gchar const* xfce_launcher_command_entry_get_command (XfceLauncherCommandEntry* e)
{
  xfce_launcher_command_entry_update_data_from_gui(e);

  if (e->exec) {
    return e->exec;
  } else {
    return NULL;
  }
}

static void xfce_launcher_command_entry_class_init(XfceLauncherCommandEntryClass* klass)
{
  parent_class = g_type_class_ref (GTK_TYPE_VBOX);
  
  G_OBJECT_CLASS(klass)->finalize = (GObjectFinalizeFunc) xfce_launcher_command_entry_finalize;
  
}

GType xfce_launcher_command_entry_get_type(void)
{
  static GType atype = 0;
  
  if (atype == 0) {
    static const GTypeInfo typeinfo = {
      sizeof(XfceLauncherCommandEntryClass),
      NULL, /* base_init */
      NULL, /* base_finalize */
      (GClassInitFunc) xfce_launcher_command_entry_class_init,
      NULL, /* class_finalize */
      NULL, /* class_data */
      sizeof(XfceLauncherCommandEntry),
      0, /* n_preallocs */
      (GInstanceInitFunc) xfce_launcher_command_entry_init,
    };
    
    atype = g_type_register_static(GTK_TYPE_VBOX,
      "XfceXfceLauncherCommandEntry", 
      &typeinfo, 
      0);
  }
  return atype;
}

XfceLauncherCommandEntry* xfce_launcher_command_entry_new(void)
{
  return g_object_new (xfce_launcher_command_entry_get_type (), NULL);
}

