/* $Id: xfce-menu-item.h,v 1.2 2004/08/04 22:26:40 bmeurer Exp $ */
/*-
 * Copyright (c) 2004 os-cillation
 * All rights reserved.
 *
 * Written by Benedikt Meurer <bm@os-cillation.de>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __XFCE_MENU_ITEM_H__
#define __XFCE_MENU_ITEM_H__

#include <gtk/gtk.h>

G_BEGIN_DECLS;

#define XFCE_TYPE_MENU_ITEM             (xfce_menu_item_get_type ())
#define XFCE_MENU_ITEM(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFCE_TYPE_MENU_ITEM, XfceMenuItem))
#define XFCE_MENU_ITEM_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), XFCE_TYPE_MENU_ITEM, XfceMenuItemClass))
#define XFCE_IS_MENU_ITEM(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFCE_TYPE_MENU_ITEM))
#define XFCE_IS_MENU_ITEM_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), XFCE_TYPE_MENU_ITEM))
#define XFCE_MENU_ITEM_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), XFCE_TYPE_MENU_ITEM, XfceMenuItemClass))


typedef struct _XfceMenuItemClass XfceMenuItemClass;
typedef struct _XfceMenuItem      XfceMenuItem;

struct _XfceMenuItemClass
{
  GtkImageMenuItemClass __parent__;
  GdkPixbuf            *default_icon;
  GtkTooltips          *tips;
};

struct _XfceMenuItem
{
  GtkImageMenuItem __parent__;

  GtkWidget       *label;
  GtkWidget       *image;

  gchar           *icon_name;
  gboolean         icon_valid;

  guint            idle_id;
};


GType        xfce_menu_item_get_type (void) G_GNUC_CONST;

GtkWidget   *xfce_menu_item_new      (const gchar  *text,
                                      const gchar  *icon,
                                      const gchar  *tip);

const gchar *xfce_menu_item_get_text (const XfceMenuItem *item);

void         xfce_menu_item_set_text (XfceMenuItem *item,
                                      const gchar  *text);

void         xfce_menu_item_set_icon (XfceMenuItem *item,
                                      const gchar  *icon);

void         xfce_menu_item_set_tip  (XfceMenuItem *item,
                                      const gchar  *tip);

G_END_DECLS;

#endif /* !__XFCE_MENU_ITEM_H__ */
