#ifndef PROPERTIES_H
#define PROPERTIES_H


class FXDialog;
class FXApp;
class PropertiesBox;

class PermFrame : public FXVerticalFrame
{
    FXDECLARE(PermFrame)
    friend class PropertiesBox;
private:
    PermFrame()
    {}
    FXCheckButton*    ur;
    FXCheckButton*    uw;
    FXCheckButton*    ux;
    FXCheckButton*    gr;
    FXCheckButton*    gw;
    FXCheckButton*    gx;
    FXCheckButton*    or_;
    FXCheckButton*    ow;
    FXCheckButton*    ox;
    FXRadioButton*    add;
    FXRadioButton*    clear;
    FXRadioButton*    set;
    FXCheckButton*    rec;
    FXCheckButton*    dironly;
    FXComboBox*       user;
    FXComboBox*       userbis;
    FXComboBox*       grp;
public:
    PermFrame(FXComposite *parent,FXObject *target);
};
class PropertiesBox : public FXDialogBox
{
    FXDECLARE(PropertiesBox)

private:
    PropertiesBox()
    {}
    FXLabel		*fileSize;
    FXString 	*files;
    FXString 	source;
	FXString	parentdir;
    FXString 	oldusr;
    FXString 	oldgrp;
    int num;
    FXCheckButton*    ur;
    FXCheckButton*    uw;
    FXCheckButton*    ux;
    FXCheckButton*    gr;
    FXCheckButton*    gw;
    FXCheckButton*    gx;
    FXCheckButton*    or_;
    FXCheckButton*    ow;
    FXCheckButton*    ox;
    FXTextField		*input;
    FXTextField		*username;
    FXTextField		*grpname;
    FXTextField		*open;
    FXTextField		*view;
    FXTextField		*edit;
    FXTextField		*ext;
    FXTextField		*descr;
    FXTextField		*bigic;
    FXTextField		*miniic;
    FXTextField		*test;
    mode_t	mode;
    mode_t	orig_mode;
    int	command;
    PermFrame *perm;
public:
    enum{
        ID_ACCEPT_SINGLE=FXDialogBox::ID_LAST, // 55
        ID_ACCEPT_MULT,
        ID_SET,
        ID_CLEAR,
        ID_ADD,
        ID_BIG_ICON,
        ID_MINI_ICON,
        ID_BROWSE_OPEN,
        ID_BROWSE_VIEW,
// Ugly hack : the 64 value doesn'work, why ??? 
        ID_DUMMY,  // 64
// To be debugged some day!!!
        ID_BROWSE_EDIT,
        ID_LAST
    };

public:
    PropertiesBox(FXWindow *win,FXString file,FXString path);
    PropertiesBox(FXWindow *win,FXString *files,int num);
    long onCmdAcceptSingle(FXObject*,FXSelector,void*);
    long onCmdAcceptMult(FXObject*,FXSelector,void*);
    long onCmdCheck(FXObject*,FXSelector,void*);
    long onCmdCommand(FXObject*,FXSelector,void*);
    long onCmdBrowseIcon(FXObject*,FXSelector,void*);
    long onCmdBrowse(FXObject*,FXSelector,void*);
	long onUpdDironly(FXObject*,FXSelector,void*);
    long onCmdKeyPress(FXObject*,FXSelector,void*);
};

#endif
