// Redefinition of the fox directory box class to use custom directory icons


#include "config.h"
#include "i18n.h"

#include <fox-1.2/fx.h>
#include <fox-1.2/FXPNGIcon.h>

#include "File.h"
#include "DirBox.h"
#include "icons.h"

// Root directory string
#ifndef ROOTDIR
#define ROOTDIR "/"
#endif

// Map
FXDEFMAP(DirBox) DirBoxMap[]={
                                 FXMAPFUNC(SEL_CHANGED,0,DirBox::onChanged),
                                 FXMAPFUNC(SEL_COMMAND,0,DirBox::onCommand),
                                 FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETVALUE,DirBox::onCmdSetValue),
                                 FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETSTRINGVALUE,DirBox::onCmdSetStringValue),
                                 FXMAPFUNC(SEL_COMMAND,FXWindow::ID_GETSTRINGVALUE,DirBox::onCmdGetStringValue),
                             };


// Implementation
FXIMPLEMENT(DirBox,FXTreeListBox,DirBoxMap,ARRAYNUMBER(DirBoxMap))


// Directory box
DirBox::DirBox(FXComposite *p,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb):
        FXTreeListBox(p,tgt,sel,opts,x,y,w,h, pl,pr,pt,pb)
{
    foldericon=new FXPNGIcon(getApp(),minifolder);
    setDirectory(ROOTDIR);
}


// Create
void DirBox::create()
{
    FXTreeListBox::create();
    foldericon->create();
}


// Detach disconnects the icons
void DirBox::detach()
{
    foldericon->detach();
    FXTreeListBox::detach();
}


// Destroy zaps the icons
void DirBox::destroy()
{
    foldericon->destroy();
    FXTreeListBox::destroy();
}


// Set the current item's text from the message
long DirBox::onCmdSetValue(FXObject*,FXSelector,void* ptr)
{
    setDirectory((char*)ptr);
    return 1;
}


// Change value
long DirBox::onCmdSetStringValue(FXObject*,FXSelector,void* ptr)
{
    setDirectory(*((FXString*)ptr));
    return 1;
}


// Obtain value
long DirBox::onCmdGetStringValue(FXObject*,FXSelector,void* ptr)
{
    *((FXString*)ptr)=getDirectory();
    return 1;
}


// Return item path
FXString DirBox::itempath(FXTreeItem *item)
{
    FXString string;
    if(item)
    {
        while(item->getParent())
        {
            string.prepend(getItemText(item));
            item=item->getParent();
            if(item->getParent())
                string.prepend(PATHSEPSTRING);
        }
        string.prepend(getItemText(item));
    }
    return string;
}


// Changed current item in tree; pass path to current item
long DirBox::onChanged(FXObject*,FXSelector,void* ptr)
{
    FXString string=itempath((FXTreeItem*)ptr);
    if(target)
        target->handle(this,FXSEL(SEL_CHANGED,message),(void*)string.text());
    return 1;
}


// Switch current item
long DirBox::onCommand(FXObject*,FXSelector,void* ptr)
{
    FXTreeItem *item=(FXTreeItem*)ptr;
    directory=itempath(item);
    removeItem(item->getFirst());
    if(target)
        target->handle(this,FXSEL(SEL_COMMAND,message),(void*)directory.text());
    return 1;
}


// Set directory
void DirBox::setDirectory(const FXString& pathname)
{
    FXTreeItem *item;
    FXString    string;
    FXint       part;
    if(!pathname.empty())
    {
        FXString path=FXFile::absolute(pathname);
        while(!FXFile::isTopDirectory(path) && !isDirectory(path))
        {
            path=FXFile::upLevel(path);
        }
        if(directory!=path)
        {
            directory=path;
            clearItems();

            item=addItemFirst(NULL,ROOTDIR,foldericon,foldericon);
            part=1;
            while(1)
            {
                string=directory.section(PATHSEP,part);
                if(string.empty())
                    break;
                item=addItemLast(item,string,foldericon,foldericon);
                part++;
            }
            setCurrentItem(item);
            recalc();
        }
    }
}


// Save object to stream
void DirBox::save(FXStream& store) const
{
    FXTreeListBox::save(store);
    store << directory;
    store << foldericon;
}


// Load object from stream
void DirBox::load(FXStream& store)
{
    FXTreeListBox::load(store);
    store >> directory;
    store >> foldericon;
}


// Delete it
DirBox::~DirBox()
{
    delete foldericon;
    foldericon=(FXIcon*)-1;
}

