/*
 * Copyright (C) 2004-5 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <X11/Xlib.h>
static const char *module_id="xffm_recent";
#include "frequent-recent.i"

/* this should be first 2 lines after headers: */
G_MODULE_EXPORT
LIBXFFM_MODULE


G_MODULE_EXPORT
const gchar * 
g_module_check_init(GModule *module){
#ifdef ENABLE_NLS
    bindtextdomain (GETTEXT_PACKAGE,PACKAGE_LOCALE_DIR);
#ifdef HAVE_BIND_TEXTDOMAIN_CODESET
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
#endif
    TRACE("domain=%s", GETTEXT_PACKAGE);
#endif
    return NULL;
}

/****************   void  functions  ***********************/

G_MODULE_EXPORT
void *module_init(void){
    recent_days=read_from_file("recentrc");
    if (!recent_days) {
	recent_days=3;
	write_to_file("recentrc",recent_days);
    }
    return GINT_TO_POINTER(1);
}

G_MODULE_EXPORT
void *
show_hidden_menuitem(void){
    return GINT_TO_POINTER(1);
}

G_MODULE_EXPORT
void *
preview_images_menuitem(void){
    return GINT_TO_POINTER(1);
}

G_MODULE_EXPORT
void *
exec_name(void){
    return "xffm-recent";
}

G_MODULE_EXPORT
void *
module_name(void){
    return "xffm_recent";
}

G_MODULE_EXPORT
void *
is_root_module(void){
    return GINT_TO_POINTER(1);
}

/*******************  natural functions **********************/

G_MODULE_EXPORT
void *
get_dnd_path(void *p)
{
    static gchar *desktop=NULL;
    if (!desktop) {
	desktop=g_strdup_printf("%s%c%s%c%s",
		PACKAGE_DATA_DIR,G_DIR_SEPARATOR,
		"applications",G_DIR_SEPARATOR,
		"Xffm-recent.desktop");
    }
    return (void *)desktop;
}

G_MODULE_EXPORT
void *
module_icon_id(void *p){
    return"xffm-recent.png";
}

G_MODULE_EXPORT
void *
module_label(void * p){
    return _("Recent");
}

G_MODULE_EXPORT
void *
is_selectable(void *p){
    record_entry_t *en=(record_entry_t *)p;
    if (IS_PATH(en->type)) return (void *)"Yes";
    
    return NULL;
}


G_MODULE_EXPORT
void *
valid_drop_site(void *p){
    record_entry_t *en=(record_entry_t *)p;
    if (!en) return NULL;
    if(IS_DIR(en->type)) return GINT_TO_POINTER(1);
    return NULL;
}

G_MODULE_EXPORT
void *
module_monitor(void *p){
    if (!p) return NULL;
    return monitor_dbh((record_entry_t *)p);
}

G_MODULE_EXPORT
void *
entry_tip(void *p)
{
    static gchar *tip=NULL;
    record_entry_t *en=p;
    g_free(tip);
    tip=NULL;
    if (!en || !en->path || !strlen(en->path)) return tip;
    {
	DBHashTable *dbh = NULL;
	GString *gs;
	gchar *recentfile = g_build_filename(xdg_cache_dir(),RECENT_DBH,NULL);
	if ((dbh = DBH_openR(recentfile)) == NULL){
	    g_free(recentfile);
	    return tip;
	}
	g_free(recentfile);
	gs = g_string_new(en->path);
	sprintf((char *)DBH_KEY(dbh), "%10u", g_string_hash(gs));
	g_string_free(gs, TRUE);
	if (DBH_load(dbh)){
	    history_dbh_t *history = (history_dbh_t *)DBH_DATA(dbh);
	    const gchar *t=my_utf_string(time_to_string(history->last_hit));
	    tip=g_strdup_printf("Accessed on %s\n%s", t,path_info(p));
	}
      
	DBH_close(dbh);
	return (tip);
    }
}

G_MODULE_EXPORT
void *
plugin_info(void){
    return _("The RECENT plugin keeps tabs of which files have been recently opened with the xffm filemanager, and allows you access to these files without having to search for them.");
}


/*******************  rational functions **********************/
G_MODULE_EXPORT
void *
add2history(void *p, void *q){
    widgets_pW=(widgets_t *)q;    
    return GINT_TO_POINTER(private_add2history(widgets_pW, (char *)p));
}


G_MODULE_EXPORT
void *
extend_popup(void *p, void *q){
    GtkWidget *w;
    widgets_pW=(widgets_t *)q;
    if (!GTK_IS_CONTAINER (p)) {
	return GINT_TO_POINTER(1);
    } 

    showit(widgets_pW->window,"module1");
    
  w = gtk_image_menu_item_new_with_mnemonic (_("Remove item from recent"));
  gtk_widget_show (w);
  gtk_container_add (GTK_CONTAINER ((GtkWidget *)p), w);
  gui_mk_pixmap_menu(widgets_pW, "xffm/stock_undo",w,MENU_PIXMAP);
  g_signal_connect ((gpointer) w, "activate",
                    G_CALLBACK (undo_history),
                    widgets_pW);

    return GINT_TO_POINTER(1);
}
	
G_MODULE_EXPORT
void *
private_popup(void *p, void *q){
    widgets_pW=(widgets_t *)q;
    return do_private_popup(p,q,FALSE);
}
		
G_MODULE_EXPORT
void *
get_xfdir(void *p, void *q){
    xfdir_t *xfdir_p;
    record_entry_t *en=(record_entry_t *)p;
    widgets_pW=(widgets_t *)q;
    xfdir_p=private_get_xfdir(en,FALSE);
    g_free(en->tag);
    en->tag=g_strdup(_("Recent"));

    return xfdir_p;
}

