/*   
  *   *  
 *  Copyright (C) 2001-2005 Edscott Wilson Garcia under GNU GPL
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <unistd.h>
#include <stdarg.h>
#include <signal.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/stat.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "constants.h"
#include "types.h"

#include "smblookup.h"

#include "primary.h"
#include "gui.h"
#include "actions_lib.h"
#include "tubo.h"

#include "smb_challenges.i"
#include "smb_ws.i"

/* this should be first 2 lines after headers: */
G_MODULE_EXPORT
LIBXFFM_MODULE


#define PARENT_MODULE "xffm_smb_wg"
#define CURRENT_MODULE "xffm_smb_ws"
#define CHILD_MODULE "xffm_smb_list"

G_MODULE_EXPORT
const gchar * 
g_module_check_init(GModule *module){
#ifdef ENABLE_NLS
    bindtextdomain (GETTEXT_PACKAGE,PACKAGE_LOCALE_DIR);
#ifdef HAVE_BIND_TEXTDOMAIN_CODESET
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
#endif
    TRACE("domain=%s", GETTEXT_PACKAGE);
#endif
    return NULL;
}

/**********************************************************/
/****************   void  functions  ***********************/

G_MODULE_EXPORT
void *
module_name(void){
    return CURRENT_MODULE;
}

G_MODULE_EXPORT
void *
submodule_name(void){
    return CHILD_MODULE;
}
G_MODULE_EXPORT
void *
parent_label(void){
    return _("Show groups");
}

G_MODULE_EXPORT
void *
module_init(void){
    return NULL;
}

G_MODULE_EXPORT
void *
exec_name(void){
    return "xffm-samba";
}


/*******************  natural functions **********************/
G_MODULE_EXPORT
void *
date_column_string(void * p){
    return ("");
}
G_MODULE_EXPORT
void *
size_column_string(void * p){
    return ("");
}
G_MODULE_EXPORT
void *
group_column_string(void * p){
    return ("");
}

G_MODULE_EXPORT
void *
owner_column_string(void * p){
    return ("");
}

G_MODULE_EXPORT
void *
mode_column_string(void * p){
    return ("");
}
G_MODULE_EXPORT
void *
window_title(void * p){
    static gchar *t=NULL;
    record_entry_t *en=p;
    if (!en || !en->path) return NULL;
    g_free(t);
    t=g_strdup_printf(_("Xfsamba (%s)"),en->path);
    return (void *) t;
}

G_MODULE_EXPORT
void *
module_icon_id(void * p){
    return "xfserver.png";
}

G_MODULE_EXPORT
void *
parent_module_name(void *p){
    return PARENT_MODULE;
}

G_MODULE_EXPORT
void *
is_selectable(void *p){
    return GINT_TO_POINTER(1);
}

G_MODULE_EXPORT
void *
valid_drop_site(void *p){
    record_entry_t *en=(record_entry_t *)p;
    if (!en) return NULL;
    if(IS_NETDIR(en->subtype)) return GINT_TO_POINTER(1);
    if(IS_XF_NETSHARE(en->subtype)) return GINT_TO_POINTER(1);
    return NULL;
}

G_MODULE_EXPORT
void *
get_dnd_format(void *p){
    gchar *server;
    static gchar *format=NULL;
    record_entry_t *en=(record_entry_t *)p;
    if (!en || !en->path || !strlen(en->path)) return NULL;
    g_free(format);
    server=g_strdup(en->path+2);
    strtok(server,"/");
    format = g_strdup_printf ("%s://%s@%s",
		 IS_SAMBA_SERVER(en->subtype)?"SMB":"smb",
		 (en->tag)?en->tag:"GUEST%%",
		 server);
    g_free(server);
    return format;
}

G_MODULE_EXPORT
void *
get_dnd_path(void *p){
    return "";
}


/*******************  rational functions **********************/

G_MODULE_EXPORT
void *
up_entry(void *en_p,void *en_c){
    record_entry_t *en = (record_entry_t *)en_p;
    gchar *n,*p;
    if (!en || !en->path || !strchr(en->path,'/')) return NULL;
    en = copy_entry((record_entry_t *)en_p);
        
    /* check for servername */
    n=en->path;
    if (strncmp(n,"smb://",strlen("smb://"))==0) p=n+strlen("smb://");
    else if (strncmp(n,"SMB://",strlen("SMB://"))==0) p=n+strlen("SMB://");
    else if (strncmp(n,"//:",strlen("//"))==0) p=n+strlen("//");
    else p=n;
    if (strchr(p,'/')) strtok(p,"/"); 
    TRACE("smb_ws: up entry is %s",en->path);

    en->module=PARENT_MODULE;
    return (void *)en;
}

G_MODULE_EXPORT
void *
extend_popup(void *p, void *q){
    if (GTK_IS_CONTAINER (p)) {
	return NULL;
    } else {   
	record_entry_t *en=(record_entry_t *)p;
	if (!en) return NULL;
	if(IS_NETDIR(en->subtype)) return GINT_TO_POINTER(1);
	if(IS_XF_NETSHARE(en->subtype)) return GINT_TO_POINTER(1);
	return NULL;
    }
}

G_MODULE_EXPORT
void *
get_xfdir(void *p, void *q){
    record_entry_t *en=(record_entry_t *)p;
    widgets_t *widgets_p=q;
    return private_get_xfdir(widgets_p, en);
}


