/* Copyright 2005 Edscott Wilson Garca. 
 * Distributed with GPL licence.*/
/*typedef struct callback_data_t {
    icon_view_t *icon_view_p;
    population_t *population_p;
    int caso;
}callback_data_t;*/


#define RESIZE_OPTION1

static
void
entry_activate(		GtkEntry *entry,
			icon_view_t *icon_view_p, 
			int caso)
{
    gchar *actual_tag;
    const gchar *tag;
    gchar *b;
    int result=FALSE;
    population_t *population_p;

    

    gtk_widget_hide(GTK_WIDGET(icon_view_p->rename));
    
    population_p=g_object_get_data(G_OBJECT(icon_view_p->rename),"population_p");
    // FIXME: should check whether population_p is still a valid pointer,
    //        or else garantee that invalid pointers will not be used...
   
    TRACE("entry_activate");
    
    if (!population_p || !population_p->en || !population_p->en->path) {
	icon_view_p->redlight=FALSE;
	return;
    }
    actual_tag=gtk_editable_get_chars ((GtkEditable *)entry,0,-1);
    tag=my_utf2local_string(actual_tag);
    g_free(actual_tag);
    actual_tag=g_strdup(tag);
    b=g_path_get_basename(population_p->en->path);
    
    if (strcmp(b,actual_tag)==0 && caso==0){
       result=xffm_touch(&(icon_view_p->widgets),population_p->en->path);
       TRACE("touching file %s...",population_p->en->path);
    }
    else {
        gchar *d=g_path_get_dirname(population_p->en->path);
	gchar *p=g_build_filename(d,actual_tag,NULL);
	g_free(d);
	switch (caso) {
	    case 0:
	        result=xffm_rename(&(icon_view_p->widgets), p,population_p->en->path);
		if (result) {
		 gchar *q=p; 
		 p=population_p->en->path; 
		 population_p->en->path=q;
	    	}
		TRACE("renaming %s to %s",population_p->en->path,p);
		/* should not do immediate update here, because
		operation is lengthy and the pointer may have changed...*/
		
		break;
	    case 1:
	        result=xffm_duplicate(&(icon_view_p->widgets), p,population_p->en->path);
		TRACE("duplication %s to %s",population_p->en->path,p);
		break;
	    case 2:
	        result=xffm_symlink(&(icon_view_p->widgets),  p,population_p->en->path);
		TRACE("symlinking %s to %s",population_p->en->path,p);
		if (result) {
		 gchar *q=p; 
		 p=population_p->en->path; 
		 population_p->en->path=q;
	    	}
		break;
	}
	g_free(p);
    }

    g_free(b);
    g_free(actual_tag);
    done_with_rename((gpointer)icon_view_p);
    if (result) {
	gchar *m=g_strdup_printf(_("cp/mv complete"));
	print_status(&(icon_view_p->widgets),"xfce/info",m,NULL);
	g_free(m);
    }
    else {
	gchar *m=g_strdup_printf(_("cp/mv %s"),strerror(EIO));
	print_status(&(icon_view_p->widgets),"xfce/error",m,NULL);
	g_free(m);
    }
}
    

static
void
entry_activate_rename(GtkEntry *entry, gpointer data){
    entry_activate(entry,(icon_view_t *)data,0); 
}
static
void
entry_activate_duplicate(GtkEntry *entry, gpointer data){
    entry_activate(entry,(icon_view_t *)data,1); 
}
static
void
entry_activate_symlink(GtkEntry *entry, gpointer data){
    entry_activate(entry,(icon_view_t *)data,2); 
}

static void
done_with_rename (gpointer data)
{
    icon_view_t *icon_view_p=(icon_view_t *)data;
    gchar *actual_tag;
    population_t *population_p;
    
    
    TRACE("done_with_rename");
    if (!icon_view_p->rename) {
	TRACE("!icon_view_p->rename");
	return;
    }
    population_p=g_object_get_data(G_OBJECT(icon_view_p->rename),"population_p");
    
    TRACE("gtk_widget_destroy(GTK_WIDGET(icon_view_p->rename));");
    gtk_widget_destroy(GTK_WIDGET(icon_view_p->rename));
    icon_view_p->rename=NULL;
    print_status(&(icon_view_p->widgets),NULL," ",NULL);
   

    actual_tag=g_path_get_basename(population_p->en->path);   
    if (strcmp(actual_tag,"..Wastebasket")==0){
	g_free(actual_tag);
	actual_tag = g_strdup(_("Wastebasket"));
    }	    

    TRACE("xxxx actual tag=%s",actual_tag);
    graphics_layout(icon_view_p,population_p,actual_tag);
    
    gtk_widget_queue_draw_area (icon_view_p->paper, 
		population_p->column*CELLSIZE, 
		population_p->row*CELLSIZE,
		CELLSIZE,CELLSIZE);
    g_free(actual_tag); 
    icon_view_p->redlight=FALSE;
    TRACE("redlight off");
}



static void
destroy_dialog (GtkWidget * widget, gpointer data)
{
    done_with_rename(data);
}



static gint on_key_press(GtkWidget * entry, GdkEventKey * event, gpointer data)
{
 icon_view_t *icon_view_p = (icon_view_t *)data;
 if (event->keyval == GDK_Escape) {
    done_with_rename(data);
    print_status(&(icon_view_p->widgets),NULL,_("Omitting"),NULL);
    return TRUE;
 }
 return FALSE;
}

static 
gboolean 
grab_focus (		GtkWidget *widget, 
			GdkEventCrossing *event, 
			gpointer data)
{
   //icon_view_t *icon_view_p = (icon_view_t *)data;   
    XSetInputFocus(GDK_DISPLAY(),
	  GDK_WINDOW_XID(gtk_widget_get_parent_window(widget)),
	  RevertToParent,CurrentTime);
    return TRUE;
}

/* exported only within library */ 
void
mk_text_entry(icon_view_t *icon_view_p, population_t *population_p, int caso){
  GtkWidget *entry;
  GtkWidget *hbox;

    /* avoid race condition with monitor...*/
    icon_view_p->redlight=TRUE;
    TRACE("redlight on");
    
    icon_view_p->selected_p = population_p;
  
  
  /* caso=0, rename; caso=1, duplicate; caso=2, symlink */
  
  if (population_p->layout){ 
    g_object_unref(population_p->layout);
    population_p->layout=NULL;
  }
  if (population_p->layout2){ 
    g_object_unref(population_p->layout2);
    population_p->layout2=NULL;
  }
  gtk_widget_queue_draw_area (icon_view_p->paper, 
	population_p->column*CELLSIZE, 
	population_p->row*CELLSIZE,
	CELLSIZE,CELLSIZE);
		    
  entry=gtk_entry_new ();
  hbox = gtk_hbox_new (FALSE, 0);
  /*icon_view_p->rename = gtk_window_new (GTK_WINDOW_TOPLEVEL);*/
  icon_view_p->rename = gtk_window_new (GTK_WINDOW_POPUP);
  /*gtk_window_set_position (GTK_WINDOW (icon_view_p->rename), GTK_WIN_POS_MOUSE);*/
  
  {
#define DECORATION_H 10
    gint x,y; 
    double sh = gtk_adjustment_get_value (gtk_scrolled_window_get_vadjustment(icon_view_p->scrolled_window));
    int X = CELLSIZE * population_p->column;
    int Y= CELLSIZE * population_p->row + ICON_SIZE + TEXTSPACING  ;
    gtk_window_get_position((GtkWindow *)icon_view_p->widgets.window,&x,&y);
    TRACE("sh=%lf, Y=%d, y=%d\n",sh,Y,y);
    gtk_window_move((GtkWindow *)icon_view_p->rename,X+x,Y+y-sh+DECORATION_H);
  }

  
  gtk_window_set_resizable (GTK_WINDOW (icon_view_p->rename), FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (icon_view_p->rename), 0);
  gtk_window_set_modal (GTK_WINDOW (icon_view_p->rename), FALSE);
  {
    gchar *g,*b=g_path_get_basename(population_p->en->path);
    g_object_set_data(G_OBJECT(icon_view_p->rename),"population_p",population_p);
    if (caso == 0) {
	g=g_strdup(b);
	print_status(&(icon_view_p->widgets),"xfce/warning",_("Rename")," ",b,NULL);
	g_signal_connect (G_OBJECT (entry), "activate", 
  		  GTK_SIGNAL_FUNC (entry_activate_rename), icon_view_p);
    }
    else if (caso == 1) {
	gchar *dir=g_path_get_dirname(population_p->en->path);
	g=g_strdup(xffm_new_name(dir, b));
	g_free(dir);
	print_status(&(icon_view_p->widgets),"xfce/warning",_("Duplicate")," ",b,NULL);
	g_signal_connect (G_OBJECT (entry), "activate", 
  		  GTK_SIGNAL_FUNC (entry_activate_duplicate), icon_view_p);
    }
    else if (caso == 2){
	g=g_strconcat(b,"-lnk",NULL);
	print_status(&(icon_view_p->widgets),"xfce/warning",_("Symlink")," ",b,NULL);
	g_signal_connect (G_OBJECT (entry), "activate", 
  		  GTK_SIGNAL_FUNC (entry_activate_symlink), icon_view_p);
    }
    
    gtk_entry_set_text ((GtkEntry *)entry,my_utf_string(g));
    g_free(b);
    g_free(g);
  }
  gtk_editable_set_editable ((GtkEditable *) entry, TRUE);
  gtk_editable_select_region((GtkEditable *) entry,0,-1);

  //gtk_widget_realize (icon_view_p->rename);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 0);
  gtk_container_add (GTK_CONTAINER(icon_view_p->rename), hbox);

  /*gtk_window_set_decorated ((GtkWindow *)icon_view_p->rename,FALSE);*/
  
  gtk_box_pack_start (GTK_BOX (hbox), entry, TRUE, FALSE, 0);
		  
  g_signal_connect (G_OBJECT (icon_view_p->rename), "destroy-event", 
  		  GTK_SIGNAL_FUNC (destroy_dialog), icon_view_p);
  g_signal_connect(G_OBJECT(icon_view_p->rename), "key_press_event", 
		    G_CALLBACK(on_key_press), icon_view_p);
  g_signal_connect (G_OBJECT (icon_view_p->rename), "delete-event", 
  		  GTK_SIGNAL_FUNC (destroy_dialog), icon_view_p);
  g_signal_connect (G_OBJECT (entry),"enter-notify-event",
		  GTK_SIGNAL_FUNC (grab_focus),icon_view_p);
 
  /*gtk_window_set_accept_focus     (GTK_WINDOW(icon_view_p->rename),TRUE);*/
  gtk_widget_show_all (icon_view_p->rename);
  /* this sucks: gtk_widget_grab_focus (icon_view_p->rename);*/
  XSetInputFocus(GDK_DISPLAY(),
	  GDK_WINDOW_XID(gtk_widget_get_parent_window(entry)),
	  RevertToParent,CurrentTime);
  gtk_window_set_transient_for (
		    GTK_WINDOW (icon_view_p->rename), 
		    GTK_WINDOW (icon_view_p->widgets.window));
  
  
  return;
}




static 
void
process_double_click(icon_view_t *icon_view_p,population_t *population_p, gboolean control){
    icon_view_t *icon_view_target=icon_view_p;
    if (!icon_view_p || !population_p) return;
    cursor_wait(icon_view_p->widgets.window);

    if (population_p->en) TRACE("submodule_name=%s",population_p->en->module);
    if (population_p->en && population_p->en->exec) {
	GError *error=NULL;
	if (!g_spawn_command_line_async (population_p->en->exec,&error)){
	    /*g_warning("error->message (%s)",population_p->en->exec);*/
	    print_diagnostics(&(icon_view_p->widgets),"xfce/error",
				error->message,NULL);
	    g_error_free(error);
	}
	cursor_reset(icon_view_p->widgets.window);
	return;
    }
    if (population_p->en && !population_p->en->module && 
	!g_file_test(population_p->en->path,G_FILE_TEST_IS_DIR)) 
    {
	record_entry_t *en=population_p->en;
	if (g_file_test(en->path,G_FILE_TEST_EXISTS)){
	    record_entry_t *en=population_p->en;
	    cursor_reset(icon_view_p->widgets.window);
	    if(IS_EXE(en->type) )
	    {	/* run it (if not registered)*/
		const gchar *prg = MIME_command (en->path);
		if (prg) gridview_double_click_open_with(en,icon_view_p);
		else {
    			/*  assume in_term to be safe */
    			SET_IN_TERM(en->subtype);
			xffm_double_click_run(&(icon_view_p->widgets),en);
		}
		if (en->path) RECENT_add2history(&(icon_view_p->widgets),en->path);
	    } else {      /* open with */
		gridview_double_click_open_with(en,icon_view_p);
		if (en->path) RECENT_add2history(&(icon_view_p->widgets),en->path);
	    }
	    return;
	}

        g_warning("nothing programed here with double click");
	cursor_reset(icon_view_p->widgets.window);
        return;
    } else {
	record_entry_t *en=copy_entry(population_p->en);
	const gchar *submodule_name=NULL;
	if (population_p->en) submodule_name=population_p->en->module;

   
	
	/* does the module have something else in mind for the
	double click on the particular entry ? */
	if (icon_view_p->module_name){
	    TRACE("looking for alternate module double click here");
	    if (function_rational("plugins",icon_view_p->module_name,en,&(icon_view_p->widgets),"double_click"))
	    {
		cursor_reset(icon_view_p->widgets.window);
		return;
	    }
	    TRACE("no alternate found, going for default...");
	}
	
	if (!control) {
	    TRACE("create_iconview ");	    
	    icon_view_target=create_iconview(en);	    
	    cursor_wait(icon_view_target->widgets.window);
	    cursor_reset(icon_view_p->widgets.window); 
	} else push_iconview_go_history(icon_view_p); 
    
	icon_view_target->preferences = icon_view_p->preferences;
	icon_view_target->sortcolumn = icon_view_p->sortcolumn;

	icon_view_target->module_name=submodule_name;
	TRACE("RELOADING HERE... module_name=%s",icon_view_target->module_name);
 	if (reload_iconview(icon_view_target, en, TRUE)){ 
	    if (en && en->path && g_file_test(en->path,G_FILE_TEST_IS_DIR)) save_to_go_history(en->path);
	    cursor_reset(icon_view_target->widgets.window);
	}
    }
    return;    
}
  
static 
gint
my_strcmp(gconstpointer a, gconstpointer b){
    return (strcmp((char *)a, (char *)b));
}



static
int 
load_xfdir_icons(	icon_view_t *icon_view_p,
			xfdir_t *xfdir_p,
			GList *reselect_list,
			record_entry_t *parent_en)
{
    population_t *population_p;
    unsigned int smallcount = 0;
    int j,up=0;
    /*const gchar *submodule_name=function_void("plugins",
					   icon_view_p->module_name,
					   "submodule_name");*/

    /* add entry for each population_t */
    TRACE("Loading... load_xfdir_icons()");
    if (xfdir_p) TRACE("pathc=%d",xfdir_p->pathc);
    
    if (icon_view_p->population_pp) g_free(icon_view_p->population_pp);
    icon_view_p->population_pp=
	graphics_mk_grid_elements(icon_view_p->grid_rows*icon_view_p->grid_columns);

    /* with a clean population_pp, this expose no longer 
     * clears the paper on screen :
     *
     * gtk_widget_queue_draw(icon_view_p->paper);
     *
     * */
   
    population_p=add_up_element(icon_view_p,parent_en);
    if (population_p) {
        icon_view_p->population_pp[up]=population_p;
        up++;
    }
    else {
	TRACE("no parent for %s",icon_view_p->module_name);
    }
	
    
    if (xfdir_p) {
      for(j=0; j < xfdir_p->pathc; j++)
      {
	
	if (j+up >= icon_view_p->max_elements){
	    g_warning("j+up >= icon_view_p->max_elements");
	    continue;
	}
	if (!xfdir_p->gl[j].pathv || !xfdir_p->gl[j].en){
	    g_warning("!xfdir->gl[j].pathv || !xfdir->gl[j].en");
	    continue;
	}
	if (icon_view_p->population_pp) {
	    population_p=create_population_t(icon_view_p,xfdir_p->gl[j].en, j+up, NULL, xfdir_p->gl[j].pathv);
	}
	else {
	    TRACE("Load borked");
	    return 0;
	}
	xfdir_p->gl[j].en->module = icon_view_p->submodule_name;
	if (icon_view_p->population_pp) icon_view_p->population_pp[j+up]=population_p;
	else return 0;
	TRACE("new population_p(%d,%d)=0x%x",population_p->row,population_p->column,(unsigned)population_p);
	
	gtk_widget_queue_draw_area (icon_view_p->paper, 
		population_p->column*CELLSIZE, population_p->row*CELLSIZE,
		CELLSIZE,CELLSIZE);
	
	if (population_p->en && population_p->en->path) {
	    if (g_list_find_custom(reselect_list,population_p->en->path,my_strcmp)){
		TRACE("reselecting %s",population_p->en->path);
		select_pixbuf(icon_view_p,population_p);
	    }
	}
	if(smallcount++ & (1 << 7))
	{
	    set_progress_full(&(icon_view_p->widgets),j, xfdir_p->pathc);
	    smallcount = 1;
	    while(gtk_events_pending()) gtk_main_iteration();
	    /*/Xprocess_pending_gtk();*/
	}
      }
      TRACE("xfdir_p->pathc=%d",xfdir_p->pathc);
      /* we add 1 to get past last element, including up element
       * which is not tabulated in pathc...*/
      for (j=xfdir_p->pathc+1; j<icon_view_p->grid_area; j++) {
	/*clear remaining gridspots */  
	int row,column;
	row = j / icon_view_p->grid_columns;

	column = j - (row * icon_view_p->grid_columns);
	TRACE("*clear remaining gridspot=%d,%d. J=%d, max=%d, rows=%d, cols=%d, area=%d",
		row,column,j,icon_view_p->max_elements,
		icon_view_p->grid_rows,icon_view_p->grid_columns,
		icon_view_p->grid_area);
	if (row <= icon_view_p->grid_rows && 
		column <= icon_view_p->grid_columns)
	{
	    gtk_widget_queue_draw_area (icon_view_p->paper, 
		column*CELLSIZE, row*CELLSIZE,
		CELLSIZE,CELLSIZE);
	}
	     
      }
      set_progress_full(&(icon_view_p->widgets),j, xfdir_p->pathc);
      TRACE("memory in population structures=%ld",(long)sizeof(population_t)*xfdir_p->pathc);
    }
    
    return 1;
}

static
void
init_icon_view(icon_view_t *icon_view_p, record_entry_t *en, int pathc){
    /*icon_view_p->grid_columns must be initialized beforehand */
    if (!icon_view_p->grid_columns) icon_view_p->grid_columns=1;
    icon_view_p->en=en;
    if (has_up_element(icon_view_p)) pathc++;
    TRACE("new size is %d", pathc);
    icon_view_p->down_X=-1,icon_view_p->down_Y=-1;
    icon_view_p->old_X=-1,icon_view_p->old_Y=-1;
    icon_view_p->selection_count=0;   
    if (icon_view_p->population_list) g_list_free(icon_view_p->population_list);
    icon_view_p->population_list=NULL;
    if (icon_view_p->selection_list) g_list_free(icon_view_p->selection_list);
    icon_view_p->selection_list=NULL;
    icon_view_p->mouseX=0;
    icon_view_p->mouseY=0;
    icon_view_p->tip_timer=0;
    icon_view_p->rename=NULL;
    icon_view_p->label_p=NULL;
    icon_view_p->doing_drag_p=NULL;
    icon_view_p->saturated_p=NULL;
    icon_view_p->selected_p=NULL;
    icon_view_p->population_pp=NULL;
    icon_view_p->max_elements=pathc;
    if (en) {
	gchar *parent=NULL;
	if (en->path) parent=g_path_get_dirname(en->path);
	if (parent) icon_view_p->max_elements++;
	g_free(parent);
    }
    icon_view_p->grid_rows = (icon_view_p->max_elements+1)/icon_view_p->grid_columns;
    if (icon_view_p->grid_rows * icon_view_p->grid_columns < icon_view_p->max_elements+1) icon_view_p->grid_rows++;

    /*{
	if (!icon_view_p->grid_rows){ 
		icon_view_p->grid_rows=DEFAULT_VISIBLE_ROWS; 
	}
	else icon_view_p->grid_rows++;
    }*/
    icon_view_p->grid_area=icon_view_p->grid_rows*icon_view_p->grid_columns;
    {
	int rows= icon_view_p->grid_area / DEFAULT_ICON_COLUMNS;
	icon_view_p->paperX = DEFAULT_ICON_COLUMNS * CELLSIZE;
	icon_view_p->paperY = rows * CELLSIZE;
    }

    
    {
	TRACE("paperX=%d columns=%d",icon_view_p->paperX,icon_view_p->grid_columns);
	TRACE("paperY=%d (%d rows)",icon_view_p->paperY,icon_view_p->grid_rows);   
	TRACE("area= %d cells)",icon_view_p->grid_area);   

    }
}


G_MODULE_EXPORT
icon_view_t *
create_iconview(	record_entry_t *en)
{
    icon_view_t *icon_view_p;
#ifdef RESIZE_OPTION1
    iconview_geometry_t *iconview_geometry_p=NULL;
#endif
    GtkWidget *vbox1,*hbox1,*input_box;

    icon_view_p=(icon_view_t *)malloc(sizeof(icon_view_t));
    g_return_val_if_fail(icon_view_p!=NULL,NULL);
    memset(icon_view_p,0,sizeof(icon_view_t));

    xffm_details->icon_view_p=icon_view_p;

    TRACE("icon_view_p initializations...");

    /* initializations: */
    icon_view_p->double_click_open_with=gridview_double_click_open_with;
    icon_view_p->preferences=__SHOW_IMAGES;
    icon_view_p->redlight=FALSE;
    icon_view_p->redlight2=TRUE;
    icon_view_p->grid_columns=DEFAULT_ICON_COLUMNS;
    
    icon_view_p->go_list=NULL;
    icon_view_p->module_name=NULL;
    icon_view_p->submodule_name=NULL;
    icon_view_p->population_list=NULL;
    icon_view_p->selection_list=NULL;
    icon_view_p->penGC=NULL;    
    icon_view_p->cmap=NULL;
    icon_view_p->dragstate=FALSE;
    icon_view_p->vpane_ratio=-1;
    icon_view_p->popup=NULL;
    icon_view_p->widgets.combo_info=NULL;
    icon_view_p->sortcolumn=GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID;
    init_icon_view(icon_view_p, NULL, DEFAULT_ICON_COLUMNS*DEFAULT_VISIBLE_ROWS);
    icon_view_p->widgets.type = ICONVIEW_TYPE;
    icon_view_p->widgets.parent = icon_view_p;
    icon_view_p->widgets.refresh = gridview_refresh;
    icon_view_p->widgets.stop=FALSE;
    icon_view_p->widgets.tubo_object = NULL;
    
    icon_view_p->widgets.window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_gravity ((GtkWindow *)icon_view_p->widgets.window,GDK_GRAVITY_STATIC);
    {
      	GdkPixbuf *xffm_icon_pixbuf;
	TRACE("create application icon...");
 	xffm_icon_pixbuf = icon_tell (&(icon_view_p->widgets),REAL_BIG,"xfce/b-iconview");
  	if (xffm_icon_pixbuf)
    	{
      		gtk_window_set_icon (GTK_WINDOW (icon_view_p->widgets.window), 
				xffm_icon_pixbuf);
      		g_object_unref (G_OBJECT(xffm_icon_pixbuf));
   	}
	else g_warning("cannot create application icon");
	

	

#ifdef RESIZE_OPTION1
	TRACE("call to get_iconview_geometry_p");
	iconview_geometry_p=get_iconview_geometry_p(icon_view_p);
	
	if (iconview_geometry_p) {
	    gtk_window_set_default_size ((GtkWindow *)icon_view_p->widgets.window, 
		iconview_geometry_p->w, 
		iconview_geometry_p->h);
	} else {
	    gtk_window_set_default_size ((GtkWindow *)icon_view_p->widgets.window, 
		xffm_details->geometryX, 
		xffm_details->geometryY);
	}
	
#else
	/* so we set it this way and later resize...*/
	gtk_window_set_default_size ((GtkWindow *)icon_view_p->widgets.window, 
		DEFAULT_ICON_COLUMNS*(CELLSIZE), 
		DEFAULT_VISIBLE_ROWS*(CELLSIZE)+CELLSIZE/2);

#endif
	gtk_window_set_resizable ((GtkWindow *)icon_view_p->widgets.window, TRUE);
	/*gtk_window_set_title (GTK_WINDOW (icon_view_p->widgets.window), OUR_HOST_NAME(&(icon_view_p->widgets.window)));*/
	    while (gtk_events_pending()) gtk_main_iteration();
	    gdk_flush();
    }
    vbox1 = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (vbox1);
    gtk_container_add (GTK_CONTAINER (icon_view_p->widgets.window), vbox1);

    input_box=gui_mk_input_box(&(icon_view_p->widgets),vbox1,icon_view_p);
    g_signal_connect ((gpointer) lookup_widget(icon_view_p->widgets.window,"input_ok"), 
	    "clicked",G_CALLBACK (gridview_input_ok), (gpointer)icon_view_p);

    gtk_widget_hide(input_box);

    icon_view_p->widgets.vpane = gtk_vpaned_new ();
    gtk_widget_show (icon_view_p->widgets.vpane);
    gtk_box_pack_start (GTK_BOX (vbox1), icon_view_p->widgets.vpane, TRUE, TRUE, 0);
    gtk_paned_set_position (GTK_PANED (icon_view_p->widgets.vpane), 1000);


    
    icon_view_p->paper = gtk_drawing_area_new ();
    {
	gtk_widget_set_size_request (icon_view_p->paper, icon_view_p->paperX,icon_view_p->paperY);
	/*gtk_window_resize  (GTK_WINDOW(icon_view_p->widgets.window),xffm_details->geometryX,xffm_details->geometryY);*/
	TRACE("gtk_window_resize");
	gtk_widget_show (icon_view_p->paper);
    }
    
    icon_view_p->scrolled_window=(GtkScrolledWindow *)gtk_scrolled_window_new (NULL,NULL);
    {
	gtk_scrolled_window_set_policy (icon_view_p->scrolled_window,GTK_POLICY_NEVER,GTK_POLICY_ALWAYS);
	gtk_paned_pack1 (GTK_PANED (icon_view_p->widgets.vpane), GTK_WIDGET(icon_view_p->scrolled_window), FALSE, TRUE);
	gtk_widget_show (GTK_WIDGET(icon_view_p->scrolled_window));
        gtk_scrolled_window_add_with_viewport (icon_view_p->scrolled_window,icon_view_p->paper);
    }
   
    {
	icon_view_p->widgets.diagnostics=gtk_text_view_new();
	GtkWidget *scrolledwindow5=gtk_scrolled_window_new (NULL,NULL);
	gtk_widget_show (scrolledwindow5);
	gtk_widget_show (icon_view_p->widgets.diagnostics);
	gtk_paned_pack2 (GTK_PANED (icon_view_p->widgets.vpane), scrolledwindow5, TRUE, TRUE);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow5), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add (GTK_CONTAINER (scrolledwindow5), icon_view_p->widgets.diagnostics);
	gtk_container_set_border_width (GTK_CONTAINER (icon_view_p->widgets.diagnostics), 2);
	GTK_WIDGET_UNSET_FLAGS (icon_view_p->widgets.diagnostics, GTK_CAN_FOCUS);
	gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (icon_view_p->widgets.diagnostics), GTK_WRAP_WORD);
	gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (icon_view_p->widgets.diagnostics), FALSE);
    }

    hbox1 = gtk_hbox_new (FALSE, 0);
    gtk_widget_show (hbox1);
    gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, FALSE, 0);    
    icon_view_p->widgets.progress = gtk_progress_bar_new ();
    gtk_box_pack_start (GTK_BOX (hbox1), icon_view_p->widgets.progress, FALSE, FALSE, 0);
    GLADE_HOOKUP_OBJECT (icon_view_p->widgets.window, icon_view_p->widgets.vpane, "vpaned1");
    GLADE_HOOKUP_OBJECT (icon_view_p->widgets.window, icon_view_p->widgets.progress, "progressbar1");
    gtk_widget_show (icon_view_p->widgets.progress);


    icon_view_p->widgets.status = gtk_text_view_new ();
    gtk_widget_show (icon_view_p->widgets.status);
    gtk_box_pack_start (GTK_BOX (hbox1), icon_view_p->widgets.status, TRUE, TRUE, 3);
    GTK_WIDGET_UNSET_FLAGS (icon_view_p->widgets.status, GTK_CAN_FOCUS);
    gtk_text_view_set_editable (GTK_TEXT_VIEW (icon_view_p->widgets.status), FALSE);
    gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (icon_view_p->widgets.status), FALSE);
    {
	GtkWidget *image;
	GdkPixbuf *pb;
	
	icon_view_p->widgets.stop_button = gtk_button_new ();
    
	gtk_box_pack_end (GTK_BOX (hbox1), icon_view_p->widgets.stop_button, FALSE, FALSE, 0);
	GTK_WIDGET_UNSET_FLAGS (icon_view_p->widgets.stop_button, GTK_CAN_FOCUS);
	/*gtk_tooltips_set_tip (tooltips, icon_view_p->widgets.stop_button, _("Stop the current operation"), NULL);*/
	gtk_button_set_relief (GTK_BUTTON (icon_view_p->widgets.stop_button), GTK_RELIEF_NONE);
	pb = icon_tell (&(icon_view_p->widgets),SMALL,"xfce/stock_stop");
	image=gtk_image_new_from_pixbuf (pb);
	g_object_unref(pb);
	gtk_widget_show (image);
	gtk_container_add (GTK_CONTAINER (icon_view_p->widgets.stop_button), image);
	g_signal_connect ((gpointer) icon_view_p->widgets.stop_button, "clicked", G_CALLBACK (on_stop), &(icon_view_p->widgets));
	/*gtk_widget_set_sensitive(icon_view_p->widgets.stop_button,FALSE);*/
	
	icon_view_p->widgets.clear_button = gtk_button_new ();
    
	gtk_widget_show (icon_view_p->widgets.clear_button);
	gtk_box_pack_end (GTK_BOX (hbox1), icon_view_p->widgets.clear_button, FALSE, FALSE, 0);
	GTK_WIDGET_UNSET_FLAGS (icon_view_p->widgets.clear_button, GTK_CAN_FOCUS);
	gtk_button_set_relief (GTK_BUTTON (icon_view_p->widgets.clear_button), GTK_RELIEF_NONE);
	pb = icon_tell (&(icon_view_p->widgets),SMALL,"xfce/stock_clear");
	image=gtk_image_new_from_pixbuf (pb);
	g_object_unref(pb);
	gtk_widget_show (image);
	gtk_container_add (GTK_CONTAINER (icon_view_p->widgets.clear_button), image);
	g_signal_connect ((gpointer) icon_view_p->widgets.clear_button, "clicked", G_CALLBACK (on_clear_text_window), &(icon_view_p->widgets));

    }


    /* events */
    gtk_widget_add_events (icon_view_p->paper,
	  GDK_POINTER_MOTION_MASK|
	  GDK_BUTTON_MOTION_MASK|
	  GDK_BUTTON_PRESS_MASK|
	  GDK_BUTTON_RELEASE_MASK|
	  GDK_ENTER_NOTIFY_MASK|
	  GDK_LEAVE_NOTIFY_MASK|
	  GDK_EXPOSURE_MASK);
    

    g_signal_connect(G_OBJECT(gtk_scrolled_window_get_vadjustment(icon_view_p->scrolled_window)), "value-changed", G_CALLBACK(adjustment_changed), icon_view_p);
   
    g_signal_connect(G_OBJECT(icon_view_p->widgets.window), "key-press-event", 
	    G_CALLBACK(keyboard_event), icon_view_p);
    g_signal_connect(G_OBJECT(icon_view_p->widgets.window), "destroy_event", 
	    G_CALLBACK(destroy_event), icon_view_p);
    g_signal_connect(G_OBJECT(icon_view_p->widgets.window), "delete_event", 
	    G_CALLBACK(destroy_event), icon_view_p);
    g_signal_connect (G_OBJECT (icon_view_p->paper), "expose-event", 
		  GTK_SIGNAL_FUNC (on_expose), icon_view_p);
    g_signal_connect (G_OBJECT (icon_view_p->paper), 
	      "size-allocate", G_CALLBACK (on_size_paper), icon_view_p);
    g_signal_connect (G_OBJECT (icon_view_p->widgets.window), 
	      "size-allocate", G_CALLBACK (on_size_window), icon_view_p);
    /* pointer events */
    /*g_signal_connect (G_OBJECT (icon_view_p->widgets.window), "check-resize", 
	    G_CALLBACK (on_check_resize), icon_view_p);    */  
    g_signal_connect (G_OBJECT (icon_view_p->widgets.window), "configure-event", 
	    G_CALLBACK (on_configure_window), icon_view_p);      
    g_signal_connect (G_OBJECT (icon_view_p->paper), "configure-event", 
	    G_CALLBACK (on_configure_paper), icon_view_p);          
    g_signal_connect (G_OBJECT (icon_view_p->paper), "button-press-event",
		  GTK_SIGNAL_FUNC (on_button_press),icon_view_p);
    g_signal_connect (G_OBJECT (icon_view_p->paper), "button-release-event",
		  GTK_SIGNAL_FUNC (on_button_release), icon_view_p);
    g_signal_connect (G_OBJECT (icon_view_p->paper),"enter-notify-event",
		  GTK_SIGNAL_FUNC (on_enter),icon_view_p);
    g_signal_connect (G_OBJECT (icon_view_p->paper),"leave-notify-event",
		  GTK_SIGNAL_FUNC (on_leave),icon_view_p);
    g_signal_connect (G_OBJECT (icon_view_p->paper),"motion-notify-event",
		  GTK_SIGNAL_FUNC (on_motion),icon_view_p);
  
  

    /* drag and drop events */
   
    if (!target_list) target_list = gtk_target_list_new (target_table,NUM_TARGETS);
  
    gtk_drag_source_set((GtkWidget *) icon_view_p->paper, 
	  GDK_BUTTON1_MASK | GDK_BUTTON2_MASK, target_table, NUM_TARGETS, 
	  GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK);
    gtk_drag_dest_set((GtkWidget *) icon_view_p->paper, 
	  GTK_DEST_DEFAULT_DROP , target_table, NUM_TARGETS, 
	  GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK);

    g_object_set_data(G_OBJECT(icon_view_p->widgets.window),"icon_view_p",(gpointer)icon_view_p->paper);
    g_object_set_data(G_OBJECT(icon_view_p->paper),"icon_view_p",(gpointer)icon_view_p->paper);
    
    g_signal_connect(G_OBJECT(icon_view_p->paper), "drag_data_received", 
	  G_CALLBACK(gridview_drag_data), icon_view_p);
    g_signal_connect(G_OBJECT(icon_view_p->paper), "drag_data_get", 
	    G_CALLBACK(gridview_drag_data_get), icon_view_p);
    g_signal_connect(G_OBJECT(icon_view_p->paper), "drag_motion", 
	    G_CALLBACK(gridview_drag_motion), icon_view_p);
    g_signal_connect(G_OBJECT(icon_view_p->paper), "drag_end", 
	    G_CALLBACK(gridview_drag_end), icon_view_p);
    g_signal_connect(G_OBJECT(icon_view_p->paper), "drag_begin", 
	    G_CALLBACK(gridview_drag_begin), icon_view_p);
    g_signal_connect(G_OBJECT(icon_view_p->paper), "drag_leave",
	    G_CALLBACK(gridview_drag_leave), icon_view_p);
    g_signal_connect(G_OBJECT(icon_view_p->paper), "drag_data_delete",
	    G_CALLBACK(gridview_drag_delete), icon_view_p);

    
    {
	TRACE("hscrollbar=%d",icon_view_p->scrolled_window->hscrollbar->allocation.height);
	TRACE("vscrollbar=%d",icon_view_p->scrolled_window->vscrollbar->allocation.width);
    }
    /*gtk_window_resize  (GTK_WINDOW(icon_view_p->widgets.window),xffm_details->geometryX,xffm_details->geometryY);*/
    gtk_widget_queue_draw (icon_view_p->paper);
    
    TRACE("iconview now flushing events...");

    while (gtk_events_pending()) gtk_main_iteration();
    gdk_flush();
    

    iconview_list=g_list_append(iconview_list, icon_view_p);

    icon_view_p->tips = gtk_tooltips_new ();
    //gtk_tooltips_disable (icon_view_p->tips);



    
    gtk_widget_show (icon_view_p->widgets.window);  
 /*   gtk_widget_realize (icon_view_p->widgets.window);  */
    
    while (gtk_events_pending()) gtk_main_iteration();
    gdk_flush();

    return icon_view_p;
}

#if 0
#ifdef CYGWIN
need correct library name, I suppose it is not preceeded by lib
#endif
static 
const gchar *
get_module_name_from_path	(gchar *path){
    const gchar *module_name;
    if (!path || !strlen(path)) return NULL;
    module_name=(strncmp(path,"lib",strlen("lib"))==0)?path+strlen("lib"):path;
    return module_name;
}
#endif
    




static 
xfdir_t *
local_xfdir(		icon_view_t *icon_view_p,
			record_entry_t *en)
{
    static xfdir_t xfdir;
    if (!en || !en->path){
	g_warning("en==NULL");
	return NULL;
    }
    if (!g_file_test(en->path,G_FILE_TEST_IS_DIR)) return NULL;
		/* XXX parameter 3 is gchar with regexp for
		 * filter. Not used in iconview at the present time. */
    if (!en->st) {
	en->st=(struct stat *)malloc(sizeof(struct stat));
	stat(en->path,en->st);
    }
    print_status(&(icon_view_p->widgets),"xfce/info",_("Loading..."),NULL);
    get_xfdir_local(&xfdir, en, NULL);
    return &xfdir;
}

G_MODULE_EXPORT 
int
reload_iconview(icon_view_t *icon_view_p, record_entry_t *en, gboolean replace){
    GList *reselect_list=NULL,*tmp;
/* this entry (parent_en==icon_view_p->en) may be used by plugins to 
 * create up element, but plugins should copy_entry to malloc memory itself
 * This entry goes down the drain...*/
    record_entry_t *parent_en=NULL;
    xfdir_t *xfdir_p=NULL;
    time_t inicio = time(NULL);
    
    if (icon_view_p->redlight) {
	return FALSE;
    }
    icon_view_p->redlight=TRUE;
    icon_view_p->redlight2=TRUE;

    TRACE("reload_iconview...");
    cursor_wait(icon_view_p->widgets.window);
    

    print_status(&(icon_view_p->widgets),"xfce/info",_("Reading..."),NULL);
    while (gtk_events_pending()) gtk_main_iteration();
    gdk_flush();
    
    for (tmp=icon_view_p->selection_list; tmp; tmp=tmp->next){
	record_entry_t *en=(record_entry_t *)tmp->data;
	if (en && en->path)
	    reselect_list=g_list_append(reselect_list,g_strdup(en->path));
    }
    /*destroy_entry(icon_view_p->en);*/
    parent_en=icon_view_p->en;
    icon_view_p->en=NULL;
    
    destroy_population(icon_view_p);
    /* This causes flashing because paper is cleared before reload: 
     * 
     * gtk_widget_queue_draw(icon_view_p->paper);*/
    
#if 0
    /* let's restore icon size before loading...
     * this doesn't work because we must init the
     * iconview first, size allocating the paper.
     * In order for it to work, we need to read
     * first, to know how many elements.*/
    {
	iconview_geometry_t *iconview_geometry_p = get_iconview_geometry_p(icon_view_p);
	if (iconview_geometry_p &&  iconview_geometry_p->x >= 0 && iconview_geometry_p->y >= 0){
	    gtk_window_move((GtkWindow *)icon_view_p->widgets.window,iconview_geometry_p->x,iconview_geometry_p->y );
	    gdk_flush();
	    while (gtk_events_pending()) gtk_main_iteration();
	    gdk_flush();
	}
    }
#endif
    


    /* paper should now be clean (but might not be) */
    set_progress_full(&(icon_view_p->widgets),-1, -1);

    if (en) {
	iconview_preferences_t *iconview_preferences_p=get_iconview_preferences(en->path);
	if (iconview_preferences_p){
	    icon_view_p->preferences=iconview_preferences_p->preferences;
	    icon_view_p->sortcolumn=iconview_preferences_p->sortcolumn;
	}

	if (icon_view_p->preferences & __SHOW_HIDDEN) SET_SHOWS_HIDDEN(en->type);
	else UNSET_SHOWS_HIDDEN(en->type);
	if (icon_view_p->preferences & __SHOW_IMAGES) SET_SHOWS_IMAGES(en->type);
	else UNSET_SHOWS_IMAGES(en->type);
	if (en->path && g_file_test(en->path,G_FILE_TEST_IS_DIR)) SET_DIR(en->type);
    }

     if (icon_view_p->module_name) {
	const gchar *icon=function_natural("plugins",icon_view_p->module_name,NULL,"module_icon_id");
	if (en && en->path){
	    print_status(&(icon_view_p->widgets),icon,en->path,NULL);
	} else {
	    const gchar *label=function_natural("plugins",icon_view_p->module_name,en,"module_label");
	    print_status(&(icon_view_p->widgets),icon,label,NULL);
	}
    } 

    if (!en || !icon_view_p->module_name) {
	icon_view_p->submodule_name=NULL;
	if (!en) {
	    TRACE("call to add_icon_roots");
	    add_icon_roots(icon_view_p);
	    goto end;
	}
	xfdir_p=local_xfdir(icon_view_p,en);

    } else {
	TRACE("obtaining xfdir_p from module %s",icon_view_p->module_name);
	xfdir_p=module_xfdir(&(icon_view_p->widgets),icon_view_p->module_name,en);
	TRACE("xfdir_p obtained!");
	icon_view_p->submodule_name=function_void("plugins",icon_view_p->module_name,"submodule_name");
    }
    /* By this point we have loaded the xfdir structure. */
    set_progress_full(&(icon_view_p->widgets),-1, -1);

    if (!xfdir_p) init_icon_view(icon_view_p, en,0);
    else init_icon_view(icon_view_p, en,xfdir_p->pathc);
    set_iconview_title(icon_view_p);
    	    
    if (!xfdir_p) {
	if (icon_view_p->module_name && function_void("plugins",icon_view_p->module_name,"empty_text")) {
	    print_status(&(icon_view_p->widgets),"xfce/warning",function_void("plugins",icon_view_p->module_name,"empty_text"),NULL);
	} else {
	    print_status(&(icon_view_p->widgets),"xfce/warning",_("Nothing found"),NULL);
	}
    } else {
	TRACE("do quicksort here: sortcolumn is %d",icon_view_p->sortcolumn);
	TRACE("pathc is %d", xfdir_p->pathc);
	/*print_status(&(icon_view_p->widgets),"xfce/info",_("Sorting..."),NULL);
	while (gtk_events_pending()) gtk_main_iteration();
	gdk_flush();*/
	set_ascending(icon_view_p->preferences & SORT_ASCENDING);
	set_sort_column(icon_view_p->sortcolumn);
	qsort((void *)xfdir_p->gl, 
		xfdir_p->pathc, sizeof(dir_t), 
#ifdef __COMPAR_FN_T
		(__compar_fn_t)
#endif
		xfdir_compare);
    }
    set_progress_full(&(icon_view_p->widgets),-1, -1);

    /* make sure you have correct regeneration values here...*/
    icon_view_p->grid_columns = icon_view_p->paper->allocation.width / CELLSIZE;
    icon_view_p->grid_rows = icon_view_p->grid_area / icon_view_p->grid_columns;
    if (icon_view_p->grid_rows * icon_view_p->grid_columns 
	    < 
	icon_view_p->grid_area)
    {
	icon_view_p->grid_rows++;
    }
    /** **/

    gtk_widget_set_size_request (icon_view_p->paper, icon_view_p->paperX,icon_view_p->paperY);

    if (!load_xfdir_icons(icon_view_p, xfdir_p, reselect_list, parent_en)){
	xfdirfree(xfdir_p);
	destroy_entry(parent_en);	
	return FALSE;
    }
    
    xfdirfree(xfdir_p);
    if (!icon_view_p->module_name) {
	if (en && en->tag){  
	    const gchar *icon=NULL;
	    if (en->path && g_file_test(en->path,G_FILE_TEST_IS_DIR)){
		icon="xfce/open_folder";
	    }
	    else {
		icon=resolve_icon_id(en);
	    }
	    print_status(&(icon_view_p->widgets),icon,en->tag,NULL);
	} else if (en && en->path){
	    gchar *buf=g_strdup_printf(_("%d files"), 0);
	    gchar *base=g_path_get_basename(en->path);
	    print_status(&(icon_view_p->widgets),"xfce/open_folder",base," (",buf,")",NULL);
	    g_free(base);
	    g_free(buf);
	} else {
	    print_status(&(icon_view_p->widgets),NULL,"fixme:reload_icons()",NULL);
	}
    }
   


end:
    gtk_widget_hide(icon_view_p->widgets.progress);
    if (icon_view_p->en) icon_view_p->en->load_time = time(NULL) - inicio;
    icon_view_p->redlight=FALSE;
    restore_iconview_size(icon_view_p);
    TRACE("paper size=(%d,%d), allocation=(%d,%d)",
	    icon_view_p->paperX,
	    icon_view_p->paperY,
	    icon_view_p->paper->allocation.width,
	    icon_view_p->paper->allocation.height);
    for (tmp=reselect_list;  tmp; tmp=tmp->next){
	g_free(tmp->data);
    }
    if (reselect_list) g_list_free(reselect_list);
    cursor_reset(icon_view_p->widgets.window);
    gdk_flush();
    while (gtk_events_pending()){
	gtk_main_iteration();
    }
    gdk_flush();
    graphics_set_default_tooltip(icon_view_p,NULL);
    
    destroy_entry(parent_en);	
    icon_view_p->redlight2=FALSE;
    TRACE("reload is done");
    return TRUE;   
}
    

