#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <X11/Xlib.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>

#include "constants.h"
#include "types.h"

#include "primary.h"
#include "secondary.h"
#include "actions_lib.h"

#include "gridview_lib.h"
#include "gridview_input.h"
#include "gridview_popup.h"



/******************** common menu configuration ******************************/
extern void save_iconview_preferences(icon_view_t *icon_view_p);
extern gchar *workdir;
#include "gridview_popup-callbacks.i"
#include "gridview_popup.i"

/************** shared symbols (not to be used by other than gridview_lib ****/

G_MODULE_EXPORT
GtkWidget * 
gridview_mk_popup_menu (	GtkWidget *parent,
				GtkAccelGroup *accel_group,
				icon_view_t *icon_view_p)
{
    return (common_mk_popup_menu(&(icon_view_p->widgets),parent,accel_group,(void *)icon_view_p));
}


G_MODULE_EXPORT
void 
gridview_mk_module_popup_menu (	const gchar *module_name,
				icon_view_t *icon_view_p, 
				record_entry_t *en){
    const gchar *txt;
    if (!module_name) return;
    txt=function_natural("plugins",module_name,en,"module_label");
    
    /* set the submenu label */
    if (txt) {
        GtkWidget *label,*a=lookup_widget(icon_view_p->widgets.window,"module1");
        label = gtk_bin_get_child(GTK_BIN(a));
        gtk_label_set_text((GtkLabel *)label,my_utf_string(txt));
    }
    /* remove anything left over */
    gtk_container_foreach ((GtkContainer *)lookup_widget(icon_view_p->widgets.window,"module1_menu"), remove_menu_item,NULL);

    /* add new stuff to submenu */
    function_rational(	"plugins",
			module_name,
			(void *)(lookup_widget(icon_view_p->widgets.window,"module1_menu")),
			&(icon_view_p->widgets),
			"extend_popup");
    

}

