

#ifndef __MIME_ICONS_H__
#define __MIME_ICONS_H__

#ifdef LINKED_MODULES

#define MIME_ICON_get_local_xml_file mime_icon_get_local_xml_file
#define MIME_ICON_get_global_xml_file mime_icon_get_global_xml_file
#define MIME_ICON_find_themes mime_icon_find_themes
#define MIME_ICON_get_iconset mime_icon_get_iconset
#define MIME_ICON_add_iconset mime_icon_add_iconset
#define MIME_ICON_load_theme mime_icon_load_theme
#define MIME_ICON_create_pixmap mime_icon_create_pixmap
#define MIME_ICON_create_pixbuf mime_icon_create_pixbuf
#define MIME_ICON_find_pixmap_file mime_icon_find_pixmap_file
#define MIME_ICON_get_theme_path mime_icon_get_theme_path
#define MIME_ICON_check4icon_path mime_icon_check4icon_path

#else

#define MIME_ICON_get_local_xml_file (*(load_mime_icon_module()->mime_icon_get_local_xml_file))
#define MIME_ICON_get_global_xml_file (*(load_mime_icon_module()->mime_icon_get_global_xml_file))
#define MIME_ICON_find_themes (*(load_mime_icon_module()->mime_icon_find_themes))
#define MIME_ICON_get_iconset (*(load_mime_icon_module()->mime_icon_get_iconset))
#define MIME_ICON_add_iconset (*(load_mime_icon_module()->mime_icon_add_iconset))
#define MIME_ICON_load_theme (*(load_mime_icon_module()->mime_icon_load_theme))
#define MIME_ICON_create_pixmap (*(load_mime_icon_module()->mime_icon_create_pixmap))
#define MIME_ICON_create_pixbuf (*(load_mime_icon_module()->mime_icon_create_pixbuf))
#define MIME_ICON_find_pixmap_file (*(load_mime_icon_module()->mime_icon_find_pixmap_file))
#define MIME_ICON_get_theme_path (*(load_mime_icon_module()->mime_icon_get_theme_path))
#define MIME_ICON_check4icon_path (*(load_mime_icon_module()->mime_icon_check4icon_path))

#endif


typedef struct _xfmime_icon_functions xfmime_icon_functions;
struct _xfmime_icon_functions {
   GtkIconSet *(*mime_icon_get_iconset)(const gchar *id, GtkWidget *main_window);
   void (*mime_icon_add_iconset)(const gchar *tag, GtkIconSet *icon_set);
   int (*mime_icon_load_theme)(void);
   GtkWidget *(*mime_icon_create_pixmap) (GtkWidget *widget,const gchar *filename);
   GdkPixbuf *(*mime_icon_create_pixbuf) (const gchar *filename);
   gchar *(*mime_icon_find_pixmap_file)(const gchar     *filename);
   char **(*mime_icon_find_themes)(gboolean only_valid,gboolean full_paths);
   gchar *(*mime_icon_get_local_xml_file)(const gchar *theme_dir);
   gchar *(*mime_icon_get_global_xml_file)(const gchar *theme_dir);
   gchar *(*mime_icon_get_theme_path)(const gchar *theme);
   const gchar *(*mime_icon_check4icon_path)(const gchar *key);
};

G_MODULE_EXPORT
gchar *
mime_icon_get_local_xml_file(const gchar *theme_dir);
G_MODULE_EXPORT
gchar *
mime_icon_get_global_xml_file(const gchar *theme_dir);


/************************************************************/
/** mime_find_themes:
 * :
 * 
 * Looks for themes in the pixmap search path.
 *
 * Returns: an array of strings indicating the theme names
 * found. Memory must be freed after use. *
 *
 **/

G_MODULE_EXPORT
char **
mime_icon_find_themes(gboolean only_valid, gboolean full_paths);

/************************************************************/
/**
 * mime_icon_check4icon_path:
 * @filename: NULL terminated string indicating name of pixmap file,
 * no file extension needed.
 * 
 * Looks for @filename in the pixmap search path.
 *
 * Returns: the full path of the requested pixmap file. This is the 
 * best match in the pixmap search path. 
 * Will return NULL if specified icon is not found.
 * 
 *
 **/

const gchar *
mime_icon_check4icon_path(const gchar *key);

/************************************************************/
/**
 * mime_icon_find_pixmap_file:
 * @filename: NULL terminated string indicating name of pixmap file. 
 * 
 * Looks for @filename in the pixmap search path.
 *
 * Returns: the full path of the requested pixmap file. This is the 
 * best match in the pixmap search path. 
 * Will return path to pirate icon if specified icon is not found.
 * Returned value must be freed when no longer used.
 * 
 *
 **/

G_MODULE_EXPORT
gchar*
mime_icon_find_pixmap_file                       (const gchar     *filename);

/************************************************************/
/**
 * mime_icon_create_pixbuf:
 * @filename: NULL terminated string indicating name of pixmap file.
 * 
 * Looks for @filename in the pixmap search path, and then
 * returns a newly created GdkPixbuf created from the pixmap file
 * specified by @filename. Note that @filename is not an absolute 
 * path, but just a file name. If a pixmap is required, use
 * @mime_icon_create_pixmap instead.
 *
 * Returns: newly created GdkPixbuf from @filename or NULL if no
 * pixmap file from @filename can be found.
 *
 **/
G_MODULE_EXPORT
GdkPixbuf *
mime_icon_create_pixbuf (const gchar     *filename);

/************************************************************/
/**
 * mime_icon_create_pixmap:
 * @parent_widget: The parent widget from which to get colormap
 * information for the newly created pixmap
 * @filename: NULL terminated string indicating name of pixmap file.
 *
 * Looks for @filename in the pixmap search path, and then
 * returns a newly created pixmap created from the pixmap file
 * specified by @filename. Note that @filename is not an absolute 
 * path, but just a file name. If a GdkPixbuf is required, use
 * @mime_icon_create_pixbuf instead.
 *
 * Returns: newly created pixmap from @filename or NULL if no
 * pixmap file from @filename can be found.

 **/
G_MODULE_EXPORT
GtkWidget *
mime_icon_create_pixmap (GtkWidget *parent_widget, const gchar   *filename);

/************************************************************/
/**
 * mime_icon_get_iconset:
 * @id: the icon identifier string.
 * @main_window: the parent window from which to get colormap information.
 * @theme: the name of the theme from which to get the iconset.
 *
 *
 * Returns: the iconset identified by @id in the theme pointed by @theme. 
 * NULL if no iconset is associated to @id. 
 * 
 *
 **/

G_MODULE_EXPORT
GtkIconSet *
mime_icon_get_iconset(const gchar *id, GtkWidget *main_window);


gchar *mime_icon_get_theme_path(const gchar *theme);


/************************************************************/
/**
 * mime_icon_add_iconset:
 * @id: the icon identifier string.
 * @icon_set: the iconset to add to currently opened theme.
 *
 * Adds an iconset to the currently open theme
 *
 * Returns: void
 *
 **/

G_MODULE_EXPORT
void 
mime_icon_add_iconset(const gchar *id, GtkIconSet *icon_set);

/************************************************************/
/**
 * mime_icon_load_theme:
 * @theme: name of theme to load.
 *
 * Loads the icon theme information, creating a GHashTable to associate
 * icon identifiers with iconsets. This information is read from the 
 * theme XML file.
 *
 * Returns: newly created GHashTable associating icon identifiers with
 * iconsets. NULL if theme cannot be loaded.
 **/

G_MODULE_EXPORT
int 
mime_icon_load_theme(void);

#endif
