/*
 *  This file is part of X-File Manager XFM
 *  ----------------------------------------------------------------------
  FmAwCb.c

  (c) S.Marlow 1990-92
  (c) A.Graef 1994

  modified 2003,2005,2006 by Bernhard R. Link (see Changelog)

  Callback routines for widgets in the application window
 *  ----------------------------------------------------------------------
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <xfmconfig.h>

#include <stdio.h>
#include <memory.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include "global.h"

#include "Am.h"

/*---------------------------------------------------------------------------
  PUBLIC FUNCTIONS
---------------------------------------------------------------------------*/

void appInstallAppCb(UNUSED(Widget w), UNUSED(void *fw),
                     UNUSED(void *call_data))
{
  installNewAppPopup();
}

/*---------------------------------------------------------------------------*/

void appInstallGroupCb(UNUSED(Widget w), UNUSED(void *client_data),
                       UNUSED(void *call_data))
{
  installGroupPopup();
}

/*---------------------------------------------------------------------------*/

void appEditCb(UNUSED(Widget w), UNUSED(void *client_data),
               UNUSED(void *call_data))
{
  installExistingAppPopup();
}

/*---------------------------------------------------------------------------*/

void appCutCb(UNUSED(Widget w), UNUSED(void *client_data),
              UNUSED(void *call_data))
{
  char s[0xff];
  FILE *fp;
  Cardinal i, j;

  if (resources.confirm_moves) {
    sprintf(s, "Cutting %d item%s from", aw.n_selections,
	    aw.n_selections > 1 ? "s" : "" );
    if (!confirm(s, "the application window", ""))
      return;
  }

  if (! (fp = fopen(resources.app_clip, "w") )) {
    sysError("Error writing clip file:");
    return;
  }

  fprintf(fp, "#XFM\n");

  for (i=j=0; j<aw.n_apps; j++)
    if (!aw.apps[j].selected) {
      if (i != j)
	memcpy(&aw.apps[i], &aw.apps[j], sizeof(AppRec));
      i++;
    } else {
      fprintexpand(fp, aw.apps[j].name, "\\:");
      fputc(':',fp);
      fprintexpand(fp, aw.apps[j].directory, "\\:");
      fputc(':',fp);
      fputc(':',fp);
      fprintexpand(fp, aw.apps[j].icon, "\\:");
      fputc(':',fp);
      fprintexpand(fp, aw.apps[j].push_action, "\\:");
      fputc(':',fp);
      fprintexpand(fp, aw.apps[j].drop_action, "\\:");
      fputc('\n',fp);
      freeApplicationResources(&aw.apps[j]);
    }
  aw.n_apps =i;
  updateApplicationDisplay();
  writeApplicationData();

  if (fclose(fp))
    sysError("Error writing clip file:");
}

/*---------------------------------------------------------------------------*/

void appCopyCb(UNUSED(Widget w), UNUSED(void *client_data),
               UNUSED(void *call_data))
{
  char s[0xff];
  FILE *fp;
  Cardinal i;

  if (resources.confirm_copies) {
    sprintf(s, "Copying %d item%s from", aw.n_selections,
	    aw.n_selections > 1 ? "s" : "" );
    if (!confirm(s, "the application window", ""))
      return;
  }

  if (! (fp = fopen(resources.app_clip, "w") )) {
    sysError("Error writing clip file:");
    return;
  }

  fprintf(fp, "#XFM\n");

  for (i=0; i < aw.n_apps; i++)
    if (aw.apps[i].selected) {
      fprintexpand(fp, aw.apps[i].name, "\\:");
      fputc(':',fp);
      fprintexpand(fp, aw.apps[i].directory, "\\:");
      fputc(':',fp);
      fputc(':',fp);
      fprintexpand(fp, aw.apps[i].icon, "\\:");
      fputc(':',fp);
      fprintexpand(fp, aw.apps[i].push_action, "\\:");
      fputc(':',fp);
      fprintexpand(fp, aw.apps[i].drop_action, "\\:");
      fputc('\n',fp);
    }
  
  if (fclose(fp))
    sysError("Error writing clip file:");
}

/*---------------------------------------------------------------------------*/

void appPasteCb(UNUSED(Widget w), UNUSED(void *client_data),
                UNUSED(void *call_data))
{
  FILE *fp;
  int p;
  
  if (!(fp = fopen(resources.app_clip, "r"))) return;

  do{
	  p = parseApp(fp,True);
  } while( p > 0 );

  if (p == -1)
    error("Error in clip file", "");

  if (fclose(fp))
    sysError("Error reading clip file:");

  updateApplicationDisplay();
  writeApplicationData();
}

/*---------------------------------------------------------------------------*/

void appRemoveCb(UNUSED(Widget w), UNUSED(void *client_data),
                 UNUSED(void *call_data))
{
  char s[0xff];
  Cardinal i, j;

  if (resources.confirm_deletes) {
    sprintf(s, "Deleting %d item%s from", aw.n_selections,
	    aw.n_selections > 1 ? "s" : "" );
    if (!confirm(s, "the application window", ""))
      return;
  }

  for (i=j=0; j<aw.n_apps; j++)
    if (!aw.apps[j].selected) {
      if (i != j)
	memcpy(&aw.apps[i], &aw.apps[j], sizeof(AppRec));
      i++;
    } else
      freeApplicationResources(&aw.apps[j]);
  aw.n_apps =i;
  updateApplicationDisplay();
  writeApplicationData();
}

/*---------------------------------------------------------------------------*/

void appSelectAllCb(UNUSED(Widget w), UNUSED(void *client_data),
                    UNUSED(void *call_data))
{
  Cardinal i;
  Pixel pix;
  
  for (i=0; i < aw.n_apps; i++)
    if (!aw.apps[i].selected) {
      XtVaGetValues(aw.apps[i].toggle, XtNforeground, &pix, NULL);
      XtVaSetValues(aw.apps[i].toggle, XtNborder, (XtArgVal) pix, NULL);
      aw.apps[i].selected = True;
    }
  aw.n_selections = aw.n_apps;
}

/*---------------------------------------------------------------------------*/

void appDeselectCb(UNUSED(Widget w), UNUSED(void *client_data),
                   UNUSED(void *call_data))
{
  Cardinal i;
  Pixel pix;
  
  for (i=0; i < aw.n_apps; i++)
    if (aw.apps[i].selected) {
      XtVaGetValues(aw.apps[i].toggle, XtNbackground, &pix, NULL);
      XtVaSetValues(aw.apps[i].toggle, XtNborder, (XtArgVal) pix, NULL);
      aw.apps[i].selected = False;
    }
  aw.n_selections = 0;
}

/*---------------------------------------------------------------------------*/

void appLoadCb(UNUSED(Widget w), UNUSED(void *client_data),
               UNUSED(void *call_data))
{
  AmReadUpdate();
}

/*---------------------------------------------------------------------------*/

void appMainCb(UNUSED(Widget w), UNUSED(void *client_data),
               UNUSED(void *call_data))
{
	XTFREE(aw.app_file);
#ifdef SYSTEMWIDE_DEFAULTS
	if (!exists(resources.main_app_file))
		/* if the main_app_file is not found, use the system_main_app_file
		 * instead. (Only change app_file and not main_app_file, to
		 * allow adding a user-file while running). */
		aw.app_file = XtNewString(resources.system_main_app_file);
	else
#endif
		aw.app_file = XtNewString(resources.main_app_file);
  clearApplicationsStack();
  AmReadUpdate();
}

/*---------------------------------------------------------------------------*/

void appBackCb(UNUSED(Widget w), UNUSED(void *client_data),
               UNUSED(void *call_data))
{
  if (n_appst > 0) {
    popApplicationsFile();
    AmReadUpdate();
  }
}

/*---------------------------------------------------------------------------*/

void appOpenCb(UNUSED(Widget w), UNUSED(void *client_data),
               UNUSED(void *call_data))
{
  newFileWindow(user.home,resources.initial_display_type,False);
}

/*---------------------------------------------------------------------------*/

void appCloseCb(UNUSED(Widget w), UNUSED(void *client_data),
		UNUSED(void *call_data))
{
  if (resources.confirm_quit && !confirm("", "Exit file manager?", ""))
    return;

  quit(0);
}

/*---------------------------------------------------------------------------*/

void aboutCb(UNUSED(Widget w), UNUSED(void *client_data),
             UNUSED(void *call_data))
{
  aboutPopup();
}
