dnl Checks for the --with-sound option on ./configure

AC_DEFUN([SOUND], [
AC_ARG_WITH(sound,
  [  --with-sound         compile with sound support],
  [cv_compile_sound=$withval],
  [AC_CACHE_CHECK(compile with sound support, cv_compile_sound,
	[cv_compile_sound=no
         test -c "/dev/audio" && cv_compile_sound=yes])]
)
if test x$cv_compile_sound = xyes; then
   SOUND_CFLAGS="$SOUND_CFLAGS -DUSE_SOUND"
   AC_SUBST(SOUND_CFLAGS)
fi
])

dnl Checks for the --with-nas-sound option on ./configure
AC_DEFUN([NAS_SND], [
AC_ARG_WITH(nas-sound,
    [  --with-nas-sound        compile with net audio support],
    [cv_compile_nas_sound=$withval],
    [AC_CACHE_CHECK(compile with net audio support,cv_compile_nas_sound,
	[cv_compile_nas_sound=no])]
)
if test x$cv_compile_nas_sound = xyes; then
   SOUND_CFLAGS="$SOUND_CFLAGS -DUSE_SOUND -DNAS_SOUND"
   SOUND_LIBS=-laudio
fi
  AC_SUBST(SOUND_LIBS)
  AC_SUBST(SOUND_CFLAGS)
])

dnl Checks for the --with-esd-sound option on ./configure
AC_DEFUN([ESD_SND], [
AC_ARG_WITH(esd-sound,
    [  --with-esd-sound        do compile with ESD support],
    [cv_compile_esd_sound=$withval],
    [AC_CACHE_CHECK(compile with ESD support,cv_compile_esd_sound,
        [cv_compile_esd_sound=no])]
)
if test x$cv_compile_esd_sound = xyes; then
   AC_CHECK_HEADER(esd.h)
   SOUND_CFLAGS="$SOUND_CFLAGS -DUSE_SOUND -DUSE_ESOUND"
   SOUND_LIBS="$SOUND_LIBS -lesd"
fi
AC_SUBST(SOUND_LIBS)
AC_SUBST(SOUND_CFLAGS)
])
