/* $Id: about.cpp,v 1.9 2002/07/24 07:43:00 fesnel Exp $ */
/*******************************************************************************
 *   This program is part of the XFMail email client.                          *
 *                                                                             *
 *   Copyright : (C) 1995-1998 Gennady B. Sorokopud (gena@NetVision.net.il)    *
 *               (C) 1995 Ugen. J. S. Antsilevich (ugen@latte.worldbank.org)   *
 *               (C) 1998-2002 by the Archimedes Project                       *
 *                   http://sourceforge.net/projects/archimedes                *
 *                                                                             *
 *             --------------------------------------------                    *
 *                                                                             *
 *   This program is free software; you can redistribute it and/or modify      *
 *   it under the terms of the GNU General Public License as published by      *
 *   the Free Software Foundation; either version 2 of the License, or         *
 *   (at your option) any later version.                                       *
 *                                                                             *
 *   This program is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY, without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *   GNU General Public License for more details.                              *
 *                                                                             *
 *   You should have received a copy of the GNU General Public License         *
 *   along with this program; if not, write to the Free Software               *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307, USA.  *
 *                                                                             *
 *   Additional Permission granted:                                            *
 *                                                                             *
 *   This program is designed to use the XForms library, so we consider        *
 *   permission to link to that non-GPL-compatible library is implicit.        *
 *   However, in case this is not considered so, we explicitly state:          *
 *                                                                             *
 *   "As a special exception, the Archimedes Project, with the permission      *
 *    of all earlier copyright holders, formally gives permission to link      *
 *    this program with the XForms library, and distribute the resulting       *
 *    executable without the source code for XForms in the source              *
 *    distribution".                                                           *
 *                                                                             *
 ******************************************************************************/

#include <fmail.h>
#include <umail.h>
#include <choose_folder.h>

#include <cfgfile.h>

extern cfgfile Config;

static int ready = 0;
FD_About_Form *about_obj;

void about(int wait) {
	char buf[512], compdate[64], *by;

	if((wait == 2) && (ready == 1))
		goto end_about;

	if(ready == 1)
		return;

	about_obj = create_form_About_Form();
	if(wait == 1)
		fl_set_timer(about_obj->About_Timer, 3);
	snprintf(compdate, sizeof(compdate), "%s", COMPILED);
	by = strstr(compdate, " by ");
	*by = '\0';
	by += 4;
	snprintf(buf, sizeof(buf),
			 "Version: %s%s OS: %s\nCompiled at: %s\nBy: %s [%i/%i]", VERSION,
			 DEBUGVERSION, XF_OS, compdate, by, Config.sizeSaved(), Config.size());
	fl_set_object_label(about_obj->Version_Text, buf);
	fl_set_form_minsize(about_obj->About_Form, 380, 290);
	fl_set_form_maxsize(about_obj->About_Form, 380, 290);
	if(wait)
		fl_show_form(about_obj->About_Form, FL_PLACE_CENTER, FL_NOBORDER,
					 NULL);
	else
		fl_show_form(about_obj->About_Form, FL_PLACE_CENTER, FL_TRANSIENT,
					 "About XFMail");

	if(wait == 1)
		return;

	ready = 1;
	fl_do_only_forms();

	end_about:fl_hide_form(about_obj->About_Form);
	fl_free_form(about_obj->About_Form);
	fl_free(about_obj);
	about_obj = NULL;
	ready = 0;
	return;
}

void About_Timer_Call(FL_OBJECT * obj, long param) {
	if(ready != 1)
		return;

	about_obj = NULL;
	fl_hide_form(about_obj->About_Form);
	fl_free_form(about_obj->About_Form);
	fl_free(about_obj);
	ready = 0;
}
