/* $Id: config.cpp,v 1.11 2002/12/05 20:34:47 fesnel Exp $ */
/*******************************************************************************
 *   This program is part of the XFMail email client.                          *
 *                                                                             *
 *   Copyright : (C) 1995-1998 Gennady B. Sorokopud (gena@NetVision.net.il)    *
 *               (C) 1995 Ugen. J. S. Antsilevich (ugen@latte.worldbank.org)   *
 *               (C) 1998-2002 by the Archimedes Project                       *
 *                   http://sourceforge.net/projects/archimedes                *
 *                                                                             *
 *             --------------------------------------------                    *
 *                                                                             *
 *   This program is free software; you can redistribute it and/or modify      *
 *   it under the terms of the GNU General Public License as published by      *
 *   the Free Software Foundation; either version 2 of the License, or         *
 *   (at your option) any later version.                                       *
 *                                                                             *
 *   This program is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY, without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *   GNU General Public License for more details.                              *
 *                                                                             *
 *   You should have received a copy of the GNU General Public License         *
 *   along with this program; if not, write to the Free Software               *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307, USA.  *
 *                                                                             *
 *   Additional Permission granted:                                            *
 *                                                                             *
 *   This program is designed to use the XForms library, so we consider        *
 *   permission to link to that non-GPL-compatible library is implicit.        *
 *   However, in case this is not considered so, we explicitly state:          *
 *                                                                             *
 *   "As a special exception, the Archimedes Project, with the permission      *
 *    of all earlier copyright holders, formally gives permission to link      *
 *    this program with the XForms library, and distribute the resulting       *
 *    executable without the source code for XForms in the source              *
 *    distribution".                                                           *
 *                                                                             *
 ******************************************************************************/


#include <fmail.h>
#include <umail.h>
#include <cfgfile.h>
#include "configform.h"

#define CONFIG_ACCOUNTS_MISC_ENTRIES 7
#define CONFIG_SETTINGS_ENTRIES  8

extern cfgfile Config;

static FD_configuredisplay *config_display_form = NULL;
static FD_configuremisc *config_misc_form = NULL;

static FD_config_misc *config_misc;
static FD_config_timers *config_timers;
static FD_config_viewedit *config_viewedit;
static FD_config_send *config_send;
static FD_config_receive *config_receive;
static FD_config_news *config_news;
#ifdef HAVE_LDAP
static FD_config_ldap *config_ldap;
#endif

static FD_config_display *config_display;
static FD_config_faces *config_faces;
static FD_config_reply *config_reply;
static FD_config_intern *config_intern;
static FD_config_mime *config_mime;
static FD_config_spell *config_spell;
static FD_config_header *config_header;
static FD_config_pgp *config_pgp;

static int help_misc_chapter[CONFIG_ACCOUNTS_MISC_ENTRIES] =
{ 14, 23, 18, 22, 16, 41, 45};
static int help_display_chapter[CONFIG_SETTINGS_ENTRIES] =
{ 17, 24, 26, 27, 25, 34, 39, 29};

static void handle_config_display_input() {
	handle_sort_input(config_display);
	handle_faces_input(config_faces);
	handle_reply_input(config_reply);
	handle_intern_input(config_intern);
	handle_charsets_input(config_intern);
	handle_spell_input(config_spell);
	handle_header_input(config_header);
	handle_pgp_input(config_pgp);
}

static void handle_config_misc_input() {
	handle_misc_input(config_misc);
	handle_timers_input(config_timers);
	handle_view_input(config_viewedit);
	handle_edit_input(config_viewedit);
	handle_smtp_input(config_send);
	handle_inc_input(config_receive);
	handle_news_input(config_news);
#ifdef HAVE_LDAP
	handle_ldap_input(config_ldap);
#endif
}

static void init_config_display() {
	sort_conf(0, config_display);
	faces_conf(0, config_faces);
	reply_conf(0, config_reply);
	int_conf(0, config_intern);
	charset_conf(0, config_intern);
	mime_conf(config_mime);
	spell_conf(0, config_spell);
	header_conf(0, config_header);
	pgp_conf(0, config_pgp);
}

static void init_config_misc() {
	misc_conf(0, config_misc);
	timers_conf(0, config_timers);
	smtp_conf(0, config_send);
	inc_conf(0, config_receive);
	view_conf(0, config_viewedit);
	edit_conf(0, config_viewedit);
	news_conf(0, config_news);
#ifdef HAVE_LDAP
	ldap_conf(0, config_ldap);
#endif
}

static void init_config_display_default(int dnr) {
	switch(dnr) {
		case 1:
			sort_conf(1, config_display);
			break;
		case 2:
			faces_conf(1, config_faces);
			break;
		case 3:
			reply_conf(1, config_reply);
			break;
		case 4:
			int_conf(1, config_intern);
			charset_conf(1, config_intern);
			break;
		case 6:
			spell_conf(1, config_spell);
			break;
		case 7:
			header_conf(1, config_header);
			break;
		case 8:
			pgp_conf(1, config_pgp);
			break;
	}
}

static void init_config_misc_default(int dnr) {
	switch(dnr) {
		case 1:
			misc_conf(1, config_misc);
			break;
		case 2:
			timers_conf(1, config_timers);
			break;
		case 3:
			view_conf(1, config_viewedit);
			edit_conf(1, config_viewedit);
			break;
		case 4:
			smtp_conf(1, config_send);
			break;
		case 5:
			inc_conf(1, config_receive);
			break;
		case 6:
			news_conf(1, config_news);
			break;
#ifdef HAVE_LDAP
		case 7:
			ldap_conf(1, config_ldap);
			break;
#endif
	}
}

void config_display_cb(FL_OBJECT * obj, long param) {
	fl_set_object_callback(config_display_form->help_button,
						   cb_help_button,
						   help_display_chapter[fl_get_active_folder_number
												(config_display_form->
												 tab) - 1]);
}

void config_misc_cb(FL_OBJECT * obj, long param) {
	fl_set_object_callback(config_misc_form->help_button, cb_help_button,
						   help_misc_chapter[fl_get_active_folder_number
											 (config_misc_form->tab) - 1]);
}

void xfm_config(long dnr) {
	FL_OBJECT *obj;

	if(!config_display_form) {
		config_display_form = create_form_configuredisplay();
		config_display = create_form_config_display();
		config_faces = create_form_config_faces();
		config_reply = create_form_config_reply();
		config_intern = create_form_config_intern();
		config_mime = create_form_config_mime();
		config_spell = create_form_config_spell();
		config_header = create_form_config_header();
		config_pgp = create_form_config_pgp();
		fl_addto_tabfolder(config_display_form->tab, "Display",
						   config_display->config_display);
		fl_addto_tabfolder(config_display_form->tab, "Faces",
						   config_faces->config_faces);
		fl_addto_tabfolder(config_display_form->tab, "Reply/Fwd",
						   config_reply->config_reply);
		fl_addto_tabfolder(config_display_form->tab, "Charsets",
						   config_intern->config_intern);
		fl_addto_tabfolder(config_display_form->tab, "MIME",
						   config_mime->config_mime);
		fl_addto_tabfolder(config_display_form->tab, "Spellchecker",
						   config_spell->config_spell);
		fl_addto_tabfolder(config_display_form->tab, "Header",
						   config_header->config_header);
		fl_addto_tabfolder(config_display_form->tab, "PGP",
						   config_pgp->config_pgp);
		fl_set_object_callback(config_display_form->tab, config_display_cb,
							   0);
	}

	fl_set_object_callback(config_display_form->help_button,
						   cb_help_button, help_display_chapter[dnr - 1]);
	init_config_display();

	fl_set_form_minsize(config_display_form->configuredisplay, 620, 360);
	fl_set_form_maxsize(config_display_form->configuredisplay, 620, 360);
	fl_show_form(config_display_form->configuredisplay,
				 FL_PLACE_CENTER, FL_TRANSIENT, "Configure");

	fl_set_folder_bynumber(config_display_form->tab, dnr);

	do {
		obj = fl_do_only_forms();
		if(obj == config_display_form->defaults_button) {
			init_config_display_default(fl_get_active_folder_number
										(config_display_form->tab));
		}
	} while(obj != config_display_form->Done_Conf
			&& obj != config_display_form->Cancel_Conf);

	if(obj == config_display_form->Done_Conf) {
		handle_config_display_input();
		if(Config.save(0) < 0)
			display_msg(MSG_WARN, "Configuration Save failed!", "%s",
						conf_name);
	}

	if(obj == config_display_form->Cancel_Conf) {
		if(Config.load(conf_name) < 0)
			display_msg(MSG_WARN, "Configuration Load failed!", "%s",
						conf_name);
	}
	fl_hide_form(config_display_form->configuredisplay);
	return;
}

void xfm_config_new(long dnr) {
	FL_OBJECT *obj;

	if(!config_misc_form) {
		config_misc_form = create_form_configuremisc();
		config_misc = create_form_config_misc();
		config_timers = create_form_config_timers();
		config_viewedit = create_form_config_viewedit();
		config_send = create_form_config_send();
		config_receive = create_form_config_receive();
		config_news = create_form_config_news();
#ifdef HAVE_LDAP
		config_ldap = create_form_config_ldap();
#endif
		fl_addto_tabfolder(config_misc_form->tab, "General",
						   config_misc->config_misc);
		fl_addto_tabfolder(config_misc_form->tab, "Timers",
						   config_timers->config_timers);
		fl_addto_tabfolder(config_misc_form->tab, "View/Edit",
						   config_viewedit->config_viewedit);
		fl_addto_tabfolder(config_misc_form->tab, "Send",
						   config_send->config_send);
		fl_addto_tabfolder(config_misc_form->tab, "Receive",
						   config_receive->config_receive);
		fl_addto_tabfolder(config_misc_form->tab, "NEWS",
						   config_news->config_news);
#ifdef HAVE_LDAP
		fl_addto_tabfolder(config_misc_form->tab, "LDAP",
						   config_ldap->config_ldap);
#endif
		fl_set_object_callback(config_misc_form->tab, config_misc_cb, 0);
	}

	fl_set_object_callback(config_misc_form->help_button, cb_help_button,
						   help_misc_chapter[dnr - 1]);
	init_config_misc();

	fl_set_form_minsize(config_misc_form->configuremisc, 620, 360);
	fl_set_form_maxsize(config_misc_form->configuremisc, 620, 360);
	fl_show_form(config_misc_form->configuremisc,
				 FL_PLACE_CENTER, FL_TRANSIENT, "Configure");

	fl_set_folder_bynumber(config_misc_form->tab, dnr);

	do {
		obj = fl_do_only_forms();
		if(obj == config_misc_form->defaults_button) {
			init_config_misc_default(fl_get_active_folder_number
									 (config_misc_form->tab));
		}
	} while(obj != config_misc_form->Done_Conf
			&& obj != config_misc_form->Cancel_Conf);

	if(obj == config_misc_form->Done_Conf) {
		handle_config_misc_input();
		if(Config.save(0) < 0)
			display_msg(MSG_WARN, "Configuration Save failed!", "%s",
						conf_name);
	}

	if(obj == config_misc_form->Cancel_Conf) {
		if(Config.load(conf_name) < 0)
			display_msg(MSG_WARN, "Configuration Load failed!", "%s",
						conf_name);
	}
	fl_hide_form(config_misc_form->configuremisc);
	return;
}
