/* $Id: addrbookdb.h,v 1.6 2004/01/02 03:54:01 fesnel Exp $ */
/*******************************************************************************
 *   This program is part of a library used by the Archimedes email client     * 
 *                                                                             *
 *   Copyright : (C) 1995-1998 Gennady B. Sorokopud (gena@NetVision.net.il)    *
 *               (C) 1995 Ugen. J. S. Antsilevich (ugen@latte.worldbank.org)   *
 *               (C) 1998-2004 by the Archimedes Project                       *
 *                   http://sourceforge.net/projects/archimedes                *
 *                                                                             *
 *             --------------------------------------------                    *
 *                                                                             *
 *   This program is free software; you can redistribute it and/or modify      *
 *   it under the terms of the GNU Library General Public License as published *
 *   by the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                       *
 *                                                                             *
 *   This program is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY, without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *   GNU Library General Public License for more details.                      *
 *                                                                             *
 *   You should have received a copy of the GNU Library General Public License *
 *   along with this program; if not, write to the Free Software               *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307, USA.  *
 *                                                                             *
 ******************************************************************************/

#ifndef __ADDRBOOKDB_H__
#define __ADDRBOOKDB_H__

#include "addrbook.h"

class AddressBookDB : public list<AddressBook *> {
  public:
	AddressBookDB() {}
	~AddressBookDB();

	bool AddBook(AddressBook *book);
	bool NewBook(string name);
	bool DeleteBook(string name);

	/* Delete AddressBook file from disk */
	void DeleteBookFile(const char *configdir, string name);

	AddressBook *FindBook(string name);

	AddressBookEntry *FindEntry(const char *addr);
	AddressBookEntry *FindEntry(struct _mail_addr *addr);

	bool Load(const char *configdir);
	bool Save(const char *configdir);

	iterator Begin() { return list<AddressBook *>::begin(); }
	iterator End() { return list<AddressBook *>::end(); }

	const_iterator Begin() const { return list<AddressBook *>::begin(); }
	const_iterator End() const { return list<AddressBook *>::end(); }

	/* to remain compatible with STL naming conventions */
	iterator begin() { return Begin(); }
	iterator end() { return End(); }

	const_iterator begin() const { return Begin(); }
	const_iterator end() const { return End(); }

	/* Clear database */
	void Clear();

  private:

	/* forbidden */
	AddressBookDB(const AddressBookDB &addrbookdb);
	AddressBookDB &operator=(const AddressBookDB &addrbookdb);

};

#endif /* __ADDRBOOKDB_H__ */
