/* $Id: pgp.h,v 1.11 2004/01/02 03:54:01 fesnel Exp $ */
/*******************************************************************************
 *   This program is part of a library used by the Archimedes email client     * 
 *                                                                             *
 *   Copyright : (C) 1995-1998 Gennady B. Sorokopud (gena@NetVision.net.il)    *
 *               (C) 1995 Ugen. J. S. Antsilevich (ugen@latte.worldbank.org)   *
 *               (C) 1998-2004 by the Archimedes Project                       *
 *                   http://sourceforge.net/projects/archimedes                *
 *                                                                             *
 *             --------------------------------------------                    *
 *                                                                             *
 *   This program is free software; you can redistribute it and/or modify      *
 *   it under the terms of the GNU Library General Public License as published *
 *   by the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                       *
 *                                                                             *
 *   This program is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY, without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *   GNU Library General Public License for more details.                      *
 *                                                                             *
 *   You should have received a copy of the GNU Library General Public License *
 *   along with this program; if not, write to the Free Software               *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307, USA.  *
 *                                                                             *
 ******************************************************************************/


#ifndef PGP_H_
#define PGP_H_

#include <glib.h>

#include <fmail.h>
#include <cfgfile.h>
#include <connectionManager.h>

#ifdef HAVE_SYS_SELECT_H
	#include <sys/select.h>
#endif

extern cfgfile Config;
extern class connectionManager ConMan;

#define PGP_DEFAULT_VERS    500 /* use PGP-5.0 by default */
#define PGP_TIMEOUT     120 /* PGP process timeout (in seconds) */

void pgp_timer_cb();
void scramble(char * string);
int compare_pgpkeys(struct _pgp_keylist *entry1, struct _pgp_keylist *entry2);

typedef struct _pgp_keylist {
	char *userid;
	unsigned long keyid;
}
pgp_keylist;

#define PGP_ENC_START   "-----BEGIN PGP MESSAGE-----"
#define PGP_SIG_START   "-----BEGIN PGP SIGNED MESSAGE-----"
#define PGP_KEY_START   "-----BEGIN PGP PUBLIC KEY BLOCK-----"

#define NORMAL      1
#define KEYRING     2
#define HTTP        4

#endif
