#!/bin/sh
# Run this to generate all the initial makefiles, etc.

srcdir=`dirname $0`
test -z "$srcdir" && srcdir=.

DIE=0

(${AUTOCONF:-autoconf} --version) < /dev/null > /dev/null 2>&1 || {
	echo
	echo "You must have autoconf installed to compile xfmail."
	DIE=1
}

(${LIBTOOL:-libtool} --version) < /dev/null > /dev/null 2>&1 || {
	echo
	echo "You must have libtool installed to compile xfmail."
	DIE=1
}

(${AUTOMAKE:-automake} --version) < /dev/null > /dev/null 2>&1 || {
	echo
	echo "You must have automake installed to compile xfmail."
	DIE=1
}

if test "$DIE" -eq 1; then
	exit 1
fi

THEDIR="`pwd`"

cd $srcdir
${ACLOCAL:-aclocal} -I macros $ACLOCAL_FLAGS
${LIBTOOLIZE:-libtoolize} --copy --force
${AUTOHEADER:-autoheader}
${AUTOCONF:-autoconf}
${AUTOMAKE:-automake} --gnu --add-missing -c
cd "$THEDIR"

#
# If we're not doing a distribution build run configure script.
#
if [ "$DIST_BUILD" != "YES" ]; then
    if test -z "$*"; then
	echo "I am going to run ./configure with no arguments - if you wish "
        echo "to pass any to it, please specify them on the $0 command line."
    fi

    $srcdir/configure "$@"

    echo 
    echo "Now type 'make' to compile xfmail."
    echo "If you have problems, please see the directory docs/"
    echo "for possible resolutions."
fi
