/*
 *  xfmedia - simple gtk2 media player based on xine
 *
 *  Copyright (c) 2004-2005 Brian Tarricone, <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XFMEDIA__COMMON_H_
#define _XFMEDIA__COMMON_H_

#include <glib.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <gtk/gtk.h>

#include <libxfcegui4/xfce-icontheme.h>

#include <xine.h>

#include "gtkxine.h"
#include "trayicon.h"
#include <xfmedia/xfmedia-playlist.h>

#define round(x) ( ((gdouble)x-(gint)x) >= 0.5000 ? ((gint)x)+1 : (gint)x )
#define BORDER 8

#if !GTK_CHECK_VERSION(2, 6, 0)
#define GTK_STOCK_MEDIA_NEXT       "gtk-media-next"
#define GTK_STOCK_MEDIA_PAUSE      "gtk-media-pause"
#define GTK_STOCK_MEDIA_PLAY       "gtk-media-play"
#define GTK_STOCK_MEDIA_PREVIOUS   "gtk-media-previous"
#define GTK_STOCK_MEDIA_STOP       "gtk-media-stop"
#define GTK_STOCK_ABOUT            "gtk-about"
#define GTK_STOCK_DIRECTORY        "gtk-directory"
#endif

G_BEGIN_DECLS

typedef struct _XfMediaMainwin
{
	GtkWidget *window;
	GdkWindow *window_decs;
	GtkWidget *autohide_window;
	gint temp_disable_autohide;
	guint autohide_timer;
	gboolean is_iconified;
	GtkWidget *video_window;
	
	gint session_id;
	
	XfMediaTrayIcon *tray_icon;
	GtkWidget *tray_icon_menu;
	GtkWidget *tray_icon_playpause_btn;
	GtkWidget *tray_icon_play_img;
	GtkWidget *tray_icon_pause_img;
	
	GtkWidget *fs_controls;
	GtkWidget *fs_playpause_btn;
	GtkWidget *fs_play_btn_img;
	GtkWidget *fs_pause_btn_img;
	GtkWidget *fs_time_label;
	GtkWidget *fs_position_slider;
	
	GtkWidget *popup_menu;
	GtkWidget *time_label;
	gboolean show_time_remaining;
	GtkWidget *song_label;
	GtkWidget *position_slider;
	gboolean slider_sticky;
    
    GtkWidget *progress_box;
    GtkWidget *progress_label;
    GtkWidget *progress_bar;
    
    GtkWidget *ui_message_label;
	
	GtkWidget *playpause_btn;
	GtkWidget *play_btn_img;
	GtkWidget *pause_btn_img;
	
	GtkWidget *playlist_pane;
	
	GtkWidget *shuffle_mi;
	GtkWidget *repeat_mi;
	GtkWidget *svis_mi;
    GtkWidget *mmarks_mi;
	
	GtkTooltips *tooltips;
	
	guint pos_id;
    gboolean oneshot;
    XfMediaPlaylistEntryRef *cur_playing;
    gint cur_playing_length;
    GQueue *shuffle_history;
	
	GtkXine *gtx;
	XfMediaPlaylist *plist;
	
	/* this sucks.  xine will block if a stream is playing and you try to open
	 * another one and get info about it.  in fact, it locks the whole display,
	 * including the keyboard.  so, we need to keep another one around. */
	xine_t *extra_xine;
	xine_stream_t *extra_stream;
	xine_video_port_t *extra_vp;
	xine_audio_port_t *extra_ap;
	
	/* settings dialog */
	GtkTreeView *ip_list;
	GtkTreeView *op_list;
	GtkWidget *tray_mini_chk;
} XfMediaMainwin;

extern XfceIconTheme *icon_theme;
extern const GdkPixdata xfmedia_icon;

void xfmedia_init_icon_theme();
GtkWidget *xfmedia_custom_button_new(const gchar *text, const gchar *icon);
GtkWidget *xfmedia_custom_button_new_from_pixdata(const gchar *text, const GdkPixdata *pixdata);
gchar *xfmedia_filename_to_name(const gchar *filename);
gchar *xfmedia_sinfo_to_string(xine_stream_t *stream, const gchar *fmt, const gchar *mrl);
gchar *xfmedia_num_prettify(gint num);
GdkWindow *xfmedia_get_window_decorations(GdkWindow *gwindow);
GList *xfmedia_uri_list_extract_uris(const gchar *uri_list);
gint xfmedia_tree_path_to_index(GtkTreePath *path);
gboolean xfmedia_list_store_remove_path(GtkListStore *ls, GtkTreePath *path);
gchar *xfmedia_brutal_utf8_validate(const gchar *string);
void xfmedia_stock_icons_init();
GdkPixbuf *xfmedia_load_stock_control_button(const gchar *stock_id, GtkIconSize size);
GtkWidget *xfmedia_squished_stock_icon_load(const gchar *stock_id, GtkIconSize size);

G_END_DECLS

#endif
