/* interface.c generated by valac, the Vala compiler
 * generated from interface.vala, do not modify */

/*
 *  Copyright (c) 2009-2010 Mike Massonnet <mmassonnet@xfce.org>
 *  Copyright (c) 2009-2010 Vincent Legout <vincent@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <mpdclient.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <pango/pango.h>


#define XFMPC_TYPE_INTERFACE (xfmpc_interface_get_type ())
#define XFMPC_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_INTERFACE, XfmpcInterface))
#define XFMPC_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_INTERFACE, XfmpcInterfaceClass))
#define XFMPC_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_INTERFACE))
#define XFMPC_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_INTERFACE))
#define XFMPC_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_INTERFACE, XfmpcInterfaceClass))

typedef struct _XfmpcInterface XfmpcInterface;
typedef struct _XfmpcInterfaceClass XfmpcInterfaceClass;
typedef struct _XfmpcInterfacePrivate XfmpcInterfacePrivate;

#define XFMPC_TYPE_PREFERENCES (xfmpc_preferences_get_type ())
#define XFMPC_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_PREFERENCES, XfmpcPreferences))
#define XFMPC_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_PREFERENCES, XfmpcPreferencesClass))
#define XFMPC_IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_PREFERENCES))
#define XFMPC_IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_PREFERENCES))
#define XFMPC_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_PREFERENCES, XfmpcPreferencesClass))

typedef struct _XfmpcPreferences XfmpcPreferences;
typedef struct _XfmpcPreferencesClass XfmpcPreferencesClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))

struct _XfmpcInterface {
	GtkVBox parent_instance;
	XfmpcInterfacePrivate * priv;
};

struct _XfmpcInterfaceClass {
	GtkVBoxClass parent_class;
};

struct _XfmpcInterfacePrivate {
	XfmpcMpdclient* mpdclient;
	XfmpcPreferences* preferences;
	GtkButton* button_prev;
	GtkButton* button_pp;
	GtkButton* button_next;
	GtkVolumeButton* button_volume;
	GtkProgressBar* progress_bar;
	GtkLabel* title;
	GtkLabel* subtitle;
};


static gpointer xfmpc_interface_parent_class = NULL;

GType xfmpc_interface_get_type (void);
GType xfmpc_preferences_get_type (void);
#define XFMPC_INTERFACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), XFMPC_TYPE_INTERFACE, XfmpcInterfacePrivate))
enum  {
	XFMPC_INTERFACE_DUMMY_PROPERTY
};
void xfmpc_interface_set_title (XfmpcInterface* self, const char* title);
void xfmpc_interface_set_subtitle (XfmpcInterface* self, const char* subtitle);
void xfmpc_interface_set_pp (XfmpcInterface* self, gboolean play);
void xfmpc_interface_pp_clicked (XfmpcInterface* self);
static gboolean xfmpc_interface_cb_progress_box_release_event (XfmpcInterface* self, GdkEventButton* event);
void xfmpc_interface_volume_changed (XfmpcInterface* self, double value);
void xfmpc_interface_set_volume (XfmpcInterface* self, gint volume);
void xfmpc_interface_popup_volume (XfmpcInterface* self);
void xfmpc_interface_set_time (XfmpcInterface* self, gint song_time, gint time_total);
void xfmpc_interface_update_title (XfmpcInterface* self);
void xfmpc_interface_reset (XfmpcInterface* self);
static void xfmpc_interface_cb_song_changed (XfmpcInterface* self);
static void xfmpc_interface_cb_pp_changed (XfmpcInterface* self, gboolean is_playing);
static void xfmpc_interface_cb_time_changed (XfmpcInterface* self, gint song_time);
static void xfmpc_interface_cb_total_time_changed (XfmpcInterface* self, gint total_time);
static void xfmpc_interface_cb_volume_changed (XfmpcInterface* self, gint volume);
static void xfmpc_interface_cb_playlist_changed (XfmpcInterface* self);
static void xfmpc_interface_cb_stopped (XfmpcInterface* self);
static void xfmpc_interface_cb_mpdclient_previous (XfmpcInterface* self);
static void xfmpc_interface_cb_mpdclient_next (XfmpcInterface* self);
XfmpcInterface* xfmpc_interface_new (void);
XfmpcInterface* xfmpc_interface_construct (GType object_type);
XfmpcPreferences* xfmpc_preferences_get_default (void);
static void _xfmpc_interface_cb_mpdclient_previous_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _xfmpc_interface_pp_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _xfmpc_interface_cb_mpdclient_next_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _xfmpc_interface_volume_changed_gtk_scale_button_value_changed (GtkScaleButton* _sender, double value, gpointer self);
static gboolean _xfmpc_interface_cb_progress_box_release_event_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void _xfmpc_interface_cb_song_changed_xfmpc_mpdclient_song_changed (XfmpcMpdclient* _sender, gpointer self);
static void _xfmpc_interface_cb_pp_changed_xfmpc_mpdclient_pp_changed (XfmpcMpdclient* _sender, gboolean is_playing, gpointer self);
static void _xfmpc_interface_cb_time_changed_xfmpc_mpdclient_time_changed (XfmpcMpdclient* _sender, gint song_time, gpointer self);
static void _xfmpc_interface_cb_total_time_changed_xfmpc_mpdclient_total_time_changed (XfmpcMpdclient* _sender, gint total_time, gpointer self);
static void _xfmpc_interface_cb_volume_changed_xfmpc_mpdclient_volume_changed (XfmpcMpdclient* _sender, gint volume, gpointer self);
static void _xfmpc_interface_cb_playlist_changed_xfmpc_mpdclient_playlist_changed (XfmpcMpdclient* _sender, gpointer self);
static void _xfmpc_interface_cb_stopped_xfmpc_mpdclient_stopped (XfmpcMpdclient* _sender, gpointer self);
static GObject * xfmpc_interface_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void xfmpc_interface_finalize (GObject* obj);



void xfmpc_interface_set_title (XfmpcInterface* self, const char* title) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	gtk_label_set_text (self->priv->title, title);
}


void xfmpc_interface_set_subtitle (XfmpcInterface* self, const char* subtitle) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (subtitle != NULL);
	gtk_label_set_text (self->priv->subtitle, subtitle);
}


void xfmpc_interface_pp_clicked (XfmpcInterface* self) {
	g_return_if_fail (self != NULL);
	if (!xfmpc_mpdclient_pp (self->priv->mpdclient)) {
		return;
	}
	xfmpc_interface_set_pp (self, xfmpc_mpdclient_is_playing (self->priv->mpdclient));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void xfmpc_interface_set_pp (XfmpcInterface* self, gboolean play) {
	GtkImage* image;
	g_return_if_fail (self != NULL);
	image = _g_object_ref0 (GTK_IMAGE (gtk_bin_get_child ((GtkBin*) self->priv->button_pp)));
	if (play == TRUE) {
		gtk_image_set_from_stock (image, GTK_STOCK_MEDIA_PAUSE, GTK_ICON_SIZE_BUTTON);
	} else {
		gtk_image_set_from_stock (image, GTK_STOCK_MEDIA_PLAY, GTK_ICON_SIZE_BUTTON);
	}
	_g_object_unref0 (image);
}


static gboolean xfmpc_interface_cb_progress_box_release_event (XfmpcInterface* self, GdkEventButton* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint time_total;
	double song_time;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((*event).type != GDK_BUTTON_RELEASE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = (*event).button != 1;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	time_total = xfmpc_mpdclient_get_total_time (self->priv->mpdclient);
	if (time_total < 0) {
		result = FALSE;
		return result;
	}
	song_time = (*event).x / ((GtkWidget*) self->priv->progress_bar)->allocation.width;
	song_time = song_time * ((double) time_total);
	xfmpc_mpdclient_set_song_time (self->priv->mpdclient, (guint) ((gint) song_time));
	result = TRUE;
	return result;
}


void xfmpc_interface_volume_changed (XfmpcInterface* self, double value) {
	g_return_if_fail (self != NULL);
	xfmpc_mpdclient_set_volume (self->priv->mpdclient, (guchar) ((gchar) value));
}


void xfmpc_interface_set_volume (XfmpcInterface* self, gint volume) {
	g_return_if_fail (self != NULL);
	gtk_scale_button_set_value ((GtkScaleButton*) self->priv->button_volume, (double) volume);
}


void xfmpc_interface_popup_volume (XfmpcInterface* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self->priv->button_volume, "popup", NULL, NULL);
}


void xfmpc_interface_set_time (XfmpcInterface* self, gint song_time, gint time_total) {
	gint min = 0;
	gint sec = 0;
	gint min_total = 0;
	gint sec_total = 0;
	double fraction;
	GString* text;
	double _tmp0_ = 0.0;
	g_return_if_fail (self != NULL);
	fraction = 1.0;
	min = song_time / 60;
	sec = song_time % 60;
	min_total = time_total / 60;
	sec_total = time_total % 60;
	text = g_string_new ("");
	g_string_append_printf (text, "%d:%02d / %d:%02d", min, sec, min_total, sec_total);
	gtk_progress_bar_set_text (self->priv->progress_bar, text->str);
	if (time_total > 0) {
		fraction = (double) (((float) song_time) / ((float) time_total));
	}
	if (fraction <= 1.0) {
		_tmp0_ = fraction;
	} else {
		_tmp0_ = 1.0;
	}
	gtk_progress_bar_set_fraction (self->priv->progress_bar, _tmp0_);
	_g_string_free0 (text);
}


void xfmpc_interface_reset (XfmpcInterface* self) {
	g_return_if_fail (self != NULL);
	xfmpc_interface_set_pp (self, FALSE);
	xfmpc_interface_set_time (self, 0, 0);
	xfmpc_interface_set_volume (self, 0);
	xfmpc_interface_update_title (self);
}


void xfmpc_interface_update_title (XfmpcInterface* self) {
	g_return_if_fail (self != NULL);
	if (xfmpc_mpdclient_is_playing (self->priv->mpdclient)) {
		char* text;
		xfmpc_interface_set_title (self, xfmpc_mpdclient_get_title (self->priv->mpdclient));
		text = g_strdup_printf (_ ("by \"%s\" from \"%s\" (%s)"), xfmpc_mpdclient_get_artist (self->priv->mpdclient), xfmpc_mpdclient_get_album (self->priv->mpdclient), xfmpc_mpdclient_get_date (self->priv->mpdclient));
		xfmpc_interface_set_subtitle (self, text);
		_g_free0 (text);
	} else {
		if (xfmpc_mpdclient_is_stopped (self->priv->mpdclient)) {
			xfmpc_interface_set_title (self, _ ("Stopped"));
			xfmpc_interface_set_subtitle (self, PACKAGE_STRING);
		} else {
			if (!xfmpc_mpdclient_is_connected (self->priv->mpdclient)) {
				xfmpc_interface_set_title (self, _ ("Not connected"));
				xfmpc_interface_set_subtitle (self, PACKAGE_STRING);
			}
		}
	}
}


static void xfmpc_interface_cb_song_changed (XfmpcInterface* self) {
	g_return_if_fail (self != NULL);
	xfmpc_interface_update_title (self);
}


static void xfmpc_interface_cb_pp_changed (XfmpcInterface* self, gboolean is_playing) {
	g_return_if_fail (self != NULL);
	xfmpc_interface_set_pp (self, is_playing);
	xfmpc_interface_cb_song_changed (self);
}


static void xfmpc_interface_cb_time_changed (XfmpcInterface* self, gint song_time) {
	g_return_if_fail (self != NULL);
	xfmpc_interface_set_time (self, song_time, xfmpc_mpdclient_get_total_time (self->priv->mpdclient));
}


static void xfmpc_interface_cb_total_time_changed (XfmpcInterface* self, gint total_time) {
	g_return_if_fail (self != NULL);
	xfmpc_interface_set_time (self, xfmpc_mpdclient_get_time (self->priv->mpdclient), total_time);
}


static void xfmpc_interface_cb_volume_changed (XfmpcInterface* self, gint volume) {
	g_return_if_fail (self != NULL);
	xfmpc_interface_set_volume (self, volume);
}


static void xfmpc_interface_cb_playlist_changed (XfmpcInterface* self) {
	g_return_if_fail (self != NULL);
	xfmpc_interface_update_title (self);
}


static void xfmpc_interface_cb_stopped (XfmpcInterface* self) {
	g_return_if_fail (self != NULL);
	xfmpc_interface_set_pp (self, FALSE);
	xfmpc_interface_update_title (self);
}


static void xfmpc_interface_cb_mpdclient_previous (XfmpcInterface* self) {
	g_return_if_fail (self != NULL);
	xfmpc_mpdclient_previous (self->priv->mpdclient);
}


static void xfmpc_interface_cb_mpdclient_next (XfmpcInterface* self) {
	g_return_if_fail (self != NULL);
	xfmpc_mpdclient_next (self->priv->mpdclient);
}


XfmpcInterface* xfmpc_interface_construct (GType object_type) {
	XfmpcInterface * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


XfmpcInterface* xfmpc_interface_new (void) {
	return xfmpc_interface_construct (XFMPC_TYPE_INTERFACE);
}


static void _xfmpc_interface_cb_mpdclient_previous_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	xfmpc_interface_cb_mpdclient_previous (self);
}


static void _xfmpc_interface_pp_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	xfmpc_interface_pp_clicked (self);
}


static void _xfmpc_interface_cb_mpdclient_next_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	xfmpc_interface_cb_mpdclient_next (self);
}


static void _xfmpc_interface_volume_changed_gtk_scale_button_value_changed (GtkScaleButton* _sender, double value, gpointer self) {
	xfmpc_interface_volume_changed (self, value);
}


static gboolean _xfmpc_interface_cb_progress_box_release_event_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	return xfmpc_interface_cb_progress_box_release_event (self, event);
}


static void _xfmpc_interface_cb_song_changed_xfmpc_mpdclient_song_changed (XfmpcMpdclient* _sender, gpointer self) {
	xfmpc_interface_cb_song_changed (self);
}


static void _xfmpc_interface_cb_pp_changed_xfmpc_mpdclient_pp_changed (XfmpcMpdclient* _sender, gboolean is_playing, gpointer self) {
	xfmpc_interface_cb_pp_changed (self, is_playing);
}


static void _xfmpc_interface_cb_time_changed_xfmpc_mpdclient_time_changed (XfmpcMpdclient* _sender, gint song_time, gpointer self) {
	xfmpc_interface_cb_time_changed (self, song_time);
}


static void _xfmpc_interface_cb_total_time_changed_xfmpc_mpdclient_total_time_changed (XfmpcMpdclient* _sender, gint total_time, gpointer self) {
	xfmpc_interface_cb_total_time_changed (self, total_time);
}


static void _xfmpc_interface_cb_volume_changed_xfmpc_mpdclient_volume_changed (XfmpcMpdclient* _sender, gint volume, gpointer self) {
	xfmpc_interface_cb_volume_changed (self, volume);
}


static void _xfmpc_interface_cb_playlist_changed_xfmpc_mpdclient_playlist_changed (XfmpcMpdclient* _sender, gpointer self) {
	xfmpc_interface_cb_playlist_changed (self);
}


static void _xfmpc_interface_cb_stopped_xfmpc_mpdclient_stopped (XfmpcMpdclient* _sender, gpointer self) {
	xfmpc_interface_cb_stopped (self);
}


static GObject * xfmpc_interface_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	XfmpcInterface * self;
	parent_class = G_OBJECT_CLASS (xfmpc_interface_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = XFMPC_INTERFACE (obj);
	{
		GtkImage* image;
		GtkButton* _tmp0_;
		GtkImage* _tmp1_;
		GtkButton* _tmp2_;
		GtkImage* _tmp3_;
		GtkButton* _tmp4_;
		GtkVolumeButton* _tmp5_;
		GtkAdjustment* adjustment;
		GtkEventBox* progress_box;
		GtkProgressBar* _tmp6_;
		PangoAttrList* attrs;
		PangoAttribute* attr;
		PangoAttribute* _tmp7_;
		GtkLabel* _tmp8_;
		PangoAttrList* _tmp9_;
		PangoAttribute* _tmp10_;
		GtkLabel* _tmp11_;
		GtkHBox* box;
		GtkVBox* vbox;
		self->priv->mpdclient = xfmpc_mpdclient_get_default ();
		self->priv->preferences = xfmpc_preferences_get_default ();
		gtk_container_set_border_width ((GtkContainer*) self, (guint) 4);
		image = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_MEDIA_PREVIOUS, GTK_ICON_SIZE_BUTTON));
		self->priv->button_prev = (_tmp0_ = g_object_ref_sink ((GtkButton*) gtk_button_new ()), _g_object_unref0 (self->priv->button_prev), _tmp0_);
		gtk_button_set_relief (self->priv->button_prev, GTK_RELIEF_NONE);
		gtk_container_add ((GtkContainer*) self->priv->button_prev, (GtkWidget*) image);
		image = (_tmp1_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_MEDIA_PLAY, GTK_ICON_SIZE_BUTTON)), _g_object_unref0 (image), _tmp1_);
		self->priv->button_pp = (_tmp2_ = g_object_ref_sink ((GtkButton*) gtk_button_new ()), _g_object_unref0 (self->priv->button_pp), _tmp2_);
		gtk_button_set_relief (self->priv->button_pp, GTK_RELIEF_NONE);
		gtk_container_add ((GtkContainer*) self->priv->button_pp, (GtkWidget*) image);
		image = (_tmp3_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_MEDIA_NEXT, GTK_ICON_SIZE_BUTTON)), _g_object_unref0 (image), _tmp3_);
		self->priv->button_next = (_tmp4_ = g_object_ref_sink ((GtkButton*) gtk_button_new ()), _g_object_unref0 (self->priv->button_next), _tmp4_);
		gtk_button_set_relief (self->priv->button_next, GTK_RELIEF_NONE);
		gtk_container_add ((GtkContainer*) self->priv->button_next, (GtkWidget*) image);
		self->priv->button_volume = (_tmp5_ = g_object_ref_sink ((GtkVolumeButton*) gtk_volume_button_new ()), _g_object_unref0 (self->priv->button_volume), _tmp5_);
		gtk_button_set_relief ((GtkButton*) self->priv->button_volume, GTK_RELIEF_NONE);
		adjustment = _g_object_ref0 (gtk_scale_button_get_adjustment ((GtkScaleButton*) self->priv->button_volume));
		gtk_adjustment_set_upper (adjustment, gtk_adjustment_get_upper (adjustment) * ((double) 100));
		gtk_adjustment_set_step_increment (adjustment, gtk_adjustment_get_step_increment (adjustment) * ((double) 100));
		gtk_adjustment_set_page_increment (adjustment, gtk_adjustment_get_page_increment (adjustment) * ((double) 100));
		progress_box = g_object_ref_sink ((GtkEventBox*) gtk_event_box_new ());
		self->priv->progress_bar = (_tmp6_ = g_object_ref_sink ((GtkProgressBar*) gtk_progress_bar_new ()), _g_object_unref0 (self->priv->progress_bar), _tmp6_);
		gtk_progress_bar_set_text (self->priv->progress_bar, "0:00 / 0:00");
		gtk_progress_bar_set_fraction (self->priv->progress_bar, 1.0);
		gtk_container_add ((GtkContainer*) progress_box, (GtkWidget*) self->priv->progress_bar);
		attrs = pango_attr_list_new ();
		attr = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
		attr->start_index = (guint) 0;
		attr->end_index = (guint) (-1);
		pango_attr_list_insert (attrs, pango_attribute_copy (attr));
		attr = (_tmp7_ = pango_attr_scale_new ((double) PANGO_SCALE_X_LARGE), _pango_attribute_destroy0 (attr), _tmp7_);
		attr->start_index = (guint) 0;
		attr->end_index = (guint) (-1);
		pango_attr_list_insert (attrs, pango_attribute_copy (attr));
		self->priv->title = (_tmp8_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Not connected"))), _g_object_unref0 (self->priv->title), _tmp8_);
		gtk_label_set_attributes (self->priv->title, attrs);
		gtk_label_set_selectable (self->priv->title, TRUE);
		gtk_label_set_ellipsize (self->priv->title, PANGO_ELLIPSIZE_END);
		gtk_misc_set_alignment ((GtkMisc*) self->priv->title, (float) 0, (float) 0.5);
		attrs = (_tmp9_ = pango_attr_list_new (), _pango_attr_list_unref0 (attrs), _tmp9_);
		attr = (_tmp10_ = pango_attr_scale_new ((double) PANGO_SCALE_SMALL), _pango_attribute_destroy0 (attr), _tmp10_);
		attr->start_index = (guint) 0;
		attr->end_index = (guint) (-1);
		pango_attr_list_insert (attrs, pango_attribute_copy (attr));
		self->priv->subtitle = (_tmp11_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (PACKAGE_STRING)), _g_object_unref0 (self->priv->subtitle), _tmp11_);
		gtk_label_set_attributes (self->priv->subtitle, attrs);
		gtk_label_set_selectable (self->priv->subtitle, TRUE);
		gtk_label_set_ellipsize (self->priv->subtitle, PANGO_ELLIPSIZE_END);
		gtk_misc_set_alignment ((GtkMisc*) self->priv->subtitle, (float) 0, (float) 0.5);
		box = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 0));
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) box, FALSE, FALSE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) self->priv->button_prev, FALSE, FALSE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) self->priv->button_pp, FALSE, FALSE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) self->priv->button_next, FALSE, FALSE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) progress_box, TRUE, TRUE, (guint) 4);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) self->priv->button_volume, FALSE, FALSE, (guint) 0);
		vbox = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0));
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) vbox, FALSE, TRUE, (guint) 0);
		gtk_container_add ((GtkContainer*) vbox, (GtkWidget*) self->priv->title);
		gtk_container_add ((GtkContainer*) vbox, (GtkWidget*) self->priv->subtitle);
		g_signal_connect_object (self->priv->button_prev, "clicked", (GCallback) _xfmpc_interface_cb_mpdclient_previous_gtk_button_clicked, self, 0);
		g_signal_connect_object (self->priv->button_pp, "clicked", (GCallback) _xfmpc_interface_pp_clicked_gtk_button_clicked, self, 0);
		g_signal_connect_object (self->priv->button_next, "clicked", (GCallback) _xfmpc_interface_cb_mpdclient_next_gtk_button_clicked, self, 0);
		g_signal_connect_object ((GtkScaleButton*) self->priv->button_volume, "value-changed", (GCallback) _xfmpc_interface_volume_changed_gtk_scale_button_value_changed, self, 0);
		g_signal_connect_object ((GtkWidget*) progress_box, "button-release-event", (GCallback) _xfmpc_interface_cb_progress_box_release_event_gtk_widget_button_release_event, self, 0);
		g_signal_connect_object (self->priv->mpdclient, "song-changed", (GCallback) _xfmpc_interface_cb_song_changed_xfmpc_mpdclient_song_changed, self, 0);
		g_signal_connect_object (self->priv->mpdclient, "pp-changed", (GCallback) _xfmpc_interface_cb_pp_changed_xfmpc_mpdclient_pp_changed, self, 0);
		g_signal_connect_object (self->priv->mpdclient, "time-changed", (GCallback) _xfmpc_interface_cb_time_changed_xfmpc_mpdclient_time_changed, self, 0);
		g_signal_connect_object (self->priv->mpdclient, "total-time-changed", (GCallback) _xfmpc_interface_cb_total_time_changed_xfmpc_mpdclient_total_time_changed, self, 0);
		g_signal_connect_object (self->priv->mpdclient, "volume-changed", (GCallback) _xfmpc_interface_cb_volume_changed_xfmpc_mpdclient_volume_changed, self, 0);
		g_signal_connect_object (self->priv->mpdclient, "playlist-changed", (GCallback) _xfmpc_interface_cb_playlist_changed_xfmpc_mpdclient_playlist_changed, self, 0);
		g_signal_connect_object (self->priv->mpdclient, "stopped", (GCallback) _xfmpc_interface_cb_stopped_xfmpc_mpdclient_stopped, self, 0);
		_g_object_unref0 (image);
		_g_object_unref0 (adjustment);
		_g_object_unref0 (progress_box);
		_pango_attr_list_unref0 (attrs);
		_pango_attribute_destroy0 (attr);
		_g_object_unref0 (box);
		_g_object_unref0 (vbox);
	}
	return obj;
}


static void xfmpc_interface_class_init (XfmpcInterfaceClass * klass) {
	xfmpc_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (XfmpcInterfacePrivate));
	G_OBJECT_CLASS (klass)->constructor = xfmpc_interface_constructor;
	G_OBJECT_CLASS (klass)->finalize = xfmpc_interface_finalize;
}


static void xfmpc_interface_instance_init (XfmpcInterface * self) {
	self->priv = XFMPC_INTERFACE_GET_PRIVATE (self);
}


static void xfmpc_interface_finalize (GObject* obj) {
	XfmpcInterface * self;
	self = XFMPC_INTERFACE (obj);
	_g_object_unref0 (self->priv->button_prev);
	_g_object_unref0 (self->priv->button_pp);
	_g_object_unref0 (self->priv->button_next);
	_g_object_unref0 (self->priv->button_volume);
	_g_object_unref0 (self->priv->progress_bar);
	_g_object_unref0 (self->priv->title);
	_g_object_unref0 (self->priv->subtitle);
	G_OBJECT_CLASS (xfmpc_interface_parent_class)->finalize (obj);
}


GType xfmpc_interface_get_type (void) {
	static volatile gsize xfmpc_interface_type_id__volatile = 0;
	if (g_once_init_enter (&xfmpc_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (XfmpcInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xfmpc_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XfmpcInterface), 0, (GInstanceInitFunc) xfmpc_interface_instance_init, NULL };
		GType xfmpc_interface_type_id;
		xfmpc_interface_type_id = g_type_register_static (GTK_TYPE_VBOX, "XfmpcInterface", &g_define_type_info, 0);
		g_once_init_leave (&xfmpc_interface_type_id__volatile, xfmpc_interface_type_id);
	}
	return xfmpc_interface_type_id__volatile;
}




