/* preferences-dialog.c generated by valac, the Vala compiler
 * generated from preferences-dialog.vala, do not modify */

/*
 *  Copyright (c) 2009-2010 Mike Massonnet <mmassonnet@xfce.org>
 *  Copyright (c) 2009-2010 Vincent Legout <vincent@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libxfce4ui/libxfce4ui.h>
#include <gtk/gtk.h>
#include <mpdclient.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>


#define XFMPC_TYPE_PREFERENCES_DIALOG (xfmpc_preferences_dialog_get_type ())
#define XFMPC_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_PREFERENCES_DIALOG, XfmpcPreferencesDialog))
#define XFMPC_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_PREFERENCES_DIALOG, XfmpcPreferencesDialogClass))
#define XFMPC_IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_PREFERENCES_DIALOG))
#define XFMPC_IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_PREFERENCES_DIALOG))
#define XFMPC_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_PREFERENCES_DIALOG, XfmpcPreferencesDialogClass))

typedef struct _XfmpcPreferencesDialog XfmpcPreferencesDialog;
typedef struct _XfmpcPreferencesDialogClass XfmpcPreferencesDialogClass;
typedef struct _XfmpcPreferencesDialogPrivate XfmpcPreferencesDialogPrivate;

#define XFMPC_TYPE_PREFERENCES (xfmpc_preferences_get_type ())
#define XFMPC_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_PREFERENCES, XfmpcPreferences))
#define XFMPC_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_PREFERENCES, XfmpcPreferencesClass))
#define XFMPC_IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_PREFERENCES))
#define XFMPC_IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_PREFERENCES))
#define XFMPC_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_PREFERENCES, XfmpcPreferencesClass))

typedef struct _XfmpcPreferences XfmpcPreferences;
typedef struct _XfmpcPreferencesClass XfmpcPreferencesClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define XFMPC_PREFERENCES_TYPE_SONG_FORMAT (xfmpc_preferences_song_format_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))

struct _XfmpcPreferencesDialog {
	XfceTitledDialog parent_instance;
	XfmpcPreferencesDialogPrivate * priv;
};

struct _XfmpcPreferencesDialogClass {
	XfceTitledDialogClass parent_class;
};

struct _XfmpcPreferencesDialogPrivate {
	XfmpcPreferences* preferences;
	GtkCheckButton* entry_use_defaults;
	GtkEntry* entry_host;
	GtkEntry* entry_passwd;
	GtkSpinButton* entry_port;
	GtkCheckButton* show_statusbar;
	GtkComboBox* combo_format;
	GtkEntry* entry_custom;
	guint format_timeout;
	GtkVBox* mpd_vbox;
};

typedef enum  {
	XFMPC_PREFERENCES_SONG_FORMAT_TITLE,
	XFMPC_PREFERENCES_SONG_FORMAT_ALBUM_TITLE,
	XFMPC_PREFERENCES_SONG_FORMAT_ARTIST_TITLE,
	XFMPC_PREFERENCES_SONG_FORMAT_ARTIST_TITLE_DATE,
	XFMPC_PREFERENCES_SONG_FORMAT_ARTIST_ALBUM_TITLE,
	XFMPC_PREFERENCES_SONG_FORMAT_ARTIST_ALBUM_TRACK_TITLE,
	XFMPC_PREFERENCES_SONG_FORMAT_CUSTOM_FORMAT
} XfmpcPreferencesSongFormat;


static gpointer xfmpc_preferences_dialog_parent_class = NULL;

GType xfmpc_preferences_dialog_get_type (void);
GType xfmpc_preferences_get_type (void);
#define XFMPC_PREFERENCES_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), XFMPC_TYPE_PREFERENCES_DIALOG, XfmpcPreferencesDialogPrivate))
enum  {
	XFMPC_PREFERENCES_DIALOG_DUMMY_PROPERTY
};
static void xfmpc_preferences_dialog_cb_response (XfmpcPreferencesDialog* self, gint response);
static void xfmpc_preferences_dialog_cb_use_defaults_toggled (XfmpcPreferencesDialog* self);
void xfmpc_preferences_set_mpd_hostname (XfmpcPreferences* self, const char* value);
void xfmpc_preferences_set_mpd_port (XfmpcPreferences* self, gint value);
void xfmpc_preferences_set_mpd_password (XfmpcPreferences* self, const char* value);
void xfmpc_preferences_set_mpd_use_defaults (XfmpcPreferences* self, gboolean value);
static void xfmpc_preferences_dialog_cb_update_mpd (XfmpcPreferencesDialog* self, GtkButton* source);
void xfmpc_preferences_set_show_statusbar (XfmpcPreferences* self, gboolean value);
static void xfmpc_preferences_dialog_cb_show_statusbar_toggled (XfmpcPreferencesDialog* self);
GType xfmpc_preferences_song_format_get_type (void);
void xfmpc_preferences_set_song_format (XfmpcPreferences* self, XfmpcPreferencesSongFormat value);
static void xfmpc_preferences_dialog_cb_combo_format_changed (XfmpcPreferencesDialog* self, GtkComboBox* source);
static gboolean xfmpc_preferences_dialog_timeout_format (XfmpcPreferencesDialog* self);
static gboolean _xfmpc_preferences_dialog_timeout_format_gsource_func (gpointer self);
static void xfmpc_preferences_dialog_cb_entry_custom_changed (XfmpcPreferencesDialog* self);
void xfmpc_preferences_set_song_format_custom (XfmpcPreferences* self, const char* value);
XfmpcPreferencesDialog* xfmpc_preferences_dialog_new (void);
XfmpcPreferencesDialog* xfmpc_preferences_dialog_construct (GType object_type);
XfmpcPreferences* xfmpc_preferences_get_default (void);
gboolean xfmpc_preferences_get_mpd_use_defaults (XfmpcPreferences* self);
static void _xfmpc_preferences_dialog_cb_use_defaults_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
const char* xfmpc_preferences_get_mpd_hostname (XfmpcPreferences* self);
gint xfmpc_preferences_get_mpd_port (XfmpcPreferences* self);
const char* xfmpc_preferences_get_mpd_password (XfmpcPreferences* self);
static void _xfmpc_preferences_dialog_cb_update_mpd_gtk_button_clicked (GtkButton* _sender, gpointer self);
gboolean xfmpc_preferences_get_show_statusbar (XfmpcPreferences* self);
static void _xfmpc_preferences_dialog_cb_show_statusbar_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
XfmpcPreferencesSongFormat xfmpc_preferences_get_song_format (XfmpcPreferences* self);
const char* xfmpc_preferences_get_song_format_custom (XfmpcPreferences* self);
static void _xfmpc_preferences_dialog_cb_combo_format_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _xfmpc_preferences_dialog_cb_entry_custom_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void _xfmpc_preferences_dialog_cb_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static GObject * xfmpc_preferences_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void xfmpc_preferences_dialog_finalize (GObject* obj);



static void xfmpc_preferences_dialog_cb_response (XfmpcPreferencesDialog* self, gint response) {
	g_return_if_fail (self != NULL);
	switch (response) {
		case GTK_RESPONSE_CLOSE:
		{
			gtk_object_destroy ((GtkObject*) self);
			break;
		}
	}
}


static void xfmpc_preferences_dialog_cb_use_defaults_toggled (XfmpcPreferencesDialog* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->mpd_vbox, !gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->entry_use_defaults));
}


static void xfmpc_preferences_dialog_cb_update_mpd (XfmpcPreferencesDialog* self, GtkButton* source) {
	XfmpcMpdclient* mpdclient;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	mpdclient = xfmpc_mpdclient_get_default ();
	xfmpc_preferences_set_mpd_hostname (self->priv->preferences, gtk_entry_get_text (self->priv->entry_host));
	xfmpc_preferences_set_mpd_port (self->priv->preferences, gtk_spin_button_get_value_as_int (self->priv->entry_port));
	xfmpc_preferences_set_mpd_password (self->priv->preferences, gtk_entry_get_text (self->priv->entry_passwd));
	xfmpc_preferences_set_mpd_use_defaults (self->priv->preferences, gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->entry_use_defaults));
	xfmpc_mpdclient_disconnect (mpdclient);
	xfmpc_mpdclient_connect (mpdclient);
}


static void xfmpc_preferences_dialog_cb_show_statusbar_toggled (XfmpcPreferencesDialog* self) {
	g_return_if_fail (self != NULL);
	xfmpc_preferences_set_show_statusbar (self->priv->preferences, gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->show_statusbar));
}


static void xfmpc_preferences_dialog_cb_combo_format_changed (XfmpcPreferencesDialog* self, GtkComboBox* source) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	switch (gtk_combo_box_get_active (self->priv->combo_format)) {
		case 0:
		{
			xfmpc_preferences_set_song_format (self->priv->preferences, XFMPC_PREFERENCES_SONG_FORMAT_TITLE);
			break;
		}
		case 1:
		{
			xfmpc_preferences_set_song_format (self->priv->preferences, XFMPC_PREFERENCES_SONG_FORMAT_ALBUM_TITLE);
			break;
		}
		case 2:
		{
			xfmpc_preferences_set_song_format (self->priv->preferences, XFMPC_PREFERENCES_SONG_FORMAT_ARTIST_TITLE);
			break;
		}
		case 3:
		{
			xfmpc_preferences_set_song_format (self->priv->preferences, XFMPC_PREFERENCES_SONG_FORMAT_ARTIST_TITLE_DATE);
			break;
		}
		case 4:
		{
			xfmpc_preferences_set_song_format (self->priv->preferences, XFMPC_PREFERENCES_SONG_FORMAT_ARTIST_ALBUM_TITLE);
			break;
		}
		case 5:
		{
			xfmpc_preferences_set_song_format (self->priv->preferences, XFMPC_PREFERENCES_SONG_FORMAT_ARTIST_ALBUM_TRACK_TITLE);
			break;
		}
		case 6:
		{
			xfmpc_preferences_set_song_format (self->priv->preferences, XFMPC_PREFERENCES_SONG_FORMAT_CUSTOM_FORMAT);
			break;
		}
		default:
		{
			xfmpc_preferences_set_song_format (self->priv->preferences, XFMPC_PREFERENCES_SONG_FORMAT_TITLE);
			break;
		}
	}
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->entry_custom, gtk_combo_box_get_active (self->priv->combo_format) == 6);
}


static gboolean _xfmpc_preferences_dialog_timeout_format_gsource_func (gpointer self) {
	return xfmpc_preferences_dialog_timeout_format (self);
}


static void xfmpc_preferences_dialog_cb_entry_custom_changed (XfmpcPreferencesDialog* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->format_timeout > 0) {
		g_source_remove (self->priv->format_timeout);
	}
	self->priv->format_timeout = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _xfmpc_preferences_dialog_timeout_format_gsource_func, g_object_ref (self), g_object_unref);
}


static gboolean xfmpc_preferences_dialog_timeout_format (XfmpcPreferencesDialog* self) {
	gboolean result = FALSE;
	char* custom_format;
	g_return_val_if_fail (self != NULL, FALSE);
	custom_format = g_strdup (gtk_entry_get_text (self->priv->entry_custom));
	xfmpc_preferences_set_song_format_custom (self->priv->preferences, custom_format);
	result = FALSE;
	_g_free0 (custom_format);
	return result;
}


XfmpcPreferencesDialog* xfmpc_preferences_dialog_construct (GType object_type) {
	XfmpcPreferencesDialog * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


XfmpcPreferencesDialog* xfmpc_preferences_dialog_new (void) {
	return xfmpc_preferences_dialog_construct (XFMPC_TYPE_PREFERENCES_DIALOG);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _xfmpc_preferences_dialog_cb_use_defaults_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	xfmpc_preferences_dialog_cb_use_defaults_toggled (self);
}


static void _xfmpc_preferences_dialog_cb_update_mpd_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	xfmpc_preferences_dialog_cb_update_mpd (self, _sender);
}


static void _xfmpc_preferences_dialog_cb_show_statusbar_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	xfmpc_preferences_dialog_cb_show_statusbar_toggled (self);
}


static void _xfmpc_preferences_dialog_cb_combo_format_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	xfmpc_preferences_dialog_cb_combo_format_changed (self, _sender);
}


static void _xfmpc_preferences_dialog_cb_entry_custom_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	xfmpc_preferences_dialog_cb_entry_custom_changed (self);
}


static void _xfmpc_preferences_dialog_cb_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	xfmpc_preferences_dialog_cb_response (self, response_id);
}


static GObject * xfmpc_preferences_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	XfmpcPreferencesDialog * self;
	parent_class = G_OBJECT_CLASS (xfmpc_preferences_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = XFMPC_PREFERENCES_DIALOG (obj);
	{
		GtkNotebook* notebook;
		GtkVBox* vbox;
		GtkLabel* label;
		GtkVBox* vbox2;
		GtkWidget* frame;
		GtkCheckButton* _tmp0_;
		GtkVBox* _tmp1_;
		GtkHBox* hbox;
		GtkLabel* _tmp2_;
		GtkEntry* _tmp3_;
		GtkLabel* _tmp4_;
		GtkSpinButton* _tmp5_;
		GtkHBox* _tmp6_;
		GtkLabel* _tmp7_;
		GtkEntry* _tmp8_;
		GtkButton* button;
		GtkVBox* _tmp9_;
		GtkLabel* _tmp10_;
		GtkVBox* _tmp11_;
		GtkWidget* _tmp12_;
		GtkCheckButton* _tmp13_;
		GtkVBox* _tmp14_;
		GtkWidget* _tmp15_;
		GtkHBox* _tmp16_;
		GtkLabel* _tmp17_;
		GtkComboBox* _tmp18_;
		GtkHBox* _tmp19_;
		GtkLabel* _tmp20_;
		GtkEntry* _tmp21_;
		GtkLabel* _tmp22_;
		GtkTable* table;
		PangoAttrList* attrs;
		GtkLabel* _tmp23_;
		GtkLabel* _tmp24_;
		GtkLabel* _tmp25_;
		GtkLabel* _tmp26_;
		GtkLabel* _tmp27_;
		GtkLabel* _tmp28_;
		GtkLabel* _tmp29_;
		GtkLabel* _tmp30_;
		gtk_dialog_set_has_separator ((GtkDialog*) self, TRUE);
		gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, TRUE);
		gtk_window_set_icon_name ((GtkWindow*) self, "stock_volume");
		gtk_window_set_resizable ((GtkWindow*) self, FALSE);
		gtk_window_set_title ((GtkWindow*) self, "Xfmpc Preferences");
		self->priv->preferences = xfmpc_preferences_get_default ();
		notebook = g_object_ref_sink ((GtkNotebook*) gtk_notebook_new ());
		gtk_container_set_border_width ((GtkContainer*) notebook, (guint) 6);
		gtk_box_pack_start ((GtkBox*) ((GtkDialog*) self)->vbox, (GtkWidget*) notebook, TRUE, TRUE, (guint) 0);
		vbox = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
		gtk_container_set_border_width ((GtkContainer*) vbox, (guint) 6);
		label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("MPD")));
		gtk_notebook_append_page (notebook, (GtkWidget*) vbox, (GtkWidget*) label);
		vbox2 = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
		frame = _g_object_ref0 (xfce_gtk_frame_box_new_with_content (_ ("Connection"), (GtkWidget*) vbox2));
		gtk_box_pack_start ((GtkBox*) vbox, frame, FALSE, FALSE, (guint) 0);
		self->priv->entry_use_defaults = (_tmp0_ = g_object_ref_sink ((GtkCheckButton*) gtk_check_button_new_with_mnemonic (_ ("Use _default system settings"))), _g_object_unref0 (self->priv->entry_use_defaults), _tmp0_);
		gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->entry_use_defaults, _ ("If checked, Xfmpc will try to read the environment variables MPD_HOST " \
"and MPD_PORT otherwise it will use localhost"));
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->entry_use_defaults, xfmpc_preferences_get_mpd_use_defaults (self->priv->preferences));
		gtk_box_pack_start ((GtkBox*) vbox2, (GtkWidget*) self->priv->entry_use_defaults, FALSE, FALSE, (guint) 0);
		self->priv->mpd_vbox = (_tmp1_ = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6)), _g_object_unref0 (self->priv->mpd_vbox), _tmp1_);
		gtk_box_pack_start ((GtkBox*) vbox2, (GtkWidget*) self->priv->mpd_vbox, FALSE, FALSE, (guint) 0);
		g_signal_connect_object ((GtkToggleButton*) self->priv->entry_use_defaults, "toggled", (GCallback) _xfmpc_preferences_dialog_cb_use_defaults_toggled_gtk_toggle_button_toggled, self, 0);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->mpd_vbox, !gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->entry_use_defaults));
		hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 2));
		gtk_box_pack_start ((GtkBox*) self->priv->mpd_vbox, (GtkWidget*) hbox, FALSE, FALSE, (guint) 0);
		label = (_tmp2_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Hostname:"))), _g_object_unref0 (label), _tmp2_);
		gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
		self->priv->entry_host = (_tmp3_ = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (self->priv->entry_host), _tmp3_);
		gtk_entry_set_width_chars (self->priv->entry_host, 15);
		gtk_entry_set_text (self->priv->entry_host, xfmpc_preferences_get_mpd_hostname (self->priv->preferences));
		gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->entry_host, TRUE, TRUE, (guint) 0);
		label = (_tmp4_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Port:"))), _g_object_unref0 (label), _tmp4_);
		gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
		self->priv->entry_port = (_tmp5_ = g_object_ref_sink ((GtkSpinButton*) gtk_spin_button_new_with_range ((double) 0, (double) 65536, (double) 1)), _g_object_unref0 (self->priv->entry_port), _tmp5_);
		gtk_spin_button_set_digits (self->priv->entry_port, (guint) 0);
		gtk_spin_button_set_value (self->priv->entry_port, (double) xfmpc_preferences_get_mpd_port (self->priv->preferences));
		gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->entry_port, TRUE, TRUE, (guint) 0);
		hbox = (_tmp6_ = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 2)), _g_object_unref0 (hbox), _tmp6_);
		gtk_box_pack_start ((GtkBox*) self->priv->mpd_vbox, (GtkWidget*) hbox, FALSE, FALSE, (guint) 0);
		label = (_tmp7_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Password:"))), _g_object_unref0 (label), _tmp7_);
		gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
		self->priv->entry_passwd = (_tmp8_ = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (self->priv->entry_passwd), _tmp8_);
		gtk_entry_set_visibility (self->priv->entry_passwd, FALSE);
		if (xfmpc_preferences_get_mpd_password (self->priv->preferences) != NULL) {
			gtk_entry_set_text (self->priv->entry_passwd, xfmpc_preferences_get_mpd_password (self->priv->preferences));
		}
		gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->entry_passwd, TRUE, TRUE, (guint) 0);
		button = g_object_ref_sink ((GtkButton*) gtk_button_new_from_stock (GTK_STOCK_APPLY));
		g_signal_connect_object (button, "clicked", (GCallback) _xfmpc_preferences_dialog_cb_update_mpd_gtk_button_clicked, self, 0);
		gtk_box_pack_start ((GtkBox*) vbox2, (GtkWidget*) button, TRUE, TRUE, (guint) 0);
		vbox = (_tmp9_ = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6)), _g_object_unref0 (vbox), _tmp9_);
		gtk_container_set_border_width ((GtkContainer*) vbox, (guint) 6);
		label = (_tmp10_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Appearance"))), _g_object_unref0 (label), _tmp10_);
		gtk_notebook_append_page (notebook, (GtkWidget*) vbox, (GtkWidget*) label);
		vbox2 = (_tmp11_ = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6)), _g_object_unref0 (vbox2), _tmp11_);
		frame = (_tmp12_ = _g_object_ref0 (xfce_gtk_frame_box_new_with_content (_ ("Statusbar"), (GtkWidget*) vbox2)), _g_object_unref0 (frame), _tmp12_);
		gtk_box_pack_start ((GtkBox*) vbox, frame, FALSE, FALSE, (guint) 0);
		self->priv->show_statusbar = (_tmp13_ = g_object_ref_sink ((GtkCheckButton*) gtk_check_button_new_with_mnemonic (_ ("Show _stastusbar"))), _g_object_unref0 (self->priv->show_statusbar), _tmp13_);
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->show_statusbar, xfmpc_preferences_get_show_statusbar (self->priv->preferences));
		g_signal_connect_object ((GtkToggleButton*) self->priv->show_statusbar, "toggled", (GCallback) _xfmpc_preferences_dialog_cb_show_statusbar_toggled_gtk_toggle_button_toggled, self, 0);
		gtk_box_pack_start ((GtkBox*) vbox2, (GtkWidget*) self->priv->show_statusbar, FALSE, FALSE, (guint) 0);
		vbox2 = (_tmp14_ = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6)), _g_object_unref0 (vbox2), _tmp14_);
		frame = (_tmp15_ = _g_object_ref0 (xfce_gtk_frame_box_new_with_content (_ ("Song Format"), (GtkWidget*) vbox2)), _g_object_unref0 (frame), _tmp15_);
		gtk_box_pack_start ((GtkBox*) vbox, frame, FALSE, FALSE, (guint) 0);
		hbox = (_tmp16_ = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 2)), _g_object_unref0 (hbox), _tmp16_);
		label = (_tmp17_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Song Format:"))), _g_object_unref0 (label), _tmp17_);
		gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
		self->priv->combo_format = (_tmp18_ = g_object_ref_sink ((GtkComboBox*) gtk_combo_box_new_text ()), _g_object_unref0 (self->priv->combo_format), _tmp18_);
		gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->combo_format, TRUE, TRUE, (guint) 0);
		gtk_combo_box_append_text (self->priv->combo_format, _ ("Title"));
		gtk_combo_box_append_text (self->priv->combo_format, _ ("Album - Title"));
		gtk_combo_box_append_text (self->priv->combo_format, _ ("Artist - Title"));
		gtk_combo_box_append_text (self->priv->combo_format, _ ("Artist - Title (Date)"));
		gtk_combo_box_append_text (self->priv->combo_format, _ ("Artist - Album - Title"));
		gtk_combo_box_append_text (self->priv->combo_format, _ ("Artist - Album - Track. Title"));
		gtk_combo_box_append_text (self->priv->combo_format, _ ("Custom..."));
		gtk_combo_box_set_active (self->priv->combo_format, (gint) xfmpc_preferences_get_song_format (self->priv->preferences));
		gtk_box_pack_start ((GtkBox*) vbox2, (GtkWidget*) hbox, TRUE, TRUE, (guint) 0);
		hbox = (_tmp19_ = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 2)), _g_object_unref0 (hbox), _tmp19_);
		label = (_tmp20_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Custom format:"))), _g_object_unref0 (label), _tmp20_);
		gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
		self->priv->entry_custom = (_tmp21_ = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (self->priv->entry_custom), _tmp21_);
		gtk_entry_set_width_chars (self->priv->entry_custom, 15);
		gtk_entry_set_max_length (self->priv->entry_custom, 30);
		gtk_entry_set_text (self->priv->entry_custom, xfmpc_preferences_get_song_format_custom (self->priv->preferences));
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->entry_custom, gtk_combo_box_get_active (self->priv->combo_format) == 6);
		gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->entry_custom, TRUE, TRUE, (guint) 0);
		g_signal_connect_object (self->priv->combo_format, "changed", (GCallback) _xfmpc_preferences_dialog_cb_combo_format_changed_gtk_combo_box_changed, self, 0);
		g_signal_connect_object ((GtkEditable*) self->priv->entry_custom, "changed", (GCallback) _xfmpc_preferences_dialog_cb_entry_custom_changed_gtk_editable_changed, self, 0);
		gtk_box_pack_start ((GtkBox*) vbox2, (GtkWidget*) hbox, TRUE, TRUE, (guint) 0);
		label = (_tmp22_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Available parameters:"))), _g_object_unref0 (label), _tmp22_);
		gtk_box_pack_start ((GtkBox*) vbox2, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
		table = g_object_ref_sink ((GtkTable*) gtk_table_new ((guint) 4, (guint) 6, TRUE));
		attrs = pango_attr_list_new ();
		pango_attr_list_insert (attrs, pango_attr_scale_new ((double) PANGO_SCALE_SMALL));
		label = (_tmp23_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("%a: Artist"))), _g_object_unref0 (label), _tmp23_);
		gtk_label_set_attributes (label, attrs);
		gtk_misc_set_alignment ((GtkMisc*) label, (float) 0, (float) 0.5);
		gtk_table_attach_defaults (table, (GtkWidget*) label, (guint) 1, (guint) 3, (guint) 0, (guint) 1);
		label = (_tmp24_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("%A: Album"))), _g_object_unref0 (label), _tmp24_);
		gtk_label_set_attributes (label, attrs);
		gtk_misc_set_alignment ((GtkMisc*) label, (float) 0, (float) 0.5);
		gtk_table_attach_defaults (table, (GtkWidget*) label, (guint) 4, (guint) 6, (guint) 0, (guint) 1);
		label = (_tmp25_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("%d: Date"))), _g_object_unref0 (label), _tmp25_);
		gtk_label_set_attributes (label, attrs);
		gtk_misc_set_alignment ((GtkMisc*) label, (float) 0, (float) 0.5);
		gtk_table_attach_defaults (table, (GtkWidget*) label, (guint) 1, (guint) 3, (guint) 1, (guint) 2);
		label = (_tmp26_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("%D: Disc"))), _g_object_unref0 (label), _tmp26_);
		gtk_label_set_attributes (label, attrs);
		gtk_misc_set_alignment ((GtkMisc*) label, (float) 0, (float) 0.5);
		gtk_table_attach_defaults (table, (GtkWidget*) label, (guint) 4, (guint) 6, (guint) 1, (guint) 2);
		label = (_tmp27_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("%f: File"))), _g_object_unref0 (label), _tmp27_);
		gtk_label_set_attributes (label, attrs);
		gtk_misc_set_alignment ((GtkMisc*) label, (float) 0, (float) 0.5);
		gtk_table_attach_defaults (table, (GtkWidget*) label, (guint) 1, (guint) 3, (guint) 2, (guint) 3);
		label = (_tmp28_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("%g: Genre"))), _g_object_unref0 (label), _tmp28_);
		gtk_label_set_attributes (label, attrs);
		gtk_misc_set_alignment ((GtkMisc*) label, (float) 0, (float) 0.5);
		gtk_table_attach_defaults (table, (GtkWidget*) label, (guint) 4, (guint) 6, (guint) 2, (guint) 3);
		label = (_tmp29_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("%t: Title"))), _g_object_unref0 (label), _tmp29_);
		gtk_label_set_attributes (label, attrs);
		gtk_misc_set_alignment ((GtkMisc*) label, (float) 0, (float) 0.5);
		gtk_table_attach_defaults (table, (GtkWidget*) label, (guint) 1, (guint) 3, (guint) 3, (guint) 4);
		label = (_tmp30_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("%T: Track"))), _g_object_unref0 (label), _tmp30_);
		gtk_label_set_attributes (label, attrs);
		gtk_misc_set_alignment ((GtkMisc*) label, (float) 0, (float) 0.5);
		gtk_table_attach_defaults (table, (GtkWidget*) label, (guint) 4, (guint) 6, (guint) 3, (guint) 4);
		gtk_box_pack_start ((GtkBox*) vbox2, (GtkWidget*) table, TRUE, TRUE, (guint) 0);
		gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_CLOSE, (gint) GTK_RESPONSE_CLOSE);
		gtk_widget_show_all ((GtkWidget*) self);
		g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) _xfmpc_preferences_dialog_cb_response_gtk_dialog_response, self, 0);
		_g_object_unref0 (notebook);
		_g_object_unref0 (vbox);
		_g_object_unref0 (label);
		_g_object_unref0 (vbox2);
		_g_object_unref0 (frame);
		_g_object_unref0 (hbox);
		_g_object_unref0 (button);
		_g_object_unref0 (table);
		_pango_attr_list_unref0 (attrs);
	}
	return obj;
}


static void xfmpc_preferences_dialog_class_init (XfmpcPreferencesDialogClass * klass) {
	xfmpc_preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (XfmpcPreferencesDialogPrivate));
	G_OBJECT_CLASS (klass)->constructor = xfmpc_preferences_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = xfmpc_preferences_dialog_finalize;
}


static void xfmpc_preferences_dialog_instance_init (XfmpcPreferencesDialog * self) {
	self->priv = XFMPC_PREFERENCES_DIALOG_GET_PRIVATE (self);
}


static void xfmpc_preferences_dialog_finalize (GObject* obj) {
	XfmpcPreferencesDialog * self;
	self = XFMPC_PREFERENCES_DIALOG (obj);
	_g_object_unref0 (self->priv->entry_use_defaults);
	_g_object_unref0 (self->priv->entry_host);
	_g_object_unref0 (self->priv->entry_passwd);
	_g_object_unref0 (self->priv->entry_port);
	_g_object_unref0 (self->priv->show_statusbar);
	_g_object_unref0 (self->priv->combo_format);
	_g_object_unref0 (self->priv->entry_custom);
	_g_object_unref0 (self->priv->mpd_vbox);
	G_OBJECT_CLASS (xfmpc_preferences_dialog_parent_class)->finalize (obj);
}


GType xfmpc_preferences_dialog_get_type (void) {
	static volatile gsize xfmpc_preferences_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&xfmpc_preferences_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (XfmpcPreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xfmpc_preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XfmpcPreferencesDialog), 0, (GInstanceInitFunc) xfmpc_preferences_dialog_instance_init, NULL };
		GType xfmpc_preferences_dialog_type_id;
		xfmpc_preferences_dialog_type_id = g_type_register_static (XFCE_TYPE_TITLED_DIALOG, "XfmpcPreferencesDialog", &g_define_type_info, 0);
		g_once_init_leave (&xfmpc_preferences_dialog_type_id__volatile, xfmpc_preferences_dialog_type_id);
	}
	return xfmpc_preferences_dialog_type_id__volatile;
}




