/* main-window.c generated by valac 0.14.0, the Vala compiler
 * generated from main-window.vala, do not modify */

/*
 *  Copyright (c) 2009-2010 Mike Massonnet <mmassonnet@xfce.org>
 *  Copyright (c) 2009-2010 Vincent Legout <vincent@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <mpdclient.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <config.h>


#define XFMPC_TYPE_MAIN_WINDOW (xfmpc_main_window_get_type ())
#define XFMPC_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_MAIN_WINDOW, XfmpcMainWindow))
#define XFMPC_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_MAIN_WINDOW, XfmpcMainWindowClass))
#define XFMPC_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_MAIN_WINDOW))
#define XFMPC_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_MAIN_WINDOW))
#define XFMPC_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_MAIN_WINDOW, XfmpcMainWindowClass))

typedef struct _XfmpcMainWindow XfmpcMainWindow;
typedef struct _XfmpcMainWindowClass XfmpcMainWindowClass;
typedef struct _XfmpcMainWindowPrivate XfmpcMainWindowPrivate;

#define XFMPC_TYPE_PREFERENCES (xfmpc_preferences_get_type ())
#define XFMPC_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_PREFERENCES, XfmpcPreferences))
#define XFMPC_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_PREFERENCES, XfmpcPreferencesClass))
#define XFMPC_IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_PREFERENCES))
#define XFMPC_IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_PREFERENCES))
#define XFMPC_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_PREFERENCES, XfmpcPreferencesClass))

typedef struct _XfmpcPreferences XfmpcPreferences;
typedef struct _XfmpcPreferencesClass XfmpcPreferencesClass;

#define XFMPC_TYPE_INTERFACE (xfmpc_interface_get_type ())
#define XFMPC_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_INTERFACE, XfmpcInterface))
#define XFMPC_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_INTERFACE, XfmpcInterfaceClass))
#define XFMPC_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_INTERFACE))
#define XFMPC_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_INTERFACE))
#define XFMPC_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_INTERFACE, XfmpcInterfaceClass))

typedef struct _XfmpcInterface XfmpcInterface;
typedef struct _XfmpcInterfaceClass XfmpcInterfaceClass;

#define XFMPC_TYPE_EXTENDED_INTERFACE (xfmpc_extended_interface_get_type ())
#define XFMPC_EXTENDED_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_EXTENDED_INTERFACE, XfmpcExtendedInterface))
#define XFMPC_EXTENDED_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_EXTENDED_INTERFACE, XfmpcExtendedInterfaceClass))
#define XFMPC_IS_EXTENDED_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_EXTENDED_INTERFACE))
#define XFMPC_IS_EXTENDED_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_EXTENDED_INTERFACE))
#define XFMPC_EXTENDED_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_EXTENDED_INTERFACE, XfmpcExtendedInterfaceClass))

typedef struct _XfmpcExtendedInterface XfmpcExtendedInterface;
typedef struct _XfmpcExtendedInterfaceClass XfmpcExtendedInterfaceClass;

#define XFMPC_TYPE_STATUSBAR (xfmpc_statusbar_get_type ())
#define XFMPC_STATUSBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_STATUSBAR, XfmpcStatusbar))
#define XFMPC_STATUSBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_STATUSBAR, XfmpcStatusbarClass))
#define XFMPC_IS_STATUSBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_STATUSBAR))
#define XFMPC_IS_STATUSBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_STATUSBAR))
#define XFMPC_STATUSBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_STATUSBAR, XfmpcStatusbarClass))

typedef struct _XfmpcStatusbar XfmpcStatusbar;
typedef struct _XfmpcStatusbarClass XfmpcStatusbarClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _XfmpcMainWindow {
	GtkWindow parent_instance;
	XfmpcMainWindowPrivate * priv;
};

struct _XfmpcMainWindowClass {
	GtkWindowClass parent_class;
};

struct _XfmpcMainWindowPrivate {
	GtkStatusIcon* status_icon;
	GtkMenu* status_icon_menu;
	XfmpcMpdclient* mpdclient;
	XfmpcPreferences* preferences;
	XfmpcInterface* interface;
	XfmpcExtendedInterface* extended_interface;
	GtkVBox* vbox;
	GtkActionGroup* action_group;
	GtkUIManager* ui_manager;
	XfmpcStatusbar* statusbar;
};


static gpointer xfmpc_main_window_parent_class = NULL;

GType xfmpc_main_window_get_type (void) G_GNUC_CONST;
GType xfmpc_preferences_get_type (void) G_GNUC_CONST;
GType xfmpc_interface_get_type (void) G_GNUC_CONST;
GType xfmpc_extended_interface_get_type (void) G_GNUC_CONST;
GType xfmpc_statusbar_get_type (void) G_GNUC_CONST;
#define XFMPC_MAIN_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), XFMPC_TYPE_MAIN_WINDOW, XfmpcMainWindowPrivate))
enum  {
	XFMPC_MAIN_WINDOW_DUMMY_PROPERTY
};
static void xfmpc_main_window_action_statusbar (XfmpcMainWindow* self, GtkAction* action);
static void _xfmpc_main_window_action_statusbar_gtk_action_callback (GtkAction* action, gpointer self);
static void xfmpc_main_window_action_quit (XfmpcMainWindow* self);
static void _xfmpc_main_window_action_quit_gtk_action_callback (GtkAction* action, gpointer self);
static void xfmpc_main_window_action_previous (XfmpcMainWindow* self);
static void _xfmpc_main_window_action_previous_gtk_action_callback (GtkAction* action, gpointer self);
static void xfmpc_main_window_action_pp (XfmpcMainWindow* self);
static void _xfmpc_main_window_action_pp_gtk_action_callback (GtkAction* action, gpointer self);
static void xfmpc_main_window_action_stop (XfmpcMainWindow* self);
static void _xfmpc_main_window_action_stop_gtk_action_callback (GtkAction* action, gpointer self);
static void xfmpc_main_window_action_next (XfmpcMainWindow* self);
static void _xfmpc_main_window_action_next_gtk_action_callback (GtkAction* action, gpointer self);
static void xfmpc_main_window_action_volume (XfmpcMainWindow* self);
static void _xfmpc_main_window_action_volume_gtk_action_callback (GtkAction* action, gpointer self);
#define XFMPC_MAIN_WINDOW_ui_string "\n" \
"<ui>\n" \
"  <accelerator action=\"quit\" />\n" \
"  <accelerator action=\"previous\" />\n" \
"  <accelerator action=\"pp\" />\n" \
"  <accelerator action=\"stop\" />\n" \
"  <accelerator action=\"next\" />\n" \
"  <accelerator action=\"volume\" />\n" \
"</ui>\n"
static void xfmpc_main_window_show_hide_status_icon (XfmpcMainWindow* self);
gboolean xfmpc_preferences_get_show_status_icon (XfmpcPreferences* self);
static void xfmpc_main_window_status_icon_activated (XfmpcMainWindow* self);
static void xfmpc_main_window_close_window (XfmpcMainWindow* self);
static void xfmpc_main_window_status_icon_popup_menu (XfmpcMainWindow* self, guint button, guint activate_time);
static void _gtk_main_quit_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
static gboolean xfmpc_main_window_refresh (XfmpcMainWindow* self);
void xfmpc_interface_reset (XfmpcInterface* self);
void xfmpc_statusbar_set_text (XfmpcStatusbar* self, const gchar* value);
void xfmpc_interface_update_title (XfmpcInterface* self);
static gboolean xfmpc_main_window_cb_window_state_event (XfmpcMainWindow* self, GdkEventWindowState* event);
void xfmpc_preferences_set_last_window_state_sticky (XfmpcPreferences* self, gboolean value);
static gboolean xfmpc_main_window_cb_window_closed (XfmpcMainWindow* self, GdkEvent* event);
void xfmpc_preferences_set_last_window_posx (XfmpcPreferences* self, gint value);
void xfmpc_preferences_set_last_window_posy (XfmpcPreferences* self, gint value);
void xfmpc_preferences_set_last_window_width (XfmpcPreferences* self, gint value);
void xfmpc_preferences_set_last_window_height (XfmpcPreferences* self, gint value);
gint xfmpc_preferences_get_last_window_posx (XfmpcPreferences* self);
gint xfmpc_preferences_get_last_window_posy (XfmpcPreferences* self);
void xfmpc_interface_pp_clicked (XfmpcInterface* self);
void xfmpc_interface_popup_volume (XfmpcInterface* self);
XfmpcStatusbar* xfmpc_statusbar_new (void);
XfmpcStatusbar* xfmpc_statusbar_construct (GType object_type);
static void xfmpc_main_window_update_statusbar (XfmpcMainWindow* self);
static void xfmpc_main_window_cb_playlist_changed (XfmpcMainWindow* self);
static void xfmpc_main_window_update_window_title (XfmpcMainWindow* self);
static void xfmpc_main_window_cb_show_statusbar_changed (XfmpcMainWindow* self, GParamSpec* pspec);
gboolean xfmpc_preferences_get_show_statusbar (XfmpcPreferences* self);
XfmpcMainWindow* xfmpc_main_window_new (void);
XfmpcMainWindow* xfmpc_main_window_construct (GType object_type);
static GObject * xfmpc_main_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
XfmpcPreferences* xfmpc_preferences_get_default (void);
static void _xfmpc_main_window_status_icon_activated_gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self);
static void _xfmpc_main_window_status_icon_popup_menu_gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self);
static void _xfmpc_main_window_show_hide_status_icon_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean _xfmpc_main_window_cb_window_closed_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
static gboolean _xfmpc_main_window_cb_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
gint xfmpc_preferences_get_last_window_width (XfmpcPreferences* self);
gint xfmpc_preferences_get_last_window_height (XfmpcPreferences* self);
gboolean xfmpc_preferences_get_last_window_state_sticky (XfmpcPreferences* self);
XfmpcInterface* xfmpc_interface_new (void);
XfmpcInterface* xfmpc_interface_construct (GType object_type);
XfmpcExtendedInterface* xfmpc_extended_interface_new (void);
XfmpcExtendedInterface* xfmpc_extended_interface_construct (GType object_type);
static void _xfmpc_main_window_update_window_title_xfmpc_mpdclient_pp_changed (XfmpcMpdclient* _sender, gboolean is_playing, gpointer self);
static void _xfmpc_main_window_update_window_title_xfmpc_mpdclient_stopped (XfmpcMpdclient* _sender, gpointer self);
static void _xfmpc_main_window_update_window_title_xfmpc_mpdclient_song_changed (XfmpcMpdclient* _sender, gpointer self);
static void _xfmpc_main_window_cb_playlist_changed_xfmpc_mpdclient_playlist_changed (XfmpcMpdclient* _sender, gpointer self);
static void _xfmpc_main_window_cb_show_statusbar_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean _xfmpc_main_window_refresh_gsource_func (gpointer self);
static void xfmpc_main_window_finalize (GObject* obj);

static const GtkToggleActionEntry XFMPC_MAIN_WINDOW_toggle_action_entries[1] = {{"view-statusbar", NULL, "", NULL, NULL, (GCallback) _xfmpc_main_window_action_statusbar_gtk_action_callback, FALSE}};
static const GtkActionEntry XFMPC_MAIN_WINDOW_action_entries[6] = {{"quit", NULL, "", "<control>q", NULL, (GCallback) _xfmpc_main_window_action_quit_gtk_action_callback}, {"previous", NULL, "", "<control>b", NULL, (GCallback) _xfmpc_main_window_action_previous_gtk_action_callback}, {"pp", NULL, "", "<control>p", NULL, (GCallback) _xfmpc_main_window_action_pp_gtk_action_callback}, {"stop", NULL, "", "<control>s", NULL, (GCallback) _xfmpc_main_window_action_stop_gtk_action_callback}, {"next", NULL, "", "<control>f", NULL, (GCallback) _xfmpc_main_window_action_next_gtk_action_callback}, {"volume", NULL, "", "<control>v", NULL, (GCallback) _xfmpc_main_window_action_volume_gtk_action_callback}};

static void _xfmpc_main_window_action_statusbar_gtk_action_callback (GtkAction* action, gpointer self) {
	xfmpc_main_window_action_statusbar (self, action);
}


static void _xfmpc_main_window_action_quit_gtk_action_callback (GtkAction* action, gpointer self) {
	xfmpc_main_window_action_quit (self);
}


static void _xfmpc_main_window_action_previous_gtk_action_callback (GtkAction* action, gpointer self) {
	xfmpc_main_window_action_previous (self);
}


static void _xfmpc_main_window_action_pp_gtk_action_callback (GtkAction* action, gpointer self) {
	xfmpc_main_window_action_pp (self);
}


static void _xfmpc_main_window_action_stop_gtk_action_callback (GtkAction* action, gpointer self) {
	xfmpc_main_window_action_stop (self);
}


static void _xfmpc_main_window_action_next_gtk_action_callback (GtkAction* action, gpointer self) {
	xfmpc_main_window_action_next (self);
}


static void _xfmpc_main_window_action_volume_gtk_action_callback (GtkAction* action, gpointer self) {
	xfmpc_main_window_action_volume (self);
}


static void xfmpc_main_window_show_hide_status_icon (XfmpcMainWindow* self) {
	GtkStatusIcon* _tmp0_;
	XfmpcPreferences* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->status_icon;
	_tmp1_ = self->priv->preferences;
	_tmp2_ = xfmpc_preferences_get_show_status_icon (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_status_icon_set_visible (_tmp0_, _tmp3_);
}


static void xfmpc_main_window_status_icon_activated (XfmpcMainWindow* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_visible ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		gtk_widget_show ((GtkWidget*) self);
		gtk_window_deiconify ((GtkWindow*) self);
	} else {
		xfmpc_main_window_close_window (self);
	}
}


static void _gtk_main_quit_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	gtk_main_quit ();
}


static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
	gtk_status_icon_position_menu (menu, x, y, push_in, self);
}


static void xfmpc_main_window_status_icon_popup_menu (XfmpcMainWindow* self, guint button, guint activate_time) {
	GtkMenu* _tmp0_;
	GtkMenu* _tmp9_;
	GtkStatusIcon* _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->status_icon_menu;
	if (_tmp0_ == NULL) {
		GtkMenu* _tmp1_;
		GtkMenu* _tmp2_;
		GtkImageMenuItem* _tmp3_;
		GtkImageMenuItem* _tmp4_;
		GtkImageMenuItem* mi;
		GtkImageMenuItem* _tmp5_;
		GtkMenu* _tmp6_;
		GtkImageMenuItem* _tmp7_;
		GtkMenu* _tmp8_;
		_tmp1_ = (GtkMenu*) gtk_menu_new ();
		_tmp2_ = g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->status_icon_menu);
		self->priv->status_icon_menu = _tmp2_;
		_tmp3_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_QUIT, NULL);
		_tmp4_ = g_object_ref_sink (_tmp3_);
		mi = _tmp4_;
		_tmp5_ = mi;
		g_signal_connect ((GtkMenuItem*) _tmp5_, "activate", (GCallback) _gtk_main_quit_gtk_menu_item_activate, NULL);
		_tmp6_ = self->priv->status_icon_menu;
		_tmp7_ = mi;
		gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) _tmp7_);
		_tmp8_ = self->priv->status_icon_menu;
		gtk_widget_show_all ((GtkWidget*) _tmp8_);
		_g_object_unref0 (mi);
	}
	_tmp9_ = self->priv->status_icon_menu;
	_tmp10_ = self->priv->status_icon;
	_tmp11_ = button;
	_tmp12_ = activate_time;
	gtk_menu_popup (_tmp9_, NULL, NULL, _gtk_status_icon_position_menu_gtk_menu_position_func, _tmp10_, _tmp11_, (guint32) _tmp12_);
}


static gboolean xfmpc_main_window_refresh (XfmpcMainWindow* self) {
	gboolean result = FALSE;
	XfmpcMpdclient* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->mpdclient;
	_tmp1_ = xfmpc_mpdclient_is_connected (_tmp0_);
	if (_tmp1_) {
		XfmpcMpdclient* _tmp2_;
		_tmp2_ = self->priv->mpdclient;
		xfmpc_mpdclient_update_status (_tmp2_);
	} else {
		XfmpcInterface* _tmp3_;
		XfmpcMpdclient* _tmp4_;
		XfmpcStatusbar* _tmp5_;
		XfmpcMpdclient* _tmp7_;
		XfmpcMpdclient* _tmp8_;
		gboolean _tmp9_ = FALSE;
		_tmp3_ = self->priv->interface;
		xfmpc_interface_reset (_tmp3_);
		_tmp4_ = self->priv->mpdclient;
		xfmpc_mpdclient_reload (_tmp4_);
		_tmp5_ = self->priv->statusbar;
		if (_tmp5_ != NULL) {
			XfmpcStatusbar* _tmp6_;
			_tmp6_ = self->priv->statusbar;
			xfmpc_statusbar_set_text (_tmp6_, "");
		}
		_tmp7_ = self->priv->mpdclient;
		xfmpc_mpdclient_connect (_tmp7_);
		_tmp8_ = self->priv->mpdclient;
		_tmp9_ = xfmpc_mpdclient_is_connected (_tmp8_);
		if (_tmp9_) {
			XfmpcInterface* _tmp10_;
			_tmp10_ = self->priv->interface;
			xfmpc_interface_update_title (_tmp10_);
		}
	}
	result = TRUE;
	return result;
}


static gboolean xfmpc_main_window_cb_window_state_event (XfmpcMainWindow* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState _tmp0_;
	GdkEventType _tmp1_;
	gboolean _tmp2_ = FALSE;
	GdkEventWindowState _tmp3_;
	GdkWindowState _tmp4_;
	gboolean _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.type;
	if (_tmp1_ != GDK_WINDOW_STATE) {
		result = FALSE;
		return result;
	}
	_tmp3_ = *event;
	_tmp4_ = _tmp3_.changed_mask;
	if (((gboolean) _tmp4_) & GDK_WINDOW_STATE_STICKY) {
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = gtk_widget_get_visible ((GtkWidget*) self);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		gboolean sticky = FALSE;
		GdkEventWindowState _tmp8_;
		GdkWindowState _tmp9_;
		XfmpcPreferences* _tmp10_;
		gboolean _tmp11_;
		_tmp8_ = *event;
		_tmp9_ = _tmp8_.new_window_state;
		if ((((gboolean) _tmp9_) & GDK_WINDOW_STATE_STICKY) == FALSE) {
			sticky = FALSE;
		} else {
			sticky = TRUE;
		}
		_tmp10_ = self->priv->preferences;
		_tmp11_ = sticky;
		xfmpc_preferences_set_last_window_state_sticky (_tmp10_, _tmp11_);
	}
	result = FALSE;
	return result;
}


static gboolean xfmpc_main_window_cb_window_closed (XfmpcMainWindow* self, GdkEvent* event) {
	gboolean result = FALSE;
	GtkStatusIcon* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	xfmpc_main_window_close_window (self);
	_tmp0_ = self->priv->status_icon;
	_tmp1_ = gtk_status_icon_get_visible (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void xfmpc_main_window_action_quit (XfmpcMainWindow* self) {
	GtkStatusIcon* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->status_icon;
	gtk_status_icon_set_visible (_tmp0_, FALSE);
	xfmpc_main_window_close_window (self);
}


static void xfmpc_main_window_close_window (XfmpcMainWindow* self) {
	gint posx = 0;
	gint posy = 0;
	gint width = 0;
	gint height = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	XfmpcPreferences* _tmp4_;
	gint _tmp5_;
	XfmpcPreferences* _tmp6_;
	gint _tmp7_;
	XfmpcPreferences* _tmp8_;
	gint _tmp9_;
	XfmpcPreferences* _tmp10_;
	gint _tmp11_;
	GtkStatusIcon* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	g_return_if_fail (self != NULL);
	gtk_window_get_position ((GtkWindow*) self, &_tmp0_, &_tmp1_);
	posx = _tmp0_;
	posy = _tmp1_;
	gtk_window_get_size ((GtkWindow*) self, &_tmp2_, &_tmp3_);
	width = _tmp2_;
	height = _tmp3_;
	_tmp4_ = self->priv->preferences;
	_tmp5_ = posx;
	xfmpc_preferences_set_last_window_posx (_tmp4_, _tmp5_);
	_tmp6_ = self->priv->preferences;
	_tmp7_ = posy;
	xfmpc_preferences_set_last_window_posy (_tmp6_, _tmp7_);
	_tmp8_ = self->priv->preferences;
	_tmp9_ = width;
	xfmpc_preferences_set_last_window_width (_tmp8_, _tmp9_);
	_tmp10_ = self->priv->preferences;
	_tmp11_ = height;
	xfmpc_preferences_set_last_window_height (_tmp10_, _tmp11_);
	_tmp12_ = self->priv->status_icon;
	_tmp13_ = gtk_status_icon_get_visible (_tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_) {
		XfmpcPreferences* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		XfmpcPreferences* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gtk_widget_hide ((GtkWidget*) self);
		_tmp15_ = self->priv->preferences;
		_tmp16_ = xfmpc_preferences_get_last_window_posx (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = self->priv->preferences;
		_tmp19_ = xfmpc_preferences_get_last_window_posy (_tmp18_);
		_tmp20_ = _tmp19_;
		gtk_window_move ((GtkWindow*) self, _tmp17_, _tmp20_);
		return;
	}
	gtk_main_quit ();
}


static void xfmpc_main_window_action_previous (XfmpcMainWindow* self) {
	XfmpcMpdclient* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	xfmpc_mpdclient_previous (_tmp0_);
}


static void xfmpc_main_window_action_pp (XfmpcMainWindow* self) {
	XfmpcInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->interface;
	xfmpc_interface_pp_clicked (_tmp0_);
}


static void xfmpc_main_window_action_stop (XfmpcMainWindow* self) {
	XfmpcMpdclient* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	xfmpc_mpdclient_stop (_tmp0_);
}


static void xfmpc_main_window_action_next (XfmpcMainWindow* self) {
	XfmpcMpdclient* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	xfmpc_mpdclient_next (_tmp0_);
}


static void xfmpc_main_window_action_volume (XfmpcMainWindow* self) {
	XfmpcInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->interface;
	xfmpc_interface_popup_volume (_tmp0_);
}


static void xfmpc_main_window_action_statusbar (XfmpcMainWindow* self, GtkAction* action) {
	GtkAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean active;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gtk_toggle_action_get_active (GTK_TOGGLE_ACTION (_tmp0_));
	active = _tmp1_;
	_tmp3_ = active;
	if (!_tmp3_) {
		XfmpcStatusbar* _tmp4_;
		_tmp4_ = self->priv->statusbar;
		_tmp2_ = _tmp4_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		XfmpcStatusbar* _tmp6_;
		_tmp6_ = self->priv->statusbar;
		gtk_object_destroy ((GtkObject*) _tmp6_);
		_g_object_unref0 (self->priv->statusbar);
		self->priv->statusbar = NULL;
	} else {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_;
		gboolean _tmp10_;
		_tmp8_ = active;
		if (_tmp8_) {
			XfmpcStatusbar* _tmp9_;
			_tmp9_ = self->priv->statusbar;
			_tmp7_ = _tmp9_ == NULL;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp10_ = _tmp7_;
		if (_tmp10_) {
			XfmpcStatusbar* _tmp11_;
			XfmpcStatusbar* _tmp12_;
			XfmpcStatusbar* _tmp13_;
			GtkVBox* _tmp14_;
			XfmpcStatusbar* _tmp15_;
			_tmp11_ = xfmpc_statusbar_new ();
			_tmp12_ = g_object_ref_sink (_tmp11_);
			_g_object_unref0 (self->priv->statusbar);
			self->priv->statusbar = _tmp12_;
			_tmp13_ = self->priv->statusbar;
			gtk_widget_show ((GtkWidget*) _tmp13_);
			_tmp14_ = self->priv->vbox;
			_tmp15_ = self->priv->statusbar;
			gtk_box_pack_start ((GtkBox*) _tmp14_, (GtkWidget*) _tmp15_, FALSE, FALSE, (guint) 0);
		}
	}
}


static void xfmpc_main_window_update_statusbar (XfmpcMainWindow* self) {
	gint seconds = 0;
	gint length = 0;
	XfmpcStatusbar* _tmp0_;
	XfmpcMpdclient* _tmp1_;
	gboolean _tmp2_ = FALSE;
	XfmpcMpdclient* _tmp3_;
	gint _tmp4_ = 0;
	XfmpcMpdclient* _tmp5_;
	gint _tmp6_ = 0;
	GString* _tmp7_;
	GString* text;
	gint _tmp8_;
	XfmpcStatusbar* _tmp18_;
	GString* _tmp19_;
	const gchar* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->statusbar;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->mpdclient;
	_tmp2_ = xfmpc_mpdclient_is_connected (_tmp1_);
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->mpdclient;
	_tmp4_ = xfmpc_mpdclient_playlist_get_length (_tmp3_);
	length = _tmp4_;
	_tmp5_ = self->priv->mpdclient;
	_tmp6_ = xfmpc_mpdclient_playlist_get_total_time (_tmp5_);
	seconds = _tmp6_;
	_tmp7_ = g_string_new ("");
	text = _tmp7_;
	_tmp8_ = seconds;
	if ((_tmp8_ / 3600) > 0) {
		GString* _tmp9_;
		const gchar* _tmp10_ = NULL;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp9_ = text;
		_tmp10_ = _ ("%d songs, %d hours and %d minutes");
		_tmp11_ = length;
		_tmp12_ = seconds;
		_tmp13_ = seconds;
		g_string_append_printf (_tmp9_, _tmp10_, _tmp11_, _tmp12_ / 3600, (_tmp13_ / 60) % 60);
	} else {
		GString* _tmp14_;
		const gchar* _tmp15_ = NULL;
		gint _tmp16_;
		gint _tmp17_;
		_tmp14_ = text;
		_tmp15_ = _ ("%d songs, %d minutes");
		_tmp16_ = length;
		_tmp17_ = seconds;
		g_string_append_printf (_tmp14_, _tmp15_, _tmp16_, (_tmp17_ / 60) % 60);
	}
	_tmp18_ = self->priv->statusbar;
	_tmp19_ = text;
	_tmp20_ = _tmp19_->str;
	xfmpc_statusbar_set_text (_tmp18_, _tmp20_);
	_g_string_free0 (text);
}


static void xfmpc_main_window_cb_playlist_changed (XfmpcMainWindow* self) {
	g_return_if_fail (self != NULL);
	xfmpc_main_window_update_statusbar (self);
	xfmpc_main_window_update_window_title (self);
}


static void xfmpc_main_window_update_window_title (XfmpcMainWindow* self) {
	gchar* _title = NULL;
	gboolean _tmp0_ = FALSE;
	XfmpcMpdclient* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp5_;
	XfmpcMpdclient* _tmp22_;
	gboolean _tmp23_ = FALSE;
	GtkStatusIcon* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->mpdclient;
	_tmp2_ = xfmpc_mpdclient_get_artist (_tmp1_);
	if (g_strcmp0 (_tmp2_, "n/a") != 0) {
		XfmpcMpdclient* _tmp3_;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = self->priv->mpdclient;
		_tmp4_ = xfmpc_mpdclient_get_title (_tmp3_);
		_tmp0_ = g_strcmp0 (_tmp4_, "n/a") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		XfmpcMpdclient* _tmp6_;
		const gchar* _tmp7_ = NULL;
		XfmpcMpdclient* _tmp8_;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp6_ = self->priv->mpdclient;
		_tmp7_ = xfmpc_mpdclient_get_artist (_tmp6_);
		_tmp8_ = self->priv->mpdclient;
		_tmp9_ = xfmpc_mpdclient_get_title (_tmp8_);
		_tmp10_ = g_strdup_printf ("%s - %s", _tmp7_, _tmp9_);
		_g_free0 (_title);
		_title = _tmp10_;
	} else {
		XfmpcMpdclient* _tmp11_;
		const gchar* _tmp12_ = NULL;
		_tmp11_ = self->priv->mpdclient;
		_tmp12_ = xfmpc_mpdclient_get_artist (_tmp11_);
		if (g_strcmp0 (_tmp12_, "n/a") == 0) {
			XfmpcMpdclient* _tmp13_;
			const gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			_tmp13_ = self->priv->mpdclient;
			_tmp14_ = xfmpc_mpdclient_get_title (_tmp13_);
			_tmp15_ = g_strdup_printf ("%s", _tmp14_);
			_g_free0 (_title);
			_title = _tmp15_;
		} else {
			XfmpcMpdclient* _tmp16_;
			const gchar* _tmp17_ = NULL;
			_tmp16_ = self->priv->mpdclient;
			_tmp17_ = xfmpc_mpdclient_get_title (_tmp16_);
			if (g_strcmp0 (_tmp17_, "n/a") == 0) {
				XfmpcMpdclient* _tmp18_;
				const gchar* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				_tmp18_ = self->priv->mpdclient;
				_tmp19_ = xfmpc_mpdclient_get_artist (_tmp18_);
				_tmp20_ = g_strdup_printf ("%s", _tmp19_);
				_g_free0 (_title);
				_title = _tmp20_;
			} else {
				gchar* _tmp21_;
				_tmp21_ = g_strdup (PACKAGE_NAME);
				_g_free0 (_title);
				_title = _tmp21_;
			}
		}
	}
	_tmp22_ = self->priv->mpdclient;
	_tmp23_ = xfmpc_mpdclient_is_playing (_tmp22_);
	if (_tmp23_) {
		const gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp24_ = _title;
		_tmp25_ = g_strconcat (_tmp24_, " - ", NULL);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_strconcat (_tmp26_, PACKAGE_NAME, NULL);
		_tmp28_ = _tmp27_;
		gtk_window_set_title ((GtkWindow*) self, _tmp28_);
		_g_free0 (_tmp28_);
		_g_free0 (_tmp26_);
	} else {
		XfmpcMpdclient* _tmp29_;
		gboolean _tmp30_ = FALSE;
		_tmp29_ = self->priv->mpdclient;
		_tmp30_ = xfmpc_mpdclient_is_paused (_tmp29_);
		if (_tmp30_) {
			const gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			_tmp31_ = _title;
			_tmp32_ = g_strconcat ("[", _tmp31_, NULL);
			_tmp33_ = _tmp32_;
			_tmp34_ = g_strconcat (_tmp33_, "] - ", NULL);
			_tmp35_ = _tmp34_;
			_tmp36_ = g_strconcat (_tmp35_, PACKAGE_NAME, NULL);
			_tmp37_ = _tmp36_;
			gtk_window_set_title ((GtkWindow*) self, _tmp37_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp35_);
			_g_free0 (_tmp33_);
		} else {
			gtk_window_set_title ((GtkWindow*) self, PACKAGE_NAME);
		}
	}
	_tmp38_ = self->priv->status_icon;
	_tmp39_ = gtk_window_get_title ((GtkWindow*) self);
	_tmp40_ = _tmp39_;
	gtk_status_icon_set_tooltip_text (_tmp38_, _tmp40_);
	_g_free0 (_title);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void xfmpc_main_window_cb_show_statusbar_changed (XfmpcMainWindow* self, GParamSpec* pspec) {
	GtkActionGroup* _tmp0_;
	GtkAction* _tmp1_ = NULL;
	GtkAction* _tmp2_;
	GtkAction* action;
	XfmpcPreferences* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean active;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->action_group;
	_tmp1_ = gtk_action_group_get_action (_tmp0_, "view-statusbar");
	_tmp2_ = _g_object_ref0 (_tmp1_);
	action = _tmp2_;
	_tmp3_ = self->priv->preferences;
	_tmp4_ = xfmpc_preferences_get_show_statusbar (_tmp3_);
	_tmp5_ = _tmp4_;
	active = _tmp5_;
	gtk_toggle_action_set_active (GTK_TOGGLE_ACTION (action), active);
	xfmpc_main_window_update_statusbar (self);
	_g_object_unref0 (action);
}


XfmpcMainWindow* xfmpc_main_window_construct (GType object_type) {
	XfmpcMainWindow * self = NULL;
	self = (XfmpcMainWindow*) g_object_new (object_type, NULL);
	return self;
}


XfmpcMainWindow* xfmpc_main_window_new (void) {
	return xfmpc_main_window_construct (XFMPC_TYPE_MAIN_WINDOW);
}


static void _xfmpc_main_window_status_icon_activated_gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self) {
	xfmpc_main_window_status_icon_activated (self);
}


static void _xfmpc_main_window_status_icon_popup_menu_gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self) {
	xfmpc_main_window_status_icon_popup_menu (self, button, activate_time);
}


static void _xfmpc_main_window_show_hide_status_icon_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	xfmpc_main_window_show_hide_status_icon (self);
}


static gboolean _xfmpc_main_window_cb_window_closed_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
	gboolean result;
	result = xfmpc_main_window_cb_window_closed (self, event);
	return result;
}


static gboolean _xfmpc_main_window_cb_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = xfmpc_main_window_cb_window_state_event (self, event);
	return result;
}


static void _xfmpc_main_window_update_window_title_xfmpc_mpdclient_pp_changed (XfmpcMpdclient* _sender, gboolean is_playing, gpointer self) {
	xfmpc_main_window_update_window_title (self);
}


static void _xfmpc_main_window_update_window_title_xfmpc_mpdclient_stopped (XfmpcMpdclient* _sender, gpointer self) {
	xfmpc_main_window_update_window_title (self);
}


static void _xfmpc_main_window_update_window_title_xfmpc_mpdclient_song_changed (XfmpcMpdclient* _sender, gpointer self) {
	xfmpc_main_window_update_window_title (self);
}


static void _xfmpc_main_window_cb_playlist_changed_xfmpc_mpdclient_playlist_changed (XfmpcMpdclient* _sender, gpointer self) {
	xfmpc_main_window_cb_playlist_changed (self);
}


static void _xfmpc_main_window_cb_show_statusbar_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	xfmpc_main_window_cb_show_statusbar_changed (self, pspec);
}


static gboolean _xfmpc_main_window_refresh_gsource_func (gpointer self) {
	gboolean result;
	result = xfmpc_main_window_refresh (self);
	return result;
}


static GObject * xfmpc_main_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	XfmpcMainWindow * self;
	XfmpcMpdclient* _tmp0_ = NULL;
	XfmpcPreferences* _tmp1_ = NULL;
	GtkStatusIcon* _tmp2_;
	GtkStatusIcon* _tmp3_;
	GtkStatusIcon* _tmp4_;
	XfmpcPreferences* _tmp5_;
	GtkVBox* _tmp6_;
	GtkVBox* _tmp7_;
	GtkVBox* _tmp8_;
	gboolean _tmp9_ = FALSE;
	XfmpcPreferences* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gboolean _tmp16_;
	gboolean _tmp23_ = FALSE;
	XfmpcPreferences* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	gboolean _tmp30_;
	XfmpcPreferences* _tmp37_;
	gboolean _tmp38_;
	gboolean _tmp39_;
	XfmpcInterface* _tmp40_;
	XfmpcInterface* _tmp41_;
	GtkVBox* _tmp42_;
	XfmpcInterface* _tmp43_;
	GtkHSeparator* _tmp44_;
	GtkHSeparator* _tmp45_;
	GtkHSeparator* separator;
	GtkVBox* _tmp46_;
	GtkHSeparator* _tmp47_;
	XfmpcExtendedInterface* _tmp48_;
	XfmpcExtendedInterface* _tmp49_;
	GtkVBox* _tmp50_;
	XfmpcExtendedInterface* _tmp51_;
	GtkUIManager* _tmp52_;
	GtkActionGroup* _tmp53_;
	GtkActionGroup* _tmp54_;
	GtkActionGroup* _tmp55_;
	GtkUIManager* _tmp56_;
	GtkActionGroup* _tmp57_;
	GtkUIManager* _tmp61_;
	GtkAccelGroup* _tmp62_ = NULL;
	GtkAccelGroup* _tmp63_;
	GtkAccelGroup* accel_group;
	GtkAccelGroup* _tmp64_;
	GtkActionGroup* _tmp65_;
	GtkAction* _tmp66_ = NULL;
	XfmpcPreferences* _tmp67_;
	gboolean _tmp68_;
	gboolean _tmp69_;
	XfmpcMpdclient* _tmp70_;
	XfmpcMpdclient* _tmp71_;
	XfmpcMpdclient* _tmp72_;
	XfmpcMpdclient* _tmp73_;
	XfmpcPreferences* _tmp74_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (xfmpc_main_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = XFMPC_MAIN_WINDOW (obj);
	_tmp0_ = xfmpc_mpdclient_get_default ();
	self->priv->mpdclient = _tmp0_;
	_tmp1_ = xfmpc_preferences_get_default ();
	self->priv->preferences = _tmp1_;
	_tmp2_ = gtk_status_icon_new_from_icon_name ("stock_volume");
	_g_object_unref0 (self->priv->status_icon);
	self->priv->status_icon = _tmp2_;
	xfmpc_main_window_show_hide_status_icon (self);
	_tmp3_ = self->priv->status_icon;
	g_signal_connect_object (_tmp3_, "activate", (GCallback) _xfmpc_main_window_status_icon_activated_gtk_status_icon_activate, self, 0);
	_tmp4_ = self->priv->status_icon;
	g_signal_connect_object (_tmp4_, "popup-menu", (GCallback) _xfmpc_main_window_status_icon_popup_menu_gtk_status_icon_popup_menu, self, 0);
	_tmp5_ = self->priv->preferences;
	g_signal_connect_object ((GObject*) _tmp5_, "notify::show-status-icon", (GCallback) _xfmpc_main_window_show_hide_status_icon_g_object_notify, self, 0);
	gtk_window_set_default_icon_name ("xfmpc");
	gtk_window_set_icon_name ((GtkWindow*) self, "stock_volume");
	gtk_window_set_title ((GtkWindow*) self, PACKAGE_NAME);
	gtk_window_set_default_size ((GtkWindow*) self, 330, 330);
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) _xfmpc_main_window_cb_window_closed_gtk_widget_delete_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "window-state-event", (GCallback) _xfmpc_main_window_cb_window_state_event_gtk_widget_window_state_event, self, 0);
	_tmp6_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	_tmp7_ = g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->vbox);
	self->priv->vbox = _tmp7_;
	_tmp8_ = self->priv->vbox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp8_);
	_tmp10_ = self->priv->preferences;
	_tmp11_ = xfmpc_preferences_get_last_window_posx (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != (-1)) {
		XfmpcPreferences* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		_tmp13_ = self->priv->preferences;
		_tmp14_ = xfmpc_preferences_get_last_window_posy (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp9_ = _tmp15_ != (-1);
	} else {
		_tmp9_ = FALSE;
	}
	_tmp16_ = _tmp9_;
	if (_tmp16_) {
		XfmpcPreferences* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		XfmpcPreferences* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp17_ = self->priv->preferences;
		_tmp18_ = xfmpc_preferences_get_last_window_posx (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = self->priv->preferences;
		_tmp21_ = xfmpc_preferences_get_last_window_posy (_tmp20_);
		_tmp22_ = _tmp21_;
		gtk_window_move ((GtkWindow*) self, _tmp19_, _tmp22_);
	}
	_tmp24_ = self->priv->preferences;
	_tmp25_ = xfmpc_preferences_get_last_window_width (_tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp26_ != (-1)) {
		XfmpcPreferences* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		_tmp27_ = self->priv->preferences;
		_tmp28_ = xfmpc_preferences_get_last_window_height (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp23_ = _tmp29_ != (-1);
	} else {
		_tmp23_ = FALSE;
	}
	_tmp30_ = _tmp23_;
	if (_tmp30_) {
		XfmpcPreferences* _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		XfmpcPreferences* _tmp34_;
		gint _tmp35_;
		gint _tmp36_;
		_tmp31_ = self->priv->preferences;
		_tmp32_ = xfmpc_preferences_get_last_window_width (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = self->priv->preferences;
		_tmp35_ = xfmpc_preferences_get_last_window_height (_tmp34_);
		_tmp36_ = _tmp35_;
		gtk_window_set_default_size ((GtkWindow*) self, _tmp33_, _tmp36_);
	}
	_tmp37_ = self->priv->preferences;
	_tmp38_ = xfmpc_preferences_get_last_window_state_sticky (_tmp37_);
	_tmp39_ = _tmp38_;
	if (_tmp39_ == TRUE) {
		gtk_window_stick ((GtkWindow*) self);
	}
	_tmp40_ = xfmpc_interface_new ();
	_tmp41_ = g_object_ref_sink (_tmp40_);
	_g_object_unref0 (self->priv->interface);
	self->priv->interface = _tmp41_;
	_tmp42_ = self->priv->vbox;
	_tmp43_ = self->priv->interface;
	gtk_box_pack_start ((GtkBox*) _tmp42_, (GtkWidget*) _tmp43_, FALSE, FALSE, (guint) 4);
	_tmp44_ = (GtkHSeparator*) gtk_hseparator_new ();
	_tmp45_ = g_object_ref_sink (_tmp44_);
	separator = _tmp45_;
	_tmp46_ = self->priv->vbox;
	_tmp47_ = separator;
	gtk_box_pack_start ((GtkBox*) _tmp46_, (GtkWidget*) _tmp47_, FALSE, FALSE, (guint) 0);
	_tmp48_ = xfmpc_extended_interface_new ();
	_tmp49_ = g_object_ref_sink (_tmp48_);
	_g_object_unref0 (self->priv->extended_interface);
	self->priv->extended_interface = _tmp49_;
	_tmp50_ = self->priv->vbox;
	_tmp51_ = self->priv->extended_interface;
	gtk_box_pack_start ((GtkBox*) _tmp50_, (GtkWidget*) _tmp51_, TRUE, TRUE, (guint) 0);
	_tmp52_ = gtk_ui_manager_new ();
	_g_object_unref0 (self->priv->ui_manager);
	self->priv->ui_manager = _tmp52_;
	_tmp53_ = gtk_action_group_new ("XfmpcMainWindow");
	_g_object_unref0 (self->priv->action_group);
	self->priv->action_group = _tmp53_;
	_tmp54_ = self->priv->action_group;
	gtk_action_group_add_actions (_tmp54_, XFMPC_MAIN_WINDOW_action_entries, G_N_ELEMENTS (XFMPC_MAIN_WINDOW_action_entries), self);
	_tmp55_ = self->priv->action_group;
	gtk_action_group_add_toggle_actions (_tmp55_, XFMPC_MAIN_WINDOW_toggle_action_entries, G_N_ELEMENTS (XFMPC_MAIN_WINDOW_toggle_action_entries), self);
	_tmp56_ = self->priv->ui_manager;
	_tmp57_ = self->priv->action_group;
	gtk_ui_manager_insert_action_group (_tmp56_, _tmp57_, 0);
	{
		GtkUIManager* _tmp58_;
		_tmp58_ = self->priv->ui_manager;
		gtk_ui_manager_add_ui_from_string (_tmp58_, XFMPC_MAIN_WINDOW_ui_string, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp59_;
		const gchar* _tmp60_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp59_ = e;
		_tmp60_ = _tmp59_->message;
		g_warning ("main-window.vala:117: %s", _tmp60_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (separator);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp61_ = self->priv->ui_manager;
	_tmp62_ = gtk_ui_manager_get_accel_group (_tmp61_);
	_tmp63_ = _g_object_ref0 (_tmp62_);
	accel_group = _tmp63_;
	_tmp64_ = accel_group;
	gtk_window_add_accel_group ((GtkWindow*) self, _tmp64_);
	_tmp65_ = self->priv->action_group;
	_tmp66_ = gtk_action_group_get_action (_tmp65_, "view-statusbar");
	_tmp67_ = self->priv->preferences;
	_tmp68_ = xfmpc_preferences_get_show_statusbar (_tmp67_);
	_tmp69_ = _tmp68_;
	gtk_toggle_action_set_active (GTK_TOGGLE_ACTION (_tmp66_), _tmp69_);
	_tmp70_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp70_, "pp-changed", (GCallback) _xfmpc_main_window_update_window_title_xfmpc_mpdclient_pp_changed, self, 0);
	_tmp71_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp71_, "stopped", (GCallback) _xfmpc_main_window_update_window_title_xfmpc_mpdclient_stopped, self, 0);
	_tmp72_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp72_, "song-changed", (GCallback) _xfmpc_main_window_update_window_title_xfmpc_mpdclient_song_changed, self, 0);
	_tmp73_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp73_, "playlist-changed", (GCallback) _xfmpc_main_window_cb_playlist_changed_xfmpc_mpdclient_playlist_changed, self, 0);
	_tmp74_ = self->priv->preferences;
	g_signal_connect_object ((GObject*) _tmp74_, "notify::show-statusbar", (GCallback) _xfmpc_main_window_cb_show_statusbar_changed_g_object_notify, self, 0);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, _xfmpc_main_window_refresh_gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (accel_group);
	_g_object_unref0 (separator);
	return obj;
}


static void xfmpc_main_window_class_init (XfmpcMainWindowClass * klass) {
	xfmpc_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (XfmpcMainWindowPrivate));
	G_OBJECT_CLASS (klass)->constructor = xfmpc_main_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = xfmpc_main_window_finalize;
}


static void xfmpc_main_window_instance_init (XfmpcMainWindow * self) {
	self->priv = XFMPC_MAIN_WINDOW_GET_PRIVATE (self);
}


static void xfmpc_main_window_finalize (GObject* obj) {
	XfmpcMainWindow * self;
	self = XFMPC_MAIN_WINDOW (obj);
	_g_object_unref0 (self->priv->status_icon);
	_g_object_unref0 (self->priv->status_icon_menu);
	_g_object_unref0 (self->priv->interface);
	_g_object_unref0 (self->priv->extended_interface);
	_g_object_unref0 (self->priv->vbox);
	_g_object_unref0 (self->priv->action_group);
	_g_object_unref0 (self->priv->ui_manager);
	_g_object_unref0 (self->priv->statusbar);
	G_OBJECT_CLASS (xfmpc_main_window_parent_class)->finalize (obj);
}


GType xfmpc_main_window_get_type (void) {
	static volatile gsize xfmpc_main_window_type_id__volatile = 0;
	if (g_once_init_enter (&xfmpc_main_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (XfmpcMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xfmpc_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XfmpcMainWindow), 0, (GInstanceInitFunc) xfmpc_main_window_instance_init, NULL };
		GType xfmpc_main_window_type_id;
		xfmpc_main_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "XfmpcMainWindow", &g_define_type_info, 0);
		g_once_init_leave (&xfmpc_main_window_type_id__volatile, xfmpc_main_window_type_id);
	}
	return xfmpc_main_window_type_id__volatile;
}



