.\" $XFree86: xc/programs/luit/luit.man,v 1.7 2003/02/24 01:10:25 dawes Exp $
.TH LUIT 1 __vendorversion__
.SH NAME
luit \- Locale and ISO\ 2022 support for Unicode terminals
.SH SYNOPSIS
.B luit
[
.I options
] [
.B \-\-
] [
.I program 
[
.I args
] ]
.SH DESCRIPTION
.B Luit
is a filter that can be run between an arbitrary application and a
UTF-8 terminal emulator.  It will convert application output from the
locale's encoding into UTF-8, and convert terminal input from UTF-8
into the locale's encoding.

An application may also request switching to a different output
encoding using ISO\ 2022 and ISO\ 6429 escape sequences.  Use of this
feature is discouraged: multilingual applications should be modified
to directly generate UTF-8 instead.

.B Luit
is usually invoked transparently by the terminal emulator.  For
information about running
.B luit
from the command line, see EXAMPLES below.
.SH OPTIONS
.TP
.B \-h
Display some summary help and quit.
.TP
.B \-list
List the supported charsets and encodings, then quit.
.TP
.B \-v
Be verbose.
.TP
.B \-c
Function as a simple converter from standard input to standard output.
.TP
.B \-x
Exit as soon as the child dies.  This may cause
.B luit
to loose data at the end of the child's output.
.TP
.BI \-argv0 " name"
Set the child's name (as passed in argv[0]).
.TP
.BI \-encoding " encoding"
Set up
.B luit
to use
.I encoding
rather than the current locale's encoding.
.TP
.B +oss
Disable interpretation of single shifts in application output.
.TP
.B +ols
Disable interpretation of locking shifts in application output.
.TP
.B +osl
Disable interpretation of character set selection sequences in
application output.
.TP
.B +ot
Disable interpretation of all sequences and pass all sequences in
application output to the terminal unchanged.  This may lead to
interesting results.
.TP
.B \-k7
Generate seven-bit characters for keyboard input.
.TP
.B +kss
Disable generation of single-shifts for keyboard input.
.TP
.B +kssgr
Use GL codes after a single shift for keyboard input.  By default, GR
codes are generated after a single shift when generating eight-bit
keyboard input.
.TP
.B \-kls
Generate locking shifts (SO/SI) for keyboard input.
.TP
.BI \-gl " gn"
Set the initial assignment of GL.  The argument should be one of
.BR g0 ,
.BR g1 ,
.B g2
or
.BR g3 .
The default depends on the locale, but is usually
.BR g0 .
.TP
.BI \-gr " gk"
Set the initial assignment of GR.  The default depends on the locale,
and is usually 
.B g2
except for EUC locales, where it is
.BR g1 .
.TP
.BI \-g0 " charset"
Set the charset initially selected in G0.  The default depends on
the locale, but is usually
.BR ASCII .
.TP
.BI \-g1 " charset"
Set the charset initially selected in G1.  The default depends on the
locale.
.TP
.BI \-g2 " charset"
Set the charset initially selected in G2.  The default depends on the
locale.
.TP
.BI \-g3 " charset"
Set the charset initially selected in G3.  The default depends on the
locale.
.TP
.BI \-ilog " filename"
Log into
.I filename
all the bytes received from the child.
.TP
.BI \-olog " filename"
Log into
.I filename
all the bytes sent to the terminal emulator.
.TP
.B \-\-
End of options.
.SH EXAMPLES
The most typical use of
.B luit
is to adapt an instance of
.B XTerm
to the locale's encoding.  Current versions of 
.B XTerm
invoke
.B luit
automatically when it is needed.  If you are using an older release of
.BR XTerm ,
or a different terminal emulator, you may invoke
.B luit
manually:
.IP
$ xterm \-u8 \-e luit
.PP
If you are running in a UTF-8 locale but need to access a remote
machine that doesn't support UTF-8,
.B luit
can adapt the remote output to your terminal:
.IP
$ LC_ALL=fr_FR luit ssh legacy-machine
.PP
.B Luit
is also useful with applications that hard-wire an encoding that is
different from the one normally used on the system or want to use
legacy escape sequences for multilingual output.  In particular,
versions of
.B Emacs
that do not speak UTF-8 well can use
.B luit
for multilingual output:
.IP
$ luit -encoding 'ISO 8859-1' emacs -nw
.PP
And then, in
.BR Emacs ,
.IP
M-x set-terminal-coding-system RET iso-2022-8bit-ss2 RET
.PP
.SH FILES
.TP
.B __projectroot__/lib/X11/fonts/encodings/encodings.dir
The system-wide encodings directory.
.TP
.B __projectroot__/lib/X11/locale/locale.alias
The file mapping locales to locale encodings.
.SH SECURITY
On systems with SVR4 (``Unix-98'') ptys (Linux version 2.2 and later,
SVR4),
.B luit
should be run as the invoking user.

On systems without SVR4 (``Unix-98'') ptys (notably BSD variants),
running
.B luit
as an ordinary user will leave the tty world-writable; this is a
security hole, and luit will generate a warning (but still accept to
run).  A possible solution is to make
.B luit
suid root;
.B luit
should drop privileges sufficiently early to make this safe.  However,
the startup code has not been exhaustively audited, and the author
takes no responsibility for any resulting security issues.

.B Luit
will refuse to run if it is installed setuid and the underlying system
does not have POSIX saved ids.
.SH BUGS
None of this complexity should be necessary.  Stateless UTF-8
throughout the system is the way to go.

Charsets with a non-trivial intermediary byte are not yet supported.

Selecting alternate sets of control characters is not supported and
will never be.
.SH SEE ALSO
xterm(1), unicode(7), utf-8(7), charsets(7).
.I Character Code Structure and Extension Techniques (ISO\ 2022, ECMA-35).
.I Control Functions for Coded Character Sets (ISO\ 6429, ECMA-48).
.SH AUTHOR
Luit was written by Juliusz Chroboczek <jch@xfree86.org> for the
XFree86 project.
