<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xgf="http://www.engl.virginia.edu/OE/xgridfit-data"
                version="1.0">

  <!-- This file is part of xgridfit.
       It is distributed under the GNU Public License, version 2.
       Copyright (c) 2006-7 by Peter S. Baker
  -->
  
  <!-- Push values and execute delta instruction -->
  <xsl:template name="exec-delta">
    <xsl:param name="sets"/>
    <xsl:param name="size-sub"/>
    <xsl:param name="cmd-suffix"/>
    <xsl:param name="caller-is" select="'pt-delta'"/>
    <xsl:param name="call-macro-param-set"/>
    <xsl:for-each select="$sets">
      <xsl:sort select="@size" data-type="number" order="ascending"/>
      <xsl:variable name="p-index" select="position() - 1"/>
      <xsl:variable name="push-here"
		    select="boolean(($p-index div number($delta-break)) =
			    floor($p-index div number($delta-break)))"/>
      <!-- "remaining" includes the present instance -->
      <xsl:variable name="remaining" select="last() - $p-index"/>
      <xsl:variable name="last-block" select="$remaining &lt;= number($delta-break)"/>
      <xsl:call-template name="push-num">
	<xsl:with-param name="num" select="number(((number(@size) -
          number($size-sub)) * 16) +
          number(document('xgfdata.xml')/*/xgf:deltavals/xgf:deltaval[@step =
          current()/@distance]/@code))"/>
	<xsl:with-param name="expect">
	  <xsl:choose>
	    <xsl:when test="$last-block">
	      <xsl:value-of select="($remaining * 2) + 1"/>
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:value-of select="number($delta-break) * 2"/>
	    </xsl:otherwise>
	  </xsl:choose>
	</xsl:with-param>
	<xsl:with-param name="add-mode" select="not($push-here)"/>
	<xsl:with-param name="size" select="'B'"/>
      </xsl:call-template>
      <xsl:choose>
        <xsl:when test="$caller-is='pt-delta'">
          <xsl:call-template name="push-value">
	    <xsl:with-param name="val">
	      <xsl:choose>
		<xsl:when test="./point">
		  <xsl:value-of select="./point/@num"/>
		</xsl:when>
		<xsl:when test="ancestor::move">
		  <xsl:value-of select="ancestor::move[1]/point/@num"/>
		</xsl:when>
		<xsl:otherwise>
		  <xsl:call-template name="error-message">
		    <xsl:with-param name="msg">
		      Cannot find a point for &lt;delta-set&gt;.
		    </xsl:with-param>
		  </xsl:call-template>
		</xsl:otherwise>
	      </xsl:choose>
	    </xsl:with-param>
            <xsl:with-param name="offset" select="./point/@offset"/>
            <xsl:with-param name="add-mode" select="true()"/>
            <xsl:with-param name="permitted" select="'1n'"/>
	    <xsl:with-param name="call-macro-param-set"
			    select="$call-macro-param-set"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
	  <xsl:call-template name="push-value">
	    <xsl:with-param name="val" select="./@cv"/>
	    <xsl:with-param name="add-mode" select="true()"/>
	    <xsl:with-param name="permitted" select="'c'"/>
	    <xsl:with-param name="call-macro-param-set"
			    select="$call-macro-param-set"/>
	  </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>
    <xsl:call-template name="push-num">
      <xsl:with-param name="num" select="count($sets)"/>
      <xsl:with-param name="add-mode" select="true()"/>
    </xsl:call-template>
    <xsl:choose>
      <xsl:when test="$caller-is='pt-delta'">
        <xsl:call-template name="simple-command">
          <xsl:with-param name="cmd" select="concat('DELTAP',$cmd-suffix)"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="simple-command">
          <xsl:with-param name="cmd" select="concat('DELTAC',$cmd-suffix)"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <!--
    Accepts a collection of delta-set nodes and goes through them three times,
    looking for delta-set nodes for the DELTAP1, DELTAP2 and DELTAP3 instructions.
    That is to say, the user doesn't have to be concerned with which instruction
    to use.
  -->
  <xsl:template name="do-delta">
    <xsl:param name="sets"/>
    <xsl:param name="caller-is" select="'pt-delta'"/> <!-- Alternative is cv-delta -->
    <xsl:param name="call-macro-param-set"/>
    <xsl:if test="$sets[number(@size) &gt;= 0 and number(@size) &lt;= 15]">
      <xsl:call-template name="exec-delta">
        <xsl:with-param name="sets" select="$sets[number(@size) &gt;= 0 and
          number(@size) &lt;= 15]"/>
        <xsl:with-param name="size-sub" select="0"/>
        <xsl:with-param name="cmd-suffix" select="'1'"/>
        <xsl:with-param name="caller-is" select="$caller-is"/>
	<xsl:with-param name="call-macro-param-set"
			select="$call-macro-param-set"/>
      </xsl:call-template>
    </xsl:if>
    <xsl:if test="$sets[number(@size) &gt;= 16 and number(@size) &lt;= 31]">
      <xsl:call-template name="exec-delta">
        <xsl:with-param name="sets" select="$sets[number(@size) &gt;= 16 and
          number(@size) &lt;= 31]"/>
        <xsl:with-param name="size-sub" select="16"/>
        <xsl:with-param name="cmd-suffix" select="'2'"/>
        <xsl:with-param name="caller-is" select="$caller-is"/>
	<xsl:with-param name="call-macro-param-set"
			select="$call-macro-param-set"/>
      </xsl:call-template>
    </xsl:if>
    <xsl:if test="$sets[number(@size) &gt;= 32 and number(@size) &lt;= 47]">
      <xsl:call-template name="exec-delta">
        <xsl:with-param name="sets" select="$sets[number(@size) &gt;= 32 and
          number(@size) &lt;= 47]"/>
        <xsl:with-param name="size-sub" select="32"/>
        <xsl:with-param name="cmd-suffix" select="'3'"/>
        <xsl:with-param name="caller-is" select="$caller-is"/>
	<xsl:with-param name="call-macro-param-set"
			select="$call-macro-param-set"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template match="delta">
    <xsl:param name="call-macro-param-set"/>
    <xsl:variable name="comp-if">
      <xsl:call-template name="compile-if-test">
	<xsl:with-param name="test" select="@compile-if"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:if test="number($comp-if)">
      <xsl:call-template name="do-delta">
	<xsl:with-param name="sets" select="delta-set"/>
	<xsl:with-param name="caller-is" select="'pt-delta'"/>
	<xsl:with-param name="call-macro-param-set"
			select="$call-macro-param-set"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template match="control-value-delta">
    <xsl:param name="call-macro-param-set"/>
    <xsl:call-template name="do-delta">
      <xsl:with-param name="sets" select="delta-set"/>
      <xsl:with-param name="caller-is" select="'cv-delta'"/>
      <xsl:with-param name="call-macro-param-set"
		      select="$call-macro-param-set"/>
    </xsl:call-template>
  </xsl:template>

</xsl:stylesheet>
