.TH JEWEL 6 "December 1992" "X Version 11"
.SH NAME

xjewel \- X windows droping jewels game

.SH SYNOPSIS

.B xjewel

.SH DESCRIPTION

.I Jewel
is a droping block game akin to tetris. 

It is played by controling the motion of blocks which continue to fall from
the top of the screen.  One can move them left and right, as well as
rotate the jewel segements.  The object is to get the most points before
the grim reaper ends the fun.

Death happens when the screen is no longer capable of holding any more
blocks.  To make high scores more interesting, you are given but three
attempts to get points -- use them wisely.

As the game progresses, and more jewels are removed, the speed of the game
will increase.  This is measured in seconds of delay between steps of
block motion.

.SH KEYS

There are three sets of keys that can be used:
.br
( or any combination )

Option 1:
.TS
center tab (%) ;
| cw(1.25i) | cw(1.25i) | cw(1.25i) | 
  c   c   c
  c   c   c .
_
J %  K %  L 
_
|  %   |   %  | 
move block left % rotate block % move block right
.TE
.TS
center tab (%) ;
_   l
| cw(1.25i) | l
_   l.

SPACE  % <- drop block

.TE

Option 2:

.TS
center tab (%) ;
| cw(1.25i) | cw(1.25i) | cw(1.25i) |
  c   c   c
  c   c   c .
_
4 %  5 %  6
_
|  %   |   %  |
move block left % rotate block % move block right
.TE
.TS
center tab (%) ;
_   l
| cw(1.25i) | l
_   l.

0  % <- drop block

.TE

.if n .ne 8
Option 3: (cursor keypad)
                
.TS
center tab (%) ;
  l        _        l 
  cw(1.25i) | cw(1.25i) | l
  l        _        l  
| cw(1.25i) | cw(1.25i) | cw(1.25i) |
  c   c   c
  c   c   c .

 %  \(ua %  - rotate block

_
\(<- %  \(da  %  \(->
_
|  %   |   %  |
move block left % rotate block % move block right
.TE

.SH ROTATIONS

The folowing rotations are possible:
( there are no others )

.TS
center tab (%);
_ % cw(1i) % _ % cw(1i) % _
| cw(1i) | % cw(1i) % | cw(1i) | % cw(1i) % | cw(1i) |
_ % cw(1i) % _ % cw(1i) % _
| cw(1i) | % cw(1i) % | cw(1i) | % cw(1i) % | cw(1i) |
_ % cw(1i) % _ % cw(1i) % _
| cw(1i) | % cw(1i) % | cw(1i) | % cw(1i) % | cw(1i) |
_ % cw(1i) % _ % cw(1i) % _ .

1 % % 3 % % 2

2 % \(rh % 1 % \(rh % 3

3 % % 2 % % 1

.TE

.SH SCORING

The basic way to get points is to unite the jewels to form triplet (or
higher) matches.  This can be done in any direction, and can be
accomplished in more than one part of the board at one time.  As the
jewels are removed, the board falls to fill the spaces -- matches may
again occur.

These teritiary matches provide an interesting part to the game due to the
formula for calculating points:
    
    ( 300 (for base triplet) + 150 * (each additional jewel) ) * 2^order

    where order is the number of the repeition from which the match
    occured.

As a light at the end of the bleak tunnel, a WILD CARD is available.  The
wild block will be given at infrequent intervals, and will give the user
the points for one triplet by removing all the jewels of a particular
shape/color.

To add some interest to the game, points are awarded for dropping the
block from a height above its resting place.  This is accumlated at 10
points per level above the place it will rest.

.SH STAGES

There are no changes for the higher levels, although the speed increases,
proportionaly to the level.  Stage increases with the successful
completion of the 50 jewels required per level.  The current status is
shown in the REST field.

.SH NOTES

This game was originally written by Yoshihiro Satoh of HP.  I have made a
modest attempt to replicate Domain/JewelBox under X.

I have somewhat rudely taken the bitmaps from the original game and
created this version.  I hold the copyright for the code, as I created
it, but I hold no claim to the bitmaps which were freely
distributed with the Domain version.

NOTE: I have attempted to reach the holder of the original copyright to 
ascertain his acceptance for the release of this game, he did not, or was
not able to reply.

REDISTRIBUTION in source or binary from is permited as long as adequate
notation of the originators is retained, including the developer of the 
original Domain/Jewlbox, Yoshihiro Satoh.

USE AT YOUR OWN RISK AND PERIL, I MAKE NO CLAIM OF USEABILITY OR WARANTY.

.SH ORIGINAL NOTATIONS
>Authors
.br
>-------
.br
>
.br
>   Programming       Yoshihiro Satoh
.br
>   Font Design       Yoshiharu Minami
.br
>   Document Writing  Nancy Paisner
.br
>
.br
>Copyright
.br
>---------
.br
>
.br
>  This software is in the Yoshihiro's Arcade Collections.
.br
>  Domain/JewelBox is a trade mark of Yoshihiro Satoh.
.br
>
.br
>  Copyright @ 1990 by Yoshihiro Satoh
.br
>  All rights are reserved by Yoshihiro Satoh.
.br

xjewel - Jewel for X11 Copyright 1992 by David Cooper

.SH AUTHOR

David Cooper
.br
Jose Guterman
.SH "SEE ALSO"

.SH BUGS

It does not currently accept any X arguments, including the -display argument.

The DISPLAY environment variable must be set for it to work.
