#include "lcp3.h"

unsigned int get_max_lcp3_pack_size()
{
    unsigned int size = sizeof(struct t_lcp3_info_auth);
    if ( size < sizeof(struct t_lcp3_info_ack) ) size = sizeof(struct t_lcp3_info_ack);
    if ( size < sizeof(struct t_lcp3_info_line) ) size = sizeof(struct t_lcp3_info_line);
    if ( size < sizeof(struct t_lcp3_info_tput) ) size = sizeof(struct t_lcp3_info_tput);
    if ( size < sizeof(struct t_lcp3_info_status) ) size = sizeof(struct t_lcp3_info_status);
    if ( size < sizeof(struct t_lcp3_info_enckey) ) size = sizeof(struct t_lcp3_info_enckey);
    if ( size < sizeof(struct t_lcp3_info_isdn) ) size = sizeof(struct t_lcp3_info_isdn);
    size += sizeof(struct t_lcp3_cmd);
    return(size);
}

unsigned int get_lcp3_pack_size(int cmd)
{
    switch ( cmd )
    {
	case CMD3_AUTHREQ:
	    return(sizeof(struct t_lcp3_cmd)+sizeof(struct t_lcp3_info_auth));
	case CMD3_INVALID:
	case CMD3_NOACCESS:
	case CMD3_ACK:
	    return(sizeof(struct t_lcp3_cmd)+sizeof(struct t_lcp3_info_ack));
	case CMD3_LINE:
	    return(sizeof(struct t_lcp3_cmd)+sizeof(struct t_lcp3_info_line));
	case CMD3_STATUS:
	    return(sizeof(struct t_lcp3_cmd)+sizeof(struct t_lcp3_info_status));
	case CMD3_ENCINFO:
	    return(sizeof(struct t_lcp3_cmd)+sizeof(struct t_lcp3_info_enckey));
	case CBR3_TPUT:
	    return(sizeof(struct t_lcp3_cmd)+sizeof(struct t_lcp3_info_tput));
	case CBR3_ISDNACT:
	    return(sizeof(struct t_lcp3_cmd)+sizeof(struct t_lcp3_info_isdn));
	default:
	    return(sizeof(struct t_lcp3_cmd));
    }
}

const char * lcp3_get_cmd_name(int cmd)
{
	switch ( cmd )
	{
		case CMD3_AUTHREQ: return "CMD3_AUTHREQ";
		case CMD3_ONLINE: return "CMD3_ONLINE";
		case CMD3_OFFLINE: return "CMD3_OFFLINE";
		case CMD3_LINESREQ: return "CMD3_LINESREQ";
		case CMD3_STATREQ: return "CMD3_STATREQ";
		case CMD3_SHUTDOWN: return "CMD3_SHUTDOWN";
		case CMD3_PUBKEYREQ: return "CMD3_PUBKEYREQ";
		case CMD3_LINESEL: return "CMD3_LINESEL";
		case CMD3_CHANADD: return "CMD3_CHANADD";
		case CMD3_CHANRM: return "CMD3_CHANRM";
		case CMD3_REFRESH: return "CMD3_REFRESH";
		case CMD3_LOCK: return "CMD3_LOCK";
		case CMD3_UNLOCK: return "CMD3_UNLOCK";
		case CMD3_GETALL: return "CMD3_GETALL";
		case CMD3_UNGETALL: return "CMD3_UNGETALL";
		case CMD3_AUTHBAD: return "CMD3_AUTHBAD";
		case CMD3_CLIENTSTAT: return "CMD3_CLIENTSTAT";
		case CMD3_LINE: return "CMD3_LINE";
		case CMD3_STATUS: return "CMD3_STATUS";
		case CMD3_INVALID: return "CMD3_INVALID";
		case CMD3_ENCINFO: return "CMD3_ENCINFO";
		case CMD3_NOACCESS: return "CMD3_NOACCESS";
		case CMD3_CHANFAIL: return "CMD3_CHANFAIL";
		case CMD3_ACK: return "CMD3_ACK";
		case CMD3_UNREG: return "CMD3_UNREG";
		case CBR3_TPUT: return "CBR3_TPUT";
		case CBR3_LINESTAT: return "CBR3_LINESTAT";
		case CBR3_SRVDEATH: return "CBR3_SRVDEATH";
		case CBR3_ISDNACT: return "CBR3_ISDNACT";
		default: return "'unknown command'";
	}
}
