#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <pwd.h>
#include <sys/types.h>

#include <gtk/gtk.h>

/*
	thanks to Vegard Lima <vegard.lima@c2i.net>
	(contributed code and the hint that
	glibc supplies getpwuid(uid)... )
*/

/* Should be "uid_t uid" (defined in sys/types.h) ? */
char *user_get_homedir(uid_t uid)
// returns for example "/home/user" (no trailing slash)
// the returned memorychunk is 1000 bytes long... so if
// get segfaults you probably have a homedir longer
// than 800 bytes.
// you have to free the buffer afterwards yourself!
{
	struct passwd *pw;
	char * homedir;
	
	if(!(pw = getpwuid(uid)) || !pw->pw_dir )
	{
		printf("You don't exist go away!\n");
		return(NULL);
	}

	if ( strlen(pw->pw_dir) > 850 )
	{
		printf("Hell... try again with a shorter homedirectory!\n");
		return(NULL);
	}

	homedir = malloc(1000);
	if ( !homedir )
	{
		printf("Unable to allocate homedirectory-name buffer.\n");
		return(NULL);
	}

	strcpy(homedir, pw->pw_dir);

	return homedir;
}
